/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Values/LightIntraDayTradeRef.cs#6 $
 * $DateTime: 2008/03/13 13:20:43 $
 * 
 */
using System;
using System.Diagnostics;

using LightIntraDayTrade=Bellagio.Data.LightIntraDayTrade;
using AbstractStockProfile=Bellagio.Data.AbstractStockProfile;

namespace Bellagio.Values {
    public class LightIntraDayTradeRef : BV {
        private LightIntraDayTrade _intraDayTrade;

        public override bool IsNil {
            get {
                return _intraDayTrade==null;
            }
        }
        public override void Format(BVFormatter formatter) {
            formatter.LightIntraDayTrade(this);
        }
        public override void Let(BV value) {
            _intraDayTrade = ((LightIntraDayTradeRef)value)._intraDayTrade;
        }
        public override BT BT {
            get { return LightIntraDayTradeType.instance; }
        }

        public LightIntraDayTrade Value {
            get {
                return _intraDayTrade;
            }
            set {
                _intraDayTrade = value;
            }
        }
    }

    public class LightIntraDayTradeType : BObjectT {
        private LightIntraDayTradeType()
            : base("LightIntraDayTrade", new LightIntraDayTradeRef()) {
        }

        public static LightIntraDayTradeType instance;
        static LightIntraDayTradeType() {
            instance = new LightIntraDayTradeType();
        }
        public override BV CreateInstance() {
            return new LightIntraDayTradeRef();
        }

        public override void RegisterFunctionsTo(FunctionLibrary lib, SystemFunctionLibrary sys) {
            BT isLightIntraDayTrade = instance;
            BT[] noArg = BuiltInFunctionLibrary.noArg;
            lib.DefineInternalFunction("price", isLightIntraDayTrade, BT.Double, noArg, new BInternalExecution(GetLastPrice));
            lib.DefineInternalFunction("lastclose", isLightIntraDayTrade, BT.Double, noArg, new BInternalExecution(GetLastClose));

            lib.DefineInternalFunction("index", null, isLightIntraDayTrade, new BT[] { BT.String }, new BInternalExecution(GetLightIntraDayTrade));
        }
        private static ExecResult GetLastPrice(BV target, EvalContext extra, BV[] args, BV result) {
            LightIntraDayTradeRef lt = (LightIntraDayTradeRef)target;
            LightIntraDayTrade rs = lt.Value as LightIntraDayTrade;
            Debug.Assert(rs!=null);
            if(rs.CurrentPriceR.IsEmpty)
                return ExecResult.Nil;
            else
                ((BDouble)result).Value = rs.RealCurrentPrice;
            return ExecResult.OK;
        }
        private static ExecResult GetLastClose(BV target, EvalContext extra, BV[] args, BV result) {
            LightIntraDayTradeRef lt = (LightIntraDayTradeRef)target;
            LightIntraDayTrade dt =  lt.Value;
            if(dt.LastCloseR.IsEmpty)
                return ExecResult.Nil;
            else
                ((BDouble)result).Value = dt.RealLastClose;
            return ExecResult.OK;
        }

        //ǂ̃R[hQƂĂ邩𒲂ׂP[X̂EvalContext甲
        private static ExecResult GetLightIntraDayTrade(BV target, EvalContext extra, BV[] args, BV result) {
            BString code = args[0] as BString;
            Debug.Assert(code!=null);
            EvalSpecial_CodeCollector c = extra.EvalSpecial_CodeCollector;
            if(c!=null) { //R[hW
                c.AddIndex(code.Value);
                LightIntraDayTrade ldt = new LightIntraDayTrade(null);
                ldt.PseudoReset(0, 0.01);
                ((LightIntraDayTradeRef)result).Value = ldt;
            }
            else {
                AbstractStockProfile stock = BellagioRoot.GlobalStockCollection.FindExact(code.Value);
                Debug.Assert(stock!=null); 
                LightIntraDayTrade v = BellagioRoot.LightIntraDayTradeProvider.Lookup(stock.Primary);
                if(v==null)
                    return ExecResult.Nil;
                else
                    ((LightIntraDayTradeRef)result).Value = v;
            }
            return ExecResult.OK;
        }
    }
}
