/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Values/ValueSystemRoot.cs#7 $
 * $DateTime: 2007/10/25 12:56:12 $
 * 
 * gݍ݊֐AgLbgŒ`֐AO^̍
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Bellagio.Script;
using Bellagio.Evaluators;

namespace Bellagio.Values {

    public class ValueSystemRoot {
        private SystemFunctionLibrary _system;
        private BuiltInFunctionLibrary _builtIn;
        private FunctionLibrary _user;
        private Dictionary<string, BT> _nameMap;

        public ValueSystemRoot() {
            _builtIn = new BuiltInFunctionLibrary();
            _system= new SystemFunctionLibrary();
            _user = new FunctionLibrary();
            _nameMap = new Dictionary<string, BT>();
            FunctionLibrary._root = this;
            EvaluatorBuildContext._root = this;

            DefineBellagioTypes();
        }
        public SystemFunctionLibrary SystemF {
            get {
                return _system;
            }
        }
        public BuiltInFunctionLibrary BuiltIn {
            get {
                return _builtIn;
            }
        }
        public FunctionLibrary User {
            get {
                return _user;
            }
        }
        public NamedValueCollection Resolve(string name, BT target) {
            NamedValueCollection result;
            result = _user.Resolve(name, target);
            if(result==null) result = _builtIn.Resolve(name, target);

            if(result!=null)
                return result;
            else {
                //ȂG[
                string context = target==null? "" : target.Name + " ";
                throw new ScriptException(String.Format("{0}֐ {1} ܂B", context, name ));
            }
        }
        public IBSystemFunction ResolveSystem(string name, BT target) {
            return _system.Resolve(name, target);
        }

        public BT FindTypeFromName(string name) {
            BT r = null;
            if(_nameMap.TryGetValue(name, out r))
                return r;
            else
                return null;
        }
        public BT ResolveType(string name) {
            //NOTE ̓v~eBû
            foreach(BPrimitiveType pt in BT.PrimitiveTypes)
                if(pt.Name==name) return pt;
            BT t = FindTypeFromName(name);
            if(t==null)
                throw new ScriptException(String.Format("{0} ͌^ƂĔFł܂B", name));
            return t;
        }
        public BT TypeDescToBT(TypeDesc t) {
            if(t is LambdaTypeDesc) {
                List<BT> l = new List<BT>();
                LambdaTypeDesc ltd = t as LambdaTypeDesc;
                for(int i=0; i<ltd.ArgCount; i++)
                    l.Add(TypeDescToBT(ltd.ArgAt(i)));
                return new BFunctionT(null, l.ToArray(), TypeDescToBT(ltd.RetType));
            }
            else if(t is ArrayTypeDesc)
                return TypeDescToBT(((ArrayTypeDesc)t).Element).ArrayType();
            else {
                Debug.Assert(t is NamedTypeDesc);
                return ResolveType(((NamedTypeDesc)t).Name);
            }
        }
        public BFunctionT ParameterToFunctionType(TypeDesc targetType, ParameterListDefinition parameters, TypeDesc returnType) {
            BT target = targetType==null? null : TypeDescToBT(targetType);
            List<BT> pl = new List<BT>();
            for(int i=0; i<parameters.Count; i++)
                pl.Add(TypeDescToBT(parameters.TypeDescAt(i)));
            return new BFunctionT(target, pl.ToArray(), TypeDescToBT(returnType));
        }

        //IuWFNǧ^`
        private void DefineBellagioTypes() {
            RegisterType(TickDataType.instance);
            RegisterType(TimeAndSalesType.instance);
            RegisterType(CandleType.instance);
            RegisterType(QuoteType.instance);
            RegisterType(StockType.instance);
            RegisterType(IntraDayTradeType.instance);
            RegisterType(LightIntraDayTradeType.instance);
        }

        private void RegisterType(BT t) {
            _nameMap[t.Name] = t;
            ((IBObjectT)t).RegisterFunctionsTo(_builtIn, _system);
        }
        public void RegisterExternalType(BT t) {
            _nameMap[t.Name] = t;
        }
    }
}
