/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: CommandEx.cs,v 1.17 2006/08/23 07:49:48 osawa Exp $
 */
using System;
using System.Collections;
using System.Windows.Forms;
using System.Drawing;
using System.Collections.Generic;
using System.Diagnostics;

using Poderosa.Preferences;

namespace Poderosa.Commands
{
    /// <summary>
    /// <ja>
    /// R}h̎sʂ܂B
    /// </ja>
    /// <en>
    /// Return the result of the command.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso><see cref="IPoderosaCommand.InternalExecute">InternalExecute\bh</see>̎҂́A
    /// R}h̎s̉ۂA̗񋓑̂ŕԂ܂B
    /// </para>
    /// <para>
    /// ꍇɂSucceededAsꍇɂFailedԂ悤ɎĂB
    /// </para>
    /// <para>
    /// Cancelled̓[U[ɂăLZꂽꍇȂǂɗp܂B
    /// </para>
    /// <para>
    /// Ignored̓R}hsΏۂȂƂiƂΑIꂽeLXgɑ΂ďׂR}h̏ꍇɁAݑIĂeLXgȂƂȂǁjɗp܂B
    /// </para>
    /// </ja>
    /// <en>
    /// <para>
    /// Those who implement about the <see cref="IPoderosaCommand.InternalExecute">InternalExecute method</see> of <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso> return right or wrong of the execution of the command with this enumeration. 
    /// </para>
    /// <para>
    /// Please implement to return Failed when Succeeded and failing when succeeding. 
    /// </para>
    /// <para>
    /// Cancelled is used when canceled by the user operation. 
    /// </para>
    /// <para>
    /// Ignored is used when there is no object the execution of the command (For instance, there is no text that has been selected now for the command that should be processed to the selected text). 
    /// </para>
    /// </en>
    /// </remarks>
	public enum CommandResult {
        /// <summary>
        /// <ja>
        /// 
        /// </ja>
        /// <en>
        /// Succeeded.
        /// </en>
        /// </summary>
		Succeeded,
        /// <summary>
        /// <ja>
        /// s
        /// </ja>
        /// <en>
        /// Failed
        /// </en>
        /// </summary>
        Failed,
        /// <summary>
        /// <ja>
        /// LZ
        /// </ja>
        /// <en>
        /// Canceleld
        /// </en>
        /// </summary>
		Cancelled,
        /// <summary>
        /// <ja>
        /// 
        /// </ja>
        /// <en>
        /// Ignored.
        /// </en>
        /// </summary>
        Ignored
	}

    //R}h̋쓮ΏہBReLXgj[o񋟂āAICommand#ExecutëɂȂB
    //Cj[z̏ꍇACEBhEIAdaptableoRŎ擾邱ƂɂȂB
    /// <summary>
    /// <ja>
    /// R}hsׂ^[QbgC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows target that command should execute.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// ̃C^[tFCX́A<seealso cref="ICommandManager">ICommandManager</seealso><see cref="ICommandManager.Execute">Execute\bh</see>ĂяoāAR}hsۂɈn
    /// ^[QbgƂĎg܂B
    /// </para>
    /// <para>
    /// nꂽ^[QbǵA<seealso cref="IPoderosaCommand">IPoderosaCommand</seealso><see cref="IPoderosaCommand.InternalExecute">InternamExecute\bh</see>
    /// ɂ̂܂܈n܂B
    /// </para>
    /// <para>
    /// j[c[o[ĂяoR}h́A<paramref name="target"/>ɂ́ACEBhE<see cref="Poderosa.Forms.IPoderosaMainWindow">IPoderosaMainWindow</see>
    /// n邱Ƃz肵Ă܂B̎ȊÕC^[tFCXnꂽƂɂ́A
    /// 삵܂B
    /// </para>
    /// <para>
    /// <seealso cref="CommandTargetUtil">CommandTargetUtil</seealso>gƁA^[QbgEBhEr[ւƕϊł܂B
    /// </para>
    /// </ja>
    /// <en>
    /// <para>
    /// This interface is used as a target handed over when the <see cref="ICommandManager.Execute">Execute method</see> of <seealso cref="ICommandManager">ICommandManager</seealso> is called, and the command is executed. 
    /// 
    /// </para>
    /// <para>
    /// As for the passed target, off is passed to the <see cref="IPoderosaCommand.InternalExecute">InternamExecute method</see> of <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso> as it is. 
    /// </para>
    /// <para>
    /// The command called from the menu and the toolbar assumes to <paramref name="target"/> 
    /// <see cref="Poderosa.Forms.IPoderosaMainWindow">IPoderosaMainWindow</see>'s that shows the main window being passed. 
    /// It doesn't operate correctly when you pass interfaces other than this kind.
    /// </para>
    /// <para>
    /// The target can be converted into the window and the view by using <seealso cref="CommandTargetUtil">CommandTargetUtil</seealso>. 
    /// </para>
    /// </en>
    /// </remarks>
    public interface ICommandTarget : IAdaptable {
    }

    //Menu/Command̎sۂdelegate
    /// <summary>
    /// <ja>j[Ƀ`FbNtĂ邩ǂ߂ƂɌĂяofQ[głB</ja>
    /// <en>Delegate called when it is decided whether the check has adhered to the menu. </en>
    /// </summary>
    /// <param name="target">
    /// <ja>
    /// R}h̑Ώۂ^[QbgłB
    /// </ja>
    /// <en>
    /// Target that shows object of command.
    /// </en>
    /// </param>
    /// <returns>
    /// <ja>
    /// `FbNtĂȂtrueAłȂȂfalseԂĂB
    /// </ja>
    /// <en>
    /// Please return true and return false if it is not so if the check has adhered. 
    /// </en>
    /// </returns>
    /// <remarks>
    /// <ja>
    /// <para>
    /// <paramref name="target">target</paramref>ɂ̓ANeBuEBhE<see cref="Poderosa.Forms.IPoderosaMainWindow">IPoderosaMainWindow</see>iCj[̏ꍇj܂̓ANeBur[<see cref="Poderosa.Sessions.IPoderosaView">IPoderosaView</see>iReLXgj[̏ꍇĵꂩn܂B
    /// </para>
    /// <para>
    /// ̃fQ[g̖߂ĺAj[Ƀ`FbNt̂ǂ𔻒f̂Ɏg܂B <seealso cref="PoderosaMenuItemImpl">PoderosaMenuItemImpl</seealso>QƂĂB
    /// </para>
    /// </ja>
    /// <en>
    /// The return value from this delegate is used to judge whether to put the check on the menu. Refer to <seealso cref="PoderosaMenuItemImpl">PoderosaMenuItemImpl</seealso>  
    /// </en>
    /// </remarks>
    public delegate bool CheckedDelegate(ICommandTarget target);

    /// <summary>
    /// <ja>
    /// j[c[o[{^Cl[ufBXGu߂ƂɌĂяofQ[głB
    /// </ja>
    /// <en>
    /// Delegate called when whether menu and toolbar button are enable or disable is decided
    /// </en>
    /// </summary>
    /// <param name="target">
    /// <ja>
    /// R}h̑Ώۂ^[QbgłB
    /// </ja>
    /// <en>
    /// Target that shows object of command.
    /// </en>
    /// </param>
    /// <returns>
    /// <ja>
    /// j[c[o[̃{^IłȂtrueAłȂȂfalseԂĂB
    /// </ja>
    /// <en>
    ///  Please return true and return false if it is not so if you can select the button of the menu and the toolbar. 
    /// </en>
    /// </returns>
    /// <remarks>
    /// <ja>
    /// <para>
    /// <paramref name="target">target</paramref>ɂ̓ANeBuEBhE<see cref="Poderosa.Forms.IPoderosaMainWindow">IPoderosaMainWindow</see>iCj[c[o[̏ꍇj܂̓ANeBur[<see cref="Poderosa.Sessions.IPoderosaView">IPoderosaView</see>iReLXgj[̏ꍇĵꂩn܂B
    /// </para>
    /// <para>
    /// ̃fQ[g̖߂ĺAj[c[{^Cl[uɂ邩fBXGuɂ邩߂̂Ɏg܂B<seealso cref="PoderosaMenuItemImpl">PoderosaMenuItemImpl</seealso><seealso cref="Poderosa.Forms.ToolBarElementImpl">ToolBarElementImpl</seealso>QƂĂB
    /// </para>
    /// </ja>
    /// <en>
    /// The return value from this Derigat is used to provide whether to make the menu and the tool button enable or to make it to disable. Refer to <seealso cref="PoderosaMenuItemImpl">PoderosaMenuItemImpl</seealso> or <seealso cref="Poderosa.Forms.ToolBarElementImpl">ToolBarElementImpl</seealso>.
    /// </en>
    /// </remarks>
    public delegate bool EnabledDelegate(ICommandTarget target);

    /// <summary>
    /// <ja>
    /// R}hs\ǂ߂ƂɌĂяofQ[głB
    /// </ja>
    /// <en>
    /// Delegate called when it is provided whether command is executable.
    /// </en>
    /// </summary>
    /// <param name="target">
    /// <ja>
    /// R}h̑Ώۂ^[QbgłB
    /// </ja>
    /// <en>
    /// Target that shows object of command.
    /// </en>
    /// </param>
    /// <returns>
    /// <ja>
    /// R}hs\ȂtrueAłȂȂfalseԂĂB
    /// </ja>
    /// <en>
    /// Return true if it is executable, false if it is not.
    /// </en>
    /// </returns>
    /// <remarks>
    /// <ja>
    /// <para>
    /// j[c[o[ĂяoꍇA<paramref name="target">target</paramref>ɂ̓ANeBuEBhE<see cref="Poderosa.Forms.IPoderosaMainWindow">IPoderosaMainWindow</see>iCj[c[o[̏ꍇj܂̓ANeBur[<see cref="Poderosa.Sessions.IPoderosaView">IPoderosaView</see>iReLXgj[̏ꍇĵꂩn܂B
    /// </para>
    /// <para>
    /// ̃fQ[g<seealso cref="GeneralCommandImpl">GeneralCommandImpl</seealso><seealso cref="PoderosaCommandImpl">PoderosaCommandImpl</seealso>ȂǂŁA<seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>
    /// <see cref="IPoderosaCommand.CanExecute">CanExecute\bh</see>Ăяo^C~OŌĂяo܂B
    /// </para>
    /// </ja>
    /// <en>This delegatee is called in <seealso cref="GeneralCommandImpl">GeneralCommandImpl</seealso> and <seealso cref="PoderosaCommandImpl">PoderosaCommandImpl</seealso>, etc. according to timing where the <see cref="IPoderosaCommand.CanExecute">CanExecute method</see> of <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso> is called. 
    /// </en>
    /// </remarks>
    public delegate bool CanExecuteDelegate(ICommandTarget target);


    /// <exclude/>
    public delegate CommandResult ExecuteDelegateArgs(ICommandTarget target, params IAdaptable[] args);


    /// <summary>
    /// <ja>
    /// R}hsƂɌĂяofQ[głB
    /// </ja>
    /// <en>
    /// Delegate called when command is executed
    /// </en>
    /// </summary>
    /// <param name="target">
    /// <ja>
    /// R}h̑Ώۂ^[QbgłB
    /// </ja>
    /// <en>
    /// Target that shows object of command.
    /// </en>
    /// </param>
    /// <returns>
    /// <ja>
    /// R}h̎sʂԂĂB
    /// </ja>
    /// <en>
    /// Please return the execution result of the command. 
    /// </en>
    /// </returns>
    /// <remarks>
    /// <ja>
    /// <para>
    /// j[c[o[ĂяoꍇA<paramref name="target">target</paramref>ɂ̓ANeBuEBhE<see cref="T:Poderosa.Forms.IPoderosaMainWindow">IPoderosaMainWindow</see>iCj[c[o[̏ꍇj܂̓ANeBur[<see cref="T:Poderosa.Sessions.IPoderosaView">IPoderosaView</see>iReLXgj[̏ꍇĵꂩn܂B
    /// </para>
    /// <para>
    /// ̃fQ[g<seealso cref="GeneralCommandImpl">GeneralCommandImpl</seealso><seealso cref="PoderosaCommandImpl">PoderosaCommandImpl</seealso>ȂǂŁA<seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>
    /// <see cref="IPoderosaCommand.InternalExecute">InternalExecute\bh</see>Ăяo^C~OŌĂяo܂B
    /// </para>
    /// </ja>
    /// <en>
    /// <para>
    /// Either of <see cref="Poderosa.Sessions.IPoderosaView">IPoderosaView</see> (For the context menu) that shows 
    /// <see cref="Poderosa.Forms.IPoderosaMainWindow">IPoderosaMainWindow</see> (For the main menu and the toolbar) 
    /// that shows the active window or an active view is passed to <paramref name="target">target</paramref>
    ///  when it is called from the menu and the toolbar. 
    /// </para>
    /// <para>
    /// This delegate is called in <seealso cref="GeneralCommandImpl">GeneralCommandImpl</seealso> and <seealso cref="PoderosaCommandImpl">PoderosaCommandImpl</seealso>, etc. according to timing where the <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>
    /// <see cref="IPoderosaCommand.InternalExecute">InternalExecute method</see> of IPoderosaCommand is called. 
    /// </para>
    /// </en>
    /// </remarks>
    public delegate CommandResult ExecuteDelegate(ICommandTarget target);

    //R}h̊
    /// <summary>
    /// <ja>
    /// R}h@\񋟂vOCC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that plug-in that offers command function implements.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// R}h}l[Wi<seealso cref="T:Poderosa.Commands.ICommandManager">ICommandManager</seealso>jɂĎsR}h񋟂ꍇɂ́AvOC̃C^[tFCX܂B
    /// </para>
    /// <para>
    /// R}h}l[W<see cref="M:Poderosa.Commands.ICommandManager.Execute(Poderosa.Commands.IPoderosaCommand,Poderosa.Commands.ICommandTarget,Poderosa.IAdaptable[])">Execute\bh</see>ĂяoƁÃC^[tFCXɎĂ
    /// <see cref="M:Poderosa.Commands.IPoderosaCommand.InternalExecute(Poderosa.Commands.ICommandTarget,Poderosa.IAdaptable[])">InternalExecute\bh</see>ԐړIɌĂяo܂B
    /// </para>
    /// </ja>
    /// <en>
    /// <para>
    /// When the command executed by the command manager(<seealso cref="ICommandManager">ICommandManager</seealso>) is offered, 
    /// the plug-in implements this interface. 
    /// </para>
    /// <para>
    /// When command manager's <see cref="ICommandManager.Execute">Execute method</see> is called, 
    /// the <see cref="IPoderosaCommand.InternalExecute">InternalExecute method </see> implemented on this interface is indirectly called. 
    /// </para>
    /// </en>
    /// </remarks>
	public interface IPoderosaCommand : IAdaptable {
        //[U𒼐ڌĂł͂ȂBCommandManager#ExecutegƁI
        /// <summary>
        /// <ja>
        /// R}hsƂɌĂяo郁\bhłB
        /// </ja>
        /// <en>
        /// Method of call when command is executed
        /// </en>
        /// </summary>
        /// <param name="target">
        /// <ja>
        /// R}h̑ΏۂƂȂ^[QbgłB
        /// </ja>
        /// <en>
        /// Target target for command.
        /// </en>
        /// <en>
        /// Target that shows object of command.
        /// </en>
        /// </param>
        /// <param name="args">
        /// <ja>
        /// R}hɓnCӂ̈łB
        /// </ja>
        /// <en>
        /// It is an arbitrary argument passed to the command. 
        /// </en>
        /// </param>
        /// <returns>
        /// <ja>
        /// R}hǂ߂lłBƂɂ<see cref="CommandResult.Succeeded">CommandResult.Succeeded</see>Ԃ܂B
        /// </ja>
        /// <en>
        /// It is a return value that shows whether it was that the command succeeds. 
        /// When succeeding, CommandResult.<see cref="CommandResult.Succeeded">CommandResult.Succeeded</see> is returned. 
        /// </en>
        /// </returns>
        /// <remarks>
        /// <ja>
        /// <para>
        /// ̃\bh́AR}h}l[Wi<seealso cref="ICommandManager">ICommandManager</seealso>j<see cref="ICommandManager.Execute">Execute\bh</see>
        /// ĂяoꂽƂɁAԐړIɌĂяo܂BJ҂́Ã\bh𒼐ڌĂяoĂ͂܂B
        /// </para>
        /// <para>
        /// <paramref name="target">target</paramref><paramref name="args">args</paramref>́A<see cref="ICommandManager.Execute">Execute\bh</see>̌Ăяoœnꂽ̂܂ܓn܂B
        /// </para>
        /// <para>
        /// <seealso cref="CommandTargetUtil">CommandTargetUtil</seealso>gƁA<paramref name="target">target</paramref>EBhEr[ւƕϊł܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// When command manager(<seealso cref="ICommandManager">ICommandManager</seealso>)'s <see cref="ICommandManager.Execute">Execute method</see> is called, this method is indirectly called.
        /// The developer must not call this method directly. 
        /// </para>
        /// <para>
        /// As for <paramref name="target">target</paramref> and <paramref name="args">args</paramref>, the argument passed by calling 
        /// the <see cref="ICommandManager.Execute">Execute method</see> is passed as it is. 
        /// </para>
        /// <para>
        /// <paramref name="target">target</paramref> can be converted into the window and the view by using <seealso cref="CommandTargetUtil">CommandTargetUtil</seealso>. 
        /// </para>
        /// </en>
        /// </remarks>
    	CommandResult InternalExecute(ICommandTarget target, params IAdaptable[] args); //Eclipseł͂ɂ͈Ap[^R}hNBA͈ӖIICommand̎mĂׂe
        
        //R}hs\ǂ̔BsĂ݂܂ł킩Ȃ悤ȂƂ͂Ƃ肠trueԂƁB
        /// <summary>
        /// <ja>
        /// R}hs\ǂԂ܂B
        /// </ja>
        /// <en>
        /// Return whether the command is executable.
        /// </en>
        /// </summary>
        /// <param name="target">
        /// <ja>
        /// R}h̎sΏۂƂȂ^[QbgłB
        /// </ja>
        /// <en>
        /// Target that shows object of command.
        /// </en>
        /// </param>
        /// <returns>
        /// <ja>
        /// s\ȂtrueAłȂȂfalseԂĂB
        /// </ja>
        /// <en>
        /// Return true if it is executable, false if it is not.
        /// </en>
        /// </returns>
        /// <remarks>
        /// <ja>
        /// <para>
        /// ̃\bh́Aj[c[o[AڂfBXGuɂ邩ǂ߂ƂɎg܂B
        /// </para>
        /// <para>
        /// falseԂƃfBXGuɂȂA[U[IłȂȂ܂B
        /// </para>
        /// <para>
        /// R}hs܂ŁAs\ǂ킩ȂƂɂ́AtrueԂ悤ɎĂB
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// When it is decided whether the menu and the toolbar make the item disable, this method is used. 
        /// </para>
        /// <para>
        /// It becomes disable if false is returned, and the user cannot select it. 
        /// </para>
        /// <para>
        /// Please implement to return true when it is executable until the command is executed is not understood. 
        /// </para>
        /// </en>
        /// </remarks>
        bool CanExecute(ICommandTarget target);
	}

    //Cj[炽ǂ^Cv̂
    /// <summary>
    /// <ja>
    /// R}h}l[WɂĊǗR}hC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows command managed by command manager
    /// </en>
    /// </summary>
    public interface IGeneralCommand : IPoderosaCommand {
        /// <summary>
        /// <ja>
        /// R}hŎʂ邽߂́uR}hIDvłB̃R}hƂ͏dȂӂ̂̂ݒ肵܂B 
        /// </ja>
        /// <en>
        /// It is "command ID" to identify the command internally. The unique one that doesn't overlap is set as other commands. 
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// J҂R}h񋟂ꍇɂ́ÃvOC񋟂R}hIDƏdȂ悤ɂ邽߁A
        /// uvOCIDv̉ɓKȖOtKŁuR}hIDv肷邱Ƃ𐄏܂B
        /// Ƃ΁u<c>co.jp.example.myplugin</c>vƂvOCIDvOCȂ΁A
        /// R}hIDƂāu<c>co.jp.example.myplugin.mycommand</c>vƂOt悤ɂ܂B 
        /// </ja>
        /// <en>
        /// Command ID is recommended to be decided in the naming convention that names a suitable name under "plug-in ID" to make it not overlap with "command ID" that other plug-ins offer when the developer offers the command. 
        /// For instance, if it is a plug-in with plug-in ID of "<c>co.jp.example.myplugin</c>", the name of "<c>co.jp.example.myplugin.mycommand</c>" is named as command ID. 
        /// </en>
        /// </remarks>
        string CommandID { get; }
        /// <summary>
        /// <ja>
        /// R}h̐łB
        /// </ja>
        /// <en>
        /// Explanation of command
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// ݒ肵ĺAIvVʂ́uR}hvɕ\镶ɂȂ܂B
        /// </ja>
        /// <en>
        /// The set value becomes a character string displayed in "Command" column on the option screen. 
        /// </en>
        /// </remarks>
        string Description { get; }
        /// <summary>
        /// <ja>
        /// ̃R}hɊ蓖ĂftHg̃V[gJbgL[łB
        /// </ja>
        /// <en>
        /// It is a shortcut key of the default allocated in this command. 
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <para>
        /// V[gJbgL[蓖ĂȂꍇɂ́A<c>Keys.None</c>nĂB
        /// </para>
        /// <para>
        /// V[gJbg̃R}hpĂ̂Ədꍇɂ́A܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// Please pass <c>Keys.None</c> when you do not allocate the shortcut key. 
        /// </para>
        /// <para>
        /// When the short cut overlaps with the one that an existing command uses, it is disregarded. 
        /// </para>
        /// </en>
        /// </remarks>
        Keys DefaultShortcutKey { get; }
        /// <summary>
        /// <ja>
        /// R}hJeS<seealso cref="Poderosa.Commands.ICommandCategory">ICommandCategory</seealso>łB
        /// </ja>
        /// <en>
        /// <seealso cref="Poderosa.Commands.ICommandCategory">ICommandCategory</seealso> that show the command category.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <seealso cref="Poderosa.Commands.ICommandCategory">ICommandCategory</seealso>́A
        /// <seealso cref="Poderosa.Commands.ICommandManager">ICommandManager</seealso>
        /// <see cref="Poderosa.Commands.ICommandManager.CommandCategories">CommandCategoriesvpeB</see>瓾A
        /// `ς݃JeSp邱Ƃł܂B
        /// </ja>
        /// <en>
        /// <seealso cref="Poderosa.Commands.ICommandCategory">ICommandCategory</seealso> can use the category that has been 
        /// defined obtaining it from the <see cref="Poderosa.Commands.ICommandManager.CommandCategories">CommandCategories property</see> 
        /// of <seealso cref="Poderosa.Commands.ICommandManager">ICommandManager</seealso>. 
        /// </en>
        /// </remarks>
        ICommandCategory CommandCategory { get; }
    }

    //PositionDesignation
    /// <summary>
    /// <ja>
    /// R}hJeSC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows command category.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// `ς݃JeŚA<seealso cref="ICommandManager">ICommandManager</seealso><see cref="ICommandManager.CommandCategories">CommandCategoriesvpeB</see>擾ł܂B
    /// </ja>
    /// <en>
    /// It is possible to get it from the <see cref="ICommandManager.CommandCategories">CommandCategories property</see> of <seealso cref="ICommandManager">ICommandManager</seealso>. 
    /// </en>
    /// </remarks>
    public interface ICommandCategory : IAdaptable {
        /// <summary>
        /// <ja>
        /// R}hJeS̖OłB
        /// </ja>
        /// <en>
        /// Name of the command category.
        /// </en>
        /// </summary>
        string Name { get; }
        /// <summary>
        /// <ja>
        /// L[oCh̃JX^}CY\ǂ܂B
        /// </ja>
        /// <en>
        /// It is shown whether customizing key bind is possible. 
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <para>
        /// trueɂƃIvVݒʂɁA̍ڂ\AL[oCh̕ύXł悤ɂȂ܂B
        /// </para>
        /// <para>
        /// falseɂƃIvVݒʂB܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// This item is displayed on the option setting screen when making it to true, and it comes to be able to change key bind. 
        /// </para>
        /// <para>
        /// It is concealed because of the option setting screen when making it to false. 
        /// </para>
        /// </en>
        /// </remarks>
        bool IsKeybindCustomizable { get; }
    }

    /// <summary>
    /// <ja>
    /// `ς݃R}hJeS܂
    /// </ja>
    /// <en>
    /// Defined  command category.
    /// </en>
    /// </summary>
    public interface IDefaultCommandCategories {
        /// <summary>
        /// <ja>
        /// mt@CnJeSłB
        /// </ja>
        /// <en>
        /// Category that shows the "File".
        /// </en>
        /// </summary>
        ICommandCategory File { get; }
        /// <summary>
        /// <ja>
        /// m_CAOnJeSłB
        /// </ja>
        /// <en>
        /// Category that shows the "Dialog".
        /// </en>
        /// </summary>
        ICommandCategory Dialogs { get; }
        /// <summary>
        /// <ja>
        /// mҏWnJeSłB
        /// </ja>
        /// <en>
        /// Category that shows the "Edit".
        /// </en>
        /// </summary>
        ICommandCategory Edit { get; }
        /// <summary>
        /// <ja>
        /// mEBhEnJeSłB
        /// </ja>
        /// <en>
        /// Category that shows the "Window".
        /// </en>
        /// </summary>
        ICommandCategory Window { get; }
    }

    //GeneralCommand̃RNV
    /// <summary>
    /// <ja>
    /// R}h}l[WC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows command manager.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// R}h}l[Ẃu<c>org.poderosa.core.commands</c>vƂvOCIDCommandManagerPluginvOCɂ
    /// 񋟂Ă܂B
    /// </para>
    /// <para>
    /// ̃C^[tFCX擾ɂ́Ai1j<seealso cref="Poderosa.Plugins.IPluginManager">IPluginManager</seealso>
    /// <see cref="Poderosa.Plugins.IPluginManager.FindPlugin">FindPlugin\bh</see>Łu<c>org.poderosa.core.commands</c>vA
    /// i2j<seealso cref="Poderosa.Plugins.ICoreServices">ICoreServices</seealso><see cref="Poderosa.Plugins.ICoreServices.CommandManager">CommandManagervpeB</see>gĎ擾Âꂩ̕@Ƃ܂B
    /// </para>
    /// </ja>
    /// <en>
    /// <para>
    /// The command manager is offered by CommandManagerPlugin plug-in with plug-in ID of "<c>org.poderosa.core.commands</c>".
    /// </para>
    /// <para>
    /// To get this interface, the developer cat adopt either of method. (1) Retrieve [<c>org.poderosa.core.commands</c>] by <see cref="Poderosa.Plugins.IPluginManager.FindPlugin">FindPlugin method</see> on <seealso cref="Poderosa.Plugins.IPluginManager">IPluginManager</seealso>.
    /// </para>
    /// </en>
    /// </remarks>
    /// <example>
    /// <ja>
    /// ICoreServiceCommandManagervpeBICommandManager擾܂B
    /// <code>
    /// // PoderosaWorld́AInitializePlugin\bhŎ󂯎
    /// // IPoderosaWorldłƉ肵܂B
    /// ICoreServices cs = (ICoreServices)PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// ICommandManager cm = cs.CommandManager;
    /// </code>
    /// </ja>
    /// <en>
    /// Get ICommandManager from CommandManager property on ICoreService.
    /// <code>
    /// // It is assumed that PoderosaWorld is IPoderosaWorld here received by the InitializePlugin method. 
    /// ICoreServices cs = (ICoreServices)PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// ICommandManager cm = cs.CommandManager;
    /// </code>
    /// </en>
    /// </example>
    public interface ICommandManager : IAdaptable {
        /// <summary>
        /// <ja>
        /// R}hR}h}l[Wɓo^܂B
        /// </ja>
        /// <en>
        /// Regist command to the command manager.
        /// </en>
        /// </summary>
        /// <param name="command">
        /// <ja>
        /// o^R}hłB
        /// </ja>
        /// <en>
        /// Command to be regist.
        /// </en>
        /// </param>
        void Register(IGeneralCommand command);
        void Unregister(IGeneralCommand command);
        /// <summary>
        /// <ja>
        /// R}hIDL[ɂāAR}h}l[Wɓo^ꂽR}h܂B
        /// </ja>
        /// <en>
        /// Retrieve command ID is made a key, and the command registered by the command manager.
        /// </en>
        /// </summary>
        /// <param name="id">
        /// <ja>
        /// R}hIDłB
        /// </ja>
        /// <en>
        /// Retrieval of the command ID.
        /// </en>
        /// </param>
        /// <returns>
        /// <ja>
        /// R}hIuWFNg<seealso cref="IGeneralCommand">IGeneralCommand</seealso>Ԃ܂B
        /// ȂƂɂ<c>null</c>Ԃ܂B
        /// </ja>
        /// <en>
        /// <seealso cref="IGeneralCommand">IGeneralCommand</seealso> of the found command object is returned. 
        /// When not found, <c>null</c> is returned. 
        /// </en>
        /// </returns>
        /// <overloads>
        /// <summary>
        /// <ja>R}hs܂B</ja>
        /// <en>Execute the command.</en>
        /// </summary>
        /// </overloads>
        IGeneralCommand Find(string id);
        /// <summary>
        /// <ja>
        /// V[gJbgL[L[ɂāAR}h}l[Wɓo^ꂽR}h܂B
        /// </ja>
        /// <en>
        /// The shortcut key is made a key, and the command registered by the command manager is retrieved. 
        /// </en>
        /// </summary>
        /// <param name="key">
        /// <ja>
        /// V[gJbgL[łB
        /// </ja>
        /// <en>
        /// Retrieval short cut key.
        /// </en>
        /// </param>
        /// <returns>
        /// <ja>
        /// R}hIuWFNg<seealso cref="IGeneralCommand">IGeneralCommand</seealso>Ԃ܂B
        /// ȂƂɂ<c>null</c>Ԃ܂B
        /// </ja>
        /// <en>
        /// <seealso cref="IGeneralCommand">IGeneralCommand</seealso> of the found command object is returned. 
        /// When not found, <c>null</c> is returned. 
        /// </en>
        /// </returns>
        IGeneralCommand Find(Keys key); //V[gJbgL[
        /// <summary>
        /// <ja>
        /// R}h}l[Wɓo^Ă邷ׂẴR}hIuWFNg񋓂܂B
        /// </ja>
        /// <en>
        /// Enumerate all the command objects being registered by the command manager.
        /// </en>
        /// </summary>
        IEnumerable<IGeneralCommand> Commands { get; }

        /// <summary>
        /// <ja>
        /// w肳ꂽR}hs܂B
        /// </ja>
        /// <en>
        /// Execute the specified command.
        /// </en>
        /// </summary>
        /// <param name="command">
        /// <ja>
        /// sR}hłB
        /// </ja>
        /// <en>
        /// Command to execute.
        /// </en>
        /// </param>
        /// <param name="target">
        /// <ja>
        /// R}h̃^[QbgłB
        /// </ja>
        /// <en>
        /// Target of command.
        /// </en>
        /// </param>
        /// <param name="args">
        /// <ja>
        /// R}hɓnCӂ̈łB
        /// </ja>
        /// <en>
        /// Arbitrary argument passed to command
        /// </en>
        /// </param>
        /// <returns>
        /// <ja>
        /// R}h̎sʂłB̒ĺA<seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>
        /// <see cref="IPoderosaCommand.InternalExecute">InternalExecute\bh</see>ԂlƓłB
        /// </ja>
        /// <en>
        /// It is an execution result of the command. This value is the same as the value that the 
        /// <see cref="IPoderosaCommand.InternalExecute">InternalExecute method</see>
        ///  of <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso> returns. 
        /// </en>
        /// </returns>
        /// <remarks>
        /// <ja>
        /// <para>
        /// j[c[o[ĂяoR}h́A<paramref name="target"/>ɂ́A
        /// CEBhE<see cref="Poderosa.Forms.IPoderosaMainWindow">IPoderosaMainWindow</see>n邱Ƃz肵Ă܂B̎ȊÕC^[tFCXnꂽƂɂ́A
        /// 삵܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// The command called from the menu and the toolbar assumes to <paramref name="target"/> <see cref="Poderosa.Forms.IPoderosaMainWindow">IPoderosaMainWindow</see>'s that shows the main window being passed. 
        /// When interfaces other than this seed are passed, it doesn't operate correctly. 
        /// </para>
        /// </en>
        /// </remarks>
        /// <example>
        /// <ja>
        /// ut@CփRs[v̋@\ĂR}hu<c>org.poderosa.terminalemulator.copytofile</c>vĂяoāA
        /// ݑIĂ͈͂t@CւƃRs[܂B
        /// <code>
        /// // ICoreServices̎擾
        /// ICoreServices cs = (ICoreServices)PoderosaWorld.GetAdapter(typeof(ICoreServices));
        /// // R}h}l[W̎擾
        /// ICommandManager cm = cs.CommandManager;
        /// 
        /// // ut@CփRs[ṽR}h
        /// IGeneralCommand cmd = cm.Find("org.poderosa.terminalemulator.copytofile");
        /// 
        /// // ANeBuEBhEIPoderosaMainWindow𓾂
        /// IPoderosaMainWindow mainwin = cs.WindowManager.ActiveWindow;
        /// 
        /// // s
        /// CommandResult result = cm.Execute(cmd, mainwin);
        /// </code>
        /// </ja>
        /// <en>
        /// Command "<c>org.poderosa.terminalemulator.copytofile</c>" where the function of "Save to file" is implemented is called, 
        /// and the range that has been selected now is copied to the file. 
        /// <code>
        /// // Get ICoreServices
        /// ICoreServices cs = (ICoreServices)PoderosaWorld.GetAdapter(typeof(ICoreServices));
        /// // Get command manager.
        /// ICommandManager cm = cs.CommandManager;
        /// 
        /// // Retrieval of the command of "Save to file"
        /// IGeneralCommand cmd = cm.Find("org.poderosa.terminalemulator.copytofile");
        /// 
        /// // Get the IPoderosaMainWindow of the active window.
        /// IPoderosaMainWindow mainwin = cs.WindowManager.ActiveWindow;
        /// 
        /// // Execute
        /// CommandResult result = cm.Execute(cmd, mainwin);
        /// </code>
        /// </en>
        /// </example>
        CommandResult Execute(IPoderosaCommand command, ICommandTarget target, params IAdaptable[] args);
        
        /// <exclude/>
        IKeyBinds CurrentKeyBinds { get; }

        /// <exclude/>
        IKeyBinds GetKeyBinds(IPreferenceFolder folder); //ƈaBʃC^tF[XɕH

        /// <summary>
        /// <ja>
        /// `ς݃R}hJeS擾邽߂̃C^[tFCXłB
        /// </ja>
        /// <en>
        /// Interface to get command category that has been defined.
        /// </en>
        /// </summary>
        IDefaultCommandCategories CommandCategories { get; }
    }
    
    //L[oChݒ
    /// <summary>
    /// <ja>
    /// L[oCh̐ݒ𑀍삷C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that operates setting of key bind.
    /// </en>
    /// </summary>
    public interface IKeyBinds {
        /// <summary>
        /// <ja>
        /// 蓖ĂĂV[gJbgL[̃RNVłB
        /// </ja>
        /// <en>
        /// Collection of allocated shortcut key.
        /// </en>
        /// </summary>
        ICollection Commands { get; }

        /// <summary>
        /// <ja>
        /// R}hɊ蓖ĂꂽV[gJbgL[Ԃ܂B
        /// </ja>
        /// <en>
        /// Return the shortcut key allocated in the command.
        /// </en>
        /// </summary>
        /// <param name="command">
        /// <ja>
        /// ׂR}hłB
        /// </ja>
        /// <en>
        /// Command that wants to be examined.
        /// </en>
        /// </param>
        /// <returns>
        /// <ja>
        /// L[Ɋ蓖ĂꂽV[gJbgL[߂܂BV[gJbgL[蓖ĂĂȂꍇɂ́AKeys.None߂܂B
        /// </ja>
        /// <en>
        /// The shortcut key allocated in the key returns. Keys.None returns when the shortcut key is not allocated. 
        /// </en>
        /// </returns>
        Keys GetKey(IGeneralCommand command);
        /// <summary>
        /// <ja>
        /// R}hɑ΂ăV[gJbgL[蓖Ă܂B
        /// </ja>
        /// <en>
        /// The shortcut key is allocated to the command. 
        /// </en>
        /// </summary>
        /// <param name="command">
        /// <ja>
        /// ΏۂƂȂR}hłB
        /// </ja>
        /// <en>
        /// Command that becomes object.
        /// </en>
        /// </param>
        /// <param name="key">
        /// <ja>
        /// 蓖ĂV[gJbgL[łB
        /// </ja>
        /// <en>
        /// Allocated shortcut key
        /// </en>
        /// </param>
        /// <exception cref="ArgumentException">
        /// <ja>
        /// ỸL[ɂ́Ałɂق̃R}h蓖ĂĂ܂B
        /// </ja>
        /// <en>
        /// Other commands have already been allocated in the key to the correspondence. 
        /// </en>
        /// </exception>
        /// <remarks>
        /// <ja>
        /// <para>
        /// <paramref name="key">key</paramref>Keys.NonenƁAV[gJbgL[̊蓖Ăł܂B
        /// </para>
        /// <para>
        /// <paramref name="key">key</paramref>ɂłɃR}h蓖ĂĂƂɂ͗O܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// The allocation of the shortcut <paramref name="key">key</paramref> can be released by passing key Keys.None. 
        /// </para>
        /// <para>
        /// When the command has already been allocated in <paramref name="key">key</paramref>, the exception is generated. 
        /// </para>
        /// </en>
        /// </remarks>
        void SetKey(IGeneralCommand command, Keys key);

        /// <summary>
        /// <ja>
        /// V[gJbgL[Ɋ蓖ĂĂR}h܂B
        /// </ja>
        /// <en>
        /// Retrieval the command allocated in the shortcut key.
        /// </en>
        /// </summary>
        /// <param name="key">
        /// <ja>
        /// V[gJbgL[łB
        /// </ja>
        /// <en>
        /// Retrieved shortcut key
        /// </en>
        /// </param>
        /// <returns>
        /// <ja>V[gJbgL[Ɋ蓖ĂĂR}hԂ܂BȂƂɂnullԂ܂B</ja>
        /// <en>The command allocated in the shortcut key is returned. When not found, null is returned. </en>
        /// </returns>
        IGeneralCommand FindCommand(Keys key);

        /// <summary>
        /// <ja>
        /// V[gJbgL[̊蓖ĂׂăNA܂B
        /// </ja>
        /// <en>
        /// The allocation of the shortcut key is all cleared. 
        /// </en>
        /// </summary>
        void ClearAll();
        /// <summary>
        /// <ja>
        /// V[gJbgL[̊蓖ĂftHgɖ߂܂B
        /// </ja>
        /// <en>
        /// The allocation of the shortcut key is set to default.
        /// </en>
        /// </summary>
        void ResetToDefault();
        /// <summary>
        /// <ja>
        /// V[gJbgL[̊蓖ĂC|[g܂B
        /// </ja>
        /// <en>
        /// Import the allocation of the shortcut key.
        /// </en>
        /// </summary>
        /// <param name="keybinds">
        /// <ja>
        /// C|[gV[gJbgL[łB
        /// </ja>
        /// <en>
        /// The shortcut key to import.
        /// </en>
        /// </param>
        void Import(IKeyBinds keybinds);

    }

    //j[

    //Extension Pointւ̐ڑp
    /// <summary>
    /// <ja>
    /// j[̌X̃ACeC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows each item of menu.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// j[ڂ쐬ꍇɂ́A<seealso cref="PoderosaMenuItemImpl">PoderosaMenuItemTmpl</seealso>g܂B
    /// </ja>
    /// <en>
    /// When the menu item is made, <seealso cref="PoderosaMenuItemImpl">PoderosaMenuItemTmpl</seealso> is used. 
    /// </en>
    /// </remarks>
    public interface IPoderosaMenu : IAdaptable {
        /// <summary>
        /// <ja>
        /// j[ɕ\eLXgłB
        /// </ja>
        /// <en>
        /// Text displayed in menu
        /// </en>
        /// </summary>
        string Text { get; }
        /// <summary>
        /// <ja>
        /// j[̃Cl[u^fBXGȕԂԂ\bhłB
        /// </ja>
        /// <en>
        /// Method of returning state of enable/disable of menu
        /// </en>
        /// </summary>
        /// <param name="target">
        /// <ja>
        /// R}h̃^[QbgłB
        /// </ja>
        /// <en>
        /// Target of command.
        /// </en>
        /// </param>
        /// <returns>
        /// <ja>
        /// j[Cl[ułꍇɂtrueAfBXGułꍇɂfalseԂ܂B
        /// </ja>
        /// <en>
        /// When it is true, and disable when the menu is enable, false is returned. 
        /// </en>
        /// </returns>
        bool IsEnabled(ICommandTarget target);
        /// <summary>
        /// <ja>
        /// j[̃`FbNԂԂ\bhłB
        /// </ja>
        /// <en>
        /// Method of returning check state on menu
        /// </en>
        /// </summary>
        /// <param name="target">
        /// <ja>
        /// R}h̃^[QbgłB
        /// </ja>
        /// <en>
        /// Target of command.
        /// </en>
        /// </param>
        /// <returns>
        /// <ja>
        /// j[Ƀ`FbNtĂꍇɂtrueAłȂꍇɂfalseԂ܂B
        /// </ja>
        /// <en>
        /// When the menu is checked, true is returned when it is false so. 
        /// </en>
        /// </returns>
        bool IsChecked(ICommandTarget target);
    }

    //MenuGroup̓o[̃f~^P
    /// <summary>
    /// <ja>
    /// j[ڂW߂j[O[v\C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that composes menu group that collects menu items.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// j[Poderosaɓo^ꍇɂ́Aj[ڂW߂j[O[v쐬Ag|CgւƓo^܂B
    /// </para>
    /// <para>
    /// j[O[v쐬ꍇɂ́A<seealso cref="PoderosaMenuGroupImpl">PoderosaMenuGroupImpl</seealso>gƂł܂B
    /// </para>
    /// </ja>
    /// <en>
    /// <para>
    /// The menu group that collects the menu items is made when the menu is registered in Poderosa, and it registers to the extension point. 
    /// </para>
    /// <para>
    /// When the menu group is made, <seealso cref="PoderosaMenuGroupImpl">PoderosaMenuGroupImpl</seealso> can be used. 
    /// </para>
    /// </en>
    /// </remarks>
    public interface IPoderosaMenuGroup : IAdaptable {
        /// <summary>
        /// <ja>
        /// ̃j[O[vɊ܂܂郁j[ڂ̔złB
        /// </ja>
        /// <en>
        /// Array of menu item included in this menu group.
        /// </en>
        /// </summary>
        IPoderosaMenu[] ChildMenus { get; }
        /// <summary>
        /// <ja>
        /// j[ڂIɍ邩ǂ܂B
        /// </ja>
        /// <en>
        /// It is shown whether the menu item is dynamically made. 
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// truełꍇAj[ڂ\悤Ƃ邽тɁAj[Đ܂BIȃj[\ꍇɂtrueAłȂꍇɂfalseԂ悤Ɏ܂B
        /// </ja>
        /// <en>
        /// The menu is done whenever the menu item tries to be displayed when it is true and the reproduction is done. 
        /// When a dynamic menu is composed, true is implemented to return false when it is not so. 
        /// </en>
        /// </remarks>
        bool IsVolatileContent { get; }
        /// <summary>
        /// <ja>
        /// ̃j[O[v̑Oɋ؂LiZp[^j邩ǂ܂B
        /// </ja>
        /// <en>
        /// It is shown whether the separator enters ahead of this menu group. 
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// truełꍇÃj[O[v̒Oɋ؂LiZp[^j\܂B
        /// </ja>
        /// <en>
        /// When it is true, the separator is displayed just before this menu group. 
        /// </en>
        /// </remarks>
        bool ShowSeparator { get; } //O[v̑OɃZp[^邩ǂ
    }

    /// <summary>
    /// <ja>
    /// j[Kw邽߂̃C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface to hierarchize menu
    /// </en>
    /// </summary>
    public interface IPoderosaMenuFolder : IPoderosaMenu {
        /// <summary>
        /// <ja>
        /// KwTuj[̔złB
        /// </ja>
        /// <en>
        /// Array of hierarchized submenu
        /// </en>
        /// </summary>
        IPoderosaMenuGroup[] ChildGroups { get; }
    }


    /// <summary>
    /// <ja>
    /// sƂɈ𔺂Ȃj[ڂC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows menu item not to accompany argument when executed.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// ̃j[ڂ́A<seealso cref="PoderosaMenuItemImpl">PoderosaMenuItemImpl</seealso>gƂō쐬ł܂B
    /// </ja>
    /// <en>
    /// This menu item can be made by using <seealso cref="PoderosaMenuItemImpl">PoderosaMenuItemImpl</seealso>. 
    /// </en>
    /// </remarks>
    public interface IPoderosaMenuItem : IPoderosaMenu {
        /// <summary>
        /// <ja>
        /// j[IꂽƂɌĂяoR}hłB
        /// </ja>
        /// <en>
        /// Command called when menu is selected.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// j[IƁÃvpeBŐݒ肵<see cref="IPoderosaCommand.InternalExecute">InternalExecute\bh</see>
        /// Ăяo܂B
        /// </ja>
        /// <en>
        /// The <see cref="IPoderosaCommand.InternalExecute">InternalExecute method</see> that sets for the menu to be selected in this property is called. 
        /// </en>
        /// </remarks>
        IPoderosaCommand AssociatedCommand { get; }
    }

    //MRUȂǁAt̂
    /// <summary>
    /// <ja>
    /// sƂɈ𔺂j[ڂC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows menu item with argument when executed
    /// </en>
    /// </summary>
    public interface IPoderosaMenuItemWithArgs : IPoderosaMenuItem {
        /// <summary>
        /// <ja>
        /// R}hsƂɈnCӂ̈łB
        /// </ja>
        /// <en>
        /// Arbitrary argument handed over when command is executed.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// ̈́A<seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>
        /// <see cref="IPoderosaCommand.InternalExecute">InternalExecute\bh</see>
        /// ĂяoƂA3ɂ̂܂ܓn܂B
        /// </ja>
        /// <en>
        /// When the <see cref="IPoderosaCommand.InternalExecute">InternalExecute method</see> of <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso> is called, this argument is passed to the third argument as it is. 
        /// </en>
        /// </remarks>
        IAdaptable[] AdditionalArgs { get; }
    }

    //ReLXgj[\͂̂NX
    /// <summary>
    /// <ja>
    /// ReLXgj[̋@\vOCׂNXłB
    /// </ja>
    /// <en>
    /// Class that plug-in with function of context menu should implement.
    /// </en>
    /// </summary>
    public interface IPoderosaContextMenuPoint : IAdaptable {
        //null
        /// <summary>
        /// <ja>
        /// ReLXgj[j[O[vłB
        /// </ja>
        /// <en>
        /// Menu group that shows context menu
        /// </en>
        /// </summary>
        IPoderosaMenuGroup[] ContextMenu { get; }
    }



    //IPoderosaCommandW
    /// <summary>
    /// <ja>
    /// <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>NXłBR}h쐬ۂɎg܂B
    /// </ja>
    /// <en>
    /// It is a class that implements <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>. When the command is made, it uses it. 
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// R}hJ҂́ÃNXgƂ<seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>IuWFNg
    /// eՂɍ쐬ł܂B
    /// </para>
    /// <para>
    /// V[gJbgL[蓖ĂR}h쐬ꍇɂ́A<seealso cref="GeneralCommandImpl">GeneralCommandImpl</seealso>gĂB
    /// </para>
    /// </ja>
    /// <en>
    /// <para>
    /// The developer who implements the command can easily make the object where <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso> is implemented by using this class. 
    /// </para>
    /// <para>
    /// Please use <seealso cref="GeneralCommandImpl">GeneralCommandImpl</seealso> when you make the command that allocates the shortcut key. 
    /// </para>
    /// </en>
    /// </remarks>
    /// <example>
    /// <ja>
    /// <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>IuWFNǵÂ悤ɂč쐬ł܂B
    /// <code>
    /// PoderosaCommandImpl mycommand = new PoderosaCommandImpl(
    ///   delegate(ICommandTarget target)
    ///   {
    ///     // R}hsꂽƂ̏
    ///    MessageBox.Show("s܂");
    ///    return CommandResult.Succeeded;
    ///   },
    ///   delegate(ICommandTarget target)
    ///   {
    ///     // R}hsł邩ǂԂ
    ///    return true;
    ///  }
    /// );
    /// </code>
    /// </ja>
    /// <en>
    /// The object that implements <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso> can be made as follows. 
    /// <code>
    /// PoderosaCommandImpl mycommand = new PoderosaCommandImpl(
    ///   delegate(ICommandTarget target)
    ///   {
    ///     // Processing when command is executed
    ///    MessageBox.Show("Executed");
    ///    return CommandResult.Succeeded;
    ///   },
    ///   delegate(ICommandTarget target)
    ///   {
    ///     // Return whether the command can be executed. 
    ///    return true;
    ///  }
    /// );
    /// </code>
    /// </en>
    /// </example>
    public class PoderosaCommandImpl : IPoderosaCommand {
        /// <exclude/>
        protected ExecuteDelegate _execute;
        /// <exclude/>
        protected CanExecuteDelegate _canExecute;

        /// <summary>
        /// <ja>
        /// Ȃ̃RXgN^łB
        /// </ja>
        /// <en>
        /// Constructor that doesn't have argument
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// ̃RXgN^ō쐬ꂽR}h́AR}hsĂȂ鏈܂B
        /// </ja>
        /// <en>
        /// The command made by this constructor is executed the command or doesn't do the becoming it processing either. 
        /// </en>
        /// </remarks>
        /// <overloads>
        /// <summary>
        /// <ja>
        /// R}hIuWFNg쐬܂B
        /// </ja>
        /// <en>
        /// Making the command object. 
        /// </en>
        /// </summary>
        /// </overloads>
        public PoderosaCommandImpl() {
            _execute = null;
            _canExecute = null;
        }
        /// <summary>
        /// <ja>
        /// R}hsۂɌĂяofQ[gw肵RXgN^łB
        /// </ja>
        /// <en>
        /// Constructor who specified delegate called when command is executed
        /// </en>
        /// </summary>
        /// <param name="execute">
        /// <ja>
        /// R}hsۂɌĂяofQ[głB
        /// </ja>
        /// <en>
        /// Delegate called when command is executed
        /// </en>
        /// </param>
        /// <remarks>
        /// <ja>
        /// <para>
        /// R}hsہ\\<seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>
        /// <see cref="IPoderosaCommand.InternalExecute">InternalExecute</see>\bhĂяoƂɁA<paramref name="execute">execute</paramref>
        /// Ɏw肵fQ[gĂяo܂B
        /// </para>
        /// <para>
        /// <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso><see cref="IPoderosaCommand.CanExecute">CanExecute</see>\bh̏ł́AtrueԂ悤Ɏ܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// When the <see cref="IPoderosaCommand.InternalExecute">InternalExecute</see> method of <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso> is called, specified delegate is called in execute when paraphrasing it when the command is executed. 
        /// </para>
        /// <para>
        /// In the processing of the <see cref="IPoderosaCommand.CanExecute">CanExecute</see> method of <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>, true is always implemented so that it is returned. 
        /// </para>
        /// </en>
        /// </remarks>
        public PoderosaCommandImpl(ExecuteDelegate execute) {
            _execute = execute;
            _canExecute = null;
        }
        /// <summary>
        /// <ja>
        /// R}hsۂɌĂяofQ[gƁAj[c[o[I\ǂfQ[gw肵RXgN^łB
        /// </ja>
        /// <en>
        /// Constructor that specified delegate that shows whether delegate, menu, and toolbar called when command is executed can be selected
        /// </en>
        /// </summary>
        /// <param name="execute">
        /// <ja>
        /// R}hsۂɌĂяofQ[głB
        /// </ja>
        /// <en>
        /// Delegate called when command is executed.
        /// </en>
        /// </param>
        /// <param name="canExecute">
        /// <ja>j[c[o[Cl[uɂ邩fBXGuɂ邩߂ƂɌĂяofQ[głB</ja>
        /// <en>Delegate called when whether menu and toolbar are made Inabl or making to disable is decided.</en>
        /// </param>
        /// <remarks>
        /// <ja>
        /// <para>
        /// R}hsہ\\<seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>
        /// <see cref="IPoderosaCommand.InternalExecute">InternalExecute</see>\bhĂяoƂɁA<paramref name="execute">execute</paramref>
        /// Ɏw肵fQ[gĂяo܂B
        /// </para>
        /// <para>
        /// j[c[o[Cl[uɂ邩fBXGuɂ邩߂Ƃ\\
        /// <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso><see cref="IPoderosaCommand.CanExecute">CanExecute</see>\bhĂяoƂɁA
        /// <paramref name="canExecute">canExecute</paramref>Ɏw肵fQ[gĂяo܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// When the <see cref="IPoderosaCommand.InternalExecute">InternalExecute</see> method of <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso> is called, specified delegate is called in execute when paraphrasing it when the command is executed. 
        /// </para>
        /// <para>
        /// In the processing of the <see cref="IPoderosaCommand.CanExecute">CanExecute</see> method of <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>, true is always implemented so that it is returned. 
        /// </para>
        /// </en>
        /// </remarks>
        public PoderosaCommandImpl(ExecuteDelegate execute, CanExecuteDelegate canExecute) {
            _execute = execute;
            _canExecute = canExecute;
        }

        /// <summary>
        /// <ja>
        /// RXgN^Ŏw肳ꂽfQ[gs邽߂̃I[o[ChĂ܂B
        /// </ja>
        /// <en>
        /// The override to execute delegate specified by the constructor is done. 
        /// </en>
        /// </summary>
        /// <param name="target"><ja>R}h̃^[QbgłB</ja>
        /// <en>
        /// Target of command.
        /// </en>
        /// </param>
        /// <param name="args"><ja>R}ḧłB</ja>
        /// <en>Argument of commane.</en></param>
        /// <returns><ja>RXgN^Ŏw肳ꂽfQ[gsʂ߂܂B</ja>
        /// <en>The result of executing delegate specified by the constructor is returned. </en></returns>
        /// <remarks>
        /// <ja>
        /// Ȃ̃RXgN^ł̃IuWFNgꂽꍇAs邱Ƃ͂ȂA߂lƂCommandResult.IgnoredԂ܂B
        /// </ja>
        /// <en>
        /// Nothing is executed when this object is made from the constructor who doesn't have the argument, and CommandResult.Ignored is returned as a return value. 
        /// </en>
        /// </remarks>
        public virtual CommandResult InternalExecute(ICommandTarget target, params IAdaptable[] args) {
            return _execute==null? CommandResult.Ignored : _execute(target);
        }

        /// <summary>
        /// <ja>
        /// RXgN^Ŏw肳ꂽfQ[gs邽߂ɃI[o[ChĂ܂B
        /// </ja>
        /// <en>
        /// To execute delegate specified by the constructor, override is done. 
        /// </en>
        /// </summary>
        /// <param name="target"><ja>R}h̃^[QbgłB</ja>
        /// <en>
        /// Target of command.
        /// </en>
        /// </param>
        /// <returns><ja>RXgN^Ŏw肳ꂽfQ[gsʂ߂܂B</ja>
        /// <en>The result of executing delegate specified by the constructor is returned. </en></returns>
        /// <remarks>
        /// <ja>
        /// ȂA܂́A1̃RXgN^ł̃IuWFNgꂽꍇAtrueԂ܂B
        /// </ja>
        /// <en>
        /// The argument none or the argument is returned and when this object is made from one constructor, true is always returned. 
        /// </en>
        /// </remarks>
        public virtual bool CanExecute(ICommandTarget target) {
            return _canExecute==null? true : _canExecute(target);
        }

        public virtual IAdaptable GetAdapter(Type adapter) {
            return CommandManagerPlugin.Instance.PoderosaWorld.AdapterManager.GetAdapter(this, adapter);
        }
    }

    //IGeneralCommandW
    /// <summary>
    /// <ja>
    /// <seealso cref="IGeneralCommand">IGeneralCommand</seealso>NXłBV[gJbgL[蓖ĂR}h쐬ۂɎg܂B
    /// </ja>
    /// <en>
    /// It is a class that implements <seealso cref="IGeneralCommand">IGeneralCommand</seealso>. When the command that allocates the shortcut key is made, it uses it. 
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// V[gJbgL[蓖ĂR}hJ҂́ÃNXgƂ<seealso cref="IGeneralCommand">IGeneralCommand</seealso>
    /// IuWFNgeՂɍ쐬ł܂B
    /// </para>
    /// <para>
    /// V[gJbgL[蓖ĂKvȂꍇɂ́A<seealso cref="PoderosaCommandImpl">PoderosaCommandImpl</seealso>gĂB
    /// </para>
    /// </ja>
    /// <en>
    /// <para>
    /// The developer who implements the command that allocates the shortcut key can easily make the object where <seealso cref="IGeneralCommand">IGeneralCommand</seealso> is implemented by using this class. 
    /// </para>
    /// <para>
    /// Please use <seealso cref="PoderosaCommandImpl">PoderosaCommandImpl</seealso> when you need not allocate the shortcut key. 
    /// </para>
    /// </en>
    /// </remarks>
    /// <example>
    /// <ja>
    /// [ҏWnƂ`ς݃JeSɑR}hIuWFNg쐬ɂ́Â悤ɂ܂B
    /// <code>
    /// // R}h}l[W̎擾
    /// ICoreServices cs = (ICoreServices)PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// ICommandManager cm = cs.CommandManager;
    /// 
    /// // R}h쐬
    /// IGeneralCommand mycmd = new GeneralCommandImpl(
    ///   "co.example.myplugin.mycommand",
    ///  "MyCommand", cm.CommandCategories.Edit,
    ///   delegate(ICommandTarget target)
    ///  {
    ///     // ɃR}hsƂ̏Lq܂
    ///   return CommandResult.Succeeded; // ȂSucceededԂ
    ///  },
    ///  delegate(ICommandTarget target)
    ///  {
    ///     // ɃR}h̉ۂׂƂ̏Lq܂
    ///     return true; // s\ȂtrueԂ
    ///  }
    /// );
    /// </code>
    /// 
    /// </ja>
    /// <en>
    /// To make the command object that belongs to the definition ending category of "Edit", as follows is done. 
    /// <code>
    /// // Get command manager.
    /// ICoreServices cs = (ICoreServices)PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// ICommandManager cm = cs.CommandManager;
    /// 
    /// // Make the command.
    /// IGeneralCommand mycmd = new GeneralCommandImpl(
    ///   "co.example.myplugin.mycommand",
    ///  "MyCommand", cm.CommandCategories.Edit,
    ///   delegate(ICommandTarget target)
    ///  {
    ///     // The processing when the command is executed here is described. 
    ///   return CommandResult.Succeeded; // If it is a success, Succeeded is returned. 
    ///  },
    ///  delegate(ICommandTarget target)
    ///  {
    ///     // The processing when right or wrong of the command is examined here is described. 
    ///     return true; // If it is executable, true is returned. 
    ///  }
    /// );
    /// </code>
    /// 
    /// </en>
    /// </example>
    public class GeneralCommandImpl : IGeneralCommand {
        /// <exclude/>
        protected string _commandID;
        /// <exclude/>
        protected string _descriptionTextID;
        /// <exclude/>
        protected StringResource _strResource;
        /// <exclude/>
        protected bool _usingStringResource;
        /// <exclude/>
        protected Keys _defaultShortcutKey;
        /// <exclude/>
        protected ICommandCategory _commandCategory;
        /// <exclude/>
        protected CanExecuteDelegate _canExecuteDelegate;
        /// <exclude/>
        protected ExecuteDelegate _executeDelegate;

        //K{vf^RXgN^
        /// <summary>
        /// <ja>
        /// R}hIDAJ`AeLXgIDAR}hJeSAR}hsۂɌĂяofQ[gAs\ǂ𒲂ׂۂɌĂяofQ[gw肵ăIuWFNg쐬܂B
        /// </ja>
        /// <en>
        /// The object is made specifying delegate called when delegate called when command ID, Culture, explanation text ID, the command category, and the command are executed and it is executable is examined. 
        /// </en>
        /// </summary>
        /// <param name="commandID">
        /// <ja>
        /// 蓖ĂR}hIDłBق̃R}hƂ͏dȂBꖳ̂̂w肵Ȃ΂Ȃ܂B
        /// </ja>
        /// <en>
        /// It is allocated command ID. The unique one that doesn't overlap should be specified other commands. 
        /// </en>
        /// </param>
        /// <param name="sr">
        /// <ja>
        /// J`łB
        /// </ja>
        /// <en>
        /// Information of the culture.
        /// </en>
        /// </param>
        /// <param name="descriptionTextID">
        /// <ja>
        /// R}h̐eLXgIDłB
        /// </ja>
        /// <en>
        /// Text ID that shows explanation of command
        /// </en>
        /// </param>
        /// <param name="commandCategory">
        /// <ja>
        /// R}h̃JeSłB
        /// </ja>
        /// <en>
        /// Category of command.
        /// </en>
        /// </param>
        /// <param name="exec">
        /// <ja>
        /// R}hsƂɌĂяofQ[głB
        /// </ja>
        /// <en>
        /// Delegate called when command is executed.
        /// </en>
        /// </param>
        /// <param name="canExecute">
        /// <ja>
        /// R}hs\ǂ𒲂ׂۂɌĂяofQ[głB
        /// </ja>
        /// <en>
        /// Delegate called when it is examined whether command is executable
        /// </en>
        /// </param>
        /// <overloads>
        /// <summary>
        /// <ja>
        /// R}hIuWFNg쐬܂B
        /// </ja>
        /// <en>
        /// Create the command object.
        /// </en>
        /// </summary>
        /// </overloads>
        public GeneralCommandImpl(string commandID, StringResource sr, string descriptionTextID, ICommandCategory commandCategory, ExecuteDelegate exec, CanExecuteDelegate canExecute) {
            _commandID = commandID;
            _usingStringResource = sr!=null;
            _strResource = sr;
            _descriptionTextID = descriptionTextID;
            _commandCategory = commandCategory;
            _executeDelegate = exec;
            _canExecuteDelegate = canExecute;
        }
        //ꕔvfȗRXgN^Q
        /// <summary>
        /// <ja>
        /// R}hIDAJ`AeLXgAR}hJeSAR}hsۂɌĂяofQ[gAs\ǂ𒲂ׂۂɌĂяofQ[gw肵ăIuWFNg쐬܂B
        /// </ja>
        /// <en>
        /// The object is made specifying delegate called when delegate called when command ID, Culture, explanation text ID, the command category, and the command are executed and it is executable is examined. 
        /// </en>
        /// </summary>
        /// <param name="commandID">
        /// <ja>
        /// 蓖ĂR}hIDłBق̃R}hƂ͏dȂBꖳ̂̂w肵Ȃ΂Ȃ܂B
        /// </ja>
        /// <en>
        /// It is allocated command ID. The unique one that doesn't overlap should be specified other commands. 
        /// </en>
        /// </param>
        /// <param name="description">
        /// <ja>
        /// R}h̐eLXgłB
        /// </ja>
        /// <en>
        /// Text that shows explanation of command
        /// </en>
        /// </param>
        /// <param name="category">
        /// <ja>
        /// R}h̃JeSłB
        /// </ja>
        /// <en>
        /// Category of command.
        /// </en>
        /// </param>
        /// <param name="execute">
        /// <ja>
        /// R}hsƂɌĂяofQ[głB
        /// </ja>
        /// <en>
        /// Delegate called when command is executed.
        /// </en>
        /// </param>
        /// <param name="canExecute">
        /// <ja>
        /// R}hs\ǂ𒲂ׂۂɌĂяofQ[głB
        /// </ja>
        /// <en>
        /// Dalagate called when it is examined whether the command is executable. 
        /// </en>
        /// </param>
        public GeneralCommandImpl(string commandID, string description, ICommandCategory category, ExecuteDelegate execute, CanExecuteDelegate canExecute)
            : this(commandID, null, description, category, execute, canExecute) {
        }
        /// <summary>
        /// <ja>
        /// R}hIDAJ`AeLXgIDAR}hJeSAR}hsۂɌĂяofQ[gw肵ăIuWFNg쐬܂B
        /// </ja>
        /// <en>
        /// The object is made specifying delegate called when command ID, culture, explanation text ID, the command category, and the command are executed. 
        /// </en>
        /// </summary>
        /// <param name="commandID">
        /// <ja>
        /// 蓖ĂR}hIDłBق̃R}hƂ͏dȂBꖳ̂̂w肵Ȃ΂Ȃ܂B
        /// </ja>
        /// <en>
        /// It is allocated command ID. The unique one that doesn't overlap should be specified other commands. 
        /// </en>
        /// </param>
        /// <param name="sr">
        /// <ja>
        /// J`łB
        /// </ja>
        /// <en>
        /// Information of the culture.
        /// </en>
        /// </param>
        /// <param name="descriptionTextID">
        /// <ja>
        /// R}h̐eLXgIDłB
        /// </ja>
        /// <en>
        /// Text ID that shows explanation of command.
        /// </en>
        /// </param>
        /// <param name="category">
        /// <ja>
        /// R}h̃JeSłB
        /// </ja>
        /// <en>
        /// Category of command.
        /// </en></param>
        /// <param name="execute">
        /// <ja>
        /// R}hsƂɌĂяofQ[głB
        /// </ja>
        /// <en>
        /// Delegate called when command is executed
        /// </en>
        /// </param>
        public GeneralCommandImpl(string commandID, StringResource sr, string descriptionTextID, ICommandCategory category, ExecuteDelegate execute)
            : this(commandID, sr, descriptionTextID, category, execute, null) {
        }
        /// <summary>
        /// <ja>
        /// R}hIDAJ`AeLXgAR}hJeSAR}hsۂɌĂяofQ[gw肵ăIuWFNg쐬܂B
        /// </ja>
        /// <en>
        /// The object is made specifying delegate called when command ID, culture, explanation text ID, the command category, and the command are executed. 
        /// </en>
        /// </summary>
        /// <param name="commandID">
        /// <ja>
        /// 蓖ĂR}hIDłBق̃R}hƂ͏dȂBꖳ̂̂w肵Ȃ΂Ȃ܂B
        /// </ja>
        /// <en>
        /// It is allocated command ID. The unique one that doesn't overlap should be specified other commands. 
        /// </en>
        /// </param>
        /// <param name="description">
        /// <ja>
        /// R}h̐eLXgłB
        /// </ja>
        /// <en>
        /// Text that shows explanation of command.
        /// </en>
        /// </param>
        /// <param name="category">
        /// <ja>
        /// R}h̃JeSłB
        /// </ja>
        /// <en>
        /// Category of command.
        /// </en>
        /// </param>
        /// <param name="execute">
        /// <ja>
        /// R}hsƂɌĂяofQ[głB
        /// </ja>
        /// <en>
        /// Delegate called when command is executed.
        /// </en>
        /// </param>
        public GeneralCommandImpl(string commandID, string description, ICommandCategory category, ExecuteDelegate execute)
            : this(commandID, null, description, category, execute, null) {
        }

        /// <summary>
        /// <ja>
        /// R}hIDAJ`AeLXgAR}hJeSw肵ăIuWFNg쐬܂B
        /// </ja>
        /// <en>
        /// The object is made specifying command ID, culture, the explanation text sentence, and the command category. 
        /// </en>
        /// </summary>
        /// <param name="commandID">
        /// <ja>
        /// 蓖ĂR}hIDłBق̃R}hƂ͏dȂBꖳ̂̂w肵Ȃ΂Ȃ܂B
        /// </ja>
        /// <en>
        /// It is allocated command ID. The unique one that doesn't overlap should be specified other commands. 
        /// </en>
        /// </param>
        /// <param name="sr">
        /// <ja>
        /// J`łB
        /// </ja>
        /// <en>
        /// Information of the culture.
        /// </en>
        /// </param>
        /// <param name="descriptionTextID">
        /// <ja>
        /// R}h̐eLXgIDłB
        /// </ja>
        /// <en>
        /// Text ID that shows explanation of command.
        /// </en>
        /// </param>
        /// <param name="category">
        /// <ja>
        /// R}h̃JeSłB
        /// </ja>
        /// <en>
        /// Category of command.
        /// </en>
        /// </param>
        public GeneralCommandImpl(string commandID, StringResource sr, string descriptionTextID, ICommandCategory category)
            : this(commandID, sr, descriptionTextID, category, null, null) {
        }
        /// <summary>
        /// <ja>
        /// R}hIDAeLXgAR}hJeSw肵ăIuWFNg쐬܂B
        /// </ja>
        /// <en>
        /// Create a object specifying command ID, the explanation text sentence, and the command category. 
        /// </en>
        /// </summary>
        /// <param name="commandID">
        /// <ja>
        /// 蓖ĂR}hIDłBق̃R}hƂ͏dȂBꖳ̂̂w肵Ȃ΂Ȃ܂B
        /// </ja>
        /// <en>
        /// It is allocated command ID. The unique one that doesn't overlap should be specified other commands. 
        /// </en>
        /// </param>
        /// <param name="description">
        /// <ja>
        /// R}h̐eLXgłB
        /// </ja>
        /// <en>
        /// Text that shows explanation of command
        /// </en>
        /// </param>
        /// <param name="category">
        /// <ja>
        /// R}h̃JeSłB
        /// </ja>
        /// <en>
        /// Category of command.
        /// </en>
        /// </param>
        public GeneralCommandImpl(string commandID, string description, ICommandCategory category)
            : this(commandID, null, description, category, null, null) {
        }

        /// <summary>
        /// <ja>
        /// ̃R}hɊ蓖ĂĂR}hIDłB
        /// </ja>
        /// <en>
        /// Command ID allocated in this command.
        /// </en>
        /// </summary>
        public virtual string CommandID {
            get {
                return _commandID;
            }
        }

        /// <summary>
        /// <ja>
        /// ̃R}hɐݒ肳ĂłB
        /// </ja>
        /// <en>
        /// Explanation set to this command.
        /// </en>
        /// </summary>
        public virtual string Description {
            get {
                return _usingStringResource? _strResource.GetString(_descriptionTextID) : _descriptionTextID;
            }
        }

        /// <summary>
        /// <ja>
        /// ftHg̃V[gJbgL[܂B
        /// </ja>
        /// <en>
        /// The shortcut key of default is shown. 
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>ftHg̃V[gJbgL[݂Ȃꍇɂ́AKeys.NoneԂ܂B</ja>
        /// <en>When the shortcut key of default doesn't exist, Keys.None is returned. </en>
        /// </remarks>
        public virtual Keys DefaultShortcutKey {
            get {
                return _defaultShortcutKey;
            }
        }

        /// <summary>
        /// <ja>
        /// R}hJeS܂B
        /// </ja>
        /// <en>
        /// The command category is shown. 
        /// </en>
        /// </summary>
        public virtual ICommandCategory CommandCategory {
            get {
                return _commandCategory;
            }
        }

        //ArgsKvȂ͓Ǝɔh
        /// <summary>
        /// <ja>
        /// I[o[[hłBR}hsƂɌĂяo悤ɐݒ肳ꂽfQ[gŌĂяo܂B
        /// </ja>
        /// <en>
        /// It is an overload. Delegate set for the command to be executed or to call it is called internally. 
        /// </en>
        /// </summary>
        /// <param name="target"><ja>Ώۂ^[QbgłB</ja><en>Target that shows processing object</en></param>
        /// <param name="args"><ja>R}hɈnCӂ̈łB</ja><en>Arbitrary argument handed over to command</en></param>
        /// <returns><ja>sꂽfQ[g̖߂lłB</ja><en>Return value of executed delegate</en></returns>
        public virtual CommandResult InternalExecute(ICommandTarget target, params IAdaptable[] args) {
            return _executeDelegate==null? CommandResult.Ignored : _executeDelegate(target);
        }

        /// <summary>
        /// <ja>
        /// I[o[[hłBR}hs\ǂ̊mFĂяo̍ۂɁAݒ肳ꂽfQ[gŌĂяo܂B
        /// </ja>
        /// <en>
        /// It is an overload. When it is called whether the command is executable to confirm it, set delegate is called internally. 
        /// </en>
        /// </summary>
        /// <param name="target"><ja>Ώۂ^[QbgłB</ja><en>Target that shows processing object.</en></param>
        /// <returns><ja>sꂽfQ[g̖߂lłB</ja><en>Return value of executed delegate.</en></returns>
        public virtual bool CanExecute(ICommandTarget target) {
            return _canExecuteDelegate==null? true : _canExecuteDelegate(target);
        }

        public virtual IAdaptable GetAdapter(Type adapter) {
            return CommandManagerPlugin.Instance.PoderosaWorld.AdapterManager.GetAdapter(this, adapter);
        }

        /// <summary>
        /// <ja>L[oCh̃ftHgݒύX܂B</ja>
        /// <en>The default setting of key bind is changed. </en>
        /// </summary>
        /// <param name="key"><ja>蓖ĂL[</ja><en>Key that wants to be allocated</en></param>
        /// <returns><ja>̃IuWFNggԂ܂B</ja><en>This object is returned. </en></returns>
        public GeneralCommandImpl SetDefaultShortcutKey(Keys key) {
            _defaultShortcutKey = key;
            return this;
        }
    }

    //IPoderosaMenuGroupW
    /// <summary>
    /// <ja>
    /// <seealso cref="IPoderosaMenuGroup">IPoderosaMenuGroup</seealso>NXłBj[O[v쐬ۂɎg܂B
    /// </ja>
    /// <en>
    /// It is a class that implements <seealso cref="IPoderosaMenuGroup">IPoderosaMenuGroup</seealso>. When the menu group is made, it uses it. 
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// j[J҂́ÃNXgƂŁA<seealso cref="IPoderosaMenuGroup">IPoderosaMenuGroup</seealso>
    /// IuWFNgeՂɍ쐬ł܂B̃NX́A<seealso cref="IPositionDesignation">IPositionDesignation</seealso>
    /// ĂAj[̏߂邱Ƃł܂B
    /// </para>
    /// <para>
    /// 쐬j[O[v́Ag|CgւƓo^܂B
    /// </para>
    /// <note type="implementnotes">
    /// xj[O[v쐬ꂽȂA𑝌@\̓T|[gĂ܂B܂j[ڂ͍쐬Ɍ܂AIɕω邱Ƃ͂܂B
    /// </note>
    /// </ja>
    /// <en>
    /// <para>
    /// The developer who implements the menu can easily make the object that implements 
    /// <seealso cref="IPoderosaMenuGroup">IPoderosaMenuGroup</seealso> by using this class. This class implements 
    /// <seealso cref="IPositionDesignation">IPositionDesignation</seealso>, and can decide the order of the menu. 
    /// </para>
    /// <para>
    /// The menu group that makes it registers to the extension point. 
    /// </para>
    /// <note type="implementnotes">
    /// If the menu group was made once, the function to increase and decrease it is not supported. Moreover, the menu item is decided when making it, and never changes dynamically. 
    /// </note>
    /// </en>
    /// </remarks>
    /// <example>
    /// <ja>
    /// <seealso cref="IPoderosaMenuGroup">IPoderosaMenuGroup</seealso>IuWFNǵÂ悤ɂč쐬ł܂B
    /// <code>
    /// // 炩߃j[sꂽƂ̃j[ƃj[ڂ쐬Ă܂B
    /// 
    /// // R}h
    /// PoderosaCommandImpl mycommand = new PoderosaCommandImpl(
    ///   delegate(ICommandTarget target)
    ///   {
    ///     // R}hsꂽƂ̏
    ///    MessageBox.Show("s܂");
    ///    return CommandResult.Succeeded;
    ///   },
    ///   delegate(ICommandTarget target)
    ///   {
    ///     // R}hsł邩ǂԂ
    ///    return true;
    ///  }
    /// );
    /// 
    /// // j[
    /// PoderosaMenuItemImpl menuitem = new PoderosaMenuItemImpl(
    ///     mycommand, "My Menu Name");
    ///
    /// // j[O[v
    /// PoderosaMenuGroupImpl menugroup = new PoderosaMenuGroupImpl(menuitem);
    /// 
    /// // ̃j[O[vAƂ΁mҏWnj[iorg.poderosa.menu.editjɓo^
    /// // g|Cg
    /// IExtensionPoint editmenu = 
    ///     PoderosaWorld.PluginManager.FindExtensionPoint("org.poderosa.menu.edit");
    /// // g|CgɃj[O[vo^
    /// editmenu.RegisterExtension(menugroup);
    /// </code>
    /// </ja>
    /// <en>
    /// The object that implements <seealso cref="IPoderosaMenuGroup">IPoderosaMenuGroup</seealso> can be made as follows. 
    /// <code>
    /// // The menu and the menu item when the menu is executed are made beforehand. 
    /// 
    /// // Command
    /// PoderosaCommandImpl mycommand = new PoderosaCommandImpl(
    ///   delegate(ICommandTarget target)
    ///   {
    ///     // Processing when command is executed
    ///    MessageBox.Show("Executed");
    ///    return CommandResult.Succeeded;
    ///   },
    ///   delegate(ICommandTarget target)
    ///   {
    ///     // It is returned whether the command can be executed. 
    ///    return true;
    ///  }
    /// );
    /// 
    /// // Menu item.
    /// PoderosaMenuItemImpl menuitem = new PoderosaMenuItemImpl(
    ///     mycommand, "My Menu Name");
    ///
    /// // Menu group.
    /// PoderosaMenuGroupImpl menugroup = new PoderosaMenuGroupImpl(menuitem);
    /// 
    /// // For instance, this menu group is registered in "Edit" menu (org.poderosa.menu.edit). 
    /// // Retrieval of The enhancing point.
    /// IExtensionPoint editmenu = 
    ///     PoderosaWorld.PluginManager.FindExtensionPoint("org.poderosa.menu.edit");
    /// // The menu group is registered in the extension point. 
    /// editmenu.RegisterExtension(menugroup);
    /// </code>
    /// </en>
    /// </example>
    public class PoderosaMenuGroupImpl : IPoderosaMenuGroup, IPositionDesignation {
        /// <exclude/>
        protected IPoderosaMenu[] _childMenus;
        /// <exclude/>
        protected bool _isVolatile;
        /// <exclude/>
        protected bool _showSeparator;
        /// <exclude/>
        protected IAdaptable _designationTarget;
        /// <exclude/>
        protected PositionType _positionType;

        /// <summary>
        /// <ja>
        /// ܂܂郁j[ڂЂƂȂj[O[v쐬܂B
        /// </ja>
        /// <en>
        /// The included menu item makes the menu group that is not no. 
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// j[ڂ͂ЂƂ܂񂪁A؂LiZp[^j͕\܂B
        /// </ja>
        /// <en>
        /// The separator is displayed though nothing is in the menu item. 
        /// </en>
        /// </remarks>
        /// <overloads>
        /// <summary>
        /// <ja>
        /// j[O[v쐬܂B
        /// </ja>
        /// <en>
        /// Create the menu group.
        /// </en>
        /// </summary>
        /// </overloads>
        public PoderosaMenuGroupImpl()
            : this(null, true) {
        }

        /// <summary>
        /// <ja>
        /// ܂܂郁j[ڂЂƂw肵j[O[v쐬܂B
        /// </ja>
        /// <en>
        /// The menu group that specifies only one included menu item is made. 
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// ؂LiZp[^j͕\܂B
        /// </ja>
        /// <en>
        /// The separator is displayed. 
        /// </en>
        /// </remarks>
        /// <param name="child"><ja>܂߂j[ڂłB</ja><en>Menu item that wants to be included</en></param>
        public PoderosaMenuGroupImpl(IPoderosaMenu child)
            : this(new IPoderosaMenu[] { child }, true) {
        }

        /// <summary>
        /// <ja>
        /// ܂܂郁j[ڂ𕡐w肵j[O[v쐬܂B
        /// </ja>
        /// <en>
        /// The menu group that specifies two or more included menu items is made. 
        /// </en>
        /// </summary>
        /// <param name="childMenus"><ja>܂߂j[ڂ̔złB</ja><en>Array of menu item that wants to be included</en></param>
        /// <remarks>
        /// <ja>
        /// ؂LiZp[^j͕\܂B
        /// </ja>
        /// <en>
        /// The separator is displayed. 
        /// </en>
        /// </remarks>
        public PoderosaMenuGroupImpl(IPoderosaMenu[] childMenus)
            :
            this(childMenus, true) {
        }
        /// <summary>
        /// <ja>
        /// ܂܂镡̃j[ڂƃj[ڂ̒Oɋ؂LiZp[^j\邩ۂ
        /// w肵ăj[O[v쐬܂B
        /// </ja>
        /// <en>
        /// The menu group is made specifying whether to display the separator just before two or more included menu item and menu item. 
        /// </en>
        /// </summary>
        /// <param name="childMenus"><ja>܂߂j[ڂ̔złB</ja><en>Array of menu item that wants to be included</en></param>
        /// <param name="showSeparator"><ja>Zp[^\邩ۂ̎włBtruêƂ\AfalsêƂ\łB</ja>
        /// <en>It is specification whether to display the separator. It displays at true, and non-display at false. </en></param>
        public PoderosaMenuGroupImpl(IPoderosaMenu[] childMenus, bool showSeparator) {
            _childMenus = childMenus;
            _isVolatile = false;
            _showSeparator = showSeparator;
            _designationTarget = null;
            _positionType = PositionType.First;
        }

        /// <summary>
        /// <ja>
        /// ܂܂郁j[ڂ̔złB
        /// </ja>
        /// <en>
        /// Array of included menu item
        /// </en>
        /// </summary>
        public virtual IPoderosaMenu[] ChildMenus {
            get {
                return _childMenus;
            }
        }

        /// <summary>
        /// <ja>
        /// j[Iɍ쐬邩ǂvpeBłB
        /// </ja>
        /// <en>
        /// Property that shows whether menu is dynamically made.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>falseij[𓮓Iɍ쐬ȂjԂ܂B</ja>
        /// <en>False (The menu is not dynamically made) is always returned. </en>
        /// </remarks>
        public virtual bool IsVolatileContent {
            get {
                return _isVolatile;
            }
        }

        /// <summary>
        /// <ja>
        /// ؂LiZp[^j\邩ۂ܂B
        /// </ja>
        /// <en>
        /// It is shown whether to display the separator. 
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// truȅꍇAj[O[v̒Oɋ؂LiZp[^j\܂Bfalsȅꍇɂ͕\܂B
        /// </ja>
        /// <en>
        /// The separator is displayed for true just before the menu group. It is not displayed for false. 
        /// </en>
        /// </remarks>
        public virtual bool ShowSeparator {
            get {
                return _showSeparator;
            }
        }


        /// <summary>
        /// <ja>
        /// j[zuꏊ̑Ώۂ܂B
        /// </ja>
        /// <en>
        /// The object of the place where the menu is arranged is shown. 
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <seealso cref="IPositionDesignation">IPositionDesignation</seealso>QƂĂB
        /// </ja>
        /// <en>
        /// Please refer to <seealso cref="IPositionDesignation">IPositionDesignation</seealso>.
        /// </en>
        /// </remarks>
        public virtual IAdaptable DesignationTarget {
            get {
                return _designationTarget;
            }
        }

        /// <summary>
        /// <ja>
        /// j[̕\ʒu܂B
        /// </ja>
        /// <en>
        /// The position where the menu is displayed is shown. 
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <seealso cref="IPositionDesignation">IPositionDesignation</seealso>QƂĂB
        /// </ja>
        /// <en>
        /// Refer to <seealso cref="IPositionDesignation">IPositionDesignation</seealso>.
        /// </en>
        /// </remarks>
        public virtual PositionType DesignationPosition {
            get {
                return _positionType;
            }
        }
        public virtual IAdaptable GetAdapter(Type adapter) {
            return CommandManagerPlugin.Instance.PoderosaWorld.AdapterManager.GetAdapter(this, adapter);
        }

        //|WVZbg
        /// <summary>
        /// <ja>
        /// j[̈ʒuݒ肵܂B
        /// </ja>
        /// <en>
        /// Set The position of the menu.
        /// </en>
        /// </summary>
        /// <param name="type">
        /// <ja>j[̏ꏊw肵܂B</ja>
        /// <en>Specifies the place of the menu.</en>
        /// </param>
        /// <param name="target">
        /// <ja>ǂ̃j[ɑ΂ʒuȂ̂w肵܂B<see cref="IPoderosaMenuGroup">IPoderosaMenuGroup</see>łȂ΂Ȃ܂B</ja>
        /// <en>To which menu position it is is specified. It should be <see cref="IPoderosaMenuGroup">IPoderosaMenuGroup</see>. </en>
        /// </param>
        /// <returns><ja>̃IuWFNgg߂܂B</ja><en>This object returns. </en></returns>
        /// <remarks>
        /// <ja>
        /// ftHgł́Aj[ʒúAu擪iPositionType.Firstjvɐݒ肳܂Bڍׂ́A<seealso cref="IPositionDesignation">IPositionDesignation</seealso>QƂĂB
        /// </ja>
        /// <en>
        /// In default, the menu position is set to the "head(PositionType.First)". 
        /// Refer to <seealso cref="IPositionDesignation">IPositionDesignation</seealso> for more information.
        /// </en>
        /// </remarks>
        public PoderosaMenuGroupImpl SetPosition(PositionType type, IAdaptable target) {
            _positionType = type;
            _designationTarget = target;
            return this;
        }
    }
    
    
    //IPoderosaMenuItemW
    /// <summary>
    /// <ja>
    /// <seealso cref="IPoderosaMenuItem">IPoderosaMenuItem</seealso>NXłBȂŎsR}h`郁j[ڂ쐬ۂɎg܂B
    /// </ja>
    /// <en>
    /// It is a class that implements <seealso cref="IPoderosaMenuItem">IPoderosaMenuItem</seealso>. When the menu item that defines the command executed without the argument is made, it uses it. 
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// j[ڂJ҂́ÃNXgƂ<seealso cref="IPoderosaMenuItem">IPoderosaMenuItem</seealso>IuWFNg
    /// eՂɍ쐬ł܂B
    /// </ja>
    /// <en>
    /// The developer who implements the menu item can easily make the object where <seealso cref="IPoderosaMenuItem">IPoderosaMenuItem</seealso> is implemented by using this class. 
    /// </en>
    /// </remarks>
    /// <example>
    /// <ja>
    /// <seealso cref="IPoderosaMenuItem">IPoderosaMenuItem</seealso>IuWFNǵÂ悤ɂč쐬ł܂B
    /// <code>
    /// // 炩߃j[sꂽƂ̃j[ƃj[ڂ쐬Ă܂B
    /// 
    /// // R}h
    /// PoderosaCommandImpl mycommand = new PoderosaCommandImpl(
    ///   delegate(ICommandTarget target)
    ///   {
    ///     // R}hsꂽƂ̏
    ///    MessageBox.Show("s܂");
    ///    return CommandResult.Succeeded;
    ///   },
    ///   delegate(ICommandTarget target)
    ///   {
    ///     // R}hsł邩ǂԂ
    ///    return true;
    ///  }
    /// );
    /// 
    /// // j[ڂ쐬
    /// PoderosaMenuItemImpl menuitem = new PoderosaMenuItemImpl(
    ///     mycommand, "My Menu Name");
    /// </code>
    /// </ja>
    /// <en>
    /// The object that implements <seealso cref="IPoderosaMenuItem">IPoderosaMenuItem</seealso> can be made as follows. 
    /// <code>
    /// // The menu and the menu item when the menu is executed are made beforehand. 
    /// 
    /// // Command.
    /// PoderosaCommandImpl mycommand = new PoderosaCommandImpl(
    ///   delegate(ICommandTarget target)
    ///   {
    ///     // Processing when command is executed
    ///    MessageBox.Show("Executed");
    ///    return CommandResult.Succeeded;
    ///   },
    ///   delegate(ICommandTarget target)
    ///   {
    ///     // Returned whether the command can be executed. 
    ///    return true;
    ///  }
    /// );
    /// 
    /// // Create the menu item.
    /// PoderosaMenuItemImpl menuitem = new PoderosaMenuItemImpl(
    ///     mycommand, "My Menu Name");
    /// </code>
    /// </en>
    /// </example>
    public class PoderosaMenuItemImpl : IPoderosaMenuItem {
        /// <exclude/>
        protected IPoderosaCommand _command;
        /// <exclude/>
        protected bool _usingStringResource;
        /// <exclude/>
        protected StringResource _strResource;
        /// <exclude/>
        protected string _textID;
        /// <exclude/>
        protected CheckedDelegate _checked;

        /// <summary>
        /// <ja>
        /// R}hIDƃj[̕\w肵ăj[ڂ쐬܂B
        /// </ja>
        /// <en>
        /// The menu item is made specifying the display name of command ID and the menu. 
        /// </en>
        /// </summary>
        /// <param name="command_id"><ja>j[IꂽƂɌĂяoR}hIDłB</ja><en>It is command ID that wants to call when the menu is selected. </en></param>
        /// <param name="text"><ja>j[ɕ\eLXgłB</ja><en>Text displayed in menu.</en></param>
        /// <remarks>
        /// <ja>
        /// <paramref name="command_id">command_id</paramref>Ɏw肵R}hIDȂƂɂ́A<see cref="P:Poderosa.Commands.PoderosaMenuItemImpl.AssociatedCommand">AssociatedCommandvpeB</see>
        /// nullɂȂ܂B
        /// </ja>
        /// <en>
        /// When command ID specified for <paramref name="command_id">command_id</paramref> is not found, the <see cref="AssociatedCommand">AssociatedCommand property</see> becomes null. 
        /// </en>
        /// </remarks>
        /// <overloads>
        /// <summary>
        /// <ja>
        /// j[ڂ쐬܂B
        /// </ja>
        /// <en>
        /// Create the menu item.
        /// </en>
        /// </summary>
        /// </overloads>
        public PoderosaMenuItemImpl(string command_id, string text) : this(BindCommand(command_id), null, text) {
        }
        /// <summary>
        /// <ja>
        /// sR}h<seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>ƃj[̕\w肵ăj[ڂ쐬܂B
        /// </ja>
        /// <en>
        /// The menu item is made specifying the display name of <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso> and the menu of the executed command. 
        /// </en>
        /// </summary>
        /// <param name="command"><ja>j[IꂽƂɌĂяoR}hłB</ja><en>It is command that wants to call when the menu is selected. </en></param>
        /// <param name="text"><ja>j[ɕ\eLXgłB</ja><en>Text displayed in menu.</en></param>
        /// <remarks>
        /// <ja><paramref name="command">command</paramref>nullw肵Ă͂܂B</ja><en>Do not specify null for command. </en>
        /// </remarks>
        public PoderosaMenuItemImpl(IPoderosaCommand command, string text) : this(command, null, text) {
        }

        /// <summary>
        /// <ja>
        /// R}hIDƃJ`Aj[̕\w肵ăj[ڂ쐬܂B
        /// </ja>
        /// <en>
        /// The menu item is made specifying the display name of command ID, culture, and the menu. 
        /// </en>
        /// </summary>
        /// <param name="command_id"><ja>j[IꂽƂɌĂяoR}hIDłB</ja><en>Command ID that wants to call when menu is selected</en></param>
        /// <param name="sr"><ja>J`łB</ja><en>Information of culture.</en></param>
        /// <param name="textID"><ja>j[ɕ\eLXgIDłB</ja><en>Text ID displayed in menu</en></param>
        /// <remarks>
        /// <ja>
        /// <paramref name="command_id">command_id</paramref>Ɏw肵R}hIDȂƂɂ́A<see cref="AssociatedCommand">AssociatedCommandvpeB</see>
        /// nullɂȂ܂B
        /// </ja>
        /// <en>
        /// When command ID specified for <paramref name="command_id">command_id</paramref> is not found, the <see cref="AssociatedCommand">AssociatedCommand property</see> becomes null. 
        /// </en>
        /// </remarks>
        public PoderosaMenuItemImpl(string command_id, StringResource sr, string textID) : this(BindCommand(command_id), sr, textID) {
        }

        /// <summary>
        /// <ja>sR}h<seealso cref="IPoderosaCommand">IPoderosaCommand</seealso>AJ`Aj[̕\w肵ăj[ڂ쐬܂B</ja>
        /// <en>The menu item is made specifying the display name of executed <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso> of the command, culture, and menu. </en>
        /// </summary>
        /// <param name="command"><ja>j[IꂽƂɌĂяoR}hłB</ja><en>Command that wants to call when menu is selected</en></param>
        /// <param name="sr"><ja>J`łB</ja><en>Information of culture.</en></param>
        /// <param name="textID"><ja>j[ɕ\eLXgIDłB</ja><en>Text ID displayed in menu</en></param>
        public PoderosaMenuItemImpl(IPoderosaCommand command, StringResource sr, string textID) {
            Debug.Assert(command!=null);
            _command = command;
            _usingStringResource = sr!=null;
            _strResource = sr;
            _textID = textID;
        }
        private static IGeneralCommand BindCommand(string command_id) {
            IGeneralCommand cmd = CommandManagerPlugin.Instance.Find(command_id);
            Debug.Assert(cmd!=null, "Command Not Found");
            return cmd;
        }

        /// <summary>
        /// <ja>
        /// j[IꂽƂɌĂяoR}h܂B
        /// </ja>
        /// <en>
        /// The command called when the menu is selected is shown. 
        /// </en>
        /// </summary>
        public virtual IPoderosaCommand AssociatedCommand {
            get {
                return _command;
            }
        }

        /// <summary>
        /// <ja>
        /// j[ɕ\eLXg܂B
        /// </ja>
        /// <en>
        /// The text displayed in the menu is shown. 
        /// </en>
        /// </summary>
        public virtual string Text {
            get {
                return _usingStringResource? _strResource.GetString(_textID) : _textID;
            }
        }

        /// <summary>
        /// <ja>
        /// j[I\ǂ܂B
        /// </ja>
        /// <en>
        /// It is shown whether the menu can be selected. 
        /// </en>
        /// </summary>
        /// <param name="target"><ja>ΏۂƂȂ^[QbgłB</ja><en>Target to be processed</en></param>
        /// <returns><ja>I\ȂtrueAIsȂfalseԂ܂B</ja><en>If it is selectable, return true. It isn't, return false.</en></returns>
        /// <remarks>
        /// <ja>
        /// ̃\bh́A<see cref="AssociatedCommand">AssiciatedCommand</see>vpeBŎꂽ
        /// <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso><seealso cref="IPoderosaCommand.CanExecute">CanExecute\bh</seealso>
        /// ĂяoƂŎĂ܂B
        /// </ja>
        /// <en>
        /// This method is implemented by calling the <seealso cref="IPoderosaCommand.CanExecute">CanExecute method</seealso> of <seealso cref="IPoderosaCommand">IPoderosaCommand</seealso> shown internally in the <see cref="AssociatedCommand">AssiciatedCommand</see> property. 
        /// </en>
        /// </remarks>
        public virtual bool IsEnabled(ICommandTarget target) {
            return _command.CanExecute(target);
        }

        /// <summary>
        /// <ja>
        /// j[Ƀ`FbNtĂ邩ǂ܂B
        /// </ja>
        /// <en>
        /// It is shown whether the menu is checked. 
        /// </en>
        /// </summary>
        /// <param name="target"><ja>ΏۂƂȂ^[QbgłB</ja><en>Target to be processed.</en></param>
        /// <returns><ja>`FbNtĂȂtrueAłȂȂfalseԂ܂B</ja><en>It is true, and a return of false if checked if not so. </en></returns>
        /// <remarks>
        /// <ja>
        /// ̃\bh́Afalse߂܂B
        /// </ja>
        /// <en>
        /// False always returns in this method. 
        /// </en>
        /// </remarks>
        public virtual bool IsChecked(ICommandTarget target) {
            return _checked==null? false : _checked(target);
        }

        public virtual IAdaptable GetAdapter(Type adapter) {
            return CommandManagerPlugin.Instance.PoderosaWorld.AdapterManager.GetAdapter(this, adapter);
        }
    }
}
