/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: SessionEx.cs,v 1.9 2006/08/23 06:08:53 dan-iwasaki Exp $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

using Poderosa.Forms;
//using Poderosa.Document;
using Poderosa.Commands;

namespace Poderosa.Sessions
{
    /// <summary>
    /// <ja>
    /// ZbV}l[WC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows session manager.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// ̃C^[tFCX̓ZbV}l[WiSessionManagerPluginvOCFvOCIDuorg.poderosa.core.sessionsvj
    /// ɂĒ񋟂C^[tFCXłAZbV𑀍삵܂B
    /// </para>
    /// <para>
    /// ̃C^[tFCX́A<seealso cref="Poderosa.Plugins.ICoreServices">ICoreServices</seealso>
    /// <see cref="Poderosa.Plugins.ICoreServices.SessionManager">SessionManagervpeB</see>
    /// gĎ擾ł܂B
    /// </para>
    /// </ja>
    /// <en>
    /// <para>
    /// This interface is an interface offered by the session manager (SessionManagerPlugin plug-in : Plug-inID "org.poderosa.core.sessions") , and session information is operated. 
    /// </para>
    /// <para>
    /// This interface can be acquired by using the <see cref="Poderosa.Plugins.ICoreServices.SessionManager">SessionManager property</see> of <seealso cref="Poderosa.Plugins.ICoreServices">ICoreServices</seealso>. 
    /// </para>
    /// </en>
    /// </remarks>
    /// <example>
    /// <ja>
    /// ISessionManager擾܂B
    /// <code>
    /// // ICoreServices擾
    /// ICoreServices cs = (ICoreServices)PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// // ISessionManager擾
    /// ISessionManager sessionman = cs.SessionManager;
    /// </code>
    /// </ja>
    /// <en>
    /// Get the ISessionManager.
    /// <code>
    /// // Get the ICoreServices.
    /// ICoreServices cs = (ICoreServices)PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// // Get the ISessionManager.
    /// ISessionManager sessionman = cs.SessionManager;
    /// </code>
    /// </en>
    /// </example>
    public interface ISessionManager : IAdaptable {
        //Structure
        /// <summary>
        /// <ja>
        /// ׂẴZbV񋓂܂B
        /// </ja>
        /// <en>
        /// Enumerate all sessions.
        /// </en>
        /// </summary>
        IEnumerable<ISession> AllSessions { get; }
        /// <summary>
        /// <ja>
        /// EBhEɌтꂽhLgzƂē܂B
        /// </ja>
        /// <en>
        /// The document tie to the window is obtained as an array. 
        /// </en>
        /// </summary>
        /// <param name="window"><ja>ΏۂƂȂEBhEłB</ja><en>It is a window that becomes an object. </en></param>
        /// <returns><ja>EBhEɊ܂܂hLg̔z񂪕Ԃ܂B</ja><en>The array of the document included in the window is returned. </en></returns>
        IPoderosaDocument[] GetDocuments(IPoderosaMainWindow window);

        //Start/End
        /// <summary>
        /// <ja>
        /// VZbVJn܂B
        /// </ja>
        /// <en>
        /// Start a new session.
        /// </en>
        /// </summary>
        /// <param name="session"><ja>JnZbV</ja><en>Session to start.</en></param>
        /// <param name="firstView"><ja>ZbVɊ蓖Ăr[</ja><en>View allocated in session</en></param>
        /// <remarks>
        /// <ja>
        /// VZbV쐬邽߂̃r[́A<seealso cref="IViewManager">IViewManager</seealso>
        /// <see cref="IViewManager.GetCandidateViewForNewDocument">GetCandidateViewForNewDocument\bh</see>
        /// ō邱Ƃł܂B
        /// </ja>
        /// <en>
        /// The view to make the session newly can be made by the <see cref="IViewManager.GetCandidateViewForNewDocument">GetCandidateViewForNewDocument method</see> of IViewManager. 
        /// </en>
        /// </remarks>
        void StartNewSession(ISession session, IPoderosaView firstView);

        /// <summary>
        /// <ja>
        /// ZbV܂B
        /// </ja>
        /// <en>
        /// Close the session.
        /// </en>
        /// </summary>
        /// <param name="session"><ja>ZbVłB</ja><en>Session to close.</en></param>
        /// <returns><ja>ZbVꂽǂlłB</ja><en>It is a value in which it is shown whether the session was closed. </en></returns>
        /// <remarks>
        /// <ja>
        /// <para>
        /// ̃\bhĂяoƁAZbV\<seealso cref="ISession">ISession</seealso>
        /// <see cref="ISession.PrepareCloseSession">PrepareCloseSession\bh</see>
        /// Ăяo܂B<see cref="ISession.PrepareCloseSession">PrepareCloseSession\bh</see>PrepareCloseResult.Cancel
        /// ԂƂɂ́AZbV铮͒~܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// When this method is called, the <see cref="ISession.PrepareCloseSession">PrepareCloseSession method</see> of <seealso cref="ISession">ISession</seealso> that composes the session is called. When the <see cref="ISession.PrepareCloseSession">PrepareCloseSession method</see> returns PrepareCloseResult.Cancel, operation that shuts the session is discontinued. 
        /// </para>
        /// </en>
        /// </remarks>
        PrepareCloseResult TerminateSession(ISession session);
        /// <summary>
        /// <ja>
        /// hLg܂B
        /// </ja>
        /// <en>
        /// Close the document.
        /// </en>
        /// </summary>
        /// <param name="document"><ja>hLgłB</ja><en>Document to close.</en></param>
        /// <returns><ja>hLgꂽǂlłB</ja><en>It is a value in which it is shown whether the document was closed. </en></returns>
        /// <remarks>
        /// <ja>
        /// <para>
        /// ̃\bhĂяoƁAZbV\<seealso cref="ISession">ISession</seealso>
        /// <see cref="ISession.PrepareCloseDocument">PrepareCloseDocument\bh</see>
        /// Ăяo܂B<see cref="ISession.PrepareCloseDocument">PrepareCloseDocument\bh</see>PrepareCloseResult.Cancel
        /// ԂƂɂ́AhLg铮͒~܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// When this method is called, the <see cref="ISession.PrepareCloseDocument">PrepareCloseDocument method</see> of 
        /// <seealso cref="ISession">ISession</seealso> that composes the session is called. 
        /// When the <see cref="ISession.PrepareCloseDocument">PrepareCloseDocument method</see> 
        /// returns PrepareCloseResult.Cancel, operation that shuts the document is discontinued. 
        /// </para>
        /// </en>
        /// </remarks>
        PrepareCloseResult CloseDocument(IPoderosaDocument document);

        //Document Management
        /// <summary>
        /// <ja>hLgANeBu܂B</ja><en>Activate the document.</en>
        /// </summary>
        /// <param name="document"><ja>ANeBuhLg</ja><en>Document to activate.</en></param>
        /// <param name="reason"><ja>ANeBu闝Ri[IuWFNg</ja><en>Object that stored reason made active</en></param>
        void ActivateDocument(IPoderosaDocument document, ActivateReason reason);
        /// <summary>
        /// <ja>hLgƃr[Ƃт܂B</ja><en>Tie the document and the view.</en>
        /// </summary>
        /// <param name="document"><ja>ΏۂƂȂhLg</ja>
        /// <en>Document to target.</en>
        /// </param>
        /// <param name="view"><ja>蓖Ăr[</ja>
        /// <en>View to assign.</en>
        /// </param>
        void AttachDocumentAndView(IPoderosaDocument document, IPoderosaView view);
        /// <summary>
        /// <ja>
        /// hLg̃Xe[^XXV܂B
        /// </ja>
        /// <en>
        /// Update the status of the document.
        /// </en>
        /// </summary>
        /// <param name="document"><ja>XVhLg</ja><en>Document to update.</en></param>
        void RefreshDocumentStatus(IPoderosaDocument document);

        //Listener
        /// <summary>
        /// <ja>
        /// ANeBuȃhLgωƂ̒ʒm󂯎郊Xio^܂B
        /// </ja>
        /// <en>
        /// The listener that receives the notification when an active document is changed is registered. 
        /// </en>
        /// </summary>
        /// <param name="listener"><ja>o^郊Xi</ja><en>Registered listener</en></param>
        void AddActiveDocumentChangeListener(IActiveDocumentChangeListener listener);
        /// <summary>
        /// <ja>
        /// ANeBuȃhLgωƂ̒ʒm󂯎郊Xi܂B
        /// </ja>
        /// <en>
        /// The listener that receives the notification when an active document is changed is released. 
        /// </en>
        /// </summary>
        /// <param name="listener"><ja>郊Xi</ja><en>Listener to release.</en></param>
        void RemoveActiveDocumentChangeListener(IActiveDocumentChangeListener listener);
        /// <summary>
        /// <ja>
        /// ZbVJnꂽؒfꂽƂ̒ʒm󂯎郊Xio^܂B
        /// </ja>
        /// <en>
        /// The listener that is begun the session and receives the notification when close is registered. 
        /// </en>
        /// </summary>
        /// <param name="listener"><ja>o^郊Xi</ja><en>Listener to regist</en></param>
        void AddSessionListener(ISessionListener listener);
        /// <summary>
        /// <ja>ZbVJnꂽؒfꂽƂ̒ʒm󂯎郊Xi܂B</ja>
        /// <en>The listener that is begun the session and receives the notification when close is released.</en>
        /// </summary>
        /// <param name="listener"><ja>郊Xi</ja><en>Listener to release.</en></param>
        void RemoveSessionListener(ISessionListener listener);
    }

    /// <summary>
    /// <ja>
    /// ZbVzXgIuWFNgC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows session host object.
    /// </en>
    /// </summary>
    public interface ISessionHost {
        /// <summary>
        /// <ja>
        /// hLgo^܂B
        /// </ja>
        /// <en>
        /// Regist the document.
        /// </en>
        /// </summary>
        /// <param name="document"><ja>o^hLg</ja><en>Document to regist.</en></param>
        void RegisterDocument(IPoderosaDocument document);
        //TODO RemoveDocumentĂ悢
        /// <summary>
        /// <ja>
        /// ZbVvOCI܂B
        /// </ja>
        /// <en>
        /// Terminate the sessoin from plug-in side.
        /// </en>
        /// </summary>
        void TerminateSession();
        /// <summary>
        /// <ja>
        /// hLgɌтꂽtH[𓾂܂B
        /// </ja>
        /// <en>
        /// Get the form tied with document.
        /// </en>
        /// </summary>
        /// <param name="document"><ja>ΏۂƂȂhLgłB</ja><en>Targeted document.</en></param>
        /// <returns><ja>hLgɌтꂽtH[Ԃ܂B</ja><en>The form tie to the document is returned. </en></returns>
        IPoderosaForm GetParentFormFor(IPoderosaDocument document);
    }

    //ANeBuɂ鑀̊Jn
    /// <summary>
    /// <ja>
    /// hLgANeBuɂȂƂ̗R܂B
    /// </ja>
    /// <en>
    /// The reason when the document becomes active is shown. 
    /// </en>
    /// </summary>
    public enum ActivateReason {
        /// <summary>
        /// <ja>ɂANeBuɂȂ</ja>
        /// <en>It became active by internal operation. </en>
        /// </summary>
        InternalAction,
        /// <summary>
        /// <ja>^uNbNɂANeBuɂȂ</ja>
        /// <en>It became active by the tab click. </en>
        /// </summary>
        TabClick,
        /// <summary>
        /// <ja>r[tH[JX󂯎߂ɃANeBuɂȂ</ja>
        /// <en>Because the view had got focus, it became active. </en>
        /// </summary>
        ViewGotFocus,
        /// <summary>
        /// <ja>hbOhbvɂANeBuɂȂ</ja>
        /// <en>It became active by the drag &amp; drop operation. </en>
        /// </summary>
        DragDrop
    }

    /// <summary>
    /// <ja>
    /// hLgZbV悤ƂƂ̖߂l܂B
    /// </ja>
    /// <en>
    /// The return value when the document and the session start being shut is shown. 
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// ̗񋓑̂́A<seealso cref="ISession">ISession</seealso><see cref="ISession.PrepareCloseDocument">PrepareCloseDocument\bh</see>
    /// <see cref="ISession.PrepareCloseSession">PrepareCloseSession\bh</see>̖߂lƂĎg܂B
    /// </para>
    /// <para>
    /// PrepareCloseResult.ContinueSessionĝ́A<see cref="ISession.PrepareCloseDocument">PrepareCloseDocument\bh</see>̂ƂłB
    /// </para>
    /// </ja>
    /// <en>
    /// <para>
    /// This enumeration is used as a return value of the <see cref="ISession.PrepareCloseDocument">PrepareCloseDocument method</see> and the <see cref="ISession.PrepareCloseSession">PrepareCloseSession method</see> of <seealso cref="ISession">ISession</seealso>. 
    /// </para>
    /// <para>
    /// Only PrepareCloseResult.ContinueSession is used on <see cref="ISession.PrepareCloseDocument">PrepareCloseDocument method</see>
    /// </para>
    /// </en>
    /// </remarks>
    public enum PrepareCloseResult {
        /// <summary>
        /// <ja>
        /// hLg͕܂AZbV͕܂B
        /// </ja>
        /// <en>
        /// Close the document, but session is not close.
        /// </en>
        /// </summary>
        ContinueSession,
        /// <summary>
        /// <ja>
        /// hLgZbV܂B
        /// </ja>
        /// <en>
        /// Close the document and the session.
        /// </en>
        /// </summary>
        TerminateSession,
        /// <summary>
        /// <ja>
        /// hLgZbV铮LZ܂B
        /// </ja>
        /// <en>
        /// Cancel closing the document and the session.
        /// </en>
        /// </summary>
        Cancel
    }

    /// <summary>
    /// <ja>
    /// ZbV܂B
    /// </ja>
    /// <en>
    /// The session is shown. 
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// W̃^[~iG~[^ƂėpꍇAISession̎Ԃ́AISessionpĂ
    /// <seealso cref="Poderosa.Sessions.ITerminalSession">ITerminalSession</seealso>łAGetAdapter\bhŕϊł܂B
    /// </ja>
    /// <en>
    /// The realities of ISession are <seealso cref="Poderosa.Sessions.ITerminalSession">ITerminalSession</seealso> that has been succeeded to, 
    /// and can be converted from ISession by the GetAdapter method when using it as a standard terminal emulator. 
    /// </en>
    /// </remarks>
    public interface ISession : IAdaptable {
        /// <summary>
        /// <ja>
        /// ZbṼLvVłB
        /// </ja>
        /// <en>
        /// Caption of the session.
        /// </en>
        /// </summary>
        string Caption { get; }
        /// <summary>
        /// <ja>
        /// ZbṼACRłB
        /// </ja>
        /// <en>
        /// Icon of the session.
        /// </en>
        /// </summary>
        Image Icon { get; } //16*16

        //ȉSessionManagerĂԁBȊOł͌Ăł͂Ȃ
        /// <summary>
        /// <ja>
        /// ZbV}l[WĂяo鏉̃\bhłB
        /// </ja>
        /// <en>
        /// Initialization called from session manager method.
        /// </en>
        /// </summary>
        /// <param name="host"><ja>ZbV𑀍삷邽߂̃ZbVzXgIuWFNgłB</ja>
        /// <en>Session host object to operate session.</en>
        /// </param>
        /// <remarks>
        /// <ja>
        /// <para>
        /// ̃\bh́A<seealso cref="ISessionManager">ISessionManager</seealso><see cref="ISessionManager.StartNewSession">StartNewSession\bh</see>
        /// ĂяoꂽƂɁAZbV}l[WɂĊԐړIɌĂяo܂B
        /// J҂́Ã\bh𒼐ڌĂяoĂ͂܂B
        /// </para>
        /// <para>
        /// J҂͈ʂɁÃ\bh̏ɂăhLg쐬A<paramref name="host">host</paramref>Ƃēnꂽ<seealso cref="ISessionHost">ISessionHost</seealso>
        /// <see cref="ISessionHost.RegisterDocument">RegisterDocument\bh</see>ĂяoăhLgo^܂B
        /// </para>
        /// <para>
        /// ZbV̏ڍׂɂẮA<see href="chap04_02_04.html">ZbV̑</see>QƂĂB
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// When the <see cref="ISessionManager.StartNewSession">StartNewSession method</see> of 
        /// <seealso cref="ISessionManager">ISessionManager</seealso> is called, this method is 
        /// indirectly called by the session manager. The developer must not call this method directly. 
        /// </para>
        /// <para>
        /// The developer makes the document in general in the processing of this method, calls the <see cref="ISessionHost.RegisterDocument">RegisterDocument method</see> of <seealso cref="ISessionHost">ISessionHost</seealso> passed as <paramref name="host">host</paramref>, and registers the document. 
        /// </para>
        /// <para>
        /// Please refer to <see href="chap04_02_04.html">Operation of session</see> for details of the session. 
        /// </para>
        /// </en>
        /// </remarks>
        void InternalStart(ISessionHost host);

        /// <summary>
        /// <ja>
        /// ZbVIƂɌĂяo郁\bhłB
        /// </ja>
        /// <en>
        /// It is a method of the call when the session ends. 
        /// </en>
        /// </summary>
        void InternalTerminate();

        //SessionTerminatew肵ꍇłAKTerminateƂ͌Ȃ_ɒӁB
        /// <summary>
        /// <ja>
        /// hLgĂ悢肵܂B
        /// </ja>
        /// <en>
        /// It is decided whether I may close the document. 
        /// </en>
        /// </summary>
        /// <param name="document"><ja>ΏۂƂȂhLg</ja><en>Document that close object</en></param>
        /// <returns><ja>hLg邩ǂ肷lłB</ja><en>Value in which it is decided whether to close document</en></returns>
        /// <remarks>
        /// <ja>
        /// <para>
        /// ̃\bh́AhLg鑀삪sƌĂяo܂B
        /// </para>
        /// <para>
        /// J҂̓hLg邩ǂ<seealso cref="PrepareCloseResult">PrepareCloseResult񋓑</seealso>
        /// ƂĕԂĂBPrepareCloseResult.CancelԂꍇAhLg铮͎܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// When the operation that closes the document is done, this method is called. 
        /// </para>
        /// <para>
        /// The developer must return whether to close the document as 
        /// <seealso cref="PrepareCloseResult">PrepareCloseResult enumeration</seealso>. 
        /// When PrepareCloseResult.Cancel is returned, operation that closed the document is canceled. 
        /// </para>
        /// </en>
        /// </remarks>
        PrepareCloseResult PrepareCloseDocument(IPoderosaDocument document);
        /// <summary>
        /// <ja>
        /// ZbVĂ悢肵܂B
        /// </ja>
        /// <en>
        /// It is decided whether I may close the session. 
        /// </en>
        /// </summary>
        /// <returns><ja>ZbV邩ǂ肷lłB</ja><en>It is a value in which it is decided whether to close the session. </en></returns>
        /// <remarks>
        /// <ja>
        ///    <para>
        ///    ̃\bh́AZbV鑀삪sƌĂяo܂B
        ///    </para>
        ///    <para>
        ///    J҂̓ZbV邩ǂ<seealso cref="T:Poderosa.Sessions.PrepareCloseResult">PrepareCloseResult񋓑</seealso>
        ///    ƂĕԂĂBPrepareCloseResult.CancelԂꍇAZbV铮͎܂B
        ///    </para>
        /// </ja>
        /// <en>
        /// <para>
        /// When the operation that close the session is done, this method is called. 
        /// </para>
        /// <para>
        /// The developer must return whether to close the document as 
        /// <seealso cref="PrepareCloseResult">PrepareCloseResult enumeration</seealso>. 
        /// When PrepareCloseResult.Cancel is returned, operation that closed the document is canceled. 
        /// </para>
        /// </en>
        /// </remarks>
        PrepareCloseResult PrepareCloseSession();


        /// <summary>
        /// 
        /// </summary>
        /// <param name="document"></param>
        /// <param name="view"></param>
        /// <exclude/>
        void InternalAttachView(IPoderosaDocument document, IPoderosaView view);

        /// <summary>
        /// 
        /// </summary>
        /// <param name="document"></param>
        /// <param name="view"></param>
        /// <exclude/>
        void InternalDetachView(IPoderosaDocument document, IPoderosaView view);

        /// <summary>
        /// <ja>
        /// hLgۂɌĂяo郁\bhłB
        /// </ja>
        /// <en>
        /// It is a method of the call when the document is closed. 
        /// </en>
        /// </summary>
        /// <param name="document"><ja>ΏۂƂȂhLg</ja><en>Document that becomes close object</en></param>
        /// <exclude/>
        void InternalCloseDocument(IPoderosaDocument document);


        //Added for Bellagio
        Type GetCorrespondingViewType(IPoderosaDocument document);
    }

    //Doc/Vieẘ֘AtύX̒ʒm@ύXe𒀈擾ł悤ɂ̂͌̉ۑ
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    /// 
    public interface IDocViewRelationEventHandler {
        void OnDocViewRelationChange();
    }

    /// <summary>
    /// <ja>
    /// hLgANeBuꂽANeBuꂽƂʒmC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that notifies for document to be made active and to have been made non-actively.
    /// </en>
    /// </summary>
    public interface IActiveDocumentChangeListener {
        /// <summary>
        /// <ja>
        /// hLgANeBuꂽƂɌĂяo܂B
        /// </ja>
        /// <en>
        /// Called when the document is activated.
        /// </en>
        /// </summary>
        /// <param name="window"><ja>ΏۂƂȂEBhE</ja><en>Window that becomes object.</en></param>
        /// <param name="document"><ja>ΏۂƂȂhLg</ja><en>Window that becomes object</en></param>
        void OnDocumentActivated(IPoderosaMainWindow window, IPoderosaDocument document);
        /// <summary>
        /// <ja>
        /// hLgANeBuꂽƂɌĂяo܂B
        /// </ja>
        /// <en>
        /// When the document is made non-active, it is called. 
        /// </en>
        /// </summary>
        /// <param name="window"><ja>ΏۂƂȂEBhE</ja><en>Window that becomes object</en>
        /// </param>
        void OnDocumentDeactivated(IPoderosaMainWindow window);
    }

    /// <summary>
    /// <ja>
    /// ZbVJn^ؒfꂽƂ̒ʒm󂯎C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that receives notification when session begin/finish
    /// </en>
    /// </summary>
    public interface ISessionListener {
        /// <summary>
        /// <ja>
        /// ZbVJnꂽƂɌĂяo܂B
        /// </ja>
        /// <en>
        /// When the session is started, it is called. 
        /// </en>
        /// </summary>
        /// <param name="session"><ja>JnꂽZbV</ja><en>Started session.</en></param>
        void OnSessionStart(ISession session);
        /// <summary>
        /// <ja>
        /// ZbVIƂɌĂяo܂B
        /// </ja>
        /// <en>
        /// When the session ends, it is called. 
        /// </en>
        /// </summary>
        /// <param name="session"><ja>IZbV</ja><en>Ended session</en></param>
        void OnSessionEnd(ISession session);
    }

}
