/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: AdapterEx.cs,v 1.12 2006/08/23 03:14:47 osawa Exp $
 */
using System;

namespace Poderosa
{
	/*
	
	*/
	
	//Adapter֌W
    // PFCX^X̋ʂȂB^ɂĂ̂ݐ邩ǂ܂
    // QFΏ̗EڗBCOMQueryInterfaceƓB
    /// <summary>
    /// <ja>
    /// w肵C^[tFCXԂ@\񋟂܂B
    /// </ja>
    /// <en>
    /// Return the mechanism of specified interface.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// IuWFNgT|[gC^[tFCXԂ@\񋟂܂B
    /// COMiComponent Object ModeljɂQueryInterfaceƓłB
    /// ҂́A̗vĂB
    /// <ol>
    /// <li>CX^X̋ʂȂłB^ɂĂ̂ݐ邩ǂ߂Ă</li>
    /// <li>Ώ̗EڗĂB</li>
    /// </ol>
    /// </ja>
    /// <en>
    /// The mechanism that returns the interface supported by the object is offered. 
    /// It's same as QueryInterface on COM (Component Object Model).
    /// Developers must defend the following requirement.
    /// <ol>
    /// <li>Please do not distinguish the instance. Please decide whether to succeed only by the type. </li>
    /// <li>Please defend the symmetric law and the transition law. </li>
    /// </ol>
    /// </en>
    /// </remarks>
	public interface IAdaptable {
        /// <summary>
        /// <ja>
        /// ̌^̃C^[tFCXԂ܂B
        /// </ja>
        /// <en>
        /// Return the interface of the specified type
        /// </en>
        /// </summary>
        /// <param name="adapter">
        /// <ja>
        /// vC^[tFCX̌^
        /// </ja>
        /// <en>Type of required interface type.</en></param>
        /// <returns>
        /// <ja>vC^[tFCX߂܂BIuWFNg̃C^[tFCXĂȂꍇɂnull߂܂B</ja>
        /// <en>Return the interface of required. Return null if the interface is not implemented on the object.</en>
        /// </returns>
        /// <remarks>
        /// <ja>
        /// ҂́Ã\bhŗOԂĂ͂Ȃ܂BȂC^[tFCX̌^nꂽꍇɂnullԂĂB<br/>
        /// ̎ł́AL̃R[hgAIAdapterManagerC^[tFCX<seealso cref="IAdapterManager.GetAdapter">GetAdapter\bh</seealso>
        /// gāAAdapterManagerɕϊC悤ɂ܂B
        /// <code>
        /// public IAdaptable GetAdapter(Type adapter)
        /// {
        ///     return poderosa_world.AdapterManager.GetAdapter(this, adapter);
        /// }
        /// </code>
        /// </ja>
        /// <en>
        /// When he or she returns the exception in this method, those who mount do not become it.
        /// Please return null when the type in the interface with which it doesn't provide is passed. 
        /// In a lot of mounting, conversion is left to AdapterManager by using the following code,
        /// and using the <seealso cref="IAdapterManager.GetAdapter">GetAdapter method</seealso> of the IAdapterManager interface. 
        /// <code>
        /// public IAdaptable GetAdapter(Type adapter)
        /// {
        ///     return poderosa_world.AdapterManager.GetAdapter(this, adapter);
        /// }
        /// </code>
        /// </en>
        /// </remarks>
		IAdaptable GetAdapter(Type adapter);
        //Note: Generics( T GetAdapter<T>() )邱ƂlAR[hIɍsƂ΋NԂɈeo邩Ȃ̂ł߂ĂB̂Ƃ邩
	}

    /*
     * Â^CvAdapterFactory. Eclipse^ĂȂ悤ȋL邪smB͎g舫̂ŉ߂
	public interface IAdapterFactory {
		Type SourceType {
			get;
		}
		Type[] Adapters {
			get;
		}
		IAdaptable GetAdapter(IAdaptable obj, Type adapter);
	}
    */

    //oɕϊłȂ΂ȂȂB
    /// <summary>
    /// <ja>
    /// A_v^t@Ng\C^[tFCXłB
    /// </ja>
    /// <en>
    /// The interface that compose the adapter factory.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// ̃C^[tFCX́AA_v^}l[Wi<seealso cref="IAdapterManager">IAdapterManager</seealso>j
    /// gČ^ϊ`ƂɎg܂B
    /// </ja>
    /// </remarks>
    public interface IDualDirectionalAdapterFactory {
        /// <summary>
        /// <ja>\[X̌^܂B</ja>
        /// <en>Type of source</en>
        /// </summary>
        Type SourceType {
            get;
        }
        /// <summary>
        /// <ja>A_v^̌^܂B
        /// </ja>
        /// <en>Type of adapter
        /// </en>
        /// </summary>
        Type AdapterType {
            get;
        }
        /// <summary>
        /// <ja>
        /// \[XA_v^ւƕϊ܂B
        /// </ja>
        /// <en>
        /// Convert from source to adapter.
        /// </en>
        /// </summary>
        /// <param name="obj">
        /// <ja>\[X̌^</ja>
        /// <en>Type of source</en>
        /// </param>
        /// <returns>
        /// <ja>A_v^̌^Ԃ܂B</ja>
        /// <en>Return the type of the adapter</en>
        /// </returns>
        IAdaptable GetAdapter(IAdaptable obj); //SourceType -> AdapterType
        /// <summary>
        /// <ja>
        /// A_v^\[Xւƕϊ܂B
        /// </ja>
        /// <en>
        /// Convert from adapter to source.
        /// </en>
        /// </summary>
        /// <param name="obj">
        /// <ja>A_v^̌^</ja>
        /// <en>Type of adapter</en>
        /// </param>
        /// <returns>
        /// <ja>\[X̌^Ԃ܂B</ja>
        /// <en>Return the type of the source</en>
        /// </returns>
        IAdaptable GetSource(IAdaptable obj);  //AdapterType -> SourceType
    }

    //Generics IAdapterFactory
    /// <summary>
    /// <ja>
    /// Genericsł̃A_v^t@NgłB
    /// </ja>
    /// <en>
    /// Adapter factory of the Generics version.
    /// </en>
    /// </summary>
    /// <typeparam name="S">
    /// <ja>\[X̌^</ja>
    /// <en>Type of the source</en>
    /// </typeparam>
    /// <typeparam name="T">
    /// <ja>A_v^̌^</ja>
    /// <en>Type of adapter</en>
    /// </typeparam>
    /// <remarks>
    /// <ja>
    /// ̃C^[tFCX́AA_v^}l[Wi<seealso cref="IAdapterManager">IAdapterManager</seealso>j
    /// gČ^ϊ`ƂɎg܂B
    /// </ja>
    /// <en>
    /// This interface is used when it defines the type conversation by adapter manager(<seealso cref="IAdapterManager">IAdapterManager</seealso>)
    /// </en>
    /// </remarks>
    public abstract class ITypedDualDirectionalAdapterFactory<S, T> : IDualDirectionalAdapterFactory
        where T:IAdaptable where S:IAdaptable {
        
        /// <summary>
        /// <ja>\[X̌^܂B</ja>
        /// <en>The type of the source</en>
        /// </summary>
        public Type SourceType {
            get {
                return typeof(S);
            }
        }

        /// <summary>
        /// <ja>A_v^̌^܂B</ja>
        /// <en>the type of the adapter</en>
        /// </summary>
        public Type AdapterType {
            get {
                return typeof(T);
            }
        }

        /// <summary>
        /// <ja>\[XA_v^ւƕϊ܂B</ja>
        /// <en>Convert from the source th the adapter.</en>
        /// </summary>
        /// <param name="obj"><ja>\[X̌^</ja><en>Type of the source</en></param>
        /// <returns><ja>A_v^̌^Ԃ܂B</ja><en>Return the type of the adapter.</en></returns>
        public IAdaptable GetAdapter(IAdaptable obj) {
            return GetAdapter((S)obj);
        }

        /// <summary>
        /// <ja>A_v^\[Xւƕϊ܂B</ja>
        /// <en>Convert from the adapter to the source.</en>
        /// </summary>
        /// <param name="obj">
        /// <ja>A_v^̌^</ja>
        /// <en>Type of adapter</en>
        /// </param>
        /// <returns>
        /// <ja>\[X̌^Ԃ܂B</ja>
        /// <en>Return the type of the source.</en>
        /// </returns>
        public IAdaptable GetSource(IAdaptable obj) {
            return GetSource((T)obj);
        }

        /// <summary>
        /// <ja>\[XA_v^ւƕϊ܂B</ja>
        /// <en>Convert from the source to the adapter.</en>
        /// </summary>
        /// <param name="obj">
        /// <ja>\[X̌^</ja>
        /// <en>Type of the source</en>
        /// </param>
        /// <returns>
        /// <ja>A_v^̌^Ԃ܂B</ja>
        /// <en>Return the type of the adapter.</en>
        /// </returns>
        public abstract T GetAdapter(S obj);

        /// <summary>
        /// <ja>A_v^\[Xւƕϊ܂B</ja>
        /// <en>Convert from the adapter to the source</en>
        /// </summary>
        /// <param name="obj">
        /// <ja>A_v^̌^</ja>
        /// <en>Type of the adapter</en>
        /// </param>
        /// <returns>
        /// <ja>\[X̌^Ԃ܂B</ja>
        /// <en>Return the type of the source.</en>
        /// </returns>
        public abstract S GetSource(T obj);
    }


    /// <summary>
    /// <ja>A_v^}l[WC^[tFCXłB</ja>
    /// <en>Interface that shows the adapter manager</en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// A_v^}l[ẂA<seealso cref="Poderosa.Plugins.IPoderosaWorld">IPoderosaWorld</seealso>
    /// <see cref="Poderosa.Plugins.IPoderosaWorld.AdapterManager">AdapterManagervpeB</see>擾ł܂B
    /// </ja>
    /// <en>
    /// The adapter manager can be got by <see cref="Poderosa.Plugins.IPoderosaWorld.AdapterManager">AdapterManager property</see>
    /// on <seealso cref="Poderosa.Plugins.IPoderosaWorld">IPoderosaWorld</seealso>.
    /// </en>
    /// </remarks>
	public interface IAdapterManager {
        /// <summary>
        /// <ja>A_v^t@Ngo^܂B</ja>
        /// <en>Regist the adapter factory.</en>
        /// </summary>
        /// <param name="factory">
        /// <ja>o^A_v^t@Ng</ja>
        /// <en>Adapter factory to be regist.</en>
        /// </param>
		void RegisterFactory(IDualDirectionalAdapterFactory factory);
        /// <summary>
        /// <ja>
        /// A_v^t@Ng܂B
        /// </ja>
        /// <en>
        /// Remove the adapter factory.
        /// </en>
        /// </summary>
        /// <param name="factory">
        /// <ja>A_v^t@Ng</ja>
        /// <en>The adapter factory to remove.</en>
        /// </param>
		void RemoveFactory(IDualDirectionalAdapterFactory factory);
        /// <summary>
        /// <ja>
        /// A_v^t@Ngg^ϊ@\񋟂܂B
        /// </ja>
        /// <en>
        /// Offers type conversation function by using adapter factory.
        /// </en>
        /// </summary>
        /// <param name="obj">
        /// <ja>ϊΏۂƂȂIuWFNg</ja>
        /// <en>The object to convert.</en>
        /// </param>
        /// <param name="adapter">
        /// <ja>擾C^[tFCX</ja>
        /// <en>The interface to get.</en>
        /// </param>
        /// <returns>
        /// <ja>ϊꂽC^[tFCX</ja>
        /// <en>The converted interface</en>
        /// </returns>
        /// <remarks>
        /// <ja>
        /// J҂́AGetAdapter\bhgāAW̌^ϊ@\i<seealso cref="IAdaptable">IAdaptable</seealso>GetAdapter̎ĵ悤ɂł܂B
        /// <code>
        /// public IAdaptable GetAdapter(Type adapter)
        /// {
        ///     return poderosa_world.AdapterManager.GetAdapter(this, adapter);
        /// }
        /// </code>
        /// </ja>
        /// <en>
        /// The developer is good at a standard type conversion mechanism as follows by the use of this GetAdapter method. 
        /// <code>
        /// public IAdaptable GetAdapter(Type adapter)
        /// {
        ///     return poderosa_world.AdapterManager.GetAdapter(this, adapter);
        /// }
        /// </code>
        /// </en>
        /// </remarks>
		IAdaptable GetAdapter(IAdaptable obj, Type adapter);
        /// <summary>
        /// <ja>
        /// A_v^t@Ngg^ϊ@\񋟂܂B
        /// </ja>
        /// <en>
        /// The type conversion function to use the adaptor factory is offered. 
        /// </en>
        /// </summary>
        /// <typeparam name="T">
        /// <ja>ϊC^[tFCX̌^</ja>
        /// <en>Type in interface that wants to be converted</en>
        /// </typeparam>
        /// <param name="obj">
        /// <ja>ϊΏۂƂȂIuWFNg</ja>
        /// <en>The object that wants to be converted.</en>
        /// </param>
        /// <returns>
        /// <ja>ϊꂽC^[tFCX</ja>
        /// <en>Converted interface</en>
        /// </returns>
        T GetAdapter<T>(IAdaptable obj) where T : IAdaptable;
	}
}
