using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;
using System.Net;
using System.IO;
using System.Threading;

using Travis.LocationOperation;
using Bellagio.Forms;
using Bellagio.Data;
using Bellagio.ExternalData;

namespace Bellagio.Personal {
    //X̃f[^_E[h
    internal class DailyDataUpdateDialog : Form , DailyDataUpdateProcess.IProcessHost{
        private Label _explanation;
        private Label _accountLabel;
        private TextBox _accountBox;
        private Label _passwordLabel;
        private TextBox _passwordBox;
        private Label _startDateInfoLabel;
        private Label _endDateInfoLabel;
        private ProgressBar _progressBar;
        private Label _progressLabel;
        private Button _startButton;
        private Button _cancelButton;
        private DateTimePicker _startDatePicker;
        private DateTimePicker _endDatePicker;

        private Thread _downloadThread;

        public DailyDataUpdateDialog() {
            FormUtil.AdjustStyleForModalDialog(this);
            this.Text = "f[^_E[h";

            _explanation = new Label();
            _accountLabel = new Label();
            _accountLabel.Text = "AJEg(&A)";
            _accountBox = new TextBox();
            _passwordLabel = new Label();
            _passwordLabel.Text = "pX[h(&P)";
            _passwordBox = new TextBox();
            _passwordBox.PasswordChar = '*';
            _progressBar = new ProgressBar();
            _progressLabel = new Label();
            _startButton = new Button();
            _startButton.Text = "Jn";
            _startButton.DialogResult = DialogResult.OK;
            _startButton.Click += new EventHandler(OnStart);
            _cancelButton = new Button();
            _cancelButton.Text = "LZ";
            _cancelButton.Enabled = false;
            _cancelButton.DialogResult = DialogResult.Cancel;
            _cancelButton.Click += new EventHandler(OnCancel);
            _startDateInfoLabel = new Label();
            _startDateInfoLabel.Text = "f[^擾Jnt";
            _startDatePicker = new DateTimePicker();
            _startDatePicker.MaxDate = new System.DateTime(2099, 12, 31, 0, 0, 0, 0);
            _startDatePicker.MinDate = new System.DateTime(2008, 1, 1, 0, 0, 0, 0);
            _endDateInfoLabel = new Label();
            _endDateInfoLabel.Text = "f[^擾It";
            _endDatePicker = new DateTimePicker();
            _endDatePicker.MaxDate = new System.DateTime(2099, 12, 31, 0, 0, 0, 0);
            _endDatePicker.MinDate = new System.DateTime(2008, 1, 1, 0, 0, 0, 0);

            _explanation.Text = @"f[^ƐMpc̃_E[hs܂B
L̃AJEgɂ̓f[^QbgЂɓo^IDiʏ̓[AhXjApX[hɂ͐\񂾃pX[h͂ĂB
̃f[^͌ߌV납\ɂȂ܂B";

            const int lw = 120;
            const int lh = 19;
            RectOp rop = new RectangleOperatorBuilder()
            .Shrink(4)
            .SplitFixed(SplitDir.Top, 64).ProbeControl(_explanation).CloseBranch()
            .SplitTop(24)
                .PlaceControl(ContentAlignment.TopLeft, _accountLabel, lw, lh).RightControl(_accountBox, 120, lh)
                .CloseBranch()
            .SplitTop(24)
                .PlaceControl(ContentAlignment.TopLeft, _passwordLabel, lw, lh).RightControl(_passwordBox, 120, lh)
                .CloseBranch()
            .SplitTop(24)
                .PlaceControl(ContentAlignment.TopLeft, _startDateInfoLabel, lw, lh).RightControl(_startDatePicker, 120, lh)
                .CloseBranch()
            .SplitTop(24)
                .PlaceControl(ContentAlignment.TopLeft, _endDateInfoLabel, lw, lh).RightControl(_endDatePicker, 120, lh)
                .CloseBranch()
            .SplitTop(24)
                .PlaceControl(ContentAlignment.TopLeft, _progressLabel, 200, lh)
                .CloseBranch()
            .SplitFixed(SplitDir.Top, 24).ProbeControl(_progressBar).CloseBranch()
            .PlaceControl(ContentAlignment.BottomRight, _cancelButton, 64, 24)
            .LeftControl(_startButton, 64, 24)
            .Finish();

            this.ClientSize = new Size(320, 240);
            rop.Rect(this.ClientRectangle);
            this.Controls.AddRange(new Control[] {
                _explanation, _accountLabel, _accountBox, _passwordLabel, _passwordBox,
                _startDateInfoLabel, _startDatePicker, _endDateInfoLabel, _endDatePicker,
                _progressLabel, _progressBar, _startButton, _cancelButton});
            this.AcceptButton = _startButton;
            this.CancelButton = _cancelButton;

            //
            _accountBox.Text = PersonalPlugin.Instance.Preferences.Account;
            _passwordBox.Text = PersonalPlugin.Instance.Preferences.Password;

            //oς̂t̗荡܂łl
            DateTime now = DateTime.Now;
            if(now.Hour < 19) now = now.AddDays(-1);
            int today = PUtil.DateTimeToInt(now);

            int last_date;
            if(PUtil.SneakDailyDataLastDate("0101", out last_date))
                _startDatePicker.Value = PUtil.IntToDateTime(PUtil.NextMarketOpenDate(last_date));
            else
                _startDatePicker.Value = PUtil.IntToDateTime(today);

            DateTime end_dt = PublicMarketUtil.IsMarketOpenDate(now)? now : PUtil.IntToDateTime(PUtil.PrevMarketOpenDate(today));
            if(end_dt.CompareTo(_startDatePicker.Value) < 0) end_dt = _startDatePicker.Value;
            _endDatePicker.Value = end_dt;
        }


        private void OnStart(object sender, EventArgs args) {
            this.DialogResult = DialogResult.None;
            try {
                if(_startDatePicker.Value.CompareTo(_endDatePicker.Value)>0) {
                    PUtil.ShowWarningMessageBox(this, "擾I擾Jn̐ɐݒ肳Ă܂B");
                    return;
                }
                List<int> target_dates = new List<int>();
                DateTime dt = _startDatePicker.Value;
                while(dt.CompareTo(_endDatePicker.Value)<=0) {
                    int idt = PUtil.DateTimeToInt(dt);
                    if(PublicMarketUtil.IsMarketOpenDate(dt)) target_dates.Add(idt);
                    dt = dt.AddDays(1);
                }
                if(target_dates.Count==0) {
                    PUtil.ShowWarningMessageBox(this, "ԓɉcƓ܂B");
                    return;
                }

                SetEnabledForDownload(false);
                
                //Of[^ WebBrowserg֌WŃCXbhŎsȂƂȂ
                IExternalDataManager dm = (IExternalDataManager)PersonalPlugin.Instance.PoderosaWorld.PluginManager.FindPlugin("jp.co.lagarto.tactico.externalData", typeof(IExternalDataManager));
                dm.DailyUpdate(target_dates.ToArray());

                DailyDataUpdateProcess p = new DailyDataUpdateProcess(this, _accountBox.Text, _passwordBox.Text, target_dates.ToArray());
                _downloadThread = new Thread(new ParameterizedThreadStart(WorkMain));
                _downloadThread.Start(p);
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.StackTrace);
                PUtil.ShowWarningMessageBox(this, ex.Message);
            }
        }

        [STAThread]
        private void WorkMain(object p_) {
            try {
                DailyDataUpdateProcess p = (DailyDataUpdateProcess)p_;
                if(p.Start()) {
                    this.Invoke(new VoidVoidDelegate(SuccessfullyExit));
                }
                else
                    PUtil.ShowWarningMessageBox(this, p.ErrorMessage);
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.StackTrace);
                if(!(ex is ThreadInterruptedException))
                    PUtil.ShowWarningMessageBox(this, ex.Message);
            }
            finally {
                _downloadThread = null;
            }
        }
        private void SuccessfullyExit() {
            try {
                //łPrefXV
                PersonalPlugin.Instance.Preferences.Account = _accountBox.Text;
                PersonalPlugin.Instance.Preferences.Password = _passwordBox.Text;

                NotifyLagartoServer();
                PersonalPlugin.Instance.ExecReloadDailyDataCommand();

                this.Close();
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.StackTrace);
                PUtil.ShowWarningMessageBox(this, ex.Message);
            }
        }

        private void SetEnabledForDownload(bool enabled) {
            _accountBox.Enabled = enabled;
            _passwordBox.Enabled = enabled;
            _startDatePicker.Enabled = enabled;
            _endDatePicker.Enabled = enabled;
            _startButton.Enabled = enabled;
            _cancelButton.Enabled = !enabled;
        }

        private void NotifyLagartoServer() {
            //KgЃT[oɒʒmB
            //͗p󋵂ACfbNX_E[hB
            //f[^Ă邩𒲍
            bool longtermdata_exists = false;
            int first_date;
            if(PUtil.SneakDailyDataFirstDate("5401", out first_date))
                longtermdata_exists = first_date < 19901231;

            string url = String.Format("http://www.lagarto.co.jp/tactico/startup/dataget.cgi?ac={0}&iv={1}&ld={2}&cv={3}", _accountBox.Text, PersonalPlugin.Instance.IndexFile.VersionInfo, longtermdata_exists? "L" : "", BellagioVersionInfo.BELLAGIO_VERSION);

            try {
                HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
                req.AllowAutoRedirect = true;
                HttpWebResponse response = (HttpWebResponse)req.GetResponse();
                if(response.StatusCode==HttpStatusCode.OK) {
                    //CfbNXXV
                    string file = PersonalPlugin.Instance.BellagioEnvironment.DataHomeDir + "index.txt";
                    FileStream fs = new FileStream(file, FileMode.Create, FileAccess.Write);
                    PUtil.CopyStream(response.GetResponseStream(), fs, 0x4000);
                    fs.Close();
                    response.Close();
                    Debug.WriteLine("IndexFile updated");
                }
            }
            catch(WebException ex) {
                HttpWebResponse r = (HttpWebResponse)ex.Response;
                if(r.StatusCode==HttpStatusCode.NotModified)
                    Debug.WriteLine("Latest Index");
                else
                    Debug.WriteLine(ex.Message);
            }

        }

        protected override bool ProcessDialogKey(Keys keyData) {
            if(keyData==Keys.Escape && _downloadThread==null) {
                this.Close();
                return true;
            }
            else
                return base.ProcessDialogKey(keyData);
        }

        private void OnCancel(object sender, EventArgs args) {
            if(_downloadThread!=null) _downloadThread.Abort();
            SetEnabledForDownload(true);
        }


        //܃CXbhœO
        public void OnDownloadStart(string msg) {
            Debug.Assert(this.InvokeRequired);
            this.Invoke(new SetProgressLabelDelegate(SetProgressLabel), msg);
        }
        private delegate void SetProgressLabelDelegate(string msg);
        private void SetProgressLabel(string msg) {
            _progressLabel.Text = msg;
        }

        public void OnImportData(int stock_count, int max_count) {
            Debug.Assert(this.InvokeRequired);
            if((stock_count % 10)==0)
                this.Invoke(new SetProgressCountDelegate(SetProgressCount), stock_count, max_count);
        }
        private delegate void SetProgressCountDelegate(int stock_count, int max_count);
        private void SetProgressCount(int stock_count, int max_count) {
            _progressBar.Maximum = max_count;
            _progressBar.Value = stock_count;

            _progressLabel.Text = String.Format("Abvf[g... {0} / {1}", stock_count, max_count);
        }
    }
}
