/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Personal/PersonalPlugin.cs#5 $
 * $DateTime$
 * 
 * lBellagioŗL̋@\^
 * 
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Resources;

using Poderosa;
using Poderosa.Forms;
using Poderosa.Plugins;
using Poderosa.Preferences;
using Poderosa.Commands;

using Bellagio.Environment;

using Travis;

[assembly: PluginDeclaration(typeof(Bellagio.Personal.PersonalPlugin))]

namespace Bellagio.Personal {
    [PluginInfo(ID=PersonalPlugin.PLUGIN_ID, Version="1.0", Author="", Dependencies="jp.co.lagarto.tactico.screening")]
    internal class PersonalPlugin : PluginBase, IBellagioEditionSpecificInfo {
        public const string PLUGIN_ID = "dataget.tactico";

        private static PersonalPlugin _instance;
        private IBellagioEnvironment _bellagioEnv;
        private IndexFile _indexFile;
        private Icon _appIcon;
        private ICoreServices _coreServices;
        private PersonalPreferences _preferences;

        private OmegaChartStyleDailyDataProvider _dailyDataProvider;
        
        public override void InitializePlugin(IPoderosaWorld poderosa) {
            base.InitializePlugin(poderosa);
            
            _instance = this;
            _coreServices = (ICoreServices)poderosa.GetAdapter(typeof(ICoreServices));

            IPluginManager pm = poderosa.PluginManager;
            pm.FindExtensionPoint(WindowManagerConstants.MAINWINDOWEVENTHANDLER_ID).RegisterExtension(new InitialDataChecker());
            _indexFile = new IndexFile();
            pm.FindExtensionPoint(BellagioConstants.BOOT_PROCEDURE_EXTENSION).RegisterExtension(_indexFile);
            _bellagioEnv = (IBellagioEnvironment)poderosa.PluginManager.FindPlugin(BellagioConstants.BELLAGIO_PLUGIN_ID, typeof(IBellagioEnvironment));
            Debug.Assert(_bellagioEnv!=null);
            _dailyDataProvider = new OmegaChartStyleDailyDataProvider();
            pm.FindExtensionPoint(BellagioConstants.DAILYDATA_PROVIDER_EXTENSION).RegisterExtension(_dailyDataProvider);
            pm.FindExtensionPoint("tactico.screening.dailyDataProvider").RegisterExtension(_dailyDataProvider);
            pm.FindExtensionPoint(BellagioConstants.EDITION_SPECIFIC_INFO_EXTENSION).RegisterExtension(this);
            
            _preferences = new PersonalPreferences();
            _coreServices.PreferenceExtensionPoint.RegisterExtension(_preferences);

            DataManagementCommands.Init();
            _coreServices.CommandManager.Register(DataManagementCommands.DownloadDailyDataCommand);

            ResourceManager rm = new ResourceManager("Bellagio.Personal.Images", typeof(PersonalPlugin).Assembly);
            _appIcon = (Icon)rm.GetObject("icon16");
            WindowManagerConstants.DEFAULT_FORM_ICON = _appIcon;

        }

        public static PersonalPlugin Instance {
            get {
                return _instance;
            }
        }
        public ICoreServices CoreServices {
            get {
                return _coreServices;
            }
        }
        public PersonalPreferences Preferences {
            get {
                return _preferences;
            }
        }
        public Icon AppIcon {
            get {
                return _appIcon;
            }
        }
        public IndexFile IndexFile {
            get {
                return _indexFile;
            }
        }

        public IBellagioEnvironment BellagioEnvironment {
            get {
                return _bellagioEnv;
            }
        }

        public void ExecReloadDailyDataCommand() {
            IGeneralCommand cmd = _coreServices.CommandManager.Find("tactico.chart.reloadDailyDataBasedSessions");
            _coreServices.CommandManager.Execute(cmd, null);
        }


        public void ShowAboutBox(System.Windows.Forms.Form parent) {
            AboutBox dlg = new AboutBox();
            dlg.ShowDialog(parent);
        }

    }

    internal class PersonalPreferences : IPreferenceSupplier {

        private IStringPreferenceItem _account;
        private IStringPreferenceItem _password;

        public string PreferenceID {
            get {
                return "tactico.dataget";
            }
        }

        public void InitializePreference(IPreferenceBuilder builder, IPreferenceFolder folder) {
            _account = builder.DefineStringValue(folder, "account", "", null);
            _password = builder.DefineStringValue(folder, "password", "", null);
        }

        public object QueryAdapter(IPreferenceFolder folder, Type type) {
            return null;
        }

        public void ValidateFolder(IPreferenceFolder folder, IPreferenceValidationResult output) {
        }

        public IAdaptable GetAdapter(Type adapter) {
            return PUtil.DefaultGetAdapter(this, adapter);
        }

        public string Account {
            get {
                return _account.Value;
            }
            set {
                _account.Value = value;
            }
        }
        public string Password {
            get {
                string v = _password.Value;
                if(v.Length==0) return v;

                try {
                    return Encoding.ASCII.GetString(SimpleXor(Base64.Decode(v), 0x49)); //0x49͈ÍɑBt@CPɂ݂ł͂킩ȂẍÍ
                }
                catch(Exception ex) {
                    Debug.WriteLine(String.Format("Password Decode Error:{0}", ex.Message));
                    return "";
                }
            }
            set {
                if(value.Length > 0) {
                    try {
                        value = Encoding.ASCII.GetString(Base64.Encode(SimpleXor(Encoding.ASCII.GetBytes(value), 0x49)));
                    }
                    catch(Exception ex) {
                        Debug.WriteLine(String.Format("Password Decode Error:{0}", ex.Message));
                        value = "";
                    }
                }
                _password.Value = value;
            }
        }
        private static byte[] SimpleXor(byte[] v, byte m) {
            for(int i=0; i<v.Length; i++) {
                v[i] ^= m;
            }
            return v;
        }

    }

}
