﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

using Poderosa;
using Poderosa.Util;
using Poderosa.Boot;
using Poderosa.Plugins;

namespace Bellagio {
    static class Program {
        private static IPoderosaApplication _poderosaApplication;

        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main(string[] args) {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            PoderosaPluginEnv.MODULE_FILENAME_KEY = "Tactico";
            PoderosaPluginEnv.WINDOW_CAPTION_KEY = "Tactico";
            BellagioVersionInfo.Init(BellagioEditions.DataGetPersonal, BellagioVersionCategory.Regular);

            try {
                string[] newargs = new string[args.Length + 2];
                Array.Copy(args, newargs, args.Length);
                newargs[newargs.Length-2] = "-p";
                newargs[newargs.Length-1] = System.Environment.GetFolderPath(System.Environment.SpecialFolder.ApplicationData) + "\\" + BellagioVersionInfo.USER_DATA_PATH;

                _poderosaApplication = PoderosaStartup.CreatePoderosaApplication(newargs);
                if(_poderosaApplication!=null) {
                    IPoderosaWorld pw = (IPoderosaWorld)_poderosaApplication.GetAdapter(typeof(IPoderosaWorld));
                    //以下のプラグインはクリック証券との通信コンポーネントに依存している。
                    pw.PluginManager.DisablePlugin(new string[] {
                    "click-sec.tactico", "jp.co.lagarto.tactico.figureBoard", "jp.co.lagarto.tactico.alert", "jp.co.lagarto.tactico.ordering"});

                    _poderosaApplication.Start();
                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }

        }
    }
}