/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/IndicatorEditor.cs#10 $
 * $DateTime: 2008/02/19 10:04:20 $
 * 
 * `[gƔ̃ZbVAstatic`[g̃ZbV̋Lp[g
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

using Travis.LocationOperation;
using Poderosa.UI;
using Sansa.Runtime;

using Bellagio.Evaluators;
using Bellagio.Environment;
using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Drawing;
using Bellagio.Forms;

namespace Bellagio.Chart {
    //SuperToolTipbvēK؂ȏǉ
    public class IndicatorEditor : StringWithParameterParser.ISite {
        private static IndicatorEditor _lastVisibleInstance; //ɂ͂ЂƂȂ

        private SuperToolTipControl _toolTip;
        private ChartViewContentBase _parent;
        private ToolTipDisplayTimer _displayTimer;
        private ToolTipHideTimer _hideTimer;
        private RuntimeIndicatorElement _indicatorElement;


        public IndicatorEditor(ChartViewContentBase parent) {
            _parent = parent;

            _toolTip = new SuperToolTipControl();
            _toolTip.Visible = false;
            _toolTip.ExpandToForm += new EventHandler(OnExpandToForm);
            _toolTip.FormClose += new EventHandler(OnFormClose);
            _toolTip.MouseEnter += new EventHandler(OnMouseEnter);
            _toolTip.MouseLeave += new EventHandler(OnMouseLeave);

            _displayTimer = new ToolTipDisplayTimer(this);
            _hideTimer = new ToolTipHideTimer(this);
        }
        //r[̏Ń}EX
        public void OnMouseMove(RuntimeIndicatorElement rie, MouseEventArgs args) {
            if(_displayTimer.IsActive) _displayTimer.Cancel();

            //\ԂȂ莞Ԍɕ\悤ɂB̊ԃ}EXLZɂȂ
            if(rie!=null && !_toolTip.Visible) {
                _indicatorElement = rie;
                _displayTimer.Start();
            }

            //c[`bv[hŕ\ĂāA}EXOꂽȂ
            if(_toolTip.Visible && _toolTip.CurrentMode==SuperToolTipControl.Mode.ToolTipMode && rie!=_indicatorElement && !_hideTimer.IsActive) {
                if(!DrawingUtil.InflateRect(_toolTip.Bounds, 3).Contains(args.Location))
                    HideIndicatorToolTip();
            }
        }

        public bool Visible {
            get {
                return _toolTip.Visible;
            }
        }

        public bool IsEditing {
            get {
                return _toolTip.Visible && _toolTip.CurrentMode==SuperToolTipControl.Mode.FormMode;
            }
        }

        public void Dispose() {
            _toolTip.Dispose();
        }
        public void ShowIndicatorToolTip() {
            //̂̂ΉB
            if(_lastVisibleInstance!=null) {
                _lastVisibleInstance.HideIndicatorToolTip();
            }
            if(_parent.ContainerControl==null) return;

            //eLXgƈʒu
            Debug.Assert(_indicatorElement!=null);
            _toolTip.Text = _indicatorElement.Label;
            Point p = _parent.ContainerControl.PointToClient(Control.MousePosition);
            Point a = _toolTip.ArrowPosition();
            _toolTip.SetMode(SuperToolTipControl.Mode.ToolTipMode);
            _toolTip.Location = new Point(p.X-a.X-1, p.Y-a.Y+2); //̈ʒuŕ\邭炢傤ǂ
            Graphics g = _toolTip.CreateGraphics();
            _toolTip.AdjustSizeByTipTextSize(g.MeasureString(_indicatorElement.Label, _toolTip.Font));
            g.Dispose();
            _toolTip.Visible = true;
            _lastVisibleInstance = this;
            if(_toolTip.Parent==null) _parent.ContainerControl.Controls.Add(_toolTip);
            _toolTip.Focus();
        }
        public void HideIndicatorToolTip() {
            _toolTip.Visible = false;
            _lastVisibleInstance = null;
            _indicatorElement = null;
            _toolTip.Controls.Clear();
            if(_displayTimer.IsActive) _displayTimer.Cancel();
            BellagioDefaultControl dc = _parent.ContainerControl;
            if(dc!=null) {
                if(dc.Contains(_toolTip)) dc.Controls.Remove(_toolTip);
                dc.Focus();
            }
        }

        private void OnExpandToForm(object sender, EventArgs args) {
            CreateForm();
        }
        private void OnFormClose(object sender, EventArgs args) {
            CancelEdit();
            HideIndicatorToolTip();
        }
        private void OnMouseEnter(object sender, EventArgs args) {
        }
        private void OnMouseLeave(object sender, EventArgs args) {
            //PɃ[WoƕsӂɏĂ܂ŁA슴܂낵Ȃ
            if(_toolTip.CurrentMode==SuperToolTipControl.Mode.ToolTipMode && !DrawingUtil.InflateRect(_toolTip.RectangleToScreen(_toolTip.Bounds), 3).Contains(Control.MousePosition))
                HideIndicatorToolTip();
        }

        //ToolTipp^C}[
        //TODO ȉQNXł
        private class ToolTipDisplayTimer : ITimerDownstream {
            private IntTimer _timer;
            private bool _cancelling;
            private IndicatorEditor _parent;

            public ToolTipDisplayTimer(IndicatorEditor parent) {
                _parent = parent;
                _timer = new IntTimer(BellagioPlugin.Instance.SansaPlatform, this);
            }
            public void Start() {
                _timer.Initialize();
            }
            public void Cancel() {
                _cancelling = true;
                _timer.Abort();
                _cancelling = false;
            }
            public bool IsActive {
                get {
                    return _timer.IsActive();
                }
            }

            public void oninitialize() {
                _timer.reset(0, BellagioPlugin.Instance.SansaPlatform.getRootTimer().secondToTick(0.5));
            }

            public void onstart() {
            }

            public void onend() {
                if(!_cancelling) _parent.ShowIndicatorToolTip();
            }

            public void ontick() {
            }
        }
        private class ToolTipHideTimer : ITimerDownstream {
            private IntTimer _timer;
            private bool _cancelling;
            private IndicatorEditor _parent;

            public ToolTipHideTimer(IndicatorEditor parent) {
                _parent = parent;
                _timer = new IntTimer(BellagioPlugin.Instance.SansaPlatform, this);
            }
            public void Start() {
                _timer.Initialize();
            }
            public void Cancel() {
                _cancelling = true;
                _timer.Abort();
                _cancelling = false;
            }
            public bool IsActive {
                get {
                    return _timer.IsActive();
                }
            }

            public void oninitialize() {
                _timer.reset(0, BellagioPlugin.Instance.SansaPlatform.getRootTimer().secondToTick(0.2));
            }

            public void onstart() {
            }

            public void onend() {
                if(!_cancelling) _parent.HideIndicatorToolTip();
            }

            public void ontick() {
            }
        }

        //p[^UI\vf
        public class ParamUI {
            public Label label;
            public ExtensionParameter extensionParameter;
            public NumericUpDown updownControl;
            public string originalValue;

            public ParamUI(string text, ExtensionParameter ep, EventHandler handler) {
                extensionParameter = ep;
                originalValue = ep.Value;

                label = FormUtil.CreateLabel(text);

                updownControl = new NumericUpDown();
                updownControl.Minimum = 1;
                updownControl.Maximum = 999;
                updownControl.DecimalPlaces = 0;
                updownControl.TextAlign = HorizontalAlignment.Right;
                updownControl.Value = Int32.Parse(originalValue);
                updownControl.ValueChanged += handler;
            }
            public void Layout(RectangleOperatorBuilder bld, Control.ControlCollection cc) {
                cc.Add(label);
                cc.Add(updownControl);
                bld.Bottom(40, 19).ProbeControl(label);
                bld.Tee().RightControl(updownControl, 64, 19).CloseBranch();
            }
        }
        //GgUI\vf
        public class ElementUI {
            public RuntimeIndicatorElement element;
            public BPenStyle originalPen;
            public Label colorLabel;
            public ColorButton colorButton;
            public Label widthLabel;
            public NumericUpDown widthButton;
            public Label styleLabel;
            public ComboBox styleBox;

            public ElementUI(RuntimeIndicatorElement e, EventHandler handler, ColorButton.NewColorEventHandler color_handler) {
                element = e;
                originalPen = e.BPenStyle;

                colorLabel = FormUtil.CreateLabel("F");

                colorButton = new ColorButton();
                colorButton.SelectedColor = originalPen.color;
                colorButton.ColorChanged += color_handler;

                widthLabel = FormUtil.CreateLabel("");

                widthButton = new NumericUpDown();
                widthButton.Minimum = 1;
                widthButton.Maximum = 5;
                widthButton.TextAlign = HorizontalAlignment.Right;
                widthButton.Value = originalPen.width;
                widthButton.ValueChanged += handler;

                styleLabel = FormUtil.CreateLabel("`");
                styleBox = FormUtil.CreateComboBox("_", "");
                styleBox.SelectedIndex = originalPen.dash==BPenStyle.DashStyle.Dot? 0 : 1;
                styleBox.SelectedIndexChanged += handler;
            }

            public void Layout(RectangleOperatorBuilder bld, Control.ControlCollection cc) {
                cc.Add(colorLabel);
                cc.Add(colorButton);
                cc.Add(widthLabel);
                cc.Add(widthButton);
                cc.Add(styleLabel);
                cc.Add(styleBox);

                bld.SetMargin(4);
                bld.BottomControl(colorLabel, 40, 19).Tee().RightControl(colorButton, 64, 19).CloseBranch();
                bld.BottomControl(widthLabel, 40, 19).Tee().RightControl(widthButton, 64, 19).CloseBranch();
                bld.BottomControl(styleLabel, 40, 19).Tee().RightControl(styleBox, 64, 19).CloseBranch();

            }

            public BPenStyle.DashStyle SelectedDashStyle {
                get {
                    return styleBox.SelectedIndex==0? BPenStyle.DashStyle.Dot : BPenStyle.DashStyle.Solid;
                }
            }
        }

        //ҏWUIvf
        private List<ParamUI> _paramUIs;
        private ElementUI _elementUI;
        private Button _okButton;

        private void CreateForm() {
            Control.ControlCollection cc = _toolTip.Controls;
            EventHandler arg_changed = new EventHandler(OnArgumentChangedLight);
            ColorButton.NewColorEventHandler color_changed = new ColorButton.NewColorEventHandler(OnElementColorChangedLight);
            EventHandler width_changed = new EventHandler(ElementWidthChanged);
            _toolTip.SuspendLayout();

            RectangleOperatorBuilder rcb = new RectangleOperatorBuilder(4);
            _paramUIs = new List<ParamUI>();
            foreach(IndicatorSchemaParameterInfo param_info in _indicatorElement.Container.SourceSchema.GetParameterInfoFor(_indicatorElement.SourceSchema)) {
                if(param_info.IsAttachedToPreference) {
                    ExtensionParameter ep = (ExtensionParameter)BellagioRoot.ExtensionKitPreference.Find(param_info.PreferenceID);
                    ParamUI pui = new ParamUI(FormatParameterLabel(param_info), ep, arg_changed);
                    pui.Layout(rcb, cc);
                    _paramUIs.Add(pui);
                }
            }

            //܂͂ЂƂelement
            ElementUI eui = new ElementUI(_indicatorElement, width_changed, color_changed); //TODO w̕ύXparam_changedył
            eui.Layout(rcb, cc);
            _elementUI = eui;

            _okButton = FormUtil.CreateOKButton();
            _okButton.Size = new Size(64, 21);
            _okButton.Click += new EventHandler(OnOK);
            _toolTip.AcceptButtonEx = _okButton;
            cc.Add(_okButton);
            rcb.CornerOffset(RectCorner.BottomLeft, 44, 4, _okButton.Width, _okButton.Height).ProbeControl(_okButton);

            //IĔzu͂Ȃ̂ňCɎs
            rcb.Finish().Rect(new Rectangle(8, 24, 0, 0));

            int prev_bottom = _toolTip.Bottom;
            _toolTip.Size = new Size(Math.Max(_toolTip.Width, _elementUI.widthButton.Right+12), _okButton.Bottom+4);
            
            //ƍ̂ňʒu
            if(_toolTip.Bottom > _toolTip.Parent.ClientSize.Height) {
                _toolTip.Top = prev_bottom -_toolTip.Height;
            }

            _toolTip.ResumeLayout();
        }
        private string FormatParameterLabel(IndicatorSchemaParameterInfo pi) {
            StringWithParameterParser p = new StringWithParameterParser(this);
            p.AddToStringMap(pi.LocalName, ""); //ϐ͏
            return p.Parse(pi.RawDescription).Trim();
        }
        string StringWithParameterParser.ISite.FindParameter(string name) {
            if(name=="unit") return _indicatorElement.Container.SourceSchema.Parent.ChartUnitName;
            else return "";
        }


        //p[^\vf̕ω
        private void OnArgumentChangedLight(object sender, EventArgs args) {
            if(!UpdateParameters()) return;

            ChartPreferenceUpdateInfo info = CreateChartPreferenceUpdateInfo();
            //ƌvZ΃p[^̕ωvf͌vZ\蔲Bꂾƃp[^L^CvɑΉłȂ
            info.AddIndicatorDefinition(_indicatorElement.Container.SourceSchema.IndicatorDefinition);
            info.UpdatedParameters = true;
            ExecReloadCommand(info);
        }
        private void OnElementColorChangedLight(object sender, Color newcolor) {
            ChangeElementAppearanceCore(new BPenStyle(newcolor, _elementUI.SelectedDashStyle, (int)_elementUI.widthButton.Value));
        }
        private void ElementWidthChanged(object sender, EventArgs args) {
            ChangeElementAppearanceCore(new BPenStyle(_elementUI.colorButton.SelectedColor, _elementUI.SelectedDashStyle, (int)_elementUI.widthButton.Value));
        }
        private void ChangeElementAppearanceCore(BPenStyle ps) {
            _indicatorElement.GetAppearancePreferenceItem().Value = ps.ToString();
            ChartPreferenceUpdateInfo info = CreateChartPreferenceUpdateInfo();
            info.UpdatedAppearance = true;
            info.AddIndicatorDefinition(_indicatorElement.Container.SourceSchema.IndicatorDefinition);
            ExecReloadCommand(info);
        }

        //OKƃLZ
        private void OnOK(object sender, EventArgs args) {
            if(!UpdateParameters()) return; //OnArgChangeoȂłȂOKɂȂP[X̂UpdateParameters͕Kv

            ChartPreferenceUpdateInfo info = CreateChartPreferenceUpdateInfo();
            info.UpdatedAllIndicators = true;
            info.UpdatedLabel = true;
            ExecReloadCommand(info);
            HideIndicatorToolTip();
        }
        private bool UpdateParameters() {
            foreach(ParamUI pu in _paramUIs) {
                int value;
                if(!Int32.TryParse(pu.updownControl.Value.ToString(), out value) || value<=0) {
                    BUtil.ShowWarningMessageBox("Pȏ̐͂Ă");
                    pu.extensionParameter.Value = pu.originalValue;
                    pu.updownControl.Value = Decimal.Parse(pu.originalValue);
                    return false;
                }
                pu.extensionParameter.Value = value.ToString();
            }
            return true;
        }

        private void CancelEdit() {
            foreach(ParamUI pu in _paramUIs)
                pu.extensionParameter.Value = pu.originalValue;
            _indicatorElement.GetAppearancePreferenceItem().Value = _elementUI.originalPen.ToString();
            ChartPreferenceUpdateInfo info = CreateChartPreferenceUpdateInfo();
            info.UpdatedAllIndicators = true;
            info.UpdatedParameters = true;
            info.UpdatedAppearance = true;
            info.UpdatedLabel = true;
            ExecReloadCommand(info);
        }

        private ChartPreferenceUpdateInfo CreateChartPreferenceUpdateInfo() {
            ChartSchema cs = _indicatorElement.Container.SourceSchema.Parent;
            return new ChartPreferenceUpdateInfo(cs);
        }

        private void ExecReloadCommand(ChartPreferenceUpdateInfo info) {
            BellagioPlugin.Instance.Commands.ReloadPreference.InternalExecute(null, info);
        }
    }
}
