/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/ResumeInfo.cs#4 $
 * $DateTime: 2008/04/17 18:20:55 $
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Threading;

using Poderosa.Sessions;
using Bellagio.Chart;
using Bellagio.Environment;
using Bellagio.Ordering;

namespace Bellagio.Data {
    //Xg[W[p̓ۑ
    public class ResumeInfo {
        private List<IntraDayTrade> _intraDayTrades;
        private List<LightIntraDayTrade> _lightIntraDayTrades;
        private List<RealtimeIta> _realtimeItas;

        private Form _owner;

        public ResumeInfo() {
            _intraDayTrades = new List<IntraDayTrade>();
            _lightIntraDayTrades = new List<LightIntraDayTrade>();
            _realtimeItas = new List<RealtimeIta>();
        }

        public void Create() {
#if false
            //Step1 A^Cf[^̕KvȃhLgSɂĂLoadingXe[^X
            ISessionManager sm = BellagioPlugin.Instance.SessionManager;


            //Step2 DaytimeTrading, RealtimeIta, EHb`XgZbgW
            //TODO GetAllActivesłȂ[fBÔ̂܂߂ق悢H
            foreach(IntraDayTrade dt in BellagioRoot.IntraDayTradeProvider.PrepareResume()) {
                dt.Reset();
                BellagioRoot.DataSubscriberManager.RemovePeriodicalSubscriber(dt); //PeriodicalSubscriberł邩AڑƂɍēo^ł邽߂ɂŊOĂ
                _intraDayTrades.Add(dt);
            }
            foreach(LightIntraDayTrade lt in BellagioRoot.LightIntraDayTradeProvider.PrepareResume()) {
                _lightIntraDayTrades.Add(lt); //Resetsv
            }
            foreach(RealtimeIta ita in BellagioRoot.ItaProvider.PrepareResume()) {
                ita.Reset();
                _realtimeItas.Add(ita);
            }

            foreach(ISession sess in sm.AllSessions) {
                RealTimeChartSession rtc = sess as RealTimeChartSession;
                if(rtc!=null && rtc.Document.DocumentStatus==BellagioDocumentStatus.Complete) {
                    rtc.EnterToLoadingStatus();
                    BellagioRoot.DataSubscriberManager.PrepareResume(rtc.Document);
                }
            }

            //TODO ۂ́AehLgDataSubscriberManageroRŒʒm󂯎̂ANotifyDelegatenȂ̂...

            //tH[̂΂ǉ
            /*
            OrderForm orderform = OrderingPlugin.Instance.OrderForm;
            if(orderform!=null) {
                ChartControl chart = orderform.RealtimeChart;
                if(chart!=null) chart.PrepareResume();
                ItaControl ita = orderform.ItaControl;
                if(ita!=null) ita.PrepareResume();
            }
            */
#endif
        }

        public void Start(Form owner) {
            _owner = owner;
            
            //Notifiero^
            //BellagioRoot.DaytimeTradeProvider.ResultNotifier = new StockDataProviderBaseT<DaytimeTrade>.ResultNotifierDeleagate(TickSubscribeResult);
            //BellagioRoot.LightDaytimeTradeProvider.ResultNotifier = new StockDataProviderBaseT<LightDaytimeTrade>.ResultNotifierDeleagate(LightStockSubscribeResult);
            //BellagioRoot.ItaProvider.ResultNotifier = new StockDataProviderBaseT<RealtimeIta>.ResultNotifierDeleagate(ItaSubscribeResult);

            //ResumeStream̂҂ق悢
            Thread.Sleep(1000);
            DoNextStep();
        }

        //̂PTuXNCuJn
        private void DoNextStep() {
            Debug.Assert(BUtil.IsExecutingInMainThread);

            string msg = null;

            if(_intraDayTrades.Count > 0) {
                IntraDayTrade t = _intraDayTrades[_intraDayTrades.Count-1];
                AsyncOpResult r = BellagioRoot.IntraDayTradeProvider.Resume(t, ref msg);
                Debug.Assert(r!=AsyncOpResult.Succeeded); //ResumeȂ̂œIɐƂ̂͂肦Ȃ
                if(r==AsyncOpResult.Failed) SubscribeFail(msg);
                return;
            }
            if(_realtimeItas.Count > 0) {
                RealtimeIta t = _realtimeItas[_realtimeItas.Count-1];
                AsyncOpResult r = BellagioRoot.ItaProvider.Resume(t, ref msg);
                Debug.Assert(r!=AsyncOpResult.Succeeded); 
                if(r==AsyncOpResult.Failed) SubscribeFail(msg);
                return;
            }
            if(_lightIntraDayTrades.Count > 0) {
                LightIntraDayTrade t = _lightIntraDayTrades[_lightIntraDayTrades.Count-1];
                AsyncOpResult r = BellagioRoot.LightIntraDayTradeProvider.Resume(t, ref msg);
                Debug.Assert(r!=AsyncOpResult.Succeeded);
                if(r==AsyncOpResult.Failed) SubscribeFail(msg);
                return;
            }

            //܂ł琬
            Terminate();
        }

        private void Terminate() {
            //Notifier
            BellagioRoot.IntraDayTradeProvider.ResultNotifier = null;
            BellagioRoot.LightIntraDayTradeProvider.ResultNotifier = null;
            BellagioRoot.ItaProvider.ResultNotifier = null;
            //OrderForm orderform = OrderingPlugin.Instance.OrderForm;
            //if(orderform!=null) orderform.Invalidate(true);
            _owner.Close();
        }

        private void TickSubscribeResult(Stock stock, AsyncOpResult result, string msg) {
            if(result==AsyncOpResult.Succeeded) {
                Debug.Assert(_intraDayTrades.Count > 0);
                _intraDayTrades.RemoveAt(_intraDayTrades.Count-1); //폜
                _owner.Invoke(new VoidVoidDelegate(DoNextStep));
            }
            else {
                SubscribeFail(msg);
            }
        }
        private void LightStockSubscribeResult(Stock stock, AsyncOpResult result, string msg) {
            if(result==AsyncOpResult.Succeeded) {
                Debug.Assert(_lightIntraDayTrades.Count > 0);
                _lightIntraDayTrades.RemoveAt(_lightIntraDayTrades.Count-1);
                _owner.Invoke(new VoidVoidDelegate(DoNextStep));
            }
            else {
                SubscribeFail(msg);
            }
        }
        private void ItaSubscribeResult(Stock stock, AsyncOpResult result, string msg) {
            if(result==AsyncOpResult.Succeeded) {
                Debug.Assert(_realtimeItas.Count > 0);
                _realtimeItas.RemoveAt(_realtimeItas.Count-1); 
                _owner.Invoke(new VoidVoidDelegate(DoNextStep));
            }
            else {
                SubscribeFail(msg);
            }
        }

        private void SubscribeFail(string msg) {
            BUtil.ShowWarningMessageBox(msg);
            _owner.Invoke(new VoidVoidDelegate(Terminate));
        }
    }
}
