/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Drawing/GraphicEffectUtil.cs#8 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.InteropServices;
#if UNITTEST
using NUnit.Framework;
#endif

namespace Bellagio.Drawing {

    //OtBbŇʂôɎg֐Q^
    public static class GraphicEffectUtil {
        //current̒l0...cycle-1܂ŕωƂAl0...+amp...0...-amp...0ƂȂ悤ɓ
        public static int LinearZigZag(int cycle, int current, int amp) {
            Debug.Assert((cycle % 4)==0);
            current %= cycle;

            int t = cycle>>2;
            int v = amp * (current % t) / t;
            if(current < t) //0...+amp
                return v;
            else if(current < t*2) //+amp ... 0
                return amp - v;
            else if(current < t*3) //0 ... -amp
                return -v;
            else
                return -amp + v;
        }
        public static float LinearZigZagF(float cycle, float current, float amp) {
            float t = cycle / 4;
            if(current < t) //0...+amp
                return amp * (current / t);
            else if(current < t*3) //+amp ... 0 ... -amp
                return amp * ((t*2 - current) / t);
            else
                return amp * ((current - t*4) / t);
        }
    }

    //pێlp`
    public static class RoundRectUtil {
        public static void Fill(Graphics g, Brush b, Rectangle rect, int radius) {
            int r2 = radius*2;

            //ꂢɌ邽߂ɂPsNZ̕␳Ă
            //㕔
            g.FillPie(b, rect.Left, rect.Top, r2, r2, 180, 90);
            g.FillRectangle(b, rect.Left+radius, rect.Top, rect.Width-r2, radius);
            g.FillPie(b, rect.Right-r2-1, rect.Top, r2, r2, 270, 90);
            //
            g.FillRectangle(b, rect.Left, rect.Top+radius, rect.Width, rect.Height-r2);
            //
            g.FillPie(b, rect.Left, rect.Bottom-r2-1, r2, r2, 90, 90);
            g.FillRectangle(b, rect.Left+radius, rect.Bottom-radius, rect.Width-r2, radius);
            g.FillPie(b, rect.Right-r2-1, rect.Bottom-r2-1, r2, r2, 0, 90);
        }
        public static void Draw(Graphics g, Pen p, Rectangle rect, int radius) {
            int r2 = radius*2;

            //ꂢɌ邽߂ɂPsNZ̕␳Ă
            //㕔
            g.DrawArc(p, rect.Left, rect.Top, r2, r2, 180, 90);
            g.DrawLine(p, rect.Left+radius, rect.Top, rect.Right-radius, rect.Top);
            g.DrawArc(p, rect.Right-r2-1, rect.Top, r2, r2, 270, 90);
            //
            g.DrawLine(p, rect.Left, rect.Top+radius, rect.Left, rect.Bottom-radius);
            g.DrawLine(p, rect.Right, rect.Top+radius, rect.Right, rect.Bottom-radius);
            //
            g.DrawArc(p, rect.Left, rect.Bottom-r2-1, r2, r2, 90, 90);
            g.DrawLine(p, rect.Left+radius, rect.Bottom, rect.Right-radius, rect.Bottom);
            g.DrawArc(p, rect.Right-r2-1, rect.Bottom-r2-1, r2, r2, 0, 90);
        }
    }

    //Op``
    public static class TriangleUtil {
        public enum Direction {
            Left, Right //͍Ê
        }
        public static void Fill(Graphics g, Rectangle rect, Color color, Direction dir) {
            FillMain(g, rect, color, dir, false, 0);
        }
        public static void FillSmooth(Graphics g, Rectangle rect, Color color, Color back, Direction dir) {
            uint smoothcolor = DrawingUtil.ToCOLORREF(DrawingUtil.ProportionalColor(back, color, 0.5));
            FillMain(g, rect, color, dir, true, smoothcolor);
        }
        private static void FillMain(Graphics g, Rectangle rect, Color color, Direction dir, bool smooth, uint smoothcolor) {
            bool odd = (rect.Height & 1)!=0;
            int h = (rect.Height+1) / 2;
            Pen pen = new Pen(color);
            uint colorref = DrawingUtil.ToCOLORREF(color);

            int hh = (h-1)/2;
            for(int y = 0; y < h; y++) {
                int w = 1 + ((rect.Width-1) * y + hh) / (h-1); //̒BŒłP͊mۂ悤ɂAy==h-1rect.WidthɂȂ悤ɁBľܓ␳邽 (h-1)/2 𑫂Ă犄
                int x1 = dir==Direction.Left? rect.Right - w : rect.Left;
                int x2 = dir==Direction.Left? rect.Right - 1 : rect.Left + w - 1;

                DrawHLine(g, x1, rect.Top+y, x2, pen, colorref, smooth, smoothcolor);
                if(y<h-1 || !odd) DrawHLine(g, x1, rect.Bottom-y-1, x2, pen, colorref, smooth, smoothcolor);
            }
            pen.Dispose();
        }

        //`BWinclusive,  smooth ̏ꍇA[ smoothcolor ŃsNZ`
        //pen̐FcolorrefƈvĂȂƂȂ
        private static void DrawHLine(Graphics g, int x1, int y, int x2, Pen pen, uint colorref, bool smooth, uint smoothcolor) {
            Debug.Assert(x1<=x2);
            bool hdc_required = smooth || x1==x2;
            IntPtr hdc = hdc_required? g.GetHdc() : IntPtr.Zero; //sKvGetHDCȂ

            if(smooth) {
                if(x1==x2)
                    SetPixel(hdc, x1, y, smoothcolor);
                else if(x1+1==x2) {
                    SetPixel(hdc, x1, y, smoothcolor);
                    SetPixel(hdc, x2, y, smoothcolor);
                }
                else if(x1+2==x2) {
                    SetPixel(hdc, x1, y, smoothcolor);
                    SetPixel(hdc, x1+1, y, colorref);
                    SetPixel(hdc, x2, y, smoothcolor);
                }
                else {
                    SetPixel(hdc, x1, y, smoothcolor);
                    SetPixel(hdc, x2, y, smoothcolor);
                    //̓gbL[FReleaseHDCĂłȂDrawLine͌ĂׂȂ
                    g.ReleaseHdc(hdc);
                    hdc_required = false;
                    g.DrawLine(pen, x1+1, y, x2-1, y);
                }
            }
            else {
                if(x1==x2)
                    SetPixel(hdc, x1, y, colorref);
                else
                    g.DrawLine(pen, x1, y, x2, y);
            }

            if(hdc_required) g.ReleaseHdc(hdc);
        }

        [DllImport("gdi32.dll")]
        public static extern uint SetPixel(IntPtr hDC, int x, int y, uint colorref);
    }



#if UNITTEST
    [TestFixture]
    public class GraphicEffectUtilTests {
        [Test]
        public void LinearZigZag1() {
            int[] expected = new int[] { 0, 1, 2, 1, 0, -1, -2, -1 };
            int[] result = new int[8];
            Assert.AreEqual(expected.Length, result.Length);
            for(int i=0; i<result.Length; i++) result[i] = GraphicEffectUtil.LinearZigZag(8, i, 2);

            for(int i=0; i<result.Length; i++)
                Assert.AreEqual(expected[i], result[i]);
        }
    }
#endif
}
