/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Forms/BellagioDefaultControl.cs#11 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 * System.Windows.Forms.ControlɁA
 *  (1) ĔzuĂRg[̍č쐬Ȃłނ悤IBellagioDefaultControlContentZbgΌڈRg[ƂĂӂ܂
 *  (2) yC@\̃T|[g
 * 
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;

using Poderosa;
using Poderosa.Forms;
using Poderosa.UI;
using Poderosa.View;
using Poderosa.Sessions;

using Bellagio.Environment;
using Bellagio;

namespace Bellagio.Forms {

    //Xvbg}[N̎Azuϊł̂h~Ƃϓ_ŁARg[̒geBellagior[ŌʂɎ悤ɂ
    public interface IBellagioDefaultControlContent {
        IPoderosaDocument IPoderosaDocument { get; }
        void Attach(BellagioDefaultControl parent);
        void Detach();

        void OnPaint(PaintEventArgs args);
        void OnMouseDown(MouseEventArgs args);
        void OnMouseUp(MouseEventArgs args);
        void OnMouseMove(MouseEventArgs args);
        void OnMouseWheel(MouseEventArgs args);
        void OnMouseLeave();
        void OnDoubleClick();
        void OnKeyDown(KeyEventArgs args);
        void OnResize();
        void OnGotFocus();
        void NotifySplitMarkStateChanged();

        Rectangle SplitMarkDisplayRect { get; }
    }

    //\ȂԁASʃJX^`AƂƂ܂ފ{r[BPoderosałCharacterDocumentViewer
    //TESTINFO ȂBPoderosałxт̂R[h
    public class BellagioDefaultControl : Control, IPoderosaControl, SplitMarkSupport.ISite {
        private SplitMarkSupport _splitMark;
        private bool _enabled; //hLgA^b`ĂȂƂ ύXƂEnabledExvpeBŁI
        private bool _errorRaisedInDrawing;
        private SplitMarkUIHandler _splitMarkUIHandler;
        protected MouseHandlerManager _mouseHandlerManager;
        private IBellagioDefaultControlContent _content;

        public BellagioDefaultControl() {
            this.DoubleBuffered = true;
            this.AllowDrop = true;
            
            _splitMark = new SplitMarkSupport(this, this);
            Pen p = new Pen(SystemColors.ControlDark);
            p.DashStyle = System.Drawing.Drawing2D.DashStyle.Dot;
            _splitMark.Pen = p;
            this.EnabledEx = false;
            
            _mouseHandlerManager = new MouseHandlerManager();
            _mouseHandlerManager.AddLastHandler(_splitMarkUIHandler = new SplitMarkUIHandler(_splitMark));
            _mouseHandlerManager.AttachControl(this);
        }
        public MouseHandlerManager MouseHandlerManager {
            get {
                return _mouseHandlerManager;
            }
        }
        public bool EnabledEx {
            get {
                return _enabled;
            }
            set {
                _enabled = value;
                _splitMark.SetPenColor(value? SystemColors.ControlDark : SystemColors.Window); //BackColorƋt
                this.Cursor = this.MouseCursor; //Splitter.ISitep
                this.BackColor = value? Color.Black : SystemColors.ControlDark;
                this.ImeMode = value? ImeMode.NoControl : ImeMode.Disable;
            }
        }
        internal void Attach(IBellagioDefaultControlContent content) {
            Debug.Assert(_content==null);
            _content = content;

            this.SuspendLayout();
            this.Controls.Clear();
            _content.Attach(this);
            this.ResumeLayout();

            this.EnabledEx = true;
        }
        internal void Detach() {
            if(_content!=null) {
                _content.Detach();
                _content = null;
            }
            if(!this.IsDisposed) {
                this.Controls.Clear();
                this.EnabledEx = false;
            }
        }

        internal IBellagioDefaultControlContent CurrentContent {
            get {
                return _content;
            }
        }

        #region IAdaptable
        public virtual IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
        #endregion
        #region IPoderosaControl
        public Control AsControl() {
            return this;
        }
        #endregion

        protected override void Dispose(bool disposing) {
            if(disposing && _content!=null) {
                _content.Detach(); //contentł̓\[XėpƂ
                _content = null;
            }

            base.Dispose(disposing);
            if(disposing) {
                _splitMark.Pen.Dispose();
            }
        }
        protected override sealed void OnPaint(PaintEventArgs e) {
            base.OnPaint(e);
            try {
                if(_enabled  && !this.DesignMode && _content!=null) {
                    _content.OnPaint(e);
                }
                //}[N̕`
                _splitMark.OnPaint(e);
            }
            catch(Exception ex) {
                if(!_errorRaisedInDrawing) { //̒ňxOƌJԂNĂ܂Ƃ܂܂BȂ̂ŏ̂ݕ\ĂƂ肠؂蔲
                    _errorRaisedInDrawing = true;
                    RuntimeUtil.ReportException(ex);
                }
            }
        }
        protected override void OnGotFocus(EventArgs args) {
            try {
                base.OnGotFocus(args);
                if(!this.EnabledEx) return;

                IPoderosaDocument pd = _content.IPoderosaDocument;
                if(_content!=null && pd!=null) { //ߒ̂Ƃ͖

                    BellagioPlugin.Instance.SessionManager.ActivateDocument(pd, ActivateReason.ViewGotFocus);
                    if(_content!=null) _content.OnGotFocus();
                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        protected override void OnResize(EventArgs e) {
            try {
                base.OnResize(e);
                if(_content!=null) _content.OnResize();
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        protected override void OnMouseDown(MouseEventArgs e) {
            try {
                base.OnMouseDown(e);
                if(!this.Focused) this.Focus(); //ControlhĂ̂ŖIɂȂ
                if(_content!=null && !_mouseHandlerManager.IsGuardingUIEvent) _content.OnMouseDown(e);
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        protected override void OnMouseUp(MouseEventArgs e) {
            try {
                if(_content!=null && !_mouseHandlerManager.IsGuardingUIEvent) _content.OnMouseUp(e);
                base.OnMouseUp(e);
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        protected override void OnMouseMove(MouseEventArgs e) {
            try {
                if(_content!=null && !_mouseHandlerManager.IsGuardingUIEvent) _content.OnMouseMove(e);
                base.OnMouseMove(e);
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        protected override void OnMouseWheel(MouseEventArgs e) {
            try {
                if(_content!=null && !_mouseHandlerManager.IsGuardingUIEvent) _content.OnMouseWheel(e);
                base.OnMouseWheel(e);
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        protected override void OnKeyDown(KeyEventArgs e) {
            try {
                base.OnKeyDown(e);
                if(_content!=null) _content.OnKeyDown(e);
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        protected override void OnDoubleClick(EventArgs e) {
            try {
                base.OnDoubleClick(e);
                if(_content!=null) _content.OnDoubleClick();
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }

        //Drag&Drop֌W
        protected override void OnDragEnter(DragEventArgs args) {
            base.OnDragEnter(args);
            try {
                IWinFormsService wfs = BellagioPlugin.Instance.WinFormsService;
                IPoderosaDocument document = (IPoderosaDocument)wfs.GetDraggingObject(args.Data, typeof(IPoderosaDocument));
                if(document!=null)
                    args.Effect = DragDropEffects.Move;
                else
                    wfs.BypassDragEnter(this, args);
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        protected override void OnDragDrop(DragEventArgs args) {
            base.OnDragDrop(args);
            try {
                IWinFormsService wfs = BellagioPlugin.Instance.WinFormsService;
                IPoderosaDocument document = (IPoderosaDocument)wfs.GetDraggingObject(args.Data, typeof(IPoderosaDocument));
                if(document!=null) {
                    IPoderosaView view = (IPoderosaView)this.GetAdapter(typeof(IPoderosaView));
                    if(view!=null) {
                        BellagioPlugin.Instance.SessionManager.AttachDocumentAndView(document, view);
                        BellagioPlugin.Instance.SessionManager.ActivateDocument(document, ActivateReason.DragDrop);
                    }
                }
                else
                    wfs.BypassDragDrop(this, args);
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }

        //J[\L[n͎OŏKeyDownU
        protected override bool ProcessDialogKey(Keys keyData) {
            Keys k = keyData & Keys.KeyCode;
            if(k==Keys.Left || k==Keys.Right || k==Keys.Up || k==Keys.Down || k==Keys.PageDown || k==Keys.PageUp || k==Keys.Home || k==Keys.End)
                return false;
            else
                return base.ProcessDialogKey(keyData);
        }


        //SplitMark֌W
        #region SplitMark.ISite
        protected override void OnMouseLeave(EventArgs e) {
            base.OnMouseLeave(e);
            if(_splitMark.IsSplitMarkVisible) _mouseHandlerManager.EndCapture();
            if(_content!=null) _content.OnMouseLeave();
            _splitMark.ClearMark();
        }

        public bool CanSplit {
            get {
                IContentReplaceableView v = AsControlReplaceableView();
                return v==null? false : GetSplittableViewManager().CanSplit(v);
            }
        }
        public int SplitClientWidth {
            get {
                return _content==null? this.ClientSize.Width : _content.SplitMarkDisplayRect.Width;
            }
        }
        public int SplitClientHeight {
            get {
                return _content==null? this.ClientSize.Height : _content.SplitMarkDisplayRect.Height;
            }
        }
        public Cursor MouseCursor {
            get {
                return Cursors.Default;
            }
        }
        public void NotifySplitMarkStateChanged() {
            if(_content!=null) _content.NotifySplitMarkStateChanged();
        }

        public void SplitVertically() {
            GetSplittableViewManager().SplitVertical(AsControlReplaceableView(), null);
        }
        public void SplitHorizontally() {
            GetSplittableViewManager().SplitHorizontal(AsControlReplaceableView(), null);
        }

        public SplitMarkSupport SplitMark {
            get {
                return _splitMark;
            }
        }
        internal SplitMarkUIHandler SplitMarkUIHandler {
            get {
                return _splitMarkUIHandler;
            }
        }

        #endregion

        private ISplittableViewManager GetSplittableViewManager() {
            IContentReplaceableView v = AsControlReplaceableView();
            if(v==null)
                return null;
            else
                return (ISplittableViewManager)v.ViewManager.GetAdapter(typeof(ISplittableViewManager));
        }
        private IContentReplaceableView AsControlReplaceableView() {
            IContentReplaceableViewSite site = (IContentReplaceableViewSite)this.GetAdapter(typeof(IContentReplaceableViewSite));
            return site==null? null : site.CurrentContentReplaceableView;
        }

    }

    //Xvbg}[Ñnh
    public class SplitMarkUIHandler : DefaultMouseHandler {
        private SplitMarkSupport _splitMark;
        public SplitMarkUIHandler(SplitMarkSupport split)
            : base("splitmark") {
            _splitMark = split;
        }

        public override UIHandleResult OnMouseDown(MouseEventArgs args) {
            return UIHandleResult.Pass;
        }
        public override UIHandleResult OnMouseMove(MouseEventArgs args) {
            bool v = _splitMark.IsSplitMarkVisible;
            //if(v || WindowManagerPlugin.Instance.WindowPreference.OriginalPreference.ViewSplitModifier==Control.ModifierKeys)
                _splitMark.OnMouseMove(args);
            //OɃLv`[ĂEndCapture
            return _splitMark.IsSplitMarkVisible? UIHandleResult.Capture : v? UIHandleResult.EndCapture : UIHandleResult.Pass;
        }
        public override UIHandleResult OnMouseUp(MouseEventArgs args) {
            bool visible = _splitMark.IsSplitMarkVisible;
            if(visible) {
                //Ⴆ΁A}[N\ʒuI悤ȏꍇlA}[NŉENbNƑI悤ɂB
                _splitMark.OnMouseUp(args);
                return UIHandleResult.EndCapture;
            }
            else
                return UIHandleResult.Pass;
        }
    }

    public class BellagioViewFactory : IViewFactory {
        public IPoderosaView CreateNew(IPoderosaForm parent) {
            return new BellagioView(parent, new BellagioDefaultControl());
        }

        public Type GetViewType() {
            return typeof(BellagioView);
        }
        public Type GetDocumentType() {
            return null; //??
        }

        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
    }

    public class BellagioView : IPoderosaView, IContentReplaceableViewSite {
        private IPoderosaForm _parent;
        private BellagioDefaultControl _control;
        private IContentReplaceableView _contentReplaceableView; //܂

        public BellagioView(IPoderosaForm parent, BellagioDefaultControl control) {
            _parent = parent;
            _control = control;
            control.Tag = this;
        }

        public BellagioDefaultControl BellagioControl {
            get {
                return _control;
            }
        }

        #region IContentReplaceableViewSite
        public IContentReplaceableView CurrentContentReplaceableView {
            get {
                return _contentReplaceableView;
            }
            set {
                _contentReplaceableView = value;
            }
        }
        #endregion

        #region IPoderosaView
        public IPoderosaDocument Document {
            get {
                IBellagioDefaultControlContent cc = _control.CurrentContent;
                return cc==null? null : cc.IPoderosaDocument;
            }
        }

        public ISelection CurrentSelection {
            get {
                return null;
            }
        }

        public Control AsControl() {
            return _control;
        }
        public IPoderosaForm ParentForm {
            get {
                return _parent;
            }
        }
        #endregion

        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }

    }
    //TerminalControl to TerminalView
    public class PaneBridgeAdapter : ITypedDualDirectionalAdapterFactory<BellagioDefaultControl, BellagioView> {

        public override BellagioView GetAdapter(BellagioDefaultControl obj) {
            return ((BellagioView)obj.Tag);
        }

        public override BellagioDefaultControl GetSource(BellagioView obj) {
            return ((BellagioView)obj).BellagioControl;
        }

    }

}
