/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Forms/BellagioListView.cs#12 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * ɃLO\Ɏg߂ɒListView
 * Columns.Add͎gp֎~BAddColumngB
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.Diagnostics;

namespace Bellagio.Forms {


    /** wȕ`
     *    ^C}[ŃeLXg̍XVĂƂŁAIĂvfɃ}EXJ[\ĂƂɁASubItem[0]DrawFocusRectangleĂȂ悤ɌB
     *    Ǝɘg`ꍇłlBDrawBackground()Ă΂ȂΐB
     * 
     *    낢낢Azo[Ăvf̕`ł͕ςȂƂ
     *    OnDrawItemőSSubItem`悵AOnDrawSubItem͖AȂ܂Azo[Ăvf̘g`悪邱ƂBBoundsςȒlȂ̂H
     * 
     *    MSDNhLgOwnerDrawӂ̃TvMouseMoveŕςȃgbNgĂ̂AOnDrawItemłΕsv炵
     */

    //TESTINFO laboɒfЂB}[WĂقȂ
    public class BellagioListView : ListView {
        public interface IBellagioListViewClient {
            void DrawColumnHeader(Graphics g, Rectangle r, ColumnHeader header);
            void DrawItemBackground(Graphics g, Rectangle r, ListViewItem item);
            void DrawItemBody(Graphics g, Rectangle r, int[] lefts, ListViewItem item); //evfXWĂ
            void OnMouseMoveInListView(MouseEventArgs e);
            void OnMouseEnterToListView(EventArgs e);
            //bool ProcessListViewDialogKey(Keys keyData);
        }

        private int[] _lefts;
        private IBellagioListViewClient _client;
        private bool _selectItemWithMouseWheel; //zC[ŃACeI𓮂Ar[̂XN[邩

        public BellagioListView(IBellagioListViewClient client) {
            //Column̍̓tHgł͕ωȂBItem͕ωBACRł\΂̂ȂׂĂȂ
            Debug.Assert(client!=null); //nullɂ͂ł
            _client = client;
          
            base.View = View.Details;
            base.OwnerDraw = true;
            base.DoubleBuffered = true;
            base.FullRowSelect = true;
            base.MultiSelect = false;
            base.HoverSelection = false;

            _selectItemWithMouseWheel = false;
        }
        public bool SelectItemWithMouseWheel {
            get {
                return _selectItemWithMouseWheel;
            }
            set {
                _selectItemWithMouseWheel = value;
            }
        }

        private class ColumnTag {
            public int _minWidth;
            public int _maxWidth;
            public ColumnTag(int minWidth, int maxWidth) {
                _minWidth = minWidth;
                _maxWidth = maxWidth;
            }
        }

        //Column`
        public void AddColumn(string text, int width, int minWidth, int maxWidth) {
            ColumnHeader h = this.Columns.Add(text);
            h.Width = width;
            h.Tag = new ColumnTag(minWidth, maxWidth);
        }
        //vf`@`悷ׂf[^Item.TagɂBSubItem.TextύX̂CPUא
        public void AddItem(object itemTag) {
            ListViewItem item = new ListViewItem();
            item.Tag = itemTag;
            for(int i=0; i<this.Columns.Count-1; i++) item.SubItems.Add(""); //킹̂߂SubItem쐬
            this.Items.Add(item);
        }

        protected override void OnDrawItem(DrawListViewItemEventArgs e) {
            //x쐬
            if(_lefts==null || _lefts.Length!=this.Columns.Count+1) _lefts = new int[this.Columns.Count+1]; //񐔂P̂ɒ

            e.DrawBackground();
            e.DrawFocusRectangle();

            //͌vZ̕KvƂ݂̂ɂł
            int x = 0;
            _lefts[0] = x;
            for(int i=0; i<this.Columns.Count; i++) {
                ColumnHeader ch = this.Columns[i];
                x += ch.Width;
                _lefts[i+1] = x;
            }
            _client.DrawItemBody(e.Graphics, e.Bounds, _lefts, e.Item);

        }
        protected override void OnDrawColumnHeader(DrawListViewColumnHeaderEventArgs e) {
            //base.OnDrawColumnHeader(e);
            ColumnHeader ch = this.Columns[e.ColumnIndex];
            //ColumnTag t = ch.Tag as ColumnTag;
            //Debug.Assert(t!=null);
            e.DrawBackground();
            e.DrawText();
        }

        protected override void OnColumnWidthChanging(ColumnWidthChangingEventArgs e) {
            //base.OnColumnWidthChanging(e);
            ColumnHeader ch = this.Columns[e.ColumnIndex];
            ColumnTag t = ch.Tag as ColumnTag;
            if(t!=null) {
                //NewWidth͐ݒ\Ăɂ͉eȂ炵B<ȏ>ݒ肵悤ƂȂΏ҂ɐݒ肵ȂƁAWidthChanged̏ŌڂX[YłȂȂ
                if(e.NewWidth < t._minWidth) {
                    ch.Width = t._minWidth;
                    e.Cancel = true;
                }
                else if(e.NewWidth > t._maxWidth) {
                    ch.Width = t._maxWidth;
                    e.Cancel = true;
                }
            }
        }

        //ColumnWidthChangingŃLZĂChanged͔ĖĂ܂B{ɕdl
        protected override void OnColumnWidthChanged(ColumnWidthChangedEventArgs e) {
            base.OnColumnWidthChanged(e);
            ColumnHeader ch = this.Columns[e.ColumnIndex];
            ColumnTag t = ch.Tag as ColumnTag;
            if(t!=null) {
                if(ch.Width < t._minWidth)
                    ch.Width = t._minWidth;
                else if(ch.Width > t._maxWidth)
                    ch.Width = t._maxWidth;
            }
        }

        protected override void OnMouseMove(MouseEventArgs e) {
            base.OnMouseMove(e);
            //Debug.WriteLine("MouseMove y="+e.Y);
            _client.OnMouseMoveInListView(e);
        }
        protected override void OnMouseEnter(EventArgs e) {
            base.OnMouseEnter(e);
            _client.OnMouseEnterToListView(e);
        }
        //̓͑I𐧂ɂق悢Ȃ
        protected override void OnMouseWheel(MouseEventArgs e) {
            if(_selectItemWithMouseWheel) {
                ListView.SelectedIndexCollection indices = this.SelectedIndices;
                if(indices.Count > 0) {
                    int c = this.Items.Count;
                    int i = indices[0];
                    ListViewItem item;
                    if(e.Delta<0)
                        item = this.Items[i==c-1? c-1 : i+1];
                    else
                        item = this.Items[i==0? 0 : i-1];

                    item.Selected = true;
                    item.EnsureVisible();
                    ((HandledMouseEventArgs)e).Handled = true;
                }
            }
            else
                base.OnMouseWheel(e); //ftHgł悢
        }

       
        private static bool IsSelected(ListViewItemStates st) {
            return (st & ListViewItemStates.Selected)!=0;
        }
        private static bool IsFocused(ListViewItemStates st) {
            return (st & ListViewItemStates.Focused)!=0;
        }
        private static bool IsSelectedOrFocused(ListViewItemStates st) {
            return (st & (ListViewItemStates.Focused | ListViewItemStates.Selected ))!=0;
        }
        private static bool IsHovered(ListViewItemStates st) {
            return (st & ListViewItemStates.Hot)!=0;
        }
    }
}
