/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/ChartViewContentBase.cs#20 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * `[gƔ̃ZbVAstatic`[g̃ZbV̋Lp[g
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

using Poderosa;
using Poderosa.Forms;
using Poderosa.Preferences;
using Poderosa.Commands;
using Poderosa.Plugins;
using Poderosa.Sessions;
using Poderosa.UI;
using Sansa.Runtime;
using Travis.LocationOperation;
using Travis;
using Travis.Forms;

using Bellagio.Evaluators;
using Bellagio.Environment;
using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Drawing;
using Bellagio.Forms;

namespace Bellagio.Chart {
    public abstract class ChartViewContentBase : BellagioViewContent {
        private ChartSessionBase _sessionBase;
        protected ChartDrawing _chartDrawing;
        protected ChartDrawingSettings _chartDrawingSettings;
        protected CodeInputBox _codeInputBox;
        protected TravisScrollBar _scrollBar;
        protected IndicatorEditor _indicatorEditor;
        protected RectOp _rectangleOperator;

        //ChartSessionŗL̐ݒ ĂPƂ̃NXɂ邩
        protected FreeLineSet _freeLineSet;
        protected bool _enableIndicatorToolTip;

        private RuntimeIndicatorElement _focusedIndicatorElement; //ANeBuȂ {IndicatorInstanceɑΉɂȂƂȂȂ

        protected string _omittedItemInfoText; //ʂ߂ɕ\ȗꂽvfeLXgBׂĂ\łĂƂnull

        private VoidVoidDelegate _subscribeCompleteEvent;

        public ChartViewContentBase(ChartSessionBase sessionbase, ChartDocumentBase doc) {
            Debug.Assert(doc!=null); //ViewContent̍쐬DocumentKvȂƂ邽߂ɁAZbVƂɂւ炸ʌɈĂ
            _sessionBase = sessionbase;

            _chartDrawingSettings = BellagioRoot.FixedPreferences.Chart.ChartDrawingSettings;

            _chartDrawing = new ChartDrawing(_container, BellagioPlugin.Instance.SansaPlatform, _chartDrawingSettings);
            BellagioPlugin.Instance.SansaPlatform.AssureStart();

            _scrollBar = new TravisHScrollBar();
            _scrollBar.ScrollValueUIChanged += new EventHandler(OnScrollBarValueUIChanged);
            _codeInputBox = new CodeInputBox();
            _codeInputBox.BackColor = _chartDrawingSettings.backColor.col;
            _codeInputBox.Location = new Point(4, 4);
            _codeInputBox.Size = new Size(272, 24);
            _codeInputBox.Font = (Font)_chartDrawingSettings.stockBoxFont.F.Clone(); //CodeInputBox̔ĵƂɃtHgʂ悤
            _codeInputBox.CodeColor = _chartDrawingSettings.stockCodeColor.col;
            _codeInputBox.NameColor = _chartDrawingSettings.stockNameColor.col;
            CodeDropDownDataProvider dropdown = new CodeDropDownDataProvider();
            dropdown.ForDaily = doc is StaticChartDocument; //Ƃ炵
            _codeInputBox.DataProvider = dropdown;
            _codeInputBox.StockChanged += new EventHandler(OnStockChanged);
            
            _indicatorEditor = new IndicatorEditor(this);
            _freeLineSet = new FreeLineSet();
            _enableIndicatorToolTip = true;

        }
        public ChartSessionBase ChartSessionBase {
            get {
                return _sessionBase;
            }
        }
        public override IPoderosaDocument IPoderosaDocument {
            get {
                return _sessionBase.IPoderosaDocument;
            }
        }
        public ChartDrawingSettings ChartDrawingSettings {
            get {
                return _chartDrawingSettings;
            }
        }
        public ChartDrawing ChartDrawing {
            get {
                return _chartDrawing;
            }
        }
        public FreeLineSet FreeLineSet {
            get {
                return _freeLineSet;
            }
        }
        public bool EnableIndicatorToolTip {
            get {
                return _enableIndicatorToolTip;
            }
            set {
                _enableIndicatorToolTip = value;
            }
        }

        public VoidVoidDelegate SubscribeCompleteEvent {
            get {
                return _subscribeCompleteEvent;
            }
            set {
                _subscribeCompleteEvent = value;
            }
        }

        public override void Attach(BellagioDefaultControl parent) {
            //ł_chartGraphics̈ʒu͐ݒ肳ȂBhNXŕKݒ̂
            _container = parent;
            _chartDrawing.SetParent(_container);
            ManualResize();

            Debug.WriteLine("Attach " + _sessionBase.ChartDocument.DocumentStatus);
            if(_sessionBase.ChartDocument.DocumentStatus!=BellagioDocumentStatus.Loading)
                SubscribeCompleteOrError();
        }
        public override void Detach() {
            Debug.Assert(!_scrollBar.AsControl.IsDisposed);
            if(_indicatorEditor.Visible) _indicatorEditor.HideIndicatorToolTip();
            _container = null;
            _chartDrawing.SetParent(null);
            _chartDrawing.SetChartDataSource(null);
            _scrollBar.AsControl.Parent = null;
            _codeInputBox.Parent = null;
            Debug.Assert(!_scrollBar.AsControl.IsDisposed);
        }
        public override void Dispose() {
            base.Dispose();
            _scrollBar.Dispose();
            _codeInputBox.Dispose();
            _indicatorEditor.Dispose();
            if(_chartDrawing!=null) _chartDrawing.Dispose();
        }
        public virtual void ReloadPreference() {
            _codeInputBox.FontEx = (Font)_chartDrawingSettings.stockBoxFont.F.Clone();
            _codeInputBox.CodeColor = _chartDrawingSettings.stockCodeColor.col;
            _codeInputBox.NameColor = _chartDrawingSettings.stockNameColor.col;
            _codeInputBox.CommitStyle();
            _chartDrawing.ChartLocalSettings.volumeAreaHeight = ParseUtil.ParseInt(_sessionBase.GetSourceSchema().VolumeHeightInfo.Value, _chartDrawingSettings.volumeAreaHeight.V);
        }
        public void ReplaceDocument(ChartDocumentBase doc) {
            _chartDrawing.SetChartDataSource(doc);
        }
        public override void AdjustActiveDocumentStatus(bool active) {
            _codeInputBox.BackColor = active? Color.FromArgb(0, 0x30, 0x60) : Color.Black; //
        }

        public virtual void PrepareStockChange() {
            //_contentStatus = ViewContentStatus.Suspend;
            Debug.WriteLine("PrepareStockChange");
            _chartDrawing.SetChartDataSource(null);
        }
        public virtual IPoderosaMenuGroup[] CreateContextMenuContent() {
            return null;
        }
        public virtual void GetOmittedScreenItemList(ref List<string> list) { //Xy[X̓sŕ\ȗĂ鍀ڂԂ O̂Ƒ̂ŃRNVrefn
            _chartDrawing.GetOmittedScreenItemList(ref list);
        }

        //TODO ̃\bhړIĂ炵
        public virtual void DocumentEvent() {
            if(_chartDrawing.ChartDataSource==null && _sessionBase.ChartDocument.DocumentStatus!=BellagioDocumentStatus.Loading) {
                SubscribeCompleteOrError();
            }
        }
        public void ResetCodeInputBox(Stock stock) {
            if(!_codeInputBox.IsDisposed)
                _codeInputBox.SetTextExternal(stock==null? "" : CodeDropDownDataProvider.DefaultFormat(stock.Profile));
        }


        public override void NotifySplitMarkStateChanged() { //̃r[Ȃ̂ŉȂ
        }
        public override Rectangle SplitMarkDisplayRect {
            get {
                Debug.Assert(_container!=null);
                Rectangle r = _container.ClientRectangle;
                r.Height -= _scrollBar.AsControl.Height;
                return r;
            }
        }
        public override void OnResize() {
            base.OnResize();
            ManualResize();
        }
        public override void OnGotFocus() {
            base.OnGotFocus();
            /*
            if(_codeInputBox.Visible) {
                _codeInputBox.Focus();
            }
            */
        }

        public override void ManualResize() {
            //OnResizenhȊOɂ蓮ŃTCYƂ͂
            if(_container!=null && _chartDrawing.ChartDataSource!=null) {
                _rectangleOperator.Rect(_container.ClientRectangle);
                //\ȗ̃eLXg̐ ̓hLgCompletełȂĂv
                List<string> omitted_items = null;
                GetOmittedScreenItemList(ref omitted_items);
                if(omitted_items!=null)
                    _omittedItemInfoText = String.Format("TCY\傫Ȃ{0}̕\ȗĂ܂", StringUtil.ConcatString(omitted_items, ", "));
                else
                    _omittedItemInfoText = null;
                
                if(_sessionBase.ChartDocument.DocumentStatus==BellagioDocumentStatus.Complete) {
                    _scrollBar.SetRange(_chartDrawing.GetMaxCandleCount(), _sessionBase.ChartDocument.SectionInfo.GetDisplayLength());
                    if(!_chartDrawing.DisplayPosition.IsEmpty)
                        _scrollBar.SetScrollPositionByRight(_chartDrawing.DisplayPosition.ToDisplayIndex());
                    _chartDrawing.DisplayPosition = _sessionBase.ChartDocument.SectionInfo.GetChartPosition(_scrollBar.ScrollEndPosition);
                    _chartDrawing.DataUpdateDirect();
                }
                else if(_container!=null)
                    _container.Invalidate();
                    
            }
        }
        public override void OnBeforeSansaTick() {
            base.OnBeforeSansaTick();
            if(_container!=null && !_container.IsDisposed) {
                if(_sessionBase.ChartDocument.DocumentStatus==BellagioDocumentStatus.Loading) {
                    _invalidateMark(); //[ĥƂ̓[fBO}[N񂷂߂invalidateKv
                }
            }
        }

        public void AdjustToLatest() {
            if(_sessionBase.ChartDocument.DocumentStatus!=BellagioDocumentStatus.Complete) return;
            if(_chartDrawing.MainLocation.IsEmpty)
                _scrollBar.SetRange(1, 0);
            else
                _scrollBar.SetValueToMaximum();
        }
        private void OnScrollBarValueUIChanged(object sender, EventArgs args) {
            int new_latest_index = _scrollBar.ScrollEndPosition;
            _chartDrawing.DisplayPosition = _sessionBase.ChartDocument.SectionInfo.GetChartPosition(new_latest_index);
            if(_container!=null) _chartDrawing.DataUpdateDirect();
        }

        protected virtual void OnStockChanged(object sender, EventArgs args) {
            AbstractStockProfile stock = BellagioRoot.GlobalStockCollection.FindExact(_codeInputBox.CurrentItem.Code);
            Debug.Assert(stock!=null); //łƋ^
            _sessionBase.SetCurrentStock(stock.Primary);
        }

        public override void OnMouseDown(MouseEventArgs args) {
            if(_sessionBase.ChartDocument.DocumentStatus!=BellagioDocumentStatus.Complete) return;

            if(args.Button==MouseButtons.Left) {
                if(_chartDrawing.MainLocation.IsEmpty) return;

                if(!_chartDrawing.FigureDrawingPosition.IsDragging) {
                    Rectangle figure_rect = _chartDrawing.FigureAreaRect;
                    if(figure_rect.Contains(args.Location)) {
                        _chartDrawing.FigureDrawingPosition.StartDrag(_container.PointToScreen(args.Location));
                        _container.Cursor = Cursors.Hand;
                        _container.Invalidate();
                        return;
                    }
                }
                
                if(_chartDrawing.MainLocation.Contains(args.Location) && _sessionBase.ChartDocument.DocumentStatus==BellagioDocumentStatus.Complete) {
                    _freeLineSet.StartDrawingNewLine(_sessionBase.ChartDocument, _chartDrawing, args.Location);
                }
            }
        }
        public override void OnMouseUp(MouseEventArgs args) {

            if(args.Button==MouseButtons.Left) {
                if(_sessionBase.ChartDocument.DocumentStatus!=BellagioDocumentStatus.Complete) return;
                if(_chartDrawing.MainLocation.IsEmpty) return;

                if(_chartDrawing.FigureDrawingPosition.IsDragging) {
                    _chartDrawing.FigureDrawingPosition.EndDrag(_chartDrawing.MainLocation, _container.PointToScreen(args.Location), _chartDrawing.FigureAreaRect.Size);
                    _container.Cursor = Cursors.Default;
                    _container.Invalidate();
                }
                
                if(_freeLineSet.IsDrawingNewLine) {
                    _freeLineSet.EndDrawingNewLine(_sessionBase.ChartDocument, _chartDrawing, args.Location);
                    FreeLineSerializeUtil.SetValue(_sessionBase.CurrentStock, _sessionBase.GetSourceSchema().ChartUnit, _freeLineSet.ToString());
                    _container.Invalidate();
                }
                
                if(_freeLineSet.FocusedLine!=null) {
                    _freeLineSet.RemoveFocusedLine();
                    FreeLineSerializeUtil.SetValue(_sessionBase.CurrentStock, _sessionBase.GetSourceSchema().ChartUnit, _freeLineSet.ToString());
                    _container.Invalidate();
                }
            }

            if(args.Button==MouseButtons.Right) {
                IPoderosaMenuGroup[] cm = CreateContextMenuContent();
                if(cm!=null && _container!=null) {
                    IPoderosaForm f = _container.FindForm() as IPoderosaForm;
                    f.ShowContextMenu(cm, this, _container.PointToScreen(args.Location), ContextMenuFlags.None);
                }
            }

        }

        //}EX̓̃`FbN
        public override void OnMouseMove(MouseEventArgs args) {
            base.OnMouseMove(args);
            if(_sessionBase.ChartDocument.DocumentStatus!=BellagioDocumentStatus.Complete) return;
            if(_chartDrawing.MainLocation.IsEmpty) return;

            bool exit_flag = false;
            //1. li{[h̃hbO
            if(_chartDrawing.FigureDrawingPosition.IsDragging) {
                Rectangle r = _chartDrawing.FigureAreaRect;
                //smARectc܂̈invalidateBŌɃyCgʒuoĂΊSɂł
                _container.Invalidate(DrawingUtil.InflateRect(r, 30));
                exit_flag = true;
            }
            //2. R`
            else if(_freeLineSet.IsDrawingNewLine) {
                _freeLineSet.OnMouseMoveNewLine(_sessionBase.ChartDocument, _chartDrawing, args.Location);
                _container.Invalidate();
                exit_flag = true;
            }
            //3. li{[hhbOJn}[N ̂Ƃ̗͂̂̂͂Ȃ
            else {
                Rectangle figure_rect = _chartDrawing.FigureAreaRect;
                if(figure_rect.Contains(args.Location)) {
                    _container.Cursor = Cursors.Hand;
                    exit_flag = true;
                }
                else {
                    _container.Cursor = Cursors.Default;
                }
            }

            //4. CWP[^ҏWJn`FbN
            if(!exit_flag && !_indicatorEditor.IsEditing) {
                RuntimeIndicatorElement fe = _enableIndicatorToolTip? _chartDrawing.FindRuntimeIndicatorFormMousePosition(args.X, args.Y) : null;
                _indicatorEditor.OnMouseMove(fe, args);

                if(_focusedIndicatorElement!=fe) { //ωƂ̂ݓ삪Kv
                    //܂NA
                    if(_focusedIndicatorElement!=null) {
                        _focusedIndicatorElement.Focused = false;
                        _focusedIndicatorElement = null;
                    }

                    //ݒ
                    if(fe!=null) {
                        fe.Focused = true;
                        _focusedIndicatorElement = fe;
                    }

                    _container.Cursor = fe!=null? Cursors.Hand : Cursors.Default;
                    _container.Invalidate();
                    exit_flag = true;
                }
            }

            //5. R̃tH[JX
            if(!exit_flag && !_freeLineSet.IsDrawingNewLine) {
                bool inv = _freeLineSet.OnMouseMoveFocuedLine(_sessionBase.ChartDocument, _chartDrawing, args.Location);
                if(inv) _container.Invalidate();
                _container.Cursor = _freeLineSet.FocusedLine!=null? Cursors.Hand : Cursors.Default;
            }

            //exit_flagɊ֌WȂs
            _chartDrawing.OnMouseMoveForTrackingLine(args.X, args.Y); 
        }

        public override void OnMouseLeave() {
            base.OnMouseLeave();
            if(_sessionBase.ChartDocument.DocumentStatus!=BellagioDocumentStatus.Complete) return;

            if(_focusedIndicatorElement!=null) {
                _focusedIndicatorElement.Focused = false;
                _focusedIndicatorElement = null;
                _container.Cursor = Cursors.Default;
                _container.Invalidate();
            }

            //ENbNăReLXgj[oAc[`bvo肵ĂMouseLeaveĂ܂B
            //Ȃ̂Ŗ{ɗ̈悩oƂɎs𐧌
            if(!_container.ClientRectangle.Contains(_container.PointToClient(Control.MousePosition))) {
                if(_indicatorEditor.Visible)
                    _indicatorEditor.HideIndicatorToolTip();

                _chartDrawing.OnMouseMoveForTrackingLine(-1, -1); //ŃNÂ͂
            }
        }


        public override void OnDoubleClick() {
            base.OnDoubleClick();
            //BR}hF[JLbV𖳎ă[h
            if(Control.ModifierKeys==(Keys.Control|Keys.Shift)) {
                _sessionBase.ReloadData();
            }
            else if(_codeInputBox.Visible) {
                _codeInputBox.Focus();
            }
        }

        protected void SubscribeCompleteOrError() {
            BellagioDocumentStatus st = _sessionBase.ChartDocument.DocumentStatus;
            
            Debug.Assert(st==BellagioDocumentStatus.Complete || st==BellagioDocumentStatus.Empty);
            Debug.WriteLine("SubcribeCompleteOrError " + st);

            if(_container!=null) {
                _container.Controls.Add(_scrollBar.AsControl);
                _container.Controls.Add(_codeInputBox);
            }

            if(st==BellagioDocumentStatus.Complete) {
                _chartDrawing.SetChartDataSource(_sessionBase.ChartDocument);
                ManualResize();

                _scrollBar.SetRange(_chartDrawing.GetMaxCandleCount(), _sessionBase.ChartDocument.SectionInfo.GetDisplayLength());
                _scrollBar.SetValueToMaximum();
                string str = CodeDropDownDataProvider.DefaultFormat(_sessionBase.CurrentStock.Profile);
                _codeInputBox.SetTextExternal(str);
                _codeInputBox.LastCorrectText = str;
                if(_container!=null) _chartDrawing.DataUpdateDirect();
                _freeLineSet.Clear();
                FreeLineSerializeUtil.Init();
                string free_line = FreeLineSerializeUtil.GetValue(_sessionBase.CurrentStock, _sessionBase.GetSourceSchema().ChartUnit);
                if(free_line.Length > 0) {
                    try {
                        _freeLineSet.FillByString(free_line);
                    }
                    catch(Exception ex) {
                        RuntimeUtil.ReportException(ex);
                    }
                }
                //Oւ̒ʒm
                if(_subscribeCompleteEvent!=null) _subscribeCompleteEvent();
                _subscribeCompleteEvent = null;
            }
            else {
                _codeInputBox.SetTextExternal(""); //͋
                _codeInputBox.LastCorrectText = "";
            }
            if(_container!=null) _container.Invalidate();
        }

        public override void OnKeyDown(KeyEventArgs args) {
            base.OnKeyDown(args);
            if(_sessionBase.ChartDocument.DocumentStatus!=BellagioDocumentStatus.Complete) return;
            
            //ɃtH[JXĂR[h͂\ɂ
            Keys k = args.KeyCode;
            if(Keys.D1 <= k && k <= Keys.D9) GotoCodeBox(k - Keys.D1 + 1);
            if(Keys.NumPad1 <= k && k <= Keys.NumPad9) GotoCodeBox(k - Keys.NumPad1 + 1);

            //ŒIL[ݒ
            if(k==Keys.Left) ScrollChart(false, false);
            else if(k==Keys.Right) ScrollChart(false, true);
            else if(k==Keys.PageUp) ScrollChart(true, false);
            else if(k==Keys.PageDown) ScrollChart(true, true);
            else if(k==Keys.Home && !_scrollBar.ScrollAllVisible) _scrollBar.SetScrollPositionWithEvent(0);
            else if(k==Keys.End && !_scrollBar.ScrollAllVisible) _scrollBar.SetValueToMaximumWithEvent();
            else if((k==Keys.F2 || k==Keys.Escape) && _codeInputBox.EnabledEx) _codeInputBox.Focus();
            else if(k==Keys.Up || k==Keys.Down) {
                if(BellagioRoot.FixedPreferences.Chart.UpDownKeyAction==UpDownKeyAction.SwitchTab)
                    SwitchTab(k==Keys.Down);
                else
                    SwitchStock(k==Keys.Down);
            }
        }
        private void GotoCodeBox(int firstletter) {
            _codeInputBox.SetTextExternal(new string((char)('0'+firstletter), 1));
            _codeInputBox.SetFocusWithoutSelection();
        }
        public override void OnMouseWheel(MouseEventArgs args) {
            if(BellagioRoot.FixedPreferences.Chart.MouseWheelOnChart==MouseWheelAction.SwitchStock) {
                SwitchStock(args.Delta<0);
            }
            else
                ScrollChart(false, args.Delta>0);

            base.OnMouseWheel(args);
        }
        private void ScrollChart(bool large, bool incr) {
            if(_container!=null && !_scrollBar.ScrollAllVisible) {
                int delta = large? _chartDrawing.GetMaxCandleCount() : 3;
                if(!incr) delta = -delta;
                int v = _scrollBar.ScrollPosition + delta;
                if(v < 0) v = 0;
                else if(v > _scrollBar.ScrollMaximum) v = _scrollBar.ScrollMaximum;
                _scrollBar.SetScrollPositionWithEvent(v);
            }
        }
        private void SwitchStock(bool incr) {
            if(_sessionBase.ChartDocument.DocumentStatus==BellagioDocumentStatus.Complete) {
                AbstractStockProfile newprof = incr? BellagioRoot.GlobalStockCollection.GetNextStock(_sessionBase.CurrentStock.Profile) : BellagioRoot.GlobalStockCollection.GetPrevStock(_sessionBase.CurrentStock.Profile);
                if(newprof!=null)
                    _sessionBase.SetCurrentStock(newprof.Primary);
            }
        }
        private void SwitchTab(bool incr) {
            if(_sessionBase.ChartDocument.DocumentStatus==BellagioDocumentStatus.Complete) {
                IPoderosaMainWindow window = _container.FindForm() as IPoderosaMainWindow;
                Debug.Assert(window!=null);
                IDocumentTabFeature tf = window.DocumentTabFeature;
                int index = tf.IndexOf(_sessionBase.IPoderosaDocument);
                Debug.Assert(index!=-1);
                if(incr)
                    index = (index==tf.DocumentCount-1)? 0 : index+1;
                else
                    index = (index==0)? tf.DocumentCount-1 : index-1;

                BellagioPlugin.Instance.SessionManager.ActivateDocument(tf.GetAtOrNull(index), ActivateReason.InternalAction);
            }
        }


        protected void PaintFreeLines(Graphics g, Rectangle clip) {
            _freeLineSet.Draw(g, clip, _sessionBase.ChartDocument, _chartDrawing);
        }

        //w肵t/悤ɃXN[B
        //10{E\Nʒu{ƂB
        public void SetScrollPositionByDateTime(int date_or_time) {
            if(_scrollBar.ScrollAllVisible) return;

            CHARTPOSITION pos;
            if(_sessionBase.ChartDocument.GetChartPositionAt(date_or_time, out pos)) {
                //10{Ƃē
                for(int i=0; i<10; i++) {
                    if(!_sessionBase.ChartDocument.SectionInfo.MovePrev(ref pos)) break;
                }
                int value = pos.IsEmpty? 0 : pos.ToDisplayIndex();
                value = Math.Min(value, _scrollBar.ScrollMaximum);
                _scrollBar.SetScrollPosition(value);
                this.OnScrollBarValueUIChanged(_scrollBar, null);
            }
        }

        //̂ƂAу[ĥƂnh
        protected bool PaintIncompleteCases(PaintEventArgs args) {
            if(_container==null) return true;

            BellagioDocumentStatus st = _sessionBase.ChartDocument.DocumentStatus;

            switch(st) {
                case BellagioDocumentStatus.Complete:
                    return _chartDrawing.ChartDataSource==null; //CompleteɂȂ͔̂񓯊ł邩AChartDataSourceZbg܂ł̓C`~
                case BellagioDocumentStatus.Loading: {
                    int s = _waitingMark.Radius * 2;
                    if(args.ClipRectangle.IntersectsWith(DrawingUtil.CenterPointToRect(DrawingUtil.RectCenterPoint(_container.ClientRectangle), s, s))) {
                        Graphics g = args.Graphics;
                        using(HighQualityDrawingSupport dr = new HighQualityDrawingSupport(g)) {
                            _waitingMark.Draw(g, DrawingUtil.RectCenterPoint(_container.ClientRectangle), BellagioPlugin.Instance.SansaPlatform.getRootTimer().getTick());
                        }
                    }
                    return true;
                }
                default:
                    DrawStringUtil.MiddleCenter(args.Graphics, _sessionBase.ChartDocument.DocumentStatusMessage, _container.Font, SystemBrushes.Window, _container.ClientSize.Width/2, _container.ClientSize.Height/2);
                    return true; 
            }
        }

        //R}hx[Xł̖w
        public class SetStockCommand : PoderosaCommandImpl {
            private ChartViewContentBase _view;
            public SetStockCommand(ChartViewContentBase view) {
                _view = view;
            }
            public override CommandResult InternalExecute(ICommandTarget target, params IAdaptable[] args) {
                AbstractStockProfile prof = (AbstractStockProfile)args[0].GetAdapter(typeof(AbstractStockProfile));
                _view._sessionBase.SetCurrentStock(prof.Primary);
                return CommandResult.Succeeded;
            }
        }
    }


}
