/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Environment/CommandCollection.cs#18 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * {̃R}h
 */
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;

using Poderosa;
using Poderosa.Sessions;
using Poderosa.Commands;
using Poderosa.Forms;

using Bellagio.Alert;
using Bellagio.Data;
using Bellagio.Forms;
using Bellagio.Chart;
using Bellagio.Ordering;
using Bellagio.Values;

namespace Bellagio.Environment {

    //ɂ͌ŒIɓR}h^BXL[}Ɏ^Cv̂͊܂܂ȂƂɒ
    public class BellagioCommandCollection {
        private ICommandManager _commandManager;

        //TODO IPoderosaCommand̂GeneralCommandɈڍŝׂ܂܂Ă
        private IPoderosaCommand _reloadPreferenceCommand;
        private IPoderosaCommand _invalidateAllCommand;
        private IGeneralCommand _loginCommand;
        private IGeneralCommand _reloadExtensions;

        private IPoderosaCommand _aboutBox;
        private IPoderosaCommand _openTacticoPage;
        private IPoderosaCommand _openHelpPage;
        private IPoderosaCommand _openRiyoKiyaku;
#if DEBUG
        private IPoderosaCommand _recreateDailyDataCacheFile;
        private IPoderosaCommand _emulateDisconnect;
        private IPoderosaCommand _emulateTickDynamicReset;
        private IPoderosaCommand _emulateTrade;
        private IPoderosaCommand _emulateUnknownOrder;
        private IPoderosaCommand _emulateCancel;
        private IPoderosaCommand _emulateInterruptingSnapshot;
        private IPoderosaCommand _emulateToggleOnDemandServer;
        private IPoderosaCommand _emulateToggleOrderServer;
        private IPoderosaCommand _emulateReportException;
        private IPoderosaCommand _emulateItaReSubscribe;
#endif
        public BellagioCommandCollection(ICommandManager cm) {
            _commandManager = cm;
        }

        public void Register() {
            _reloadPreferenceCommand = new ReloadPreferenceCommand();
            _invalidateAllCommand = new InvalidateAllCommand();

            ICommandCategory cc = _commandManager.CommandCategories.File;
            _loginCommand = new GeneralCommandImpl("tactico.login", "OC", cc, new ExecuteDelegate(LoginCommandImpl), new CanExecuteDelegate(CanLogin));
            _commandManager.Register(_loginCommand);
            _reloadExtensions = new GeneralCommandImpl("tactico.reloadExtensions", "gLbg̃[h", cc, new ExecuteDelegate(ReloadExtensions), null);
            _commandManager.Register(_reloadExtensions);

            _aboutBox = new PoderosaCommandImpl(new ExecuteDelegate(AboutBoxImpl));
            _openTacticoPage = new PoderosaCommandImpl(new ExecuteDelegate(OpenTacticoPageImpl));
            _openHelpPage = new PoderosaCommandImpl(new ExecuteDelegate(OpenHelpPageImpl));
            _openRiyoKiyaku = new PoderosaCommandImpl(new ExecuteDelegate(OpenRiyoKiyakuImpl));

#if DEBUG
            _recreateDailyDataCacheFile = new PoderosaCommandImpl(new ExecuteDelegate(RecreateDailyDataCacheFileImpl));
            _emulateDisconnect = new PoderosaCommandImpl(new ExecuteDelegate(EmulateDisconnectImpl));
            _emulateTickDynamicReset = new PoderosaCommandImpl(new ExecuteDelegate(EmulateTickDynamicResetImpl));
            _emulateTrade = new PoderosaCommandImpl(new ExecuteDelegate(EmulateTradeImpl));
            _emulateUnknownOrder = new PoderosaCommandImpl(new ExecuteDelegate(EmulateUnknownOrderImpl));
            _emulateCancel = new PoderosaCommandImpl(new ExecuteDelegate(EmulateCancelImpl));
            _emulateInterruptingSnapshot = new PoderosaCommandImpl(new ExecuteDelegate(EmulateInterruptingSnapshotImpl));
            _emulateToggleOnDemandServer = new PoderosaCommandImpl(new ExecuteDelegate(EmulateToggleOnDemandServerImpl));
            _emulateToggleOrderServer = new PoderosaCommandImpl(new ExecuteDelegate(EmulateToggleOrderServerImpl));
            _emulateReportException = new PoderosaCommandImpl(new ExecuteDelegate(EmulateReportExceptionImpl));
            _emulateItaReSubscribe = new PoderosaCommandImpl(new ExecuteDelegate(EmulateItaResubscribeImpl));
#endif   
        }

        public IPoderosaCommand ReloadPreference {
            get {
                return _reloadPreferenceCommand;
            }
        }
        public IPoderosaCommand InvlaidateAllCommand {
            get {
                return _invalidateAllCommand;
            }
        }
        public IGeneralCommand LoginCommand {
            get {
                return _loginCommand;
            }
        }
        public IGeneralCommand ReloadExtensionsCommand {
            get {
                return _reloadExtensions;
            }
        }
        public IPoderosaCommand AboutBox {
            get {
                return _aboutBox;
            }
        }
        public IPoderosaCommand OpenTacticoPage {
            get {
                return _openTacticoPage;
            }
        }
        public IPoderosaCommand OpenHelpPage {
            get {
                return _openHelpPage;
            }
        }
        public IPoderosaCommand OpenRiyoKiyaku {
            get {
                return _openRiyoKiyaku;
            }
        }
#if DEBUG
        public IPoderosaCommand RecreateDailyDataCacheFile {
            get {
                return _recreateDailyDataCacheFile;
            }
        }

        public IPoderosaCommand EmulateDisconnect {
            get {
                return _emulateDisconnect;
            }
        }
        public IPoderosaCommand EmulateTickDynamicReset {
            get {
                return _emulateTickDynamicReset;
            }
        }
        public IPoderosaCommand EmulateTrade {
            get {
                return _emulateTrade;
            }
        }
        public IPoderosaCommand EmulateUnknownOrder {
            get {
                return _emulateUnknownOrder;
            }
        }
        public IPoderosaCommand EmulateCancel {
            get {
                return _emulateCancel;
            }
        }
        public IPoderosaCommand EmulateInterruptingSnapshot {
            get {
                return _emulateInterruptingSnapshot;
            }
        }
        public IPoderosaCommand EmulateToggleOnDemandServer {
            get {
                return _emulateToggleOnDemandServer;
            }
        }
        public IPoderosaCommand EmulateToggleOrderServer {
            get {
                return _emulateToggleOrderServer;
            }
        }
        public IPoderosaCommand EmulateReportException {
            get {
                return _emulateReportException;
            }
        }
        public IPoderosaCommand EmulateItaReSubscribe {
            get {
                return _emulateItaReSubscribe;
            }
        }
#endif

        private class ReloadPreferenceCommand : PoderosaCommandImpl {
            public override CommandResult InternalExecute(ICommandTarget target, params IAdaptable[] args) {
                ISessionManager sm = BellagioPlugin.Instance.SessionManager;
                IAdaptable arg = args[0];
                foreach(ISession sess in sm.AllSessions) {
                    BellagioSessionBase bs = sess as BellagioSessionBase; 
                    if(bs!=null) bs.ReloadPreference(arg); //BellagiõZbVȊO͖
                }
                return CommandResult.Succeeded;
            }
        }
        private class InvalidateAllCommand : PoderosaCommandImpl {
            public override CommandResult InternalExecute(ICommandTarget target, params IAdaptable[] args) {
                foreach(IPoderosaMainWindow w in BellagioPlugin.Instance.WindowManager.MainWindows)
                    w.AsForm().Invalidate(true);
                return CommandResult.Succeeded;
            }
        }
        private CommandResult LoginCommandImpl(IAdaptable target) {
            DataSourceStatus st = BellagioRoot.DataSourceHost.CurrentStatus;
            if(st==DataSourceStatus.Connected) return CommandResult.Ignored;
            return BellagioRoot.DataSourceHost.LoginOrResume();

        }

        //gLbg[h
        private CommandResult ReloadExtensions(ICommandTarget target) {
            //XN[jOE؂͂悢A`[gʓ|Ȏ菇𓥂ނƂɂȂ
            //܂AExtensionKitDynamicPreferenceɈˑĂ̂łv
            try {
                IPoderosaForm form = (IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm));

                //܂VSchemaRootɃ[h݁ÂA[hPreference؂藣B
                BellagioLoadingLog log = new BellagioLoadingLog(BellagioPlugin.Instance.PoderosaWorld);

                ExtensionFileLoader loader = new ExtensionFileLoader();
                SchemaRoot newroot = loader.Reload(log);

                //NG[Ε\
                if(log.HasError) {
                    ReportLoadingLog(log, form);
                    return CommandResult.Failed;
                }

                //̂A[h
                foreach(ExtensionKit k in BellagioRoot.SchemaRoot.EnumExtensionKits())
                    k.Unload();

                Debug.Assert(BellagioRoot.ExtensionKitPreference.GetRootNode().IsEmpty);

                //V̂ɂ...
                BellagioRoot.ReplaceSchemaRoot(newroot);

                //[hBłz͖
                List<ExtensionKit> errors = new List<ExtensionKit>();
                foreach(ExtensionKit k in newroot.EnumExtensionKits()) {
                    try {
                        k.Load();
                    }
                    catch(Exception ex) {
                        Debug.WriteLine(ex.Message);
                        errors.Add(k);
                        log.Add(ex.Message);
                    }
                }

                foreach(ExtensionKit k in errors)
                    newroot.RemoveExtensionKitDirect(k);

                if(log.HasError) {
                    ReportLoadingLog(log, form); //LoadłƂ́Aǂݍ߂gLbĝŃ^[͂Ȃ
                }

                //p[^̒lǂݒw
                BellagioRoot.ExtensionKitPreference.LoadFrom(BellagioRoot.ExtensionKitPreference.UnderlyingData);

                //`[gɂĂ͓ǂݒ
                List<ChartSessionBase> to_be_closed_sessions = new List<ChartSessionBase>();
                foreach(ISession sess in BellagioPlugin.Instance.SessionManager.AllSessions) {
                    ChartSessionBase chart = sess as ChartSessionBase;
                    if(chart!=null) {
                        chart.ReloadSchema(chart.GetSourceSchema().FullID, chart.CurrentStock);
                        if(chart.CurrentStock==null) to_be_closed_sessions.Add(chart); 
                    }
                }
                foreach(ChartSessionBase sess in to_be_closed_sessions)
                    BellagioPlugin.Instance.SessionManager.CloseDocument(sess.IPoderosaDocument);

                return CommandResult.Succeeded;
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
                return CommandResult.Failed;
            }

        }
        private void ReportLoadingLog(BellagioLoadingLog log, IPoderosaForm f) {
            SimpleLogViewer v = new SimpleLogViewer();
            v.Text = String.Format("{0} - ǂݍ݃G[", BellagioVersionInfo.APPLICATION_CAPTION);
            v.SetMultiLineText(log.GetMessagesAsStringArray());
            v.ShowDialog(f.AsForm());
            v.Dispose();
        }

        private bool CanLogin(IAdaptable target) {
            return BellagioRoot.DataSourceHost.CurrentStatus!=DataSourceStatus.Connected;
        }
        private bool CanOffline(IAdaptable target) {
            return BellagioRoot.DataSourceHost.CurrentStatus!=DataSourceStatus.Offline;
        }

        private CommandResult AboutBoxImpl(IAdaptable target) {
            IBellagioEditionSpecificInfo[] editions = (IBellagioEditionSpecificInfo[])BellagioPlugin.Instance.PoderosaWorld.PluginManager.FindExtensionPoint(BellagioConstants.EDITION_SPECIFIC_INFO_EXTENSION).GetExtensions();
            if(editions.Length==0)
                return CommandResult.Failed;
            else {
                editions[0].ShowAboutBox(BellagioPlugin.Instance.ActivePoderosaWindow.AsForm());
                return CommandResult.Succeeded;
            }
        }
        private CommandResult OpenTacticoPageImpl(IAdaptable target) {
            return OpenWebPage("http://www.lagarto.co.jp/tactico/");
        }
        private CommandResult OpenHelpPageImpl(IAdaptable target) {
            return OpenWebPage("https://www.click-sec.com/corp/guide/kabu/hatchukun/tx.html");
        }
        private CommandResult OpenRiyoKiyakuImpl(IAdaptable target) {
            //https://www.click-sec.com/corp/guide/regulations/index.html
            return OpenWebPage("https://www.click-sec.com/corp/guide/regulations/reg_hatchukun_txbeta.html");
        }
        private CommandResult OpenWebPage(string url) {
            try {
                Process p = Process.Start(url);
                return p==null? CommandResult.Failed : CommandResult.Succeeded;
            }
            catch(Exception ex) {
                BUtil.ShowWarningMessageBox(ex.Message);
                return CommandResult.Failed;
            }
        }
#if DEBUG
        private CommandResult RecreateDailyDataCacheFileImpl(IAdaptable target) {
            //RecentDailyDataCache c = new RecentDailyDataCache();
            //c.RecreateCacheFile();
            return CommandResult.Succeeded;
        }
        private CommandResult EmulateDisconnectImpl(IAdaptable target) {
            DataSourceStatus st = BellagioRoot.DataSourceHost.CurrentStatus;
            if(st!=DataSourceStatus.Connected) {
                BUtil.ShowWarningMessageBox("ڑĂ܂");
                return CommandResult.Ignored;
            }

            Debug.WriteLineIf(BRuntimeOpts.TRACE_DEBUG_COMMAND, "Dynamic Reset");
            BellagioRoot.DataSourceHost.DisconnectStream();
            return CommandResult.Succeeded;
        }
        private CommandResult EmulateToggleOnDemandServerImpl(IAdaptable target) {
            IDataSourceEnvironment e = BellagioRoot.DataSourceHost.ExternalEnvironment;
            e.EmulateOnDemandServerError = !e.EmulateOnDemandServerError;
            return CommandResult.Succeeded;
        }
        private CommandResult EmulateToggleOrderServerImpl(IAdaptable target) {
            IDataSourceEnvironment e = BellagioRoot.DataSourceHost.ExternalEnvironment;
            e.EmulateOrderServerError = !e.EmulateOrderServerError;
            return CommandResult.Succeeded;
        }
        private CommandResult EmulateItaResubscribeImpl(IAdaptable target) {
            IDataSourceEnvironment e = BellagioRoot.DataSourceHost.ExternalEnvironment;
            ISessionManager sm = BellagioPlugin.Instance.SessionManager;
            foreach(ISession sess in sm.AllSessions) {
                RealTimeChartSession rs = sess as RealTimeChartSession;
                if(rs!=null) {
                    Stock stock = rs.CurrentStock;
                    e.ItaResubscribe(stock);
                }
            }
            return CommandResult.Succeeded;
        }
        private CommandResult EmulateTickDynamicResetImpl(IAdaptable target) {
            ThreadPool.QueueUserWorkItem(delegate(object st) {
                try {
                    ISessionManager sm = BellagioPlugin.Instance.SessionManager;
                    foreach(ISession sess in sm.AllSessions) {
                        RealTimeChartSession rs = sess as RealTimeChartSession;
                        if(rs!=null) {
                            Stock stock = rs.CurrentStock;
                            if(stock.Profile is DerivativeStockProfile) {
                                ITickDataHost h = BellagioRoot.IntraDayTradeProvider;
                                IntraDayTrade dt = BellagioRoot.IntraDayTradeProvider.Lookup(stock);
                                int price = dt.CurrentPriceInfo.CurrentPrice.Value;
                                Debug.WriteLineIf(BRuntimeOpts.TRACE_DEBUG_COMMAND, "Dynamic Reset");
                                h.DynamicReset(stock);
                                //̂ATick̃V~[gł낢Ă
                                //Thread.Sleep(200); //DataThread𑖂点邽߂Ƒҋ@
                                //h.OnTickData(stock, MarketUtil.GetEveningOpenTime(StockExchange.O).AsInt(), price, 1, price);
                                //dt.UpdateByTime(new BTime(MarketUtil.GetGobaCloseTime(StockExchange.O).AsInt()-60));
                                //h.OnTickData(stock, MarketUtil.GetGobaCloseTime(StockExchange.O).AsInt(), price, 1000, price);
                                return;
                            }
                        }
                    }
                }
                catch(Exception ex) {
                    RuntimeUtil.ReportException(ex);
                }
            });
            return CommandResult.Succeeded;
        }
        private CommandResult EmulateTradeImpl(IAdaptable target) {
            TradeOrderList ol = BellagioRoot.OrderDataProvider.StockOrder.Value;
            if(ol==null || ol.Count==0) return CommandResult.Ignored;

            TradeOrderItem item = ol[0];

            System.Windows.Forms.Timer timer = new System.Windows.Forms.Timer();
            timer.Interval = 3000;
            timer.Tick += delegate(object sender, EventArgs args) {
                BellagioRoot.DataSourceHost.NotifyTrade(item.UniqueString, OrderStatusCodeCategory.Stock, false, BTime.FromDateTime(DateTime.Now).AsInt(), item.Sashine, item.Stock.VolumeUnit*5);
                timer.Stop();
            };
            timer.Start();
            return CommandResult.Succeeded;
        }
        private CommandResult EmulateUnknownOrderImpl(IAdaptable target) {
            BellagioRoot.DataSourceHost.UpdateOrderStatus("unknowncode", OrderStatusCodeCategory.Stock, OrderStatusEvent.Expired);
            return CommandResult.Succeeded;
        }
        private CommandResult EmulateCancelImpl(IAdaptable target) {
            TradeOrderList ol = BellagioRoot.OrderDataProvider.StockOrder.Value;
            if(ol==null || ol.Count==0) return CommandResult.Ignored;

            TradeOrderItem item = ol[0];
            BellagioRoot.DataSourceHost.UpdateOrderStatus(item.UniqueString, OrderStatusCodeCategory.Stock, OrderStatusEvent.Cancelled);
            return CommandResult.Succeeded;
        }
        private CommandResult EmulateInterruptingSnapshotImpl(IAdaptable target) {
            ISessionManager sm = BellagioPlugin.Instance.SessionManager;
            foreach(ISession sess in sm.AllSessions) {
                RealTimeChartSession rs = sess as RealTimeChartSession;
                if(rs!=null) {
                    Stock stock = rs.CurrentStock;
                    IntraDayTrade dt = BellagioRoot.IntraDayTradeProvider.Lookup(stock);
                    BellagioRoot.DataSourceHost.ExternalEnvironment.EmulateInterruptingSnapshot(stock, dt.TimeAndSales.Count+3, dt.Minutely.LastCandle.Time, dt.TimeAndSales.LastPrice, 1);
                }
            }
            return CommandResult.Ignored;
        }
        private CommandResult EmulateReportExceptionImpl(IAdaptable target) {
            try {
                throw new NullReferenceException("AAA");
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
            return CommandResult.Succeeded;
        }
#endif
        //PoderosaR}hł͂Ȃ̂
        public void DoLayoutAllViews() {
            ISessionManager sm = BellagioPlugin.Instance.SessionManager;
            foreach(ISession session in sm.AllSessions) {
                BellagioSessionBase bs = session as BellagioSessionBase;
                if(bs!=null) {
                    BellagioViewContent bc = bs.BellagioViewContent;
                    if(bc.ContainerControl!=null) {
                        bc.DoLayout();
                        bc.ManualResize();
                    }
                }
            }
        }

    }

    //ZbVJ
    public abstract class BellagioSessionOpenCommand : IGeneralCommand {
        protected string _schemaID; //R}hxł͑ΏۃXL[}͖OłĂȂ
        protected Keys _defaultShortcutKey;
        private BellagioSessionBase _resultSession;

        public BellagioSessionOpenCommand(string item_name, Keys shortcut) {
            _defaultShortcutKey = shortcut;
            _schemaID = item_name;
            BellagioPlugin.Instance.CommandManager.Register(this);
        }
        public BellagioSessionBase ResultSession {
            get {
                return _resultSession;
            }
        }

        public CommandResult InternalExecute(ICommandTarget target, params IAdaptable[] args) {
            ISessionManager sm = BellagioPlugin.Instance.SessionManager;;
            IPoderosaMainWindow window = (IPoderosaMainWindow)target.GetAdapter(typeof(IPoderosaMainWindow));
            if(window==null) {
                BellagioViewContent content = AsViewContent(target);
                if(content==null || content.ContainerControl==null) return CommandResult.Ignored;
                window = content.ContainerControl.FindForm() as IPoderosaMainWindow;
                if(window==null) return CommandResult.Ignored; //ꂵLXg
            }

            try {
                BellagioSessionBase rs = CreateSession(target);
                _resultSession = rs;
                sm.StartNewSession(rs, window.ViewManager.GetCandidateViewForNewDocument());
                sm.ActivateDocument(rs.IPoderosaDocument, ActivateReason.InternalAction);
                return CommandResult.Succeeded;
            }
            catch(BellagioException ex) {
                BUtil.ShowWarningMessageBox(ex.Message);
                return CommandResult.Failed;
            }
        }
        public string CommandID {
            get {
                return "tactico.opensession."+_schemaID;
            }
        }
        public string Description {
            get {
                return null;
            }
        }
        public Keys DefaultShortcutKey {
            get {
                return _defaultShortcutKey;
            }
        }
        public ICommandCategory CommandCategory {
            get {
                return null;
            }
        }

        public virtual bool CanExecute(ICommandTarget target) {
            return true;
        }

        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
        private static BellagioViewContent AsViewContent(ICommandTarget target) {
            return target==null? null : (BellagioViewContent)target.GetAdapter(typeof(BellagioViewContent));
        }
        /*
            IGeneralCommand cmd = new GeneralCommandImpl("bellagio.openitachart", "ƃ`[gJ܂", cm.CommandCategories.Dialogs, new ExecuteDelegate(StartChartItaSession));
            cm.Register(cmd);
            viewMenu.RegisterExtension(new PoderosaMenuGroupImpl(new PoderosaMenuItemImpl(cmd, "ʖ(&Q)")));
         */

        protected abstract BellagioSessionBase CreateSession(IAdaptable target);
    }

    //eXgp̂Ԃ
#if DEBUG
    public class TestAndDebugMenuGroup : PoderosaMenuGroupImpl {
        public TestAndDebugMenuGroup()
            : base(CreateItems(), true) {
        }

        private static IPoderosaMenu[] CreateItems() {
            List<IPoderosaMenu> items = new List<IPoderosaMenu>();
            BellagioCommandCollection cc = BellagioPlugin.Instance.Commands;
            items.Add(new PoderosaMenuItemImpl(cc.EmulateDisconnect, "Test:zMؒf"));
            items.Add(new PoderosaMenuItemImpl(cc.EmulateToggleOnDemandServer, "Test:If}h؂ւ"));
            items.Add(new PoderosaMenuItemImpl(cc.EmulateToggleOrderServer, "Test:؂ւ"));
            items.Add(new PoderosaMenuItemImpl(cc.EmulateTickDynamicReset, "Test:0TICK+16:30f[^(敨̂)"));
            items.Add(new PoderosaMenuItemImpl(cc.EmulateTrade, "Test:ʒm"));
            items.Add(new PoderosaMenuItemImpl(cc.EmulateUnknownOrder, "Test:sȒԍXV"));
            items.Add(new PoderosaMenuItemImpl(cc.EmulateCancel, "Test:ʒm"));
            items.Add(new PoderosaMenuItemImpl(cc.EmulateInterruptingSnapshot, "Test:荞SNAPSHOT"));
            items.Add(new PoderosaMenuItemImpl(cc.EmulateReportException, "Test:ReportException"));
            items.Add(new PoderosaMenuItemImpl(cc.EmulateItaReSubscribe, "Test:ItaSubscribe"));
            items.Add(new PoderosaMenuItemImpl(cc.RecreateDailyDataCacheFile, "Test:f[^LbVč쐬"));
            return items.ToArray();
        }
    }
#endif


    public class BellagioMenuFolder : IPoderosaMenuFolder {
        private string _text;
        private IPoderosaMenuGroup[] _childGroups;
        private CanExecuteDelegate _enabledDelegate;
        private CanExecuteDelegate _checkedDelegate;

        public BellagioMenuFolder(string text, IPoderosaMenuGroup[] childGroups) {
            _text = text;
            _childGroups = childGroups;
        }
        public BellagioMenuFolder SetEnabled(CanExecuteDelegate d) {
            _enabledDelegate = d;
            return this;
        }
        public BellagioMenuFolder SetChecked(CanExecuteDelegate d) {
            _checkedDelegate = d;
            return this;
        }

        public IPoderosaMenuGroup[] ChildGroups {
            get {
                return _childGroups;
            }
        }

        public string Text {
            get {
                return _text;
            }
        }

        public bool IsEnabled(ICommandTarget target) {
            return _enabledDelegate==null? true : _enabledDelegate(target);
        }

        public bool IsChecked(ICommandTarget target) {
            return _checkedDelegate==null? false : _checkedDelegate(target);
        }

        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
    }



    public class BellagioMenuItemImpl : PoderosaMenuItemImpl {
        public BellagioMenuItemImpl(IPoderosaCommand cmd, string text, CheckedDelegate checkedd) : base(cmd, text) {
            _checked = checkedd;
        }
        public BellagioMenuItemImpl(IPoderosaCommand cmd, string text)
            : base(cmd, text) {
            _checked = null;
        }
    }

    public class BellagioCommandCategory : ICommandCategory {
        private string _name;

        public BellagioCommandCategory(string name) {
            _name = name;
        }

        public string Name {
            get { return _name; }
        }
        public bool IsKeybindCustomizable {
            get {
                return true;
            }
        }
        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
    }


    public class BellagioCommandUtil {
        public static IPoderosaForm AsPoderosaForm(ICommandTarget target) {
            IPoderosaForm f = (IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm));
            if(f!=null) return f;

            BellagioViewContent v = (BellagioViewContent)target.GetAdapter(typeof(BellagioViewContent));
            if(v.ContainerControl!=null)
                return v.ContainerControl.FindForm() as IPoderosaForm;
            else
                return null;
        }
    }
}
