/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Environment/SchemaRoot.cs#10 $
 * $DateTime: 2008/02/22 14:41:38 $
 * 
 * XL[}Ƃ́A.NET̃NXŒ`郌xƃGh[UJX^}CY郌x̒ԑw̃r[`B
 * OmegaChartłƂ̊gLbg̊TOB
 * lp[XAesȂƂɃG[bZ[Wo͎ۂɃZbVƂɍŝ ORText ̏ԂŒ`eێ
 * 
 * XL[}̓[ĥŁARuntimeIndicatorȂǁA琶IuWFNgQ̓XL[}IuWFNg𒼐ڎQƂẮuȂȂvB
 * 
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;

using Travis.ORT;

using Bellagio.Chart;
using Bellagio.FigureBoard;
using Bellagio.Alert;
using Bellagio.Screening;

#if UNITTEST
using NUnit.Framework;
using Bellagio.Script;
using Bellagio.Values;
using Bellagio.Evaluators;
#endif

namespace Bellagio.Environment {



    //BellagioRootQƂ郋[gvf SLbg̃RNV
    public class SchemaRoot {

        private ORTypeInfoCollection _schemaCollection;
        private ORTypeInfo _extenstionKitType;
        private List<ExtensionKit> _extensionKits;

        public SchemaRoot() {
            ORTypeInfoCollection lib = new ORTypeInfoCollection();
            _extensionKits = new List<ExtensionKit>();

            //^ ^Cuɓo^鏇Ԃɒ
            lib.Add(typeof(ExtensionParameter));
            //lib.Add(typeof(RankingSchemaColumn));
            //lib.Add(typeof(RankingSchema));
            //lib.Add(typeof(ScatterSchema));
            lib.Add(typeof(IndicatorDefinition.Element));
            lib.Add(typeof(IndicatorDefinition));
            lib.Add(typeof(IndicatorSchema));
            lib.Add(typeof(OscillatorGroupSchema));
            lib.Add(typeof(ChartSchema));
            lib.Add(typeof(FigureBoardItemSchema));
            lib.Add(typeof(FigureBoardSchema));
            lib.Add(typeof(AlertConditionSchema));
            lib.Add(typeof(ScreeningSchemaColumn));
            lib.Add(typeof(ScreeningSchema));
            lib.Add(typeof(SignalSelectorSchema));
            lib.Add(typeof(AutoTradingCondition));
            lib.Add(typeof(AutoTradingAdditionalColumn));
            lib.Add(typeof(AutoTradingSchema));
            lib.Add(typeof(PilotAutoTrading.FeedParameter));
            lib.Add(typeof(PilotAutoTrading));
            _extenstionKitType = new ORTypeInfo(lib, typeof(ExtensionKit));
            lib.Add(_extenstionKitType);

            _schemaCollection = lib;
        }
        private SchemaRoot(ORTypeInfoCollection coll, ORTypeInfo extkittype) {
            _extenstionKitType = extkittype;
            _schemaCollection = coll;
            _extensionKits = new List<ExtensionKit>();
        }

        public ORTypeInfo ExtensionKitSchema {
            get {
                return _extenstionKitType;
            }
        }
        public void AddFixedExtensionKit(ExtensionKit kit) {
            _extensionKits.Add(kit);
        }
        public void RemoveExtensionKitDirect(ExtensionKit kit) {
            _extensionKits.Remove(kit);
        }
        public void Unload() {
            foreach(ExtensionKit k in _extensionKits) k.Unload();
            _extensionKits.Clear();
        }

        public ExtensionKit FindExtensionKit(string name) {
            foreach(ExtensionKit k in _extensionKits)
                if(k.id.Value==name) return k;
            return null;
        }
        public IEnumerable EnumExtensionKits() {
            return _extensionKits;
        }
        //^n͎܂
        public SchemaRoot CreateNewRoot() {
            return new SchemaRoot(_schemaCollection, _extenstionKitType);
        }

        private delegate ExtensionKitItem SchemaFinder(ExtensionKit context, string name);

        private ExtensionKitItem FindItem(ExtensionKit context, string name, SchemaFinder finder) {
            ExtensionKitItem t = null;
            if(context!=null) t = finder(context, name);
            if(t!=null) return t;

            int p = name.IndexOf('.');
            if(p==-1) return null;
            string kitname = name.Substring(0, p);
            name = name.Substring(p+1);

            ExtensionKit kit = FindExtensionKit(kitname);
            if(kit==null) return null;

            return finder(kit, name);
        }

        //SchemaRootɑ΂錟ExtensionKitIvViȃReLXgɂł
        //̂Ƃ܂܂Ƃ߂ȂH
        public ChartSchema FindRealTimeChartSchema(ExtensionKit context, string name) {
            return (ChartSchema)FindItem(context, name, delegate(ExtensionKit k, string n) { return k.FindRealTimeChart(n); });
        }
        public ChartSchema FindStaticChartSchema(ExtensionKit context, string name) {
            return (ChartSchema)FindItem(context, name, delegate(ExtensionKit k, string n) { return k.FindStaticChart(n); });
        }
        /*
        public RankingSchema FindRankingSchema(ExtensionKit context, string name) {
            return (RankingSchema)FindItem(context, name, delegate(ExtensionKit k, string n) { return k.FindRanking(n); });
        }
        public ScatterSchema FindScatterSchema(ExtensionKit context, string name) {
            return (ScatterSchema)FindItem(context, name, delegate(ExtensionKit k, string n) { return k.FindScatter(n); });
        }
        */
        public FigureBoardSchema FindFigureBoardSchema(ExtensionKit context, string name) {
            return (FigureBoardSchema)FindItem(context, name, delegate(ExtensionKit k, string n) { return k.FindFigureBoard(n); });
        }
        public IndicatorDefinition FindChartIndicatorDefinition(ExtensionKit context, string name) {
            return (IndicatorDefinition)FindItem(context, name, delegate(ExtensionKit k, string n) { return k.FindIndicatorDef(n); });
        }
        public ChartSchema FindRealTimeChartSchema(string name) {
            return FindRealTimeChartSchema(null, name);
        }
        public ChartSchema FindStaticChartSchema(string name) {
            return FindStaticChartSchema(null, name);
        }
        /*
        public RankingSchema FindRankingSchema(string name) {
            return FindRankingSchema(null, name);
        }
        public ScatterSchema FindScatterSchema(string name) {
            return FindScatterSchema(null, name);
        }
        */
        public FigureBoardSchema FindFigureBoardSchema(string name) {
            return FindFigureBoardSchema(null, name);
        }
        public IndicatorDefinition FindChartIndicatorDefinition(string name) {
            return FindChartIndicatorDefinition(null, name);
        }
        public AutoTradingSchema FindAutoTradingSchema(ExtensionKit context, string name) {
            return (AutoTradingSchema)FindItem(context, name, delegate(ExtensionKit k, string n) { return k.FindAutoTrading(n); });
        }

        //RNVn
        public IList CollectStaticChartSchema(IList c) {
            CollectItem(c, delegate(ExtensionKit k, IList lc) { k.CollectStaticChart(lc); });
            return c;
        }
        public IList CollectRealTimeChartSchema(IList c) {
            CollectItem(c, delegate(ExtensionKit k, IList lc) { k.CollectRealTimeChart(lc); });
            return c;
        }
        /*
        public IList CollectScatterSchema(IList c) {
            CollectItem(c, delegate(ExtensionKit k, IList lc) { k.CollectScatter(lc); });
            return c;
        }
        public IList CollectRankingSchema(IList c) {
            CollectItem(c, delegate(ExtensionKit k, IList lc) { k.CollectRanking(lc); });
            return c;
        }
        */
        public IList CollectFigureBoardSchema(IList c) {
            CollectItem(c, delegate(ExtensionKit k, IList lc) { k.CollectFigureBoard(lc); });
            return c;
        }
        public IList CollectAlertSchema(IList c) {
            CollectItem(c, delegate(ExtensionKit k, IList lc) { k.CollectAlert(lc); });
            return c;
        }
        public IList CollectScreeningSchema(IList c) {
            CollectItem(c, delegate(ExtensionKit k, IList lc) { k.CollectScreening(lc); });
            return c;
        }
        public IList CollectAutoTradingSchema(IList c) {
            CollectItem(c, delegate(ExtensionKit k, IList lc) { k.CollectAutoTrading(lc); });
            return c;
        }
        private delegate void CollectorDelegate(ExtensionKit k, IList c);
        private void CollectItem(IList c, CollectorDelegate d) {
            foreach(ExtensionKit k in _extensionKits) d(k, c);
        }
    }
#if UNITTEST
    [TestFixture]
    public class SchemaLoadTests {
        [TestFixtureSetUp]
        public void Setup() {
            BellagioEnvironmentParam p = new BellagioEnvironmentParam();
            p.SetupForUnitTest();
            BellagioRoot.Init(p);
        }
        private void LoadConfig(string text) {
            StringReader r = new StringReader(text);
            BellagioRoot.LoadExtensionFileFromStream("Test", r, true);
            r.Close();
        }
        private void LoadConfig2(string text1, string text2) { //Q{ǂ
            StringReader r = new StringReader(text1);
            BellagioRoot.LoadExtensionFileFromStream("Test1", r, true);
            r.Close();
            r = new StringReader(text2);
            BellagioRoot.LoadExtensionFileFromStream("Test2", r, false);
            r.Close();
        }
#if false
        //TODO ̓[gvfĂȂ
        [Test]
        public void Empty() {
            LoadConfig("<x id=\"a\"><scatter></scatter><ranking></ranking></x>");
            ExtensionKit kit = BellagioRoot.SchemaRoot.FindExtensionKit("a");
            Assert.AreEqual(1, kit.scatter.Count);
            Assert.AreEqual(1, kit.ranking.Count);

            Assert.AreEqual(12, kit.scatter[0]._location.Column);
            Assert.AreEqual(31, kit.ranking[0]._location.Column);
        }
        [Test]
        public void TwoFiles() {
            LoadConfig2("<x id=\"a\"><scatter></scatter><ranking></ranking></x>", "<x id=\"b\"><scatter></scatter><ranking></ranking></x>");
            ExtensionKit ka = BellagioRoot.SchemaRoot.FindExtensionKit("a");
            ExtensionKit kb = BellagioRoot.SchemaRoot.FindExtensionKit("b");

            Assert.AreEqual("Test1", ka.scatter[0]._location.FileName);
            Assert.AreEqual("Test2", kb.scatter[0]._location.FileName);
            Assert.AreEqual("Test1", ka.ranking[0]._location.FileName);
            Assert.AreEqual("Test2", kb.ranking[0]._location.FileName);
            Assert.AreEqual(12, kb.scatter[0]._location.Column);
            Assert.AreEqual(31, kb.ranking[0]._location.Column);
        }
        [Test]
        public void Findings() {
            LoadConfig("<x id='a'><scatter id='s'></scatter><ranking id='r'></ranking><staticChart id='c' chartsession='daily'></staticChart><parameter id='p'></parameter></x>");
            ExtensionKit k = BellagioRoot.SchemaRoot.FindExtensionKit("a");

            ScatterSchema s = k.FindScatter("s");
            RankingSchema r = k.FindRanking("r");
            ChartSchema c = k.FindStaticChart("c");

            Assert.IsNotNull(s);
            Assert.IsNotNull(r);
            Assert.IsNotNull(c);

            ScatterSchema s1 = BellagioRoot.SchemaRoot.FindScatterSchema(k, "s");
            RankingSchema r1 = BellagioRoot.SchemaRoot.FindRankingSchema(k, "r");
            ChartSchema c1 = BellagioRoot.SchemaRoot.FindStaticChartSchema(k, "c");

            Assert.AreSame(s, s1);
            Assert.AreSame(r, r1);
            Assert.AreSame(c, c1);

            s1 = BellagioRoot.SchemaRoot.FindScatterSchema("a.s");
            r1 = BellagioRoot.SchemaRoot.FindRankingSchema("a.r");
            c1 = BellagioRoot.SchemaRoot.FindStaticChartSchema("a.c");

            Assert.AreSame(s, s1);
            Assert.AreSame(r, r1);
            Assert.AreSame(c, c1);
        }
#endif
        [Test]
        public void UserFunction() {
            LoadConfig("<x id='a'><functionDefinitions>int f(int a, int b) { a*2+b } double pi() { 3.14 } </functionDefinitions></x>");

            //A[hƍsꂽƂmFB֐f͏FindingɂBقƂ͂̂mFʂ̃eXgɂׂ蔲
            //̊mFSchemaLoadTests܂Ƃ߂čsꍇ݈̂ӖBUserFunctionP̂ł͖Ӗ
            Assert.AreEqual(1, BellagioRoot.Functions.User.GetOverloads("f").Count);


            ExtensionKit k = BellagioRoot.SchemaRoot.FindExtensionKit("a");
            Expression e = Expression.ParseExpression("f(2,3)");
            EvaluatorBuildContext bc = new EvaluatorBuildContext(null);
            Evaluator v = new EvaluatorBuilder(bc).Build(e);
            BInt result = (BInt)v.Eval(CreateEvalContext(bc));

            Assert.AreEqual(7, result.Value);

            e = Expression.ParseExpression("pi()");

            bc = new EvaluatorBuildContext(null);
            v = new EvaluatorBuilder(bc).Build(e);
            BDouble result2 = (BDouble)v.Eval(CreateEvalContext(bc));

            Assert.AreEqual(3.14, result2.Value);
        }
        private EvalContext CreateEvalContext(EvaluatorBuildContext bc) {
            EvalContext c = new EvalContext();
            c.InitializeStack(new BStackFrame(bc, new BV[0]));
            return c;
        }


        [Test]
        public void Unload() {
            //ăRpCɃG[̋N֐`Ă
            Exception err = null;
            try {
                LoadConfig("<x id='a'><scatter id='s'></scatter><functionDefinitions>int f(</functionDefinitions>></x>");
            }
            catch(Exception ex) {
                err = ex;
            }
            Assert.IsNotNull(err); //G[ƂmF
            ExtensionKit ka = BellagioRoot.SchemaRoot.FindExtensionKit("a");
            Assert.IsNull(ka);
            /*
            ScatterSchema s1 = BellagioRoot.SchemaRoot.FindScatterSchema("a.s");
            Assert.IsNull(s1);
            Assert.IsNull(BellagioRoot.Functions.User.ResolveUnique("f", null));
            */
        }

    }
#endif
}
