/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/FigureBoard/ScriptScratchPad.cs#9 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;

using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Evaluators;
using Bellagio.Forms;
using Bellagio.Environment;

using Poderosa;
using Poderosa.Forms;

namespace Bellagio.FigureBoard {
    //XNvg̗KpBFigureBoard̒Ԃł
    public class ScriptScratchPad : Form {
        private enum ModeT {
            Realtime, //f[^p\ȃ[h
            Static    //݂̂̃[h
        }

        private TextBox _scriptBox;
        private Button _evalButton;
        private TextBox _valueLabel;
        private bool _waitingSubscribeResult;
        private RTSubscriber _realTimeSubscriber;
        private ModeT _mode;

        //A_evalButtonƕ]ɂA
        //R[h̃XgωƃTuXNCûȂɂȂ̂ŎԂ
        private List<Stock> _subscribingStocks; //ʏ
        private List<Stock> _subscribingIndices; //w

        public ScriptScratchPad(Form owner) {
            _mode = BellagioVersionInfo.EDITION==BellagioEditions.HatchukunTX? ModeT.Realtime : ModeT.Static;

            _scriptBox = new TextBox();
            _scriptBox.Multiline = true;
            _scriptBox.AcceptsReturn = true;
            _scriptBox.Text = _mode==ModeT.Realtime? "index(\"NK225\").price()" : "let((q = refbrand(\"NK225\"))\n q.close())" ; //Tv
            _scriptBox.Font = new Font("lr SVbN", 10F, FontStyle.Regular);

            _evalButton = new Button();
            _evalButton.Click += new EventHandler(OnEval);
            _evalButton.Text = "](F5)";
            this.AcceptButton = _evalButton;

            _valueLabel = new TextBox();
            _valueLabel.BorderStyle = BorderStyle.FixedSingle;
            _valueLabel.TextAlign = HorizontalAlignment.Left;
            _valueLabel.ReadOnly = true;

            int width = 300;
            int height = 150;
            _scriptBox.Location = new Point(2, 2);
            _scriptBox.Size = new Size(width-4, height-4-_evalButton.Height);
            _evalButton.Location = new Point(2, _scriptBox.Bottom+2);
            _valueLabel.Location = new Point(_evalButton.Right+2, _evalButton.Top);
            _valueLabel.Size = new Size(width-_evalButton.Width-6, _evalButton.Height);

            this.Text = "XNvg̃eXg";
            this.ClientSize = new Size(300, 150);
            FormUtil.AdjustStyleForModelessFixedDialog(this, owner);
            this.Controls.AddRange(new Control[] { _evalButton, _valueLabel, _scriptBox });

            _subscribingStocks = new List<Stock>();
            _subscribingIndices = new List<Stock>();

            //refbrandg悤ɂĂ
            if(Screening.ScreeningPlugin.Instance!=null) Screening.ScreeningExecutorBase.RegisterFunctions();
        }
        protected override void OnFormClosing(FormClosingEventArgs e) {
            base.OnFormClosing(e);
            e.Cancel = true;
            InternalHide();
        }
        private void InternalHide() {
            this.Hide();
            IPoderosaMainWindow w = BellagioPlugin.Instance.ActivePoderosaWindow;
            if(w!=null) w.AsForm().Activate();
        }

        protected override void OnClosed(EventArgs e) {
            base.OnClosed(e);
            Unsubscribe();
        }
        protected override bool ProcessDialogKey(Keys keyData) {
            if(keyData==Keys.F5) {
                OnEval(null, null);
                return true;
            }
            else
                return base.ProcessDialogKey(keyData);

        }

        private void OnEval(object sender, EventArgs args) {
            try {
                if(_waitingSubscribeResult) return;

                _valueLabel.Text = "";

                StandAloneEvaluator ev = CreateEvaluator();
                if(ev==null) return;

                List<Stock> stocks = new List<Stock>();
                //List<Stock> indices = new List<Stock>();

                if(_mode==ModeT.Realtime) {
                    CollectSubscribeRequiredStocks(stocks, ev);
                    //TuXNCusvATuXNCuωĂȂΑ]ĕ\
                    if(stocks.Count==0 || StockListEquals(stocks, _subscribingStocks)) {
                        if(_realTimeSubscriber!=null) _realTimeSubscriber.SetEvaluator(ev);
                        EvalAndDisplay(ev);
                    }
                    else {
                        if(!BellagioRoot.DataSourceHost.IsConnected)
                            throw new BellagioException("f[^XNvg̎sł̓OCĂKv܂B");
                        Unsubscribe();
                        _subscribingStocks = stocks;
                        //_subscribingIndices = indices;
                        _valueLabel.Text = "f[^擾...";
                        StartSubscribe(ev);
                    }
                }
                else {
                    CollectSubscribeRequiredStocks(stocks, ev);
                    if(stocks.Count > 0) {
                        throw new BellagioException("A^Cf[^̎擾͖ɂȂĂ܂B");
                    }
                    EvalAndDisplay(ev);
                }
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.StackTrace);
                BUtil.ShowWarningMessageBox(ex.Message);
            }
        }

        private StandAloneEvaluator CreateEvaluator() {
            try {
                EvaluatorBuildContext bc = new EvaluatorBuildContext(null);
                return EvaluatorBuilderFromText.BuildStandAlone(_scriptBox.Text, null, null, LocalVariable.EmptyArray, BV.EmptyArray);
            }
            catch(Exception ex) {
                BUtil.ShowWarningMessageBox("XNvgG[łB\n" + ex.Message);
                return null;
            }
        }

        private void CollectSubscribeRequiredStocks(List<Stock> stocks, StandAloneEvaluator ev) {
            EvalContext ec = new EvalContext();
            EvalSpecial_CodeCollector codes = new EvalSpecial_CodeCollector();
            ec.EvalSpecial_CodeCollector = codes;
            //ꃂ[hŕ]Jn
            ev.Eval(ec);

            foreach(string code in codes.ResultStocks) {
                AbstractStockProfile stock = BellagioRoot.GlobalStockCollection.FindExact(code);
                if(stock==null || (!(stock is BasicStockProfile) && !(stock is DerivativeStockProfile)))
                    throw new BellagioException(String.Format("R[h {0} ͊/敨̃R[hł͂܂", code)); //TODO ꂪ`Ăʒu񂪕IɂłƂ悢

                stocks.Add(stock.Primary);
            }
            foreach(string code in codes.ResultIndex) {
                MarketIndex stock = BellagioRoot.GlobalStockCollection.FindExact(code) as MarketIndex;
                if(stock==null)
                    throw new BellagioException(String.Format("R[h {0} ͎w̃R[hł͂܂", code));

                stocks.Add(stock.Primary);
            }
        }

        private void StartSubscribe(StandAloneEvaluator ev) {
            _waitingSubscribeResult = true;
            if(_subscribingStocks.Count > 0) {
                _realTimeSubscriber = new RTSubscriber(this, ev, _subscribingStocks);
                BellagioRoot.DataSubscriberManager.AddRealtimeSubscriber(_realTimeSubscriber, new SubscribeRequest(_subscribingStocks.ToArray(), SubscribeDataKind.Ticks));

            }
        }
        private void Unsubscribe() {
            if(_subscribingStocks.Count > 0)
                BellagioRoot.DataSubscriberManager.RemoveSubscriber(_realTimeSubscriber);
        }
        private void SubscribeFail(string msg) {
            BUtil.ShowWarningMessageBox(msg);
            _waitingSubscribeResult = false;
            _subscribingStocks.Clear();
        }

        private void EvalAndDisplay(StandAloneEvaluator ev) {
            try {
                _waitingSubscribeResult = false;

                EvalContext c = new EvalContext();
                c.CurrentDate = new BDate(MarketUtil.PrevMarketOpenDate(BDate.DateTimeToInt(DateTime.Now)));
                BV val = ev.Eval(c);
                BVFormatter f = new DefaultBVFormatter();
                val.Format(f);
                _valueLabel.Text = f.Result;
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }

        private class RTSubscriber :IRealTimeDataSubscriber  {
            private ScriptScratchPad _parent;
            private Stock[] _stocks;
            private StandAloneEvaluator _evaluator;
            private DataThreadToMainThread _notifier;

            public RTSubscriber(ScriptScratchPad parent, StandAloneEvaluator evaluator, List<Stock> stocks) {
                _parent = parent;
                _evaluator = evaluator;
                _stocks = stocks.ToArray();
                _notifier = delegate() {
                    _parent.EvalAndDisplay(_evaluator);
                };
            }

            public int ThinningTime {
                get { return 0; }
            }

            public void RealTimeProcess(DataProcessArg arg) {

            }
            public void SetEvaluator(StandAloneEvaluator ev) {
                _evaluator = ev;
            }

            public SubscribeDataKind RequestedDataKind {
                get { return SubscribeDataKind.Ticks; }
            }

            public void FillTargetStocks(out Stock[] stocks) {
                stocks = (Stock[])_stocks.Clone();
            }

            public void SubscribeComplete() {
            //    _parent.SubscribeComplete();
            }

            public void SubscribeFailed(string reason) {
                _parent.SubscribeFail(reason);
            }

            public DataThreadToMainThread NotifyDelegate {
                get { return _notifier; }
            }
        }

        private static bool StockListEquals(List<Stock> c1, List<Stock> c2) {
            if(c1.Count!=c2.Count) return false;

            //܂ňvĂȂƂ߂Ƃ
            for(int i=0; i<c1.Count; i++) {
                if(c1[i]!=c2[i]) return false;
            }

            return true;
        }
    }

}
