/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/OrderConfirmDrawing.cs#6 $
 * $DateTime: 2008/02/22 14:12:23 $
 * 
 * mF̕`
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Text;
using System.Diagnostics;

using Bellagio.Values;
using Bellagio.Drawing;
using Travis;
using Travis.LocationOperation;

namespace Bellagio.Ordering {
    public class OrderConfirmDrawingSettings : DrawingSettingsBase {
        public DSInt rowHeight; //Ps̍
        public DSInt headerWidth; //ږ̕
        public DSInt bodyWidth; //l̕
        public DSFont labelFont; //ڃtHg
        public DSFont numberFont; //ltHg
        public DSInt numberFontYOffset; //ltHg̒p
        public DSPenStyle framePen; //g̐F
        public DSPenStyle delimiterPen; //؂
        public DSBrush labelColor; //W̃xF
        public DSBrush buyColor; //t̐F
        public DSBrush sellColor; //t̐F
        public DSBrush numberColor; //lF

        public int totalWidth {
            get {
                return headerWidth.V + bodyWidth.V;
            }
        }

        public OrderConfirmDrawingSettings(string id):base(id) {
        }

        protected override void  CreateElements() {
            rowHeight = DefinePositiveInt("rowHeight", 24);
            headerWidth = DefinePositiveInt("headerWidth", 96);
            bodyWidth = DefinePositiveInt("bodyWidth", 248);

            labelFont = DefineFont("labelFont", DSFont.GenericFontName, 10.5F);
            numberFont = DefineFont("numberFont", DSFont.GenericFontName, 11F);
            numberFontYOffset = DefineInt("numberFontYOffset", -1);

            framePen = DefinePenStyle("framePen", Color.DarkOliveGreen, BPenStyle.DashStyle.Dot, 1);
            delimiterPen = DefinePenStyle("delimiterPen", Color.DarkOliveGreen, BPenStyle.DashStyle.Dot, 1);
            labelColor = DefineBrush("labelColor", Color.White);
            buyColor = DefineBrush("buyColor", Color.Red);
            sellColor = DefineBrush("sellColor", Color.LightBlue);
            numberColor = DefineBrush("numberColor", Color.LightCyan);
        }


    }

    public class OrderConfirmDrawing {
        private OrderConfirmDrawingSettings _settings;
        private TradeOrderItem _order;
        private IOrderItemFormatter _formatter;
        private string _torihikiSuffix;

        public OrderConfirmDrawing(TradeOrderItem order) {
            _order = order;
            _settings = BellagioRoot.FixedPreferences.Ordering.OrderConfirmDrawingSettings;
            _formatter = BellagioRoot.OrderDataProvider.OrderItemFormatter;
        }
        public int TotalHeight {
            get {
                return _settings.rowHeight.V * 8;
            }
        }
        public string TorihikiSuffix {
            get {
                return _torihikiSuffix;
            }
            set {
                _torihikiSuffix = value;
            }
        }

        public void Draw(Graphics g) {

            int x = 2;
            int y = 2;
            int middle;


            //wb_E{fB̋`
            Rectangle rh = new Rectangle(x, y, _settings.headerWidth.V, _settings.rowHeight.V);
            Rectangle rb = new Rectangle(x+_settings.headerWidth.V+5, y, _settings.bodyWidth.V-5, _settings.rowHeight.V);

            //g
            Pen framepen = _settings.framePen.P;
            RoundRectUtil.Draw(g, framepen, new Rectangle(x, y, _settings.totalWidth, this.TotalHeight), 4);

            //
            DrawHDelimiter(g, rh.Left, rh.Bottom, _settings.totalWidth);
            DrawVDelimiter(g, rh.Right, rh.Top, _settings.rowHeight.V);
            DrawStringUtil.MiddleLeft(g, " ", _settings.labelFont.F, _settings.labelColor.B, rh);
            DrawStringUtil.MiddleLeft(g, FormatTradeType(), _settings.labelFont.F, _order.IsBuying? _settings.buyColor.B : _settings.sellColor.B, rb);
            NextRow(ref rh, ref rb);
            //
            DrawHDelimiter(g, rh.Left, rh.Bottom, _settings.totalWidth);
            DrawVDelimiter(g, rh.Right, rh.Top, _settings.rowHeight.V);
            DrawStringUtil.MiddleLeft(g, " ", _settings.labelFont.F, _settings.labelColor.B, rh);
            DrawStringUtil.MiddleLeft(g, String.Format("{0} {1}", _order.Stock.Profile.Code, _order.Stock.Profile.Name), _settings.labelFont.F, _settings.labelColor.B, rb);
            NextRow(ref rh, ref rb);
            //s
            DrawHDelimiter(g, rh.Left, rh.Bottom, _settings.totalWidth);
            DrawVDelimiter(g, rh.Right, rh.Top, _settings.rowHeight.V);
            DrawStringUtil.MiddleLeft(g, " s", _settings.labelFont.F, _settings.labelColor.B, rh);
            DrawStringUtil.MiddleLeft(g, _formatter.FormatStockExchange(_order.Stock.Market), _settings.labelFont.F, _settings.labelColor.B, rb);
            NextRow(ref rh, ref rb);
            //
            DrawHDelimiter(g, rh.Left, rh.Bottom, _settings.totalWidth);
            DrawVDelimiter(g, rh.Right, rh.Top, _settings.rowHeight.V);
            DrawStringUtil.MiddleLeft(g, " ", _settings.labelFont.F, _settings.labelColor.B, rh);
            x = rb.Left;
            middle = rh.Top + rh.Height/2;
            DrawStringUtil.MiddleLeft(g, _order.Volume.ToString("N0"), _settings.numberFont.F, _settings.numberColor.B, ref x, middle + _settings.numberFontYOffset.V);
            DrawStringUtil.MiddleLeft(g, _order.Stock.Profile.VolumeUnitString, _settings.labelFont.F, _settings.labelColor.B, ref x, middle);
            if(_order.IsPartialTraded) {
                PartialTradeDisplay pd = BellagioRoot.FixedPreferences.Ordering.PartialTradeDisplay;
                DrawStringUtil.MiddleLeft(g, pd==PartialTradeDisplay.Traded? "( " : "( ", _settings.labelFont.F, _settings.labelColor.B, ref x, middle);
                int partial_vol = pd==PartialTradeDisplay.Traded? _order.TradedVolume : _order.Volume - _order.TradedVolume;
                DrawStringUtil.MiddleLeft(g, partial_vol.ToString("N0"), _settings.numberFont.F, _settings.numberColor.B, ref x, middle + _settings.numberFontYOffset.V);
                DrawStringUtil.MiddleLeft(g, _order.Stock.Profile.VolumeUnitString+")", _settings.labelFont.F, _settings.labelColor.B, ref x, middle);
            }
            NextRow(ref rh, ref rb);

            //
            DrawHDelimiter(g, rh.Left, rh.Bottom, _settings.totalWidth);
            DrawVDelimiter(g, rh.Right, rh.Top, _settings.rowHeight.V);
            DrawStringUtil.MiddleLeft(g, " ", _settings.labelFont.F, _settings.labelColor.B, rh);
            x = rb.Left;
            middle = rb.Top + rb.Height/2;
            DrawStringUtil.MiddleLeft(g, _formatter.FormatOrderCondition(_order.Condition), _settings.labelFont.F, _settings.labelColor.B, ref x, middle);
            if(OrderingUtil.IsSashineRequired(_order.Condition)) {
                DrawStringUtil.MiddleLeft(g, _order.AdjustPriceI(_order.Sashine).ToString("N0"), _settings.numberFont.F, _settings.numberColor.B, ref x, middle + _settings.numberFontYOffset.V);
                DrawStringUtil.MiddleLeft(g, "~", _settings.labelFont.F, _settings.labelColor.B, ref x, middle);
            }

            NextRow(ref rh, ref rb);
            //
            DrawHDelimiter(g, rh.Left, rh.Bottom, _settings.totalWidth);
            DrawVDelimiter(g, rh.Right, rh.Top, _settings.rowHeight.V);
            DrawStringUtil.MiddleLeft(g, " L", _settings.labelFont.F, _settings.labelColor.B, rh);
            DrawStringUtil.MiddleLeft(g, _order.LimitDate==OrderLimitDate.Week? "T" : "", _settings.labelFont.F, _settings.labelColor.B, rb);
            NextRow(ref rh, ref rb);

            //
            DrawHDelimiter(g, rh.Left, rh.Bottom, _settings.totalWidth);
            DrawVDelimiter(g, rh.Right, rh.Top, _settings.rowHeight.V);
            DrawStringUtil.MiddleLeft(g, " ", _settings.labelFont.F, _settings.labelColor.B, rh);
            string kouza = _order.Stock.Profile.IsDerivative? "--" : _formatter.FormatOrderKouza(_order.Kouza);
            DrawStringUtil.MiddleLeft(g, kouza, _settings.labelFont.F, _settings.labelColor.B, rb);
            NextRow(ref rh, ref rb);

            //ԍ
            //DrawHDelimiter(g, rh.Left, rh.Bottom, _settings.totalWidth);
            DrawVDelimiter(g, rh.Right, rh.Top, _settings.rowHeight.V);
            DrawStringUtil.MiddleLeft(g, " ԍ", _settings.labelFont.F, _settings.labelColor.B, rh);
            DrawStringUtil.MiddleLeft(g, String.IsNullOrEmpty(_order.UniqueStringEx)? "--" : _order.UniqueStringEx, _settings.labelFont.F, _settings.labelColor.B, rb);
            NextRow(ref rh, ref rb);
        }

        //Kȃ}[WĐ
        private void DrawHDelimiter(Graphics g, int x, int y, int width) {
            const int margin = 4;
            Pen p = _settings.delimiterPen.P;
            g.DrawLine(p, x+margin, y, x+width-margin, y);
        }
        private void DrawVDelimiter(Graphics g, int x, int y, int height) {
            const int margin = 4;
            Pen p = _settings.delimiterPen.P;
            g.DrawLine(p, x, y+margin, x, y+height-margin);
        }
        private void NextRow(ref Rectangle rh, ref Rectangle rb) {
            rh.Y += _settings.rowHeight.V;
            rb.Y += _settings.rowHeight.V;
        }

        private string FormatTradeType() {
            StringBuilder bld = new StringBuilder();
            OrderDealType dt = _order.DealType;

            if(dt==OrderDealType.Genbutsu)
                bld.Append("").Append(_formatter.FormatTradeDescription(dt, _order.LongShort, _order.NewOrClose));
            else  {
                if(OrderingUtil.IsShinnyo(dt))
                    bld.Append("Mp");
                bld.Append(_formatter.FormatTradeDescription(dt, _order.LongShort, _order.NewOrClose));
                if(OrderingUtil.IsShinnyo(dt))
                    bld.Append(" (").Append(_formatter.FormatShinnyoKubun(dt)).Append(")");
            }

            if(!String.IsNullOrEmpty(_torihikiSuffix)) {
                bld.Append(" ").Append(_torihikiSuffix);
            }

            return bld.ToString();
        }
    }

}
