/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Screening/AutoTradingSchema.cs#3 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using Poderosa;
using Poderosa.Preferences;
using Poderosa.Util;

using Travis.ORT;
using Bellagio.Values;
using Bellagio.Environment;

namespace Bellagio.Screening {
    public enum LongShort {
        Long,
        Short
    }
    //ƒ̊֌W
    public enum ConditionType {
        TodayClose, //Il
        TomorrowOpen, //nl
        Sashine, //wl 
        Gyakusashine //twl
    }

    public class AutoTradingCondition : OriginReportableObject {
        public ORText type; //ConditionTypeQ
        public ORText condition; //boolԂExpression
        public ORText sashine; //wlEtwlŎgp

        private void AvoidWarning() {
            type = new ORText();
        }
    }

    //ǉw̗`
    public class AutoTradingAdditionalColumn : OriginReportableObject {
        public ORText label;
        public ORText expression;
        public ORText format;

        private void AvoidWarning() {
            label = expression = format = new ORText();
        }
    }

    //VOȋI
    public class SignalSelectorSchema : OriginReportableObject {
        public ORText sortExpression; //\[gExpression
        public ORText order; //~EǂŏʂÂ邩
        public ORText limitCount; //ő̗p
        public ORText maxCashAllocation; //őEŏz[
        public ORText minCashAllocation;

        private void AvoidWarning() {
            sortExpression = order = limitCount = maxCashAllocation = minCashAllocation = new ORText();
        }
    }

    public class AutoTradingSchema : ExtensionKitItemWithParameter {
        public ORText title;
        public ORText initialCash;
        public ORText filter;
        
        //閧vf
        public ORText termStats;
        public ORText customSignalFilter;

        //Strategy
        //́̕AparameterUI̒łΉւł
        public ORText longshort;
        public ORText parameterDescription; //̏Ńp[^𖄂߂邽߂UI
        public ORText maxDayCount; //ő剽܂Ŏs邩
        public ORText maxDayCountAction; //̂Ƃ̃ANV
        public ORText misconfigTradeRule; //Ӑ}ȂʂɏIg[hǂɂ邩
        public AutoTradingCondition entry;
        public AutoTradingCondition exit;
        public AutoTradingCondition losscut;

        //VOiZN^
        public SignalSelectorSchema signalSelector;
        
        

        //ǉJ
        public ORCollectionMember<AutoTradingAdditionalColumn> entryColumn;
        public ORCollectionMember<AutoTradingAdditionalColumn> exitColumn;

        public AutoTradingSchema() {
            entryColumn = new ORCollectionMember<AutoTradingAdditionalColumn>();
            exitColumn = new ORCollectionMember<AutoTradingAdditionalColumn>();
        }

        private void AvoidWarning() {
            title = longshort = termStats = new ORText();
            entry = exit = losscut = new AutoTradingCondition();
            signalSelector = new SignalSelectorSchema();
        }

        public static LongShort ParseLongShort(ORText text) {
            string t = text.ParseOptionalString("long");
            if(t=="short")
                return LongShort.Short;
            else if(t=="long")
                return LongShort.Long;
            else
                throw new FormatException(ORText.FormatMulformedElementMessage(text, ""));
                
        }
        public static ConditionType ParseConditionType(ORText text) {
            string t = text.ParseOptionalString("tomorrowopen").ToLower();
            if(t=="tomorrowopen")
                return ConditionType.TomorrowOpen;
            else if(t=="todayclose")
                return ConditionType.TodayClose;
            else if(t=="sashine")
                return ConditionType.Sashine;
            else if(t=="limitorder" || t=="gyakusashine")
                return ConditionType.Gyakusashine;
            else
                throw new FormatException(ORText.FormatMulformedElementMessage(text, "condition"));

        }
    }
    public class AutoTradingSchemaCollection : ViewSchemaCollection<AutoTradingSchema> {
        private List<AutoTradingSchema> _data;

        public AutoTradingSchemaCollection() {
            _data = new List<AutoTradingSchema>();
        }
        public AutoTradingSchema Find(string name) {
            foreach(AutoTradingSchema ss in _data)
                if(!ss.id.IsOmitted && ss.id.Value==name) return ss;

            return null;
        }

        public override void Clear() {
            _data.Clear();
        }
        public override int Count {
            get {
                return _data.Count;
            }
        }
        public override void Add(AutoTradingSchema item) {
            _data.Add(item);
        }
        public override AutoTradingSchema this[int index] {
            get {
                return _data[index];
            }
        }
        public override IEnumerator GetEnumerator() {
            return _data.GetEnumerator();
        }


    }

    //؂̘As
    public class PilotAutoTrading : ExtensionKitItemWithParameter {
        public class FeedParameter : OriginReportableObject {
            public ORText name;
            public ORText start;
            public ORText end;
            public ORText step;
        }
        public ORText target;
        public ORText stock;
        public ORCollectionMember<FeedParameter> feedParameter;

        public PilotAutoTrading() {
            feedParameter = new ORCollectionMember<FeedParameter>();
        }
    }

}
