/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Screening/ScreeningDialog.cs#3 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Diagnostics;
using System.Text;
using System.Collections.Generic;

using Poderosa.Util;

using Bellagio.Values;
using Bellagio.Data;
using Bellagio.Forms;
using Bellagio.Environment;

namespace Bellagio.Screening {
    /// <summary>
    /// ScreeningDialog ̊Tv̐łB
    /// </summary>
    public class ScreeningDialog : BellagioDefaultForm , ScreeningExecutorBase.IProgressNotifier {
        //ŌɎs
        private static ScreeningQuery _lastQuery;

        //XL[}ƃp[^UI
        private int _selectedSchemaIndex;
        private ScreeningSchema[] _schemas;
        private ScreeningParameterUI[] _parameterUIs; //z̏̓XL[}Ɠ

        private ScreeningExecutor _executor;
        private ScreeningResult _result;

        private System.Windows.Forms.Button _okButton;
        private System.Windows.Forms.Button _cancelButton;
        private System.Windows.Forms.GroupBox _filterGroup;
        private System.Windows.Forms.Label _messageLabel;
        private System.Windows.Forms.Label _filterLabel;
        private System.Windows.Forms.ComboBox _filterBox;
        private System.Windows.Forms.GroupBox _schemaSelectionGroup;
        private System.Windows.Forms.Label _lCondition;
        private System.Windows.Forms.Label _schemaLabel;
        private System.Windows.Forms.ComboBox _schemaBox;
        private System.Windows.Forms.Label _countLabel;
        private System.Windows.Forms.ComboBox _numberBox;
        private System.Windows.Forms.GroupBox _dateGroup;
        private System.Windows.Forms.DateTimePicker _datePicker;
        private System.Windows.Forms.ProgressBar _progressBar;
        /// <summary>
        /// KvȃfUCiϐłB
        /// </summary>
        private System.ComponentModel.Container components = null;

        //private BookmarkFolder _bookmarkFolder;

        public ScreeningDialog() {
            //
            // Windows tH[ fUCi T|[gɕKvłB
            //
            InitializeComponent();

            //
            // TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
            //
            _filterBox.Items.AddRange(EnumDescAttribute.For(typeof(ScreeningFilterType)).DescriptionCollection());
            _numberBox.Items.AddRange(EnumDescAttribute.For(typeof(ScreeningResultCountType)).DescriptionCollection());
            _filterBox.SelectedIndex = 0;
            _numberBox.SelectedIndex = 0;
            InitUI();
        }

        /// <summary>
        /// gpĂ郊\[XɌ㏈s܂B
        /// </summary>
        protected override void Dispose(bool disposing) {
            if(disposing) {
                if(components != null) {
                    components.Dispose();
                }
                foreach(ScreeningParameterUI u in _parameterUIs) {
                    if(u!=null) u.DisposeControls();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows tH[ fUCiŐꂽR[h
        /// <summary>
        /// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
        /// R[h GfB^ŕύXȂłB
        /// </summary>
        private void InitializeComponent() {
            this._filterGroup = new System.Windows.Forms.GroupBox();
            this._filterBox = new System.Windows.Forms.ComboBox();
            this._filterLabel = new System.Windows.Forms.Label();
            this._messageLabel = new System.Windows.Forms.Label();
            this._schemaSelectionGroup = new System.Windows.Forms.GroupBox();
            this._lCondition = new System.Windows.Forms.Label();
            this._numberBox = new System.Windows.Forms.ComboBox();
            this._countLabel = new System.Windows.Forms.Label();
            this._schemaBox = new System.Windows.Forms.ComboBox();
            this._schemaLabel = new System.Windows.Forms.Label();
            this._dateGroup = new System.Windows.Forms.GroupBox();
            this._datePicker = new System.Windows.Forms.DateTimePicker();
            this._progressBar = new System.Windows.Forms.ProgressBar();
            this._okButton = new System.Windows.Forms.Button();
            this._cancelButton = new System.Windows.Forms.Button();
            this._filterGroup.SuspendLayout();
            this._schemaSelectionGroup.SuspendLayout();
            this._dateGroup.SuspendLayout();
            this.SuspendLayout();
            // 
            // _filterGroup
            // 
            this._filterGroup.Controls.Add(this._filterBox);
            this._filterGroup.Controls.Add(this._filterLabel);
            this._filterGroup.Controls.Add(this._messageLabel);
            this._filterGroup.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._filterGroup.Location = new System.Drawing.Point(8, 8);
            this._filterGroup.Name = "_filterGroup";
            this._filterGroup.Size = new System.Drawing.Size(464, 76);
            this._filterGroup.TabIndex = 0;
            this._filterGroup.TabStop = false;
            this._filterGroup.Text = "P@tB^̐ݒ";
            // 
            // _filterBox
            // 
            this._filterBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this._filterBox.Location = new System.Drawing.Point(136, 40);
            this._filterBox.Name = "_filterBox";
            this._filterBox.Size = new System.Drawing.Size(224, 20);
            this._filterBox.TabIndex = 3;
            // 
            // _filterLabel
            // 
            this._filterLabel.Location = new System.Drawing.Point(24, 40);
            this._filterLabel.Name = "_filterLabel";
            this._filterLabel.Size = new System.Drawing.Size(64, 16);
            this._filterLabel.TabIndex = 2;
            this._filterLabel.Text = "tB^(&F)";
            this._filterLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // _messageLabel
            // 
            this._messageLabel.Location = new System.Drawing.Point(16, 16);
            this._messageLabel.Name = "_messageLabel";
            this._messageLabel.Size = new System.Drawing.Size(432, 16);
            this._messageLabel.TabIndex = 1;
            this._messageLabel.Text = "܂Ώۂ߂܂Bł̑ΏۖȂقǍɌʂ܂B";
            // 
            // _primaryIndicatorGroup
            // 
            this._schemaSelectionGroup.Controls.Add(this._lCondition);
            this._schemaSelectionGroup.Controls.Add(this._numberBox);
            this._schemaSelectionGroup.Controls.Add(this._countLabel);
            this._schemaSelectionGroup.Controls.Add(this._schemaBox);
            this._schemaSelectionGroup.Controls.Add(this._schemaLabel);
            this._schemaSelectionGroup.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._schemaSelectionGroup.Location = new System.Drawing.Point(8, 92);
            this._schemaSelectionGroup.Name = "_primaryIndicatorGroup";
            this._schemaSelectionGroup.Size = new System.Drawing.Size(464, 120);
            this._schemaSelectionGroup.TabIndex = 4;
            this._schemaSelectionGroup.TabStop = false;
            this._schemaSelectionGroup.Text = "Q@\[gƌ̐ݒ";
            // 
            // _lCondition
            // 
            this._lCondition.Location = new System.Drawing.Point(16, 16);
            this._lCondition.Name = "_lCondition";
            this._lCondition.Size = new System.Drawing.Size(432, 23);
            this._lCondition.TabIndex = 5;
            this._lCondition.Text = "\[g͊gLbgɂĒǉ邱Ƃł܂B";
            this._lCondition.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // _primaryIndicatorBox
            // 
            this._schemaBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this._schemaBox.Location = new System.Drawing.Point(136, 40);
            this._schemaBox.Name = "_primaryIndicatorBox";
            this._schemaBox.Size = new System.Drawing.Size(272, 20);
            this._schemaBox.TabIndex = 7;
            // 
            // _primaryIndicatorLabel
            // 
            this._schemaLabel.Location = new System.Drawing.Point(24, 40);
            this._schemaLabel.Name = "_primaryIndicatorLabel";
            this._schemaLabel.TabIndex = 6;
            this._schemaLabel.Text = "\[g(&S)";
            this._schemaLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // _numberBox
            // 
            this._numberBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this._numberBox.Location = new System.Drawing.Point(136, 88);
            this._numberBox.Name = "_numberBox";
            this._numberBox.Size = new System.Drawing.Size(272, 20);
            this._numberBox.TabIndex = 8;
            // 
            // _countLabel
            // 
            this._countLabel.Location = new System.Drawing.Point(24, 88);
            this._countLabel.Name = "_countLabel";
            this._countLabel.TabIndex = 9;
            this._countLabel.Text = "\(&N)";
            this._countLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // _dateGroup
            // 
            this._dateGroup.Controls.Add(this._datePicker);
            this._dateGroup.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._dateGroup.Location = new System.Drawing.Point(8, 220);
            this._dateGroup.Name = "_dateGroup";
            this._dateGroup.Size = new System.Drawing.Size(464, 48);
            this._dateGroup.TabIndex = 10;
            this._dateGroup.TabStop = false;
            this._dateGroup.Text = "R@XN[jO̊";
            // 
            // _datePicker
            // 
            this._datePicker.Location = new System.Drawing.Point(16, 16);
            this._datePicker.MaxDate = new System.DateTime(2010, 12, 31, 0, 0, 0, 0);
            this._datePicker.MinDate = new System.DateTime(1996, 1, 1, 0, 0, 0, 0);
            this._datePicker.Name = "_datePicker";
            this._datePicker.TabIndex = 12;
            this._datePicker.ValueChanged += new System.EventHandler(this.OnDateChanged);
            // 
            // _progressBar
            // 
            this._progressBar.Location = new System.Drawing.Point(8, 276);
            this._progressBar.Name = "_progressBar";
            this._progressBar.Size = new System.Drawing.Size(464, 23);
            this._progressBar.TabIndex = 14;
            // 
            // _okButton
            // 
            this._okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
            this._okButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._okButton.Location = new System.Drawing.Point(312, 308);
            this._okButton.Name = "_okButton";
            this._okButton.TabIndex = 15;
            this._okButton.Text = "OK";
            this._okButton.Click += new System.EventHandler(this.OnOK);
            // 
            // _cancelButton
            // 
            this._cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this._cancelButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._cancelButton.Location = new System.Drawing.Point(400, 308);
            this._cancelButton.Name = "_cancelButton";
            this._cancelButton.TabIndex = 16;
            this._cancelButton.Text = "LZ";
            this._cancelButton.Click += new System.EventHandler(this.OnCancel);
            // 
            // ScreeningDialog
            // 
            this.AcceptButton = this._okButton;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.CancelButton = this._cancelButton;
            this.ClientSize = new System.Drawing.Size(482, 340);
            this.Controls.Add(this._dateGroup);
            this.Controls.Add(this._schemaSelectionGroup);
            this.Controls.Add(this._progressBar);
            this.Controls.Add(this._filterGroup);
            this.Controls.Add(this._cancelButton);
            this.Controls.Add(this._okButton);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "ScreeningDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "XN[jOݒ";
            this._filterGroup.ResumeLayout(false);
            this._schemaSelectionGroup.ResumeLayout(false);
            this._dateGroup.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        public ScreeningResult Result {
            get {
                return _result;
            }
        }

        private void InitUI() {
            if(_lastQuery!=null) {
                _filterBox.SelectedIndex = (int)_lastQuery.StaticFilter;
                _numberBox.SelectedIndex = (int)_lastQuery.CountType;
                _datePicker.Value = BDate.ToDateTime(_lastQuery.OriginDate);
            }
            else {
                _datePicker.Value = ScreeningPlugin.Instance.ScreeningDailyDataProvider.GuessLatestTradeDate;
            }

            int si = 0;
            List<ScreeningSchema> coll = new List<ScreeningSchema>();
            BellagioRoot.SchemaRoot.CollectScreeningSchema(coll);
            _schemas = new ScreeningSchema[coll.Count];
            _parameterUIs = new ScreeningParameterUI[coll.Count];
            string last_executed_id = ScreeningPlugin.Instance.Preferences.LastExecutedScreening; //ڂ̂ݕۑ
            for(int i=0; i<coll.Count; i++) {
                ScreeningSchema item = coll[i];
                _schemas[i] = item;
                StringWithParameterParser string_parser = new StringWithParameterParser(item);

                _schemaBox.Items.Add(string_parser.Parse(item.title));
                if(last_executed_id==item.FullID)
                    si = i;
            }
            _schemaBox.SelectedIndex = coll.Count==0? -1 : si;
            _selectedSchemaIndex = -1;
            _schemaBox.SelectedIndexChanged += new EventHandler(OnSelectedSchemaChanged);
            OnSelectedSchemaChanged(_schemaBox, null);
        }

        private void OnSelectedSchemaChanged(object sende, EventArgs args) {
            if(_selectedSchemaIndex == _schemaBox.SelectedIndex) return;

            _schemaSelectionGroup.SuspendLayout();
            ScreeningParameterUI u;
            if(_selectedSchemaIndex!=-1) {
                u = _parameterUIs[_selectedSchemaIndex];
                Debug.Assert(u!=null);
                foreach(ScreeningParameterUI.ParamTag tag in u.Tags) {
                    _schemaSelectionGroup.Controls.Remove(tag.label);
                    _schemaSelectionGroup.Controls.Remove(tag.valueControl);
                }
            }

            u = _parameterUIs[_schemaBox.SelectedIndex];
            if(u==null) {
                ScreeningSchema schema = _schemas[_schemaBox.SelectedIndex];
                u = new ScreeningParameterUI(schema, schema.parameterDescription.ParseOptionalString(""), new EventHandler(OnParameterChanged));
                _parameterUIs[_schemaBox.SelectedIndex] = u;
            }

            int x = _schemaBox.Left;
            foreach(ScreeningParameterUI.ParamTag tag in u.Tags) {
                tag.label.Location = new Point(x, 64);
                _schemaSelectionGroup.Controls.Add(tag.label);
                x += tag.label.Width + 8;
                _schemaSelectionGroup.Controls.Add(tag.valueControl);
                tag.valueControl.Location = new Point(x, 64);
                x += tag.valueControl.Width + 8;
            }

            _selectedSchemaIndex = _schemaBox.SelectedIndex;
            _schemaSelectionGroup.ResumeLayout();
        }
        //IɃeLXg܂ŔfĂ܂
        private void OnParameterChanged(object sender, EventArgs args) {
            ScreeningParameterUI u = _parameterUIs[_selectedSchemaIndex];
            CommitParameter(u);

            ScreeningSchema item = _schemas[_selectedSchemaIndex];
            StringWithParameterParser string_parser = new StringWithParameterParser(item);
            _schemaBox.Items[_selectedSchemaIndex] = string_parser.Parse(item.title);


        }

        private void OnOK(object sender, EventArgs args) {
            this.DialogResult = DialogResult.None;
            ScreeningQuery q = CreateScreeningQuery();
            if(q==null) return;

            SetUIEnabled(false);

            //_progressBar.Maximum = _executor.BrandEnumerator.Count;
            _progressBar.Value = 0;
            _progressBar.Enabled = true;
            _lastQuery = q;

            this.Cursor = Cursors.AppStarting;
            _executor = new ScreeningExecutor(q);
            _executor.ProgressNotifier = this;
            _executor.AsyncExecute();
        }
        private void SetUIEnabled(bool value) {
            _okButton.Enabled = value;
            _filterBox.Enabled = value;
            _numberBox.Enabled = value;
            _schemaBox.Enabled = value;
            _datePicker.Enabled = value;
            ScreeningParameterUI u = _parameterUIs[_schemaBox.SelectedIndex];
            u.EnableControls(value);
        }

        private void OnCancel(object sender, EventArgs args) {
            if(_executor!=null) {
                this.DialogResult = DialogResult.None;
                SetUIEnabled(true);
                _executor.Abort();
            }
        }

        private void OnDateChanged(object sender, EventArgs args) {
            DateTime dt = _datePicker.Value;
        }

        private ScreeningQuery CreateScreeningQuery() {
            if(_datePicker.Value.CompareTo(DateTime.Today)>0) {
                BUtil.ShowWarningMessageBox(this, "łB");
                return null;
            }

            //p[^commit
            int ind = _schemaBox.SelectedIndex;
            ScreeningParameterUI u = _parameterUIs[ind];
            CommitParameter(u);

            try {
                ScreeningQuery q = new ScreeningQuery();
                q.ConstructWithSchema(_schemas[ind]);
                ScreeningFilterType filter = (ScreeningFilterType)_filterBox.SelectedIndex;
                q.StaticFilter = filter;
                q.OriginDate = BDate.DateTimeToInt(_datePicker.Value);
                q.CountType = (ScreeningResultCountType)_numberBox.SelectedIndex;

                return q;
            }
            catch(Exception ex) {
                BUtil.ShowWarningMessageBox(this, ex.Message);
                return null;
            }
        }
        private void CommitParameter(ScreeningParameterUI u) {
            foreach(ScreeningParameterUI.ParamTag tag in u.Tags) {
                int v = (int)tag.valueControl.Value;
                BellagioRoot.ExtensionKitPreference.Find(tag.fullID).Value = v.ToString();
            }
        }

        //񓯊nh

        #region IProgressNotifier o

        private delegate void ProgressDelegate(int count);
        public void InitProgress(string comment, int limit) {
            this.Invoke(new ProgressDelegate(UIInitProgress), limit);
        }
        private void UIInitProgress(int limit) {
            _progressBar.Value = 0;
            _progressBar.Maximum = limit;
        }
        
        public void OnProgress(int count) {
            this.Invoke(new ProgressDelegate(UIOnProgress), count);
        }
        private void UIOnProgress(int count) {
            if(count<_progressBar.Maximum) _progressBar.Value = count;
        }

        public void OnComplete() {
            this.Invoke(new VoidVoidDelegate(ExitSuccessFully));
        }

        public void OnFail(string message) {
            BUtil.ShowWarningMessageBox(message);
            this.Invoke(new VoidVoidDelegate(ResetExec));
        }

        public void OnAbort() {
            this.Invoke(new VoidVoidDelegate(ResetExec));
        }
        private void ResetExec() {
            Debug.Assert(BUtil.IsExecutingInMainThread);
            this.Cursor = Cursors.Default;
            _progressBar.Value = 0;
            _executor = null;
            SetUIEnabled(true);
        }

        #endregion

        private void ExitSuccessFully() {
            Debug.Assert(BUtil.IsExecutingInMainThread);

            this.DialogResult = DialogResult.OK;
            this.Cursor = Cursors.Default;
            ScreeningResult r = _executor.Result;
            StringBuilder msg = new StringBuilder();
            msg.AppendFormat("XN[jO܂B\nΏۖ {0} łB\n", r.TotalCount);
            if(r.Count==0)
                msg.Append("Ƀ}b`͌܂łB\n");
            for(int i=0; i<r.InsufficientDataStocks.Count; i++) {
                Debug.WriteLine("Insufficients "+r.InsufficientDataStocks[i].Code);
            }
            for(int i=0; i<r.ErrorStocks.Count; i++) {
                Debug.WriteLine("DataError "+r.ErrorStocks[i].Code);
            }

            BUtil.ShowInformationMessageBox( msg.ToString());
            ScreeningPlugin.Instance.Preferences.LastExecutedScreening = r.Query.SourceSchema.FullID;

            _result = r;
            Close();
        }



    }
}
