/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Screening/ScreeningPlugin.cs#3 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;

using Poderosa;
using Poderosa.Plugins;
using Poderosa.Commands;
using Poderosa.Forms;
using Poderosa.Sessions;
using Poderosa.View;
using Poderosa.Preferences;

using Sansa.Runtime;
using Bellagio.Forms;
using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Environment;

[assembly: PluginDeclaration(typeof(Bellagio.Screening.ScreeningPlugin))]

namespace Bellagio.Screening {

    //؂͕IɉۋliT[oƂ̘AgɓȂĵŁA
    //KronosɈڊǂă\[XR[hJɂB
    //ʃAZuɂȂ邪AScreeningƖڂɊ֌WĂ̂ł̃C^tF[XʂĒʐM
    public interface IAutoTradingFeature {
        CommandResult OpenAutoTradingDialog(Form parentForm);
        CommandResult OpenAutoTradingPilotDialog(Form parentForm);
    }
    public interface IScreeningPlugin : IAdaptable {
        void RegisterAutoTrading(IAutoTradingFeature at);
    }


    [PluginInfo(ID=ScreeningPlugin.PLUGIN_ID, Version=BellagioVersionInfo.PLUGIN_VERSION, Author=BellagioVersionInfo.AUTHOR_NAME, Dependencies=BellagioPlugin.PLUGIN_ID+";"+Chart.ChartPlugin.PLUGIN_ID)]
    public class ScreeningPlugin : PluginBase, IScreeningPlugin  {
        public const string PLUGIN_ID = "jp.co.lagarto.tactico.screening";
        private static ScreeningPlugin _instance;

        private IGeneralCommand _openScreeningDialogCommand;
        private IGeneralCommand _openAutoTradingDialogCommand;
        private IGeneralCommand _openAutoTradingPilotDialogCommand;
        private IExtensionPoint _screeningDailyDataProvider;
        private ICoreServices _coreServices;
        private ScreeningPreferences _preferences;

        private RecentDailyDataCache _dataCache;
        private IAutoTradingFeature _autoTradingFeature;
     
        public override void InitializePlugin(IPoderosaWorld poderosa) {
            base.InitializePlugin(poderosa);

            _instance = this;

            ICoreServices cs = (ICoreServices)poderosa.GetAdapter(typeof(ICoreServices));
            _coreServices = cs;
            ICommandCategory cat = cs.CommandManager.CommandCategories.Dialogs;
            _openScreeningDialogCommand = new GeneralCommandImpl("tactico.screening.openDialog", "XN[jO_CAO", cat, new ExecuteDelegate(OpenScreeningDialogImpl), null);
            _openAutoTradingDialogCommand = new GeneralCommandImpl("tactico.screening.openAutoTrading", "؃_CAO", cat, new ExecuteDelegate(OpenAutoTradingDialogImpl), null);
            _openAutoTradingPilotDialogCommand = new GeneralCommandImpl("tactico.screening.openAutoTradingPilot", "p[^f^؃_CAO", cat, new ExecuteDelegate(OpenAutoTradingPilotDialogImpl), null);

            _preferences = new ScreeningPreferences();
            _coreServices.PreferenceExtensionPoint.RegisterExtension(_preferences);

            cs.CommandManager.Register(_openScreeningDialogCommand);
            _screeningDailyDataProvider = poderosa.PluginManager.CreateExtensionPoint("tactico.screening.dailyDataProvider", typeof(IScreeningDailyDataProvider), this);
            _dataCache = new RecentDailyDataCache();

            /*
            PoderosaMenuGroupImpl menugroup = new PoderosaMenuGroupImpl(new IPoderosaMenu[] {
            new PoderosaMenuItemImpl(_openAutoTradingPilotDialogCommand, "p[^f^")}, false);
            poderosa.PluginManager.FindExtensionPoint("org.poderosa.menu.tool").RegisterExtension(menugroup);
            */

            IExtensionPoint panel = poderosa.PluginManager.FindExtensionPoint("org.poderosa.optionpanel");
            panel.RegisterExtension(new ScreeningAndAutoTradingOptionPanelExtension());
            //{BellagioPluginGeneralOptionPanelo^ׂA͍Ō̃plƂĕ\Ăق̂łڂĂœo^Ă܂B
            panel.RegisterExtension(new Bellagio.Environment.GeneralOptionPanelExtension());

        }
        public static ScreeningPlugin Instance {
            get {
                return _instance;
            }
        }
        public void RegisterAutoTrading(IAutoTradingFeature at) {
            _autoTradingFeature = at;
        }

        public ICommandManager CommandManager {
            get {
                return _coreServices.CommandManager;
            }
        }

        public ScreeningPreferences Preferences {
            get {
                return _preferences;
            }
        }

        public RecentDailyDataCache DailyDataCache {
            get {
                return _dataCache;
            }
        }

        public IGeneralCommand OpenScreeningDialogCommand {
            get {
                return _openScreeningDialogCommand;
            }
        }
        public IGeneralCommand OpenAutoTradingDialogCommand {
            get {
                return _openAutoTradingDialogCommand;
            }
        }
        public IGeneralCommand OpenAutoTradingPilotDialogCommand {
            get {
                return _openAutoTradingPilotDialogCommand;
            }
        }
        public IScreeningDailyDataProvider ScreeningDailyDataProvider {
            get {
                IScreeningDailyDataProvider[] p = (IScreeningDailyDataProvider[])_screeningDailyDataProvider.GetExtensions();
                Debug.Assert(p.Length==1);
                return p[0];
            }
        }


        public override void TerminatePlugin() {
            base.TerminatePlugin();
        }

        internal CommandResult OpenScreeningDialogImpl(ICommandTarget target) {
            IPoderosaForm f = (IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm));
            ScreeningDialog dlg = new ScreeningDialog();
            if(dlg.ShowDialog(f.AsForm())==DialogResult.OK) {
                if(dlg.Result.Count > 0) {
                    ScreeningResultPane pane = new ScreeningResultPane(dlg.Result);
                    FormUtil.AdjustStyleForModelessSizableDialog(pane, f.AsForm());
                    pane.Show();
                }
            }
            dlg.Dispose();

            return CommandResult.Succeeded;
        }

        internal CommandResult OpenAutoTradingDialogImpl(ICommandTarget target) {
            if(_autoTradingFeature==null) {
                BUtil.ShowWarningMessageBox("؋@\̎܂");
                return CommandResult.Failed;
            }
            IPoderosaForm f = (IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm));
            return _autoTradingFeature.OpenAutoTradingDialog(f.AsForm());
        }

        internal CommandResult OpenAutoTradingPilotDialogImpl(ICommandTarget target) {
            if(_autoTradingFeature==null) {
                BUtil.ShowWarningMessageBox("؋@\̎܂");
                return CommandResult.Failed;
            }
            IPoderosaForm f = (IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm));
            return _autoTradingFeature.OpenAutoTradingPilotDialog(f.AsForm());
        }

#if UNITTEST
        //DailyDataCachêݎgpł悤ɂĂ
        public static void BootForTest() {
            ScreeningPlugin pl = new ScreeningPlugin();
            _instance = pl;
            pl._dataCache = new RecentDailyDataCache();
            pl._dataCache.ProhibitDataProvider();
        }
#endif
    }
    
    //ACR擾pɂpublicȂ̂p
    public class ScreeningPluginAccessor {
        public static Image GetToolbarBitmap(int index) {
            return BellagioRoot.CommonIcons.LargeSessions.GetBitmap(index);
        }
    }

    public static class ScreeningUtil {
        public static double BVToDouble(BV value) {
            BDouble bd = value as BDouble;
            if(bd!=null) return bd.Value;

            BInt bi = value as BInt;
            if(bi!=null) return bi.Value;

            Debug.Assert(false);
            return 0;
        }

        public static ColumnHeader CreateColumnHeader(string name, int width) {
            ColumnHeader h = new ColumnHeader();
            h.Text = name;
            h.Width = width;
            h.TextAlign = HorizontalAlignment.Left;
            return h;
        }

        public static ListViewItem GetSelectedItem(ListView lv) {
            ListView.SelectedListViewItemCollection t = lv.SelectedItems;
            return t.Count>0? t[0] : null;
        }
    }
}
