using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;

//Debug.WriteLinegȂŋً}IɃg[X
namespace Travis {
    public class TrDebugLog {
        private static string _fileName;
        private static TextWriter _writer;
        private static bool _enabled = true;

        public static string FileName {
            get {
                return _fileName;
            }
            set {
                _fileName = value;
            }
        }

        public static void WriteLine(string msg) {
            if(!_enabled) return;
            Prepare();

            lock(_writer) {
                _writer.WriteLine(msg);
                _writer.Flush();
            }
        }

        public static void WriteCurrentStackTrace() {
            if(!_enabled) return;
            WriteLine(new StackTrace(true).ToString());
        }

        private static void Prepare() {
            if(_writer!=null) return;

            try {
                _writer = new StreamWriter(_fileName, false, System.Text.Encoding.Default);
                _writer.WriteLine(String.Format("[DebugLog {0}]", DateTime.Now.ToString()));
            }
            catch(Exception ex) {
                System.Windows.Forms.MessageBox.Show(ex.Message);
            }
        }
    }
}
