/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: //depot/Bellagio/Hermes/Poderosa/Usability/UsabilityPlugin.cs#2 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Poderosa.Plugins;
using Poderosa.Commands;
using Poderosa.Forms;
using Poderosa.Preferences;

[assembly: PluginDeclaration(typeof(Poderosa.Usability.UsabilityPlugin))]

namespace Poderosa.Usability {
    [PluginInfo(ID="org.poderosa.usability", Version=VersionInfo.PODEROSA_VERSION, Author=VersionInfo.PROJECT_NAME, Dependencies="org.poderosa.core.window")]
    internal class UsabilityPlugin : PluginBase {
        private static UsabilityPlugin _instance;
        private static StringResource _stringResource;
        private ICommandManager _commandManager;
        private IWindowManager _windowManager;


        public static UsabilityPlugin Instance {
            get {
                return _instance;
            }
        }

        public override void InitializePlugin(IPoderosaWorld poderosa) {
            base.InitializePlugin(poderosa);
            _instance = this;
            ICoreServices cs = (ICoreServices)poderosa.GetAdapter(typeof(ICoreServices));

            poderosa.Culture.AddChangeListener(UsabilityPlugin.Strings);
            IPluginManager pm = poderosa.PluginManager;

            _commandManager = cs.CommandManager;
            Debug.Assert(_commandManager!=null);

            _windowManager = cs.WindowManager;
            Debug.Assert(_windowManager!=null);
        
        }
        public override void TerminatePlugin() {
            base.TerminatePlugin();
        }

        public IWindowManager WindowManager {
            get {
                return _windowManager;
            }
        }

        public static StringResource Strings {
            get {
                if(_stringResource==null) {
                    _stringResource = new StringResource("Bellagio.Hermes.Poderosa.Usability.strings", typeof(UsabilityPlugin).Assembly);
                    _instance.PoderosaWorld.Culture.AddChangeListener(_stringResource);
                }
                return _stringResource;
            }
        }
    }

}
