/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/PoderosaChartDocument.cs#9 $
 * $DateTime: 2007/12/28 19:23:38 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

using Poderosa;
using Poderosa.Sessions;
using Poderosa.Commands;
using Bellagio.Environment;

namespace Bellagio.Chart {
    //IPoderosaDocument̎
    // PoderosaSessionɔˑ̃`[gT|[g邽߁AChartDocumentBasePoderosat[[NɊւ镔𒊏o
    public class PoderosaChartDocument : IPoderosaDocument, IPoderosaContextMenuPoint {
        private ChartSessionBase _sessionBase;
        private PoderosaCommandImpl _closeCommand;

        public PoderosaChartDocument(ChartSessionBase session) {
            _sessionBase = session;
            _closeCommand = new PoderosaCommandImpl(new ExecuteDelegate(CloseThisCommand));
        }

        public Image Icon {
            get { return _sessionBase.Icon; }
        }

        public string Caption {
            get { return _sessionBase.Caption; }
        }

        public ISession OwnerSession {
            get { return _sessionBase; }
        }

        public IPoderosaMenuGroup[] ContextMenu {
            get {
                return new IPoderosaMenuGroup[] { new PoderosaMenuGroupImpl(new PoderosaMenuItemImpl(_closeCommand, "(&C)")) };
            }
        }

        private CommandResult CloseThisCommand(ICommandTarget target) {
            BellagioPlugin.Instance.SessionManager.CloseDocument(this);
            return CommandResult.Succeeded;
        }

        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }

    }
}
