/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/StockDataProviderBase.cs#10 $
 * $DateTime: 2008/05/14 13:05:12 $
 * L[ɂf[^W߁AILbV̋@\񋟂BDataSubscriberPrimaryDatåԂ̃CɓB
 * ݂́AETickE̂ȐɂĔhNXŒ񋟂
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

#if UNITTEST
using NUnit.Framework;
#endif

namespace Bellagio.Data {
    public enum AsyncOpResult { 
        Succeeded, Failed, Async
    }

    public abstract class StockDataProviderBaseT<PD, INIT> where PD : StockPrimaryData where INIT : IStockPrimaryDataInitializer {
        public delegate void ResultNotifierDeleagate(Stock stock, AsyncOpResult result, string msg);

        protected class StockTag {
            public Stock stock;
            public int count; //SubscriberƂPAIƂPB0ɂȂPrimaryDataɏIʒm
            public PD value;
            public INIT initializer; //PDɑΉ鏉葱IuWFNg
        }
        protected Dictionary<Stock, StockTag> _data;
        private ResultNotifierDeleagate _notifier;

        public StockDataProviderBaseT() {
            _data = new Dictionary<Stock, StockTag>();
        }
        //f[^΂ԂAȂnullԂ
        public PD Lookup(Stock stock) {
            lock(this) {
                StockTag e = GetTagOrNull(stock);
                return (e!=null && e.value.DataChangeTag.IsOK)? e.value : null;
            }
        }

        //Subscribeʒʒmnh̓o^@NG
        public ResultNotifierDeleagate ResultNotifier {
            get {
                Debug.Assert(_notifier==null);
                return _notifier;
            }
            set {
                _notifier = value;
            }
        }

        //f[^΂ԂAȂnullԂB
        //ȂΎ擾JnB񓯊Ɏ擾ꍇAʂ͔񓯊DataSubscriberɓ`
        public /*virtual*/ AsyncOpResult Open(Stock stock, ref PD value, ref string message) {
            Debug.Assert(stock!=null);
            lock(this) {
                StockTag e = GetTagOrNull(stock);
                if(e!=null) {
                    Debug.Assert(e.value!=null);
                    PrimaryDataStatus st = e.value.DataStatus;
                    if(st==PrimaryDataStatus.OK) {
                        value = e.value;
                        e.count++;
                        return AsyncOpResult.Succeeded;
                    }
                    else if(st==PrimaryDataStatus.Preparing) { //ł邩炻̂
                        e.count++;
                        return AsyncOpResult.Async;
                    }
                }

                //ȊO͐VK쐬Kv
                value = CreateValue(stock);
                Debug.Assert(value.DataChangeTag.Status==PrimaryDataStatus.Initial);
                e = new StockTag();
                e.stock = stock;
                e.count = 1;
                e.initializer = CreateInitializer(value);
                e.value = value;
                _data.Add(stock, e); //OpenValuêȂœIɏP[X(ƂUnittest)lĂŃ}bv͍

                try {
                    AsyncOpResult result = OpenValue(e.initializer, ref message);
                    if(result==AsyncOpResult.Failed) {
                        _data.Remove(stock);
                        value = null;
                        e.value.DataChangeTag.SetErrorStatus(message);
                    }
                    else if(result==AsyncOpResult.Async) { //initializerԂ݂Ă
                        e.value.DataChangeTag.SetStatus(PrimaryDataStatus.Preparing);
                    }
                    else {
                        Debug.Assert(result==AsyncOpResult.Succeeded);
                    }
                    return result;
                }
                catch(Exception ex) {
                    Debug.WriteLine(ex.StackTrace);
                    Debug.Assert(false, ex.Message); //̒ł̗O͔F߂Ȃ
                    return AsyncOpResult.Failed;
                }
            }
        }


        //I[vStockXgԂAPreparingɂ
        public List<PD> PrepareResume() {
            return null;
            /*
            List<PD> r = new List<PD>();
            lock(this) {
                foreach(KeyValuePair<Stock, StockTag> p in _data) {
                    if(p.Value.status==EntryStatus.OK || p.Value.status==EntryStatus.Preparing) {
                        r.Add(p.Value.value);
                        p.Value.status = EntryStatus.Preparing;
                    }
                }
            }

            return r;
            */
        }
        //ResumeJn
        public AsyncOpResult Resume(PD value, ref string msg) {
            return AsyncOpResult.Failed;
        }

        //\[Xԋp
        public void Release(Stock stock) {
            lock(this) {
                StockTag e = GetTagOrNull(stock);
                //{̞͂B͂悭ȂBAsReleaseOシ邱Ƃ͂肤
                if(e==null) return;
                Debug.Assert(e.count > 0);
                e.count--;
                //TODO QƃJEgOɂȂƂđ؂ƍĐڑȂǂŎԂ邩Ȃ
                if(e.count==0 && e.value.DataStatus==PrimaryDataStatus.OK) { //OKԂłȂƐؒf͂ȂBPreparinĝƂ͌ʔ܂CloseValuex
                    CloseValue(stock, e.value);
                    _data.Remove(stock);
                }
            }
        }

        //ڑ؂ꂽƂɎsB҂̂݃G[ԂɎĂ
        public void PurgeWaitingData() {
            lock(this) {
                List<StockTag> tags = new List<StockTag>();
                foreach(KeyValuePair<Stock, StockTag> p in _data) {
                    if(p.Value.value.DataStatus==PrimaryDataStatus.Preparing) tags.Add(p.Value);
                }
                //FailLoading_datavf̂ŁAtagsɑΏۂԂޕKv
                foreach(StockTag tag in tags)
                    FailLoading(tag.stock, "ڑ؂܂");
            }
        }

        protected StockTag GetTagOrNull(Stock stock) {
            //GetOrOpen烊^[Oɔ񓯊Ƀf[^ꍇłAMapInitialDatałʂ̂ŃubNB]GetOrOpen̊f[^Ȃ͕̂ۏ؂ĂB
            lock(this) {
                StockTag e;
                if(_data.TryGetValue(stock, out e))
                    return e;
                else
                    return null;
            }
        }


#if UNITTEST
        //eXgł̂ݎgpBEntry̓ԂmF
        public void AssertStockEntry(Stock stock, int refcount, PrimaryDataStatus status) {
            StockTag e = GetTagOrNull(stock);
            Assert.IsNotNull(e);
            Assert.AreEqual(refcount, e.count);
            Assert.AreEqual(status, e.value.DataStatus);
        }
        public void AssertStockEntryIsNull(Stock stock) {
            StockTag e = GetTagOrNull(stock);
            Assert.IsNull(e);
        }
#endif
        public void ClearAll() {
            _data.Clear();
        }

        //DataProvidervf쐬
        protected abstract PD CreateValue(Stock stock);
        protected abstract INIT CreateInitializer(PD value);

        //f[^쐬BʂƂĂ͎̂RN肤
        //
        //s(errorɃbZ[W)
        //񓯊Jn
        protected abstract AsyncOpResult OpenValue(INIT initializer, ref string error);
        protected abstract void CloseValue(Stock stock, PD value);

        //񓯊Ƀf[^擾鑀삪Ƃʒm
        protected void CompleteLoading(Stock stock) {
            StockTag e = GetTagOrNull(stock);
            Debug.Assert(e!=null && e.value.DataChangeTag.IsInitialOrPreparing);
            e.value.DataChangeTag.SetStatus(PrimaryDataStatus.OK);
            if(e.count==0) { //ʂ܂łɂłɐ؂ĂxĂCloseValues
                CloseValue(stock, e.value);
                _data.Remove(stock);
            }
            else {
                if(_notifier!=null) _notifier(stock, AsyncOpResult.Succeeded, null);
                e.value.FireDataUpdateEvent();
            }
        }
        protected void FailLoading(Stock stock, string msg) {
            StockTag e = GetTagOrNull(stock);
            Debug.Assert(e!=null && e.value.DataChangeTag.IsInitialOrPreparing);
            if(_notifier!=null) _notifier(stock, AsyncOpResult.Failed, msg);
            e.value.DataChangeTag.SetErrorStatus(msg);
            _data.Remove(stock);
            e.value.FireErrorEventToSubscriberManager(msg);
        }
    }

#if UNITTEST
    //ˋ̎ނPrimaryData̓eXg
    internal class UnitTestMockPrimaryData : StockPrimaryData {
        public UnitTestMockPrimaryData(Stock stock) : base(stock) {
        }

        public override void FireErrorEventToSubscriberManager(string msg) {
            errorCount++;
            lastErrorMsg = msg;
        }
        public override bool FireEventToSubscriberManager() {
            return false;
        }

        public int errorCount;
        public string lastErrorMsg;
        public void PrepareTest() {
            errorCount = 0;
            lastErrorMsg = null;
        }
    }
    internal class UnitTestMockPrimaryDataInitializer : StockPrimaryDataInitializer {
        public UnitTestMockPrimaryDataInitializer(UnitTestMockPrimaryData value)
            : base(value) {
        }
        public override bool IsCompleted {
            get {
                return true;
            }
        }

        public override void FailLoading(string msg) {
        }
        public override void CompleteInitialization() {
            
        }
    }
    internal class UnitTestMockPrimaryDataProvider : StockDataProviderBaseT<UnitTestMockPrimaryData, UnitTestMockPrimaryDataInitializer> {
        protected override UnitTestMockPrimaryData CreateValue(Stock stock) {
            return new UnitTestMockPrimaryData(stock);
        }
        protected override UnitTestMockPrimaryDataInitializer CreateInitializer(UnitTestMockPrimaryData value) {
            return new UnitTestMockPrimaryDataInitializer(value);
        }
        protected override AsyncOpResult OpenValue(UnitTestMockPrimaryDataInitializer initializer, ref string error) {
            openValueCall++;

            if(openValueResultRetVal==AsyncOpResult.Failed)
                error = errorMsg;
            else if(openValueResultRetVal==AsyncOpResult.Succeeded)
                base.CompleteLoading(initializer.Stock);

            return openValueResultRetVal;
        }
        protected override void CloseValue(Stock stock, UnitTestMockPrimaryData value) {
            closeValueCall++;
        }

        //ǑĂяo
        public void CompleteAsyncLoad(Stock stock) {
            base.CompleteLoading(stock);
        }
        public void FailAsyncLoad(Stock stock) {
            base.FailLoading(stock, errorMsg);
        }

        //ȉAUnitTestR[󋵂
        public int openValueCall;
        public int closeValueCall;
        public AsyncOpResult openValueResultRetVal;
        public const string errorMsg = "UnitTestMock";
        public void PrepareTest(AsyncOpResult r) {
            openValueCall = 0;
            closeValueCall = 0;
            openValueResultRetVal = r;
        }
    }

    [TestFixture]
    public class PrimaryDataTests {
        private Stock _testStock;

        [TestFixtureSetUp]
        public void SetUp() {
            AbstractStockProfile p = new BasicStockProfile("PrimaryDataTest", "PrimaryDataTest", StockProfileFlags.None, 1);
            _testStock = p.CreatePrimary(StockExchange.T, StockExchangeSubType.Ichibu, StockFlags.None);
        }

        [Test]
        public void Synchronous() {
            //PȗFIюs
            UnitTestMockPrimaryDataProvider pr = new UnitTestMockPrimaryDataProvider();
            UnitTestMockPrimaryData dt = null;
            string msg = null;

            //s
            pr.PrepareTest(AsyncOpResult.Failed);
            pr.Open(_testStock, ref dt, ref msg);

            Assert.IsNull(dt);
            Assert.AreEqual(msg, UnitTestMockPrimaryDataProvider.errorMsg);
            pr.AssertStockEntryIsNull(_testStock);
            Assert.AreEqual(1, pr.openValueCall);
            Assert.AreEqual(0, pr.closeValueCall);

            //
            pr.PrepareTest(AsyncOpResult.Succeeded);
            pr.Open(_testStock, ref dt, ref msg);

            Assert.IsNotNull(dt);
            pr.AssertStockEntry(_testStock, 1, PrimaryDataStatus.OK);
            Assert.AreEqual(1, pr.openValueCall);
            Assert.AreEqual(0, pr.closeValueCall);
            Assert.AreEqual(dt, pr.Lookup(_testStock));

        }

        [Test]
        public void AsynchronousOpenAndClose() {
            //PȔ񓯊Bۂɂ͂Ƃ悭P[X
            UnitTestMockPrimaryDataProvider pr = new UnitTestMockPrimaryDataProvider();
            UnitTestMockPrimaryData dt = null;
            string msg = null;

            pr.PrepareTest(AsyncOpResult.Async);
            AsyncOpResult ar = pr.Open(_testStock, ref dt, ref msg);
            //̎_łAsync
            Assert.AreEqual(AsyncOpResult.Async, ar);
            Assert.IsNotNull(dt);
            Assert.AreEqual(PrimaryDataStatus.Preparing, dt.DataStatus);
            pr.AssertStockEntry(_testStock, 1, PrimaryDataStatus.Preparing);
            Assert.AreEqual(1, pr.openValueCall);
            Assert.AreEqual(0, pr.closeValueCall);
            Assert.IsNull(pr.Lookup(_testStock)); //f[^͏Ȃ̂Ŏ擾ł
            
            //񓯊
            pr.CompleteAsyncLoad(_testStock);
            Assert.IsNotNull(pr.Lookup(_testStock));
            pr.AssertStockEntry(_testStock, 1, PrimaryDataStatus.OK);

            //
            pr.PrepareTest(AsyncOpResult.Async);
            pr.Release(_testStock);
            Assert.AreEqual(0, pr.openValueCall);
            Assert.AreEqual(1, pr.closeValueCall);
            Assert.IsNull(pr.Lookup(_testStock));
            pr.AssertStockEntryIsNull(_testStock);
        }

        [Test]
        public void AsynchronousOpenAndFail() {
            //PɊJĔ񓯊s
            UnitTestMockPrimaryDataProvider pr = new UnitTestMockPrimaryDataProvider();
            UnitTestMockPrimaryData dt = null;
            string msg = null;

            pr.PrepareTest(AsyncOpResult.Async);
            AsyncOpResult ar = pr.Open(_testStock, ref dt, ref msg);

            //񓯊s
            pr.FailAsyncLoad(_testStock);
            Assert.IsNull(pr.Lookup(_testStock));
            Assert.AreEqual(PrimaryDataStatus.Error, dt.DataStatus);
            Assert.AreEqual(UnitTestMockPrimaryDataProvider.errorMsg, dt.lastErrorMsg);
            Assert.AreEqual(UnitTestMockPrimaryDataProvider.errorMsg, dt.DataChangeTag.ErrorMessage);
            Assert.AreEqual(1, dt.errorCount);
            pr.AssertStockEntryIsNull(_testStock);
        }

        [Test]
        public void RefCount() {
            //IĂ...
            UnitTestMockPrimaryDataProvider pr = new UnitTestMockPrimaryDataProvider();
            UnitTestMockPrimaryData dt = null;
            string msg = null;

            pr.PrepareTest(AsyncOpResult.Succeeded);
            pr.Open(_testStock, ref dt, ref msg);
            Assert.AreEqual(1, pr.openValueCall);
            Assert.AreEqual(0, pr.closeValueCall);

            //Qڂ̃I[v
            pr.Open(_testStock, ref dt, ref msg);
            Assert.AreEqual(1, pr.openValueCall);
            Assert.AreEqual(0, pr.closeValueCall);
            pr.AssertStockEntry(_testStock, 2, PrimaryDataStatus.OK); //QƃJEg͑Ă邪AopenValue͌Ă΂ĂȂ

            //P񃊃[X
            pr.Release(_testStock);
            pr.AssertStockEntry(_testStock, 1, PrimaryDataStatus.OK);
            Assert.AreEqual(1, pr.openValueCall);
            Assert.AreEqual(0, pr.closeValueCall);

            //PŖ{ɉ
            pr.Release(_testStock);
            pr.AssertStockEntryIsNull(_testStock);
            Assert.AreEqual(1, pr.openValueCall);
            Assert.AreEqual(1, pr.closeValueCall);
        }

        [Test]
        public void DuplicatedConnect() {
            //ʑ҂ɃI[vdȂƂ͎QƃJEgB̌㐬Ȃ炻̂܂܃JEgQŐȏԁB̌㎸sȂʏ̎sB
            UnitTestMockPrimaryDataProvider pr = new UnitTestMockPrimaryDataProvider();
            UnitTestMockPrimaryData dt = null;
            string msg = null;

            pr.PrepareTest(AsyncOpResult.Async);
            AsyncOpResult ar = pr.Open(_testStock, ref dt, ref msg);
            Assert.AreEqual(1, pr.openValueCall);
            Assert.AreEqual(0, pr.closeValueCall);
            ar = pr.Open(_testStock, ref dt, ref msg);
            Assert.AreEqual(AsyncOpResult.Async, ar); //񓯊dĂ͂
            Assert.AreEqual(1, pr.openValueCall); //openValue͂P̂
            Assert.AreEqual(0, pr.closeValueCall);
            pr.AssertStockEntry(_testStock, 2, PrimaryDataStatus.Preparing);
            
            //񓯊
            pr.CompleteAsyncLoad(_testStock);
            Assert.IsNotNull(pr.Lookup(_testStock));
            pr.AssertStockEntry(_testStock, 2, PrimaryDataStatus.OK);


            //㔼 dI[v㎸s
            pr = new UnitTestMockPrimaryDataProvider();
            pr.PrepareTest(AsyncOpResult.Async);
            pr.Open(_testStock, ref dt, ref msg);
            pr.Open(_testStock, ref dt, ref msg);
            pr.FailAsyncLoad(_testStock);
            pr.AssertStockEntryIsNull(_testStock);
            Assert.AreEqual(1, dt.errorCount); //G[ʒm͂P̂
        }

        [Test]
        public void ReleasePreparingStatus() {
            //2008N8`9̐݌vǂŒǉB
            //ʑ҂Ԃ[XƂ́AN[Yʂ܂ŒxBPrimaryDataɂ͒ʒm𑗂ȂB
            //xĂԂɍēxI[vꍇ͒ʏPrepareԂɑJځB
            UnitTestMockPrimaryDataProvider pr = new UnitTestMockPrimaryDataProvider();
            UnitTestMockPrimaryData dt = null;
            string msg = null;

            pr.PrepareTest(AsyncOpResult.Async);
            AsyncOpResult ar = pr.Open(_testStock, ref dt, ref msg);
            pr.Release(_testStock);
            Assert.AreEqual(1, pr.openValueCall);
            Assert.AreEqual(0, pr.closeValueCall);
            Assert.AreEqual(0, dt.errorCount);
            pr.AssertStockEntry(_testStock, 0, PrimaryDataStatus.Preparing);

            //ŌʔF̃P[X
            pr.CompleteAsyncLoad(_testStock);
            Assert.AreEqual(1, pr.openValueCall);
            Assert.AreEqual(1, pr.closeValueCall); //N[YĂ΂Ă͂
            Assert.AreEqual(0, dt.errorCount);
            pr.AssertStockEntryIsNull(_testStock);

            //s̃P[X
            pr = new UnitTestMockPrimaryDataProvider();

            pr.PrepareTest(AsyncOpResult.Async);
            ar = pr.Open(_testStock, ref dt, ref msg);
            pr.Release(_testStock);

            pr.FailAsyncLoad(_testStock);
            Assert.AreEqual(1, pr.openValueCall);
            Assert.AreEqual(0, pr.closeValueCall); //sȂ炻̂܂܃VJgł悢
            Assert.AreEqual(1, dt.errorCount);
            pr.AssertStockEntryIsNull(_testStock);

            //ʑ҂ԁ`[X`I[v̏ꍇ  ʏ̌ʑ҂Ԃł邱
            pr = new UnitTestMockPrimaryDataProvider();

            pr.PrepareTest(AsyncOpResult.Async);
            ar = pr.Open(_testStock, ref dt, ref msg);
            pr.Release(_testStock);
            pr.Open(_testStock, ref dt, ref msg);

            Assert.AreEqual(1, pr.openValueCall);
            Assert.AreEqual(0, pr.closeValueCall);
            Assert.AreEqual(0, dt.errorCount);
            pr.AssertStockEntry(_testStock, 1, PrimaryDataStatus.Preparing);
        }
    }
    


#endif

}
