﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using Bellagio.Environment;

namespace Bellagio.Forms {
    //非同期にデータを受信するパートでエラーが発生したエラーをメッセージボックスで表示する場合、
    //単にメインスレッドをInvokeするとブロック時間が長いし、同時に複数のエラーが起きたときにメッセージボックス連発などでいやらしい。
    //そこで実行時にはいったん表示すべきデータを保持しておき、IdleイベントでUIに表示する手段をとる。
    public class UIError {
        public enum ErrorType {
            FatalExit, //他に優先して表示、かつその後終了
            StockLocalError
        }

        private class Tag {
            public ErrorType _errorType;
            public Form _form;
            public string _message;

            public Tag(ErrorType errorType, Form form, string message) {
                _errorType = errorType;
                _form = form;
                _message = message;
            }
        }

        private List<Tag> _tags;

        public void AttachToApplication() {
            _tags = new List<Tag>();
            Application.Idle += new EventHandler(Check);
        }

        public void ShowLater(ErrorType errorType, Form form, string message) {
            if(_tags==null) return; //UnitTestのときなど、_tags未設定なら何もしない

            if(errorType!=ErrorType.FatalExit && ContainsFatalExitError()) return; //優先度の高いエラーがあるときは無視

            Tag tag = new Tag(errorType, form, message);
            _tags.Add(tag);
        }

        private void Check(object sender, EventArgs args) {
            if(_tags.Count==0) return;

            Tag[] local_tags = _tags.ToArray();
            _tags.Clear(); //以下の動作で再びIdleが来てもクリアされているのでうかつに再帰することはない

            for(int i=0; i<local_tags.Length; i++)
                ShowError(local_tags[i]);
        }

        private void ShowError(Tag tag) {
            if(tag._form==null || tag._form.IsDisposed)
                MessageBox.Show(tag._message, BellagioVersionInfo.APPLICATION_CAPTION, MessageBoxButtons.OK, MessageBoxIcon.Stop);
            else
                MessageBox.Show(tag._form, tag._message, BellagioVersionInfo.APPLICATION_CAPTION, MessageBoxButtons.OK, MessageBoxIcon.Stop);

            if(tag._errorType==ErrorType.FatalExit)
                BellagioPlugin.Instance.PoderosaApplication.ExitApplication();
        }

        private bool ContainsFatalExitError() {
            foreach(Tag tag in _tags)
                if(tag._errorType==ErrorType.FatalExit) return true;

            return false;
        }
    }
}
