/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/ChartSessionBase.cs#13 $
 * $DateTime: 2008/02/19 10:04:20 $
 * 
 * `[gƔ̃ZbVAstatic`[g̃ZbV̋Lp[g
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

using Poderosa;
using Poderosa.Forms;
using Poderosa.Preferences;
using Poderosa.Commands;
using Poderosa.Plugins;
using Poderosa.Sessions;

using Bellagio.Evaluators;
using Bellagio.Environment;
using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Drawing;
using Bellagio.Forms;

namespace Bellagio.Chart {

    public abstract class ChartSessionCreateParamBase {
        private ChartSchema _schema;
        private Stock _stock; //Ԃ̖Fnull̂Ƃ

        public ChartSessionCreateParamBase(ChartSchema schema, Stock stock) {
            _schema = schema;
            _stock = stock;
        }

        public ChartSchema Schema {
            get {
                return _schema;
            }
        }

        public Stock Stock {
            get {
                return _stock;
            }
        }
    }

    //p[^appearanceύXƂɒʒm邽߂̃p[^
    public class ChartPreferenceUpdateInfo : IAdaptable {
        private ChartSchema _schema;
        private List<IndicatorDefinition> _updatedIndicators;
        private bool _updatedAllSchema;
        private bool _updatedAllIndicators; //̃RNV͑ΏۂIndicatorDefinitionw肷P[XB͖őSXV
        private bool _updatedParameters;
        private bool _updatedAppearance;
        private bool _updatedLabel;

        public ChartPreferenceUpdateInfo(ChartSchema schema) {
            _schema = schema;
        }
        public ChartPreferenceUpdateInfo() {
            _schema = null;
            _updatedAllSchema = true;
        }
        public void AddIndicatorDefinition(IndicatorDefinition def) {
            if(_updatedIndicators==null) _updatedIndicators = new List<IndicatorDefinition>();
            _updatedIndicators.Add(def);
        }
        public ChartSchema SourceSchema {
            get {
                return _schema;
            }
        }
        public bool UpdatedAllIndicators {
            get {
                return _updatedAllIndicators;
            }
            set {
                _updatedAllIndicators = value;
            }
        }
        public bool UpdatedParameters {
            get {
                return _updatedParameters;
            }
            set {
                _updatedParameters = value;
            }
        }
        public bool UpdatedAppearance {
            get {
                return _updatedAppearance;
            }
            set {
                _updatedAppearance = value;
            }
        }
        public bool UpdatedAllSchema {
            get {
                return _updatedAllSchema;
            }
            set {
                _updatedAllSchema = value;
            }
        }
        public bool UpdatedLabel {
            get {
                return _updatedLabel;
            }
            set {
                _updatedLabel = value;
            }
        }

        //x[XŁAXVΏۂɂȂĂ邩`FbN 
        public bool ContainsSchema(string schema_full_id) {
            return _updatedAllSchema || _schema.FullID==schema_full_id;
        }

        //XL[}ł͒ʉ߂ĂOŃCWP[^PʂŃ`FbN
        public bool ContainsLocalIndicator(string definition_id) {
            //Ƃindicator܂܂邩ǂ
            if(_updatedAllIndicators) return true;

            if(_updatedIndicators!=null) {
                foreach(IndicatorDefinition def in _updatedIndicators)
                    if(def.id.ParseMandatoryString()==definition_id) return true;
            }
            return false;
        }


        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
    }


    public abstract class ChartSessionBase : BellagioSessionBase {
        protected ChartViewContentBase _internalContent;
        protected ChartDocumentBase _internalDocument;
        protected string _sourceSchemaName; //XL[}͕Ŏ
   
        public ChartSessionBase() {
            _icon = BellagioRoot.CommonIcons.SmallSessions.GetBitmap(0);
        }

        protected void Init(ChartDocumentBase doc, ChartViewContentBase cont, string sourceSchemaName) {
            base.InitContent(cont, new PoderosaChartDocument(this));
            _internalContent = cont;
            _internalDocument = doc;
            _sourceSchemaName = sourceSchemaName;
            _internalDocument.NotifyDelegate = new DataThreadToMainThread(DocumentEventCallback);
        }
        protected void ReplaceDocument(ChartDocumentBase doc) {
            _internalDocument.NotifyDelegate = null;
            _internalDocument = doc;
            _internalDocument.NotifyDelegate = new DataThreadToMainThread(DocumentEventCallback);
        }

        public override void InternalTerminate() {
            base.InternalTerminate();
            _internalDocument.Dispose();
        }

        public ChartDocumentBase ChartDocument {
            get {
                return _internalDocument;
            }
        }
        public Stock CurrentStock {
            get {
                return _internalDocument.CurrentStock;
            }
        }

        public abstract ChartSchema GetSourceSchema();

        //XL[}[hBstatic/intraDay܂悤ȕύX͌ݕs
        public abstract void ReloadSchema(string schema_name, Stock stock);

        public void ReloadData() {
            Stock stock = this.CurrentStock;
            ReloadSchema(_sourceSchemaName, stock);
        }

        //SetCurrentStockDocumentComplete
        //͕\̕ύX菇ɂđ傫|CgB
        //SetCurrentStock͂܂łADocument, ViewContentSetCurrentStock͂̒Ă΂B
        //ADocumentEventCallbackDataSubscriberManagerĂԁACXbhŎsfQ[gŁAʏ̃f[^XVłȂSubscribeCompletȅs
        //ύXꍇA
        // A. f[^̏ɂłĂADataSubscriber.AddSubscriberƓDocumentCompleteꍇ
        // B. 񓯊Ƀf[^̂ŁAf[^XbhDocumentCompleteĂ΂ꂽꍇ
        //̂QB܂Ȁꍇł̂ƂƎŝƂB
        public virtual void SetCurrentStock(Stock stock) {
            //TODO ̏ꍇDocument.SetCurrentStock͐ɏIB̂тPrepareChangeStock / DocumentEvent͂BRg[e؂藣肷̂
            _internalContent.PrepareStockChange();
            _internalDocument.SetCurrentStock(stock);
            if(_sessionHost!=null) //ZbV쐬͂܂쓮łĂȂ
                BellagioPlugin.Instance.SessionManager.RefreshDocumentStatus(this.IPoderosaDocument);
        }
        public virtual void SuspendStock() {
            _internalContent.PrepareStockChange();
            _internalDocument.SuspendStock();
        }
        protected virtual void SubscribeFailed() {
            if(_sessionHost!=null)
                BellagioPlugin.Instance.SessionManager.RefreshDocumentStatus(this.IPoderosaDocument);
        }

        private void DocumentEventCallback() {
            try {
                //܂}i[Iɂ낵ȂAf[^XVłȂSubscribeʒʒm̂ƂɂĂ΂
                _internalContent.DocumentEvent();
                if(_internalDocument.DocumentStatus==BellagioDocumentStatus.Empty)
                    SubscribeFailed();
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }

        protected void CreateDocument(ChartDocumentBase document, ChartSchema schema) {
            document.ConstructWithSchema(schema);
        }


        public override void ReloadPreference(IAdaptable arg) {
            ChartPreferenceUpdateInfo info = (ChartPreferenceUpdateInfo)arg.GetAdapter(typeof(ChartPreferenceUpdateInfo));
            if(info==null) return;

            if(info.ContainsSchema(GetSourceSchema().FullID)) {
                if(info.UpdatedAllIndicators) _internalDocument.ReloadQuote();
                _internalContent.ReloadPreference();

                int old_future_length = _internalDocument.Indicators.FutureLength;
                foreach(RuntimeIndicator ind in _internalDocument.Indicators.Indicators) {
                    StringWithParameterParser parser = new StringWithParameterParser(new ArgumentValueFormatter(ind.EvaluatorContext));
                    parser.AddToStringMap("unit", GetSourceSchema().ChartUnitName); 
                    ind.ReloadPreference(info, _internalDocument.ValueCache, parser);
                }

                if(info.UpdatedAppearance) {
                    ChartDrawing ds = _internalContent.ChartDrawing;
                    int og_count = ds.VisibleOscillatorGroupCount;
                    ds.ResetOscillatorGroups(_internalDocument.OscillatorGroupSet);
                    if(og_count != ds.VisibleOscillatorGroupCount) {
                        //Debug.WriteLine(String.Format("OscillatorCountChange {0}->{1}", og_count, ds.VisibleOscillatorGroupCount));
                        _internalContent.ManualResize(); //\ׂIV[^O[v̐ς\rh
                    }
                }

                if(old_future_length!=_internalDocument.Indicators.FutureLength) {
                    _internalDocument.ResetSectionInfo();
                    _internalContent.AdjustToLatest();
                }


                if(_internalContent.ContainerControl!=null)
                    _internalContent.ManualResize(); //InvalidatełȂƂɒ


            }
        }

    }
}
