/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/IndicatorFigureDrawing.cs#11 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * `[g̕`
 * OmegaChartChartDrawingɑc悪邪ς
 */
using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Diagnostics;

using Sansa.Runtime;
using Travis;
using Travis.LocationOperation;

using Bellagio.Drawing;
using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Forms;

namespace Bellagio.Chart {
    //ChartDrawinĝAl̕`S
    //ANeBuɂȂ̂͂PEBhEɂP
    public class IndicatorFigureDrawingSettings : DrawingSettingsBase {
        public DSBrush textColor; //tƎl{l̐F
        public DSBrush backColor; //GA̔wiF@At@ufBOƌh悵
        public DSBrush draggingBackColor; //hbÔƂ̔wiF
        public DSFont font;
        public DSInt width;  //IndicatorƃtHgvZ
        public DSInt margin;  //Ogƕ̊Ԋu
        //ƃ`[g{̂Əd˂邩ǂAȂ
        public bool enableCredit; //Mpc@͉Bݒ̂Preferenceł͂Ȃ

        public IndicatorFigureDrawingSettings(string id)
            : base(id) {
        }

        protected override void CreateElements() {
            textColor = DefineBrush("textColor", Color.White);
            backColor = DefineBrush("backColor", Color.FromArgb(160, 24, 24, 48));
            draggingBackColor = DefineBrush("draggingBackColor", Color.FromArgb(255, 24, 24, 48));
            font = DefineFont("font", DSFont.GenericFontName, 9);
            width = DefinePositiveInt("width", 220);
            margin = DefineInt("margin", 5);
            enableCredit = BellagioVersionInfo.EDITION==BellagioEditions.DataGetPersonal;
        }
    }


    public class IndicatorFigureDrawing {
        private IndicatorFigureDrawingSettings _settings;
        private int _lastPaintHeight;

        public IndicatorFigureDrawing() {
            _settings = BellagioRoot.FixedPreferences.Chart.IndicatorFigureDrawingSettings;
        }

        public IndicatorFigureDrawingSettings Settings {
            get {
                return _settings;
            }
            set {
                _settings = value;
            }
        }

        public int LastPaintHeight {
            get {
                return _lastPaintHeight;
            }
        }
        public int CalcHeight(Graphics g, RuntimeIndicatorSet indset) {
            int h = DrawStringUtil.GetFontHeightAsInt(_settings.font.F, g);
            //          t S{l o
            _lastPaintHeight = h * (1 + 4 + 1 + (_settings.enableCredit? 2 : 0) + indset.VisibleElementCount) + _settings.margin.V*2;
            return _lastPaintHeight;
        }

        public void Paint(Graphics g, Point location, bool dragging, ref Rectangle clip, IChartDataSource data, ref CHARTPOSITION position) {
            BRect r = new BRect();
            int pitch = DrawStringUtil.GetFontHeightAsInt(_settings.font.F, g);
            int total_height = CalcHeight(g, data.Indicators);
            g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;

            //wi
            r.Set(location.X, location.Y, _settings.width.V, total_height);
            if(r.IntersectsWith(ref clip)) {
                ControlPaint.DrawBorder3D(g, r.Value, Border3DStyle.Sunken);
                Brush bb = dragging? _settings.draggingBackColor.B : _settings.backColor.B;
                g.FillRectangle(bb, r.Value);
            }

            Font f = _settings.font.F;
            Brush db = _settings.textColor.B;
            Candle y = position.IndicatesData?  data.GetCandleAt(position) : null;

            //tƂS{lƏo
            r.Set(r.Left+_settings.margin.V, r.Top+_settings.margin.V, r.Width-_settings.margin.V*2, pitch * (_settings.enableCredit? 8 : 6));
            if(y!=null && r.IntersectsWith(ref clip)) {
                DrawStringUtil.Clipped(g, data.GetTimeLabel(y.Time), f, db, r.Value, r.Left, r.Top); //t܂͎
                DrawCandleFigures(g, data, y, db, r, pitch);
            }

            //indicators
            r.Set(r.Left, r.Bottom, r.Width, pitch * data.Indicators.ElementCount);
            foreach(RuntimeIndicatorElement elem in data.Indicators.Elements) {
                if(elem.Visible) {
                    if(r.IntersectsWith(ref clip)) {
                        SolidBrush br = new SolidBrush(elem.BPenStyle.color);
                        g.DrawString(elem.Label, f, br, r.Left, r.Top);
                        DrawStringUtil.OnCorner(g, FormatIndicatorValue(data, elem, ref position), f, br, r.Right, r.Top, Corners.TopRight);
                        br.Dispose();
                    }
                    r.Top += pitch;
                }
            }
        }

        private void DrawCandleFigures(Graphics g, IChartDataSource data, Candle y, Brush br, BRect r, int pitch) {
            AbstractStockProfile prof = data.Stock.Profile;
            string nil_str = "*";
            DrawCandleFiguresItem(g, "nl", y.IsNil? nil_str : prof.FormatPrice(y.Open), br, r.Left, r.Right, r.Top + pitch);
            DrawCandleFiguresItem(g, "l", y.IsNil? nil_str : prof.FormatPrice(y.High), br, r.Left, r.Right, r.Top + pitch*2);
            DrawCandleFiguresItem(g, "l", y.IsNil? nil_str : prof.FormatPrice(y.Low), br, r.Left, r.Right, r.Top + pitch*3);
            DrawCandleFiguresItem(g, "Il", y.IsNil? nil_str : prof.FormatPrice(y.Close), br, r.Left, r.Right, r.Top + pitch*4);
            DrawCandleFiguresItem(g, "o", y.IsNil? nil_str : y.Volume.ToString(), br, r.Left, r.Right, r.Top + pitch*5);
            if(_settings.enableCredit) {
                DrawCandleFiguresItem(g, "Mpc", y.IsNil? nil_str : y.CreditLong.ToString(), br, r.Left, r.Right, r.Top + pitch*6);
                DrawCandleFiguresItem(g, "Mpc", y.IsNil? nil_str : y.CreditShort.ToString(), br, r.Left, r.Right, r.Top + pitch*7);
            }
        }
        private void DrawCandleFiguresItem(Graphics g, string label, string text, Brush br, int left, int right, int y) {
            g.DrawString(label, _settings.font.F, br, left, y);
            DrawStringUtil.OnCorner(g, text, _settings.font.F, br, right, y, Corners.TopRight);
        }


        private string FormatIndicatorValue(IChartDataSource data, RuntimeIndicatorElement elem, ref CHARTPOSITION pos) {
            if(pos.IndicatesData || elem.FutureLength > 0) {
                double value = data.GetIndicatorValue(elem, pos);
                if(!Double.IsNaN(value)) {
                    return elem.Container.Location.FormatForFigure(value);
                }
            }

            return "*";
        }
    }

    //`̈ʒuD&D
    public class IndicatorFigureDrawingPosition {
        //ʒu̓`[g{̂̎l̂ꂩ̑Έʒu
        private RectCorner _posCorner;
        private Point _posOffset;
        private bool _dragging;
        private Point _dragStartPoint;

        public IndicatorFigureDrawingPosition() {
            _posCorner = RectCorner.BottomLeft;
            _posOffset = new Point(16, -16); //lPreferenceĂ悢
        }
        public bool IsDragging {
            get {
                return _dragging;
            }
        }
        public void SetPosition(RectCorner corner, Point posOffset) {
            _posCorner = corner;
            _posOffset = posOffset;
        }
        public Point GetDrawPoint(BRect chart_rect, Size size) {
            Point pt = chart_rect.GetCorner(_posCorner);
            pt.Offset(_posOffset);
            if(_posCorner==RectCorner.BottomRight || _posCorner==RectCorner.TopRight) pt.X -= size.Width;
            if(_posCorner==RectCorner.BottomLeft || _posCorner==RectCorner.BottomRight) pt.Y -= size.Height;
            if(_dragging) {
                Point mousePos = Control.MousePosition;
                pt.Offset(mousePos.X - _dragStartPoint.X, mousePos.Y - _dragStartPoint.Y);
                return pt;
            }
            else {
                //ʊOɏoȂ悤
                if(pt.X < 0) pt.X = 0;
                if(pt.X > chart_rect.Right - size.Width) pt.X = chart_rect.Right - size.Width;
                if(pt.Y < 0) pt.Y = 0;
                if(pt.Y > chart_rect.Bottom - size.Height) pt.Y = chart_rect.Bottom - size.Height;
                return pt;
            }
        }
        //XN[WŃZbg
        public void StartDrag(Point drag_start_pos) {
            _dragging = true;
            _dragStartPoint = drag_start_pos;
        }
        public void EndDrag(BRect chart_rect, Point drag_end_pos, Size size) {
            _dragging = false;
            Point mousePos = Control.MousePosition;
            _posOffset.X += mousePos.X - _dragStartPoint.X;
            _posOffset.Y += mousePos.Y - _dragStartPoint.Y;

            //l̍ł߂ʒuɃZbgĊm肳
            BRect r = new BRect(GetDrawPoint(chart_rect, size), size);
            SizeComp[] comps = new SizeComp[4];
            comps[0].Set(RectCorner.TopLeft, chart_rect, r);
            comps[1].Set(RectCorner.TopRight, chart_rect, r);
            comps[2].Set(RectCorner.BottomLeft, chart_rect, r);
            comps[3].Set(RectCorner.BottomRight, chart_rect, r);

            int result_index = -1;
            int value = Int32.MaxValue;
            for(int i=0; i<comps.Length; i++) {
                int d = Math.Abs(comps[i].offset.X) + Math.Abs(comps[i].offset.Y);
                if(value > d) {
                    value = d;
                    result_index = i; //ŏlXV
                }
            }
            Debug.Assert(result_index >= 0);
            _posCorner = comps[result_index].corner;
            _posOffset = comps[result_index].offset;
        }
        private struct SizeComp {
            public RectCorner corner;
            public Point offset;
            public void Set(RectCorner c, BRect chart_rect, BRect figure_rect) {
                corner = c;
                Point pc = chart_rect.GetCorner(corner);
                Point pf = figure_rect.GetCorner(corner);
                offset = new Point(pf.X - pc.X, pf.Y - pc.Y);
            }
        }
    }
}
