/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Forms/VolumeInputBox.cs#12 $
 * $DateTime: 2008/01/28 14:58:16 $
 */
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace Bellagio.Forms {

    public class VolumeInputBox : TextBox {

        public delegate void ValueChangeByKeyDelegate(int newvalue);
        public delegate void UnitChangeDelegate(bool increment);

        public VolumeInputBox() {
            ReadOnly = true; //ReadOnlyɂĂAKvȃL[݂̂Ǝɏ
            BackColor = SystemColors.Window;
            ForeColor = SystemColors.WindowText;
            ContextMenuStrip = new ContextMenuStrip(); //nullݒ肷̂ł̓ftHg̃j[\Ă܂
            TextAlign = HorizontalAlignment.Right;
            MaxLength = 10;
            MaximumValue = 100000000;
        }

        //ŗL̃vpeB
        private int _zeroFixedDigits; //OŌŒ肷邩BPʊɂČ܂
        private string _savedValue; //tH[JXl̃eLXg
        private int _maximumValue; //ݒ\ől

        private ValueChangeByKeyDelegate _valueChangeByKey;
        private UnitChangeDelegate _unitChange;

        public int ZeroFixedDigits {
            get {
                return _zeroFixedDigits;
            }
            set {
                _zeroFixedDigits = value;
            }
        }
        public int MaximumValue {
            get {
                return _maximumValue;
            }
            set {
                _maximumValue = value;
            }
        }
        public int UnitValue {
            get {
                int r = 1;
                for(int i=0; i<ZeroFixedDigits; i++) r *= 10;
                return r;
            }
        }
        public ValueChangeByKeyDelegate ValueChangeByKey {
            get {
                return _valueChangeByKey;
            }
            set {
                _valueChangeByKey = value;
            }
        }
        public UnitChangeDelegate UnitChangeHandler {
            get {
                return _unitChange;
            }
            set {
                _unitChange = value;
            }
        }

        public int GetTextAsInt() {
            return GetTextAsInt(this.Text);
        }
        private int GetTextAsInt(string text) {
            int v = 0;
            foreach(char ch in text) {
                if('0' <= ch && ch <='9') {
                    v = v * 10 + (ch-'0');
                }
            }
            return v;
        }

        public void SetTextByInt(int value) {
            if(value==0) {
                this.Text = new String('0', _zeroFixedDigits);
                return;
            }

            StringBuilder bld = new StringBuilder();
            string src = value.ToString();

            int index = 0;
            int rest = src.Length;
            while(rest > 0) {
                int l = rest % 3;
                if(l==0) l = 3;

                if(bld.Length>0) bld.Append(',');
                bld.Append(src.Substring(index, l));
                index += l;
                rest -= l;
            }

            this.Text = bld.ToString();
        }
        

        protected override void OnGotFocus(EventArgs e) {
            base.OnGotFocus(e);
            _savedValue = this.Text;
            int len = this.Text.Length - _zeroFixedDigits;
            if(len > 0) {
                this.SelectionStart = 0;
                this.SelectionLength = len;
            }
        }

        protected override bool IsInputKey(Keys keyData) {
            if(keyData==Keys.Up || keyData==Keys.Down || keyData==Keys.Oemplus || keyData==Keys.OemMinus) {
                return false;
            }
            else
                return base.IsInputKey(keyData);
        }

        protected override bool ProcessDialogKey(Keys keyData) {
            //Debug.WriteLine("Sel " + this.SelectionStart + " " + this.SelectionLength);

            Keys k = keyData & Keys.KeyCode;
            if(Keys.D0 <= k && k <=Keys.D9)
                ProcessNumKey(k-Keys.D0);
            else if(Keys.NumPad0 <= k && k<=Keys.NumPad9)
                ProcessNumKey(k-Keys.NumPad0);
            else if(k==Keys.Delete)
                ProcessDeleteKey(true);
            else if(k==Keys.Back)
                ProcessDeleteKey(false);
            else if(k==(Keys.Escape|Keys.Shift)) //PƃGXP[v̓tH[N[YɎgB
                this.Text = _savedValue;
            else if(_unitChange!=null) {
                if(k==Keys.Up || k==Keys.Oemplus || k==Keys.Add)
                    _unitChange(true);
                else if(k==Keys.Down || k==Keys.OemMinus || k==Keys.Subtract)
                    _unitChange(false);
                else
                    return base.ProcessDialogKey(keyData);
            }
            else
                return base.ProcessDialogKey(keyData);

            return true; //OL[ׂ͂ĂȂ
        }

        private void ProcessNumKey(int value) {
            //SelectionStart/Length̑gƁAI͋ʂłȂBA͂łʂ̕Kv͂ȂI

            string current = this.Text;
            if(this.SelectionLength==0 && current.Length==this.MaxLength) return; //

            int ss = this.SelectionStart; //selection start
            int se = this.SelectionStart + this.SelectionLength; //selection end
            if(value==0 && ss==0) return; //[ł̂O͂͂Ȃ

            int right = current.Length - se; //ẼLbgʒuێ
            StringBuilder bld = new StringBuilder();
            if(right < _zeroFixedDigits) {
                if(this.SelectionLength!=current.Length) return;
                bld.Append((char)('0'+value));
                for(int i=0; i<_zeroFixedDigits; i++) bld.Append('0');
                right = _zeroFixedDigits;
            }
            else {
                if(ss>0) bld.Append(current.Substring(0, ss));
                bld.Append((char)('0'+value));
                if(se < current.Length) bld.Append(current.Substring(se));
            }

            int newvalue = GetTextAsInt(bld.ToString());
            if(newvalue > _maximumValue) return;
            SetTextByInt(newvalue); //ƂĂ͐蔲
            if(_valueChangeByKey!=null) _valueChangeByKey(newvalue);

            this.SelectionStart = Math.Max(0, this.Text.Length - right); 
            this.SelectionLength = 0;
        }
        private void ProcessDeleteKey(bool is_delete) { //RxVIɂ悭ȂADeleteL[̂Ƃtrue, BackspacêƂfalseBႢô͑Ï悪ȂƂ̂
            string current = this.Text;
            if(is_delete && current.Length==this.SelectionStart) return; //Del:E[ł͖
            if(!is_delete && 0==this.SelectionStart) return; //BackSpace:[ł͖

            int ss = this.SelectionStart;

            int t = current.Length - ss - this.SelectionLength; //ẼLbgʒuێ

            int sl = this.SelectionLength;
            if(sl==0) { //ꂪʏ펞Bׂ̈ݒ
                if(is_delete) {
                    sl = 1;
                    t--;
                    if(current[ss]==',') { sl++; t--; }
                }
                else { //backspace
                    sl = 1;
                    ss--;
                    if(ss>=0 && current[ss]==',') { sl++; ss--; }
                }
            }
            if(ss<0 || t < _zeroFixedDigits) return; //擪܂͌Œ蕔̂ƂNG

            StringBuilder bld = new StringBuilder();
            if(ss>0) bld.Append(current.Substring(0, ss));
            if(ss+sl<current.Length) bld.Append(current.Substring(ss + sl));

            int newvalue = GetTextAsInt(bld.ToString());
            SetTextByInt(newvalue); //ƂĂ͐蔲
            if(_valueChangeByKey!=null) _valueChangeByKey(newvalue);
            this.SelectionStart = Math.Max(0, this.Text.Length - t);
            this.SelectionLength = 0;
        }
    }
}