//css_reference Microsoft.DirectX.Direct3DX;

using System;
using System.Collections.Generic;
using System.IO;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

using TDCG;
using TDCGUtils;
using Tso2Pmd;

namespace TDCG.PhysObTemplate
{
    public class Chichi_Soft : IPhysObTemplate
    {
        string name = "ՂՂ";   // gɕ\閼O
        int group = 1;          // \g̎ށi0: 1: 2:XJ[g 3:̑j

        public string Name() { return name; }
        public int Group() { return group; }

        public void Execute(ref T2PPhysObjectList phys_list)
        {
            phys_list.MakeChain("EP");
            phys_list.MakeChain("P");
        
            SetParameter(phys_list.GetBodyListByName(".."));
            SetParameterEnd(phys_list.GetBodyListByName("."));
            SetParameter(phys_list.GetJointListByName(".."));
            phys_list.GetBodyByName("EP").type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("P").type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]

            float min = Geometry.DegreeToRadian(-10.0f);
            float max = Geometry.DegreeToRadian(+10.0f);

            Vector3 rotation_min = new Vector3(min, min, min);
            Vector3 rotation_max = new Vector3(max, max, max);

            phys_list.GetJointByName("EP-EQ").rotation_min = rotation_min;
            phys_list.GetJointByName("EP-EQ").rotation_max = rotation_max;

            phys_list.GetJointByName("P-Q").rotation_min = rotation_min;
            phys_list.GetJointByName("P-Q").rotation_max = rotation_max;

            phys_list.GetJointByName("EQ-ER").rotation_min = rotation_min;
            phys_list.GetJointByName("EQ-ER").rotation_max = rotation_max;

            phys_list.GetJointByName("Q-R").rotation_min = rotation_min;
            phys_list.GetJointByName("Q-R").rotation_max = rotation_max;
        }

        private void SetParameter(List<PMD_RBody> body_list)
        {
            foreach (PMD_RBody body in body_list)
            {
                body.group_id = 3; // f[^FO[v // 00
                body.group_non_collision = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_id = 2; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.size.X = 0.2f; // `Fa() // CD CC CC 3F // 1.6

                body.weight = 0.1f; // f[^F // 00 00 80 3F // 1.0
                body.position_dim = 0.5f; // f[^Fړ // 00 00 00 00
                body.rotation_dim = 0.5f; // f[^F] // 00 00 00 00
                body.recoil = 0.0f; // f[^F // 00 00 00 00
                body.friction = 0.0f; // f[^FC // 00 00 00 00
                body.type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        private void SetParameterEnd(List<PMD_RBody> body_list)
        {
            foreach (PMD_RBody body in body_list)
            {
                body.group_id = 3; // f[^FO[v // 00
                body.group_non_collision = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_id = 0; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.size.X = 0.2f; // `Fa() // CD CC CC 3F // 1.6

                body.weight = 0.01f; // f[^F // 00 00 80 3F // 1.0
                body.position_dim = 0.5f; // f[^Fړ // 00 00 00 00
                body.rotation_dim = 0.5f; // f[^F] // 00 00 00 00
                body.recoil = 0.0f; // f[^F // 00 00 00 00
                body.friction = 0.0f; // f[^FC // 00 00 00 00
                body.type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        private void SetParameter(List<PMD_Joint> joint_list)
        {
            foreach (PMD_Joint joint in joint_list)
            {
                joint.spring_rotation = new Vector3(200.0f, 200.0f, 200.0f);
            }
        }
    }
}
