using System;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace TDCG
{
    /// <summary>
    /// J
    /// </summary>
public class Camera
{
    internal Vector3 center = Vector3.Empty;
    /// <summary>
    /// ]S
    /// </summary>
    public Vector3 Center { get { return center; } set { center = value; } }

    internal Vector3 translation = Vector3.Empty;
    /// <summary>
    /// viewW̃J̈ʒu
    /// </summary>
    public Vector3 Translation { get { return translation; } set { translation = value; } }

    internal Vector3 camPosL = new Vector3(0.0f, 0.0f, -10.0f);
    /// <summary>
    /// __ƂW̃J̈ʒu
    /// </summary>
    public Vector3 CamPosL { get { return camPosL; } set { camPosL = value; } }
    
    internal Vector3 camDirDef = Vector3.Empty; //JړxNg
    internal float offsetZ = 0.0f;      //JsItZbgl
    internal bool needUpdate = true;    //XV
    internal Matrix viewMat = Matrix.Identity;  //r[s

    internal Matrix camPoseMat = Matrix.Identity;
    /// <summary>
    /// J̎ps
    /// </summary>
    public Matrix CamPoseMat { get { return camPoseMat; } set { camPoseMat = value; } }

    internal float camZRotDef = 0.0f;   //J Z]
    internal float camAngleUnit = 0.02f;        //ړ]PʁiWAj

    /// <summary>
    /// J𐶐܂B
    /// </summary>
    public Camera()
    {
        motion = new CameraMotion(this);
    }

    /// <summary>
    /// J̈ʒuƎpWo͂֏o܂B
    /// </summary>
    public void Dump()
    {
        XmlSerializer serializer = new XmlSerializer(typeof(Camera));
        XmlWriterSettings settings = new XmlWriterSettings();
        settings.Encoding = Encoding.GetEncoding("Shift_JIS");
        settings.Indent = true;
        XmlWriter writer = XmlWriter.Create(Console.Out, settings);
        serializer.Serialize(writer, this);
        writer.Close();
    }

    /// <summary>
    /// J̈ʒuƎpwpX֏o܂B
    /// </summary>
    /// <param name="dest_file">pX</param>
    public void Save(string dest_file)
    {
        XmlSerializer serializer = new XmlSerializer(typeof(Camera));
        XmlWriterSettings settings = new XmlWriterSettings();
        settings.Encoding = Encoding.GetEncoding("Shift_JIS");
        settings.Indent = true;
        XmlWriter writer = XmlWriter.Create(dest_file, settings);
        serializer.Serialize(writer, this);
        writer.Close();
    }

    /// <summary>
    /// J̈ʒuƎpwpXǂݍ݂܂B
    /// </summary>
    /// <param name="source_file">pX</param>
    /// <returns>J</returns>
    public static Camera Load(string source_file)
    {
        XmlReader reader = XmlReader.Create(source_file);
        XmlSerializer serializer = new XmlSerializer(typeof(Camera));
        Camera camera = serializer.Deserialize(reader) as Camera;
        reader.Close();
        return camera;
    }

    /// <summary>
    /// J̈ʒuƎp⊮܂B
    /// </summary>
    /// <param name="cam1">ԊJn̈ʒupێJ</param>
    /// <param name="cam2">ԏÏʒupێJ</param>
    /// <param name="ratio">Ԕ䗦</param>
    /// <returns>J</returns>
    public static Camera Interpolation(Camera cam1, Camera cam2, float ratio)
    {
        Camera camera = new Camera();
        camera.Center = Vector3.Lerp(cam1.Center, cam2.Center, ratio);
        camera.Translation = Vector3.Lerp(cam1.Translation, cam2.Translation, ratio);
        camera.CamPosL = Vector3.Lerp(cam1.CamPosL, cam2.CamPosL, ratio);
        Quaternion q1 = Quaternion.RotationMatrix(cam1.CamPoseMat);
        Quaternion q2 = Quaternion.RotationMatrix(cam2.CamPoseMat);
        camera.CamPoseMat = Matrix.RotationQuaternion(Quaternion.Slerp(q1, q2, ratio));
        return camera;
    }

    /// <summary>
    /// J̈ʒuƎp⊮܂B
    /// </summary>
    /// <param name="cam1">ԊJn̈ʒupێJ</param>
    /// <param name="cam2">ԏÏʒupێJ</param>
    /// <param name="ratio">Ԕ䗦</param>
    public void Interp(Camera cam1, Camera cam2, float ratio)
    {
        center = Vector3.Lerp(cam1.Center, cam2.Center, ratio);
        translation = Vector3.Lerp(cam1.Translation, cam2.Translation, ratio);
        camPosL = Vector3.Lerp(cam1.CamPosL, cam2.CamPosL, ratio);
        Quaternion q1 = Quaternion.RotationMatrix(cam1.CamPoseMat);
        Quaternion q2 = Quaternion.RotationMatrix(cam2.CamPoseMat);
        camPoseMat = Matrix.RotationQuaternion(Quaternion.Slerp(q1, q2, ratio));

        //viewsXV
        Vector3 posW = camPosL + center;
        {
            Matrix m = camPoseMat;
            m.M41 = posW.X;
            m.M42 = posW.Y;
            m.M43 = posW.Z;
            m.M44 = 1.0f;
            viewMat = Matrix.Invert(m) * Matrix.Translation(-translation);
        }

        //Zbg
        ResetDefValue();
        needUpdate = false;
    }

    /// <summary>
    /// J̈ʒuƎpZbg܂B
    /// </summary>
    public void Reset()
    {
        center = Vector3.Empty;
        translation = Vector3.Empty;
        camPosL = new Vector3(0.0f, 0.0f, -10.0f);
        camPoseMat = Matrix.Identity;
        needUpdate = true;
    }

    /// <summary>
    /// J̈ʒuXV܂B
    /// </summary>
    /// <param name="camDirX">ړioxj</param>
    /// <param name="camDirY">ړiܓxj</param>
    /// <param name="offsetZ">sItZbgl</param>
    public void Move(float camDirX, float camDirY, float offsetZ)
    {
        if (camDirX == 0.0f && camDirY == 0.0f && offsetZ == 0.0f)
            return;

        camDirDef.X += camDirX;
        camDirDef.Y += camDirY;
        this.offsetZ += offsetZ;
        needUpdate = true;
    }

    /// <summary>
    /// JZ]܂B
    /// </summary>
    /// <param name="radian">]pxiWAj</param>
    public void RotZ(float radian)
    {
        if (radian == 0.0f)
            return;

        camZRotDef = radian;
        needUpdate = true;
    }

    /// <summary>
    /// J̈ʒuƎpXV܂B
    /// }EX̉]S͌_ɃZbg܂B
    /// ӁF̑ Move() RotZ() Update() Ƃ͈قȂnłB
    /// </summary>
    /// <param name="eye">_</param>
    /// <param name="center">viewW̃J̈ʒu</param>
    /// <param name="up">xNg</param>
    public void LookAt(Vector3 eye, Vector3 center, Vector3 up)
    {
        this.camPosL = center - eye;
        {
            // JpXV
            Vector3 z = Vector3.Normalize(-camPosL);
            Vector3 y = up;
            Vector3 x = Vector3.Normalize(Vector3.Cross(y, z));
            y = Vector3.Normalize(Vector3.Cross(z, x));
            {
                Matrix m = Matrix.Identity;
                m.M11 = x.X;
                m.M12 = x.Y;
                m.M13 = x.Z;
                m.M21 = y.X;
                m.M22 = y.Y;
                m.M23 = y.Z;
                m.M31 = z.X;
                m.M32 = z.Y;
                m.M33 = z.Z;
                this.camPoseMat = m;
            }
        }
        this.center = Vector3.Empty;
        this.translation = eye;

        //viewsXV
        Vector3 posW = camPosL + this.center;
        {
            Matrix m = camPoseMat;
            m.M41 = posW.X;
            m.M42 = posW.Y;
            m.M43 = posW.Z;
            m.M44 = 1.0f;
            viewMat = Matrix.Invert(m) * Matrix.Translation(-translation);
        }

        //Zbg
        ResetDefValue();
        needUpdate = false;
    }

    /// <summary>
    /// J̈ʒuƎpXV܂B
    /// }EX̉]S͌_ɃZbg܂B
    /// ӁF̑ Move() RotZ() Update() Ƃ͈قȂnłB
    /// </summary>
    /// <param name="eye">_</param>
    /// <param name="center">viewW̃J̈ʒu</param>
    public void LookAt(Vector3 eye, Vector3 center)
    {
        LookAt(eye, center, new Vector3(0.0f, 1.0f, 0.0f));
    }

    public Vector3 GetCamZAxis()
    {
        return new Vector3(camPoseMat.M31, camPoseMat.M32, camPoseMat.M33);
    }

    public Vector3 GetCamYAxis()
    {
        return new Vector3(camPoseMat.M21, camPoseMat.M22, camPoseMat.M23);
    }

    /// <summary>
    /// J̈ʒuƎpXV܂B
    /// </summary>
    public void Update()
    {
        if (! needUpdate)
            return;

        //J Z]ŎpXV
        camPoseMat = Matrix.RotationZ(camZRotDef) * camPoseMat;

        //ܓxox̍ړ
        Vector3 dL = Vector3.TransformCoordinate(camDirDef, camPoseMat);
        if (dL.X != 0.0f || dL.Y != 0.0f || dL.Z != 0.0f)
        {
            //JʒuXV
            Vector3 camZAxis = GetCamZAxis();
            Vector3 rotAxis = Vector3.Cross(dL, camZAxis);
            Quaternion q = Quaternion.RotationAxis(rotAxis, camAngleUnit * camDirDef.Length());
            Matrix rotMat = Matrix.RotationQuaternion(q);
            camPosL = Vector3.TransformCoordinate(camPosL, rotMat);

            //JpXV
            Vector3 z = Vector3.Normalize(-camPosL);
            Vector3 y = GetCamYAxis();
            Vector3 x = Vector3.Normalize(Vector3.Cross(y, z));
            y = Vector3.Normalize(Vector3.Cross(z, x));
            {
                Matrix m = Matrix.Identity;
                m.M11 = x.X;
                m.M12 = x.Y;
                m.M13 = x.Z;
                m.M21 = y.X;
                m.M22 = y.Y;
                m.M23 = y.Z;
                m.M31 = z.X;
                m.M32 = z.Y;
                m.M33 = z.Z;
                camPoseMat = m;
            }
        }

        //sItZbgXV
        if (offsetZ != 0.0f && camPosL.Length() - offsetZ > 0)
        {
            Vector3 z = Vector3.Normalize(-camPosL);
            camPosL += offsetZ * z;
        }

        //viewsXV
        Vector3 posW = camPosL + center;
        {
            Matrix m = camPoseMat;
            m.M41 = posW.X;
            m.M42 = posW.Y;
            m.M43 = posW.Z;
            m.M44 = 1.0f;
            viewMat = Matrix.Invert(m) * Matrix.Translation(-translation);
        }

        //Zbg
        ResetDefValue();
        needUpdate = false;
    }

    /// <summary>
    /// views擾܂B
    /// </summary>
    public Matrix GetViewMatrix()
    {
        return viewMat;
    }

    /// <summary>
    /// ]Sݒ肵܂B
    /// </summary>
    /// <param name="center">]S</param>
    public void SetCenter(Vector3 center)
    {
        this.center = center;
        needUpdate = true;
    }

    /// <summary>
    /// viewẄʒuݒ肵܂B
    /// </summary>
    /// <param name="translation">viewẄʒu</param>
    public void SetTranslation(Vector3 translation)
    {
        this.translation = translation;
        needUpdate = true;
    }

    /// <summary>
    /// viewWňړ܂B
    /// </summary>
    /// <param name="dx">Xړ</param>
    /// <param name="dy">Yړ</param>
    public void MoveView(float dx, float dy)
    {
        this.translation.X += dx;
        this.translation.Y += dy;
        needUpdate = true;
    }

    /// <summary>
    /// Zbg܂B
    /// </summary>
    protected void ResetDefValue()
    {
        camDirDef = Vector3.Empty;
        offsetZ = 0.0f;
        camZRotDef = 0.0f;
    }

    private CameraMotion motion = null;

    /// <summary>
    /// J[V
    /// </summary>
    public CameraMotion Motion
    {
        get { return motion; }
    }

    /// <summary>
    /// J[Vݒ肵܂B
    /// </summary>
    /// <param name="frame_index">t[ԍ</param>
    /// <param name="eye">_</param>
    /// <param name="center">J̈ʒu</param>
    public void SetMotion(int frame_index, Vector3 eye, Vector3 center)
    {
        motion.Add(frame_index, eye, center);
    }

    /// <summary>
    /// J[Vݒ肵܂B
    /// </summary>
    /// <param name="frame_index">t[ԍ</param>
    /// <param name="eye">_</param>
    /// <param name="center">J̈ʒu</param>
    /// <param name="interp_length">Ԃt[</param>
    public void SetMotion(int frame_index, Vector3 eye, Vector3 center, int interp_length)
    {
        motion.Add(frame_index, eye, center, interp_length);
    }

    /// <summary>
    /// J[Vݒ肵܂B
    /// </summary>
    /// <param name="frame_index">t[ԍ</param>
    /// <param name="eyex">_XW</param>
    /// <param name="eyey">_YW</param>
    /// <param name="eyez">_ZW</param>
    /// <param name="centerx">J̈ʒuXW</param>
    /// <param name="centery">J̈ʒuYW</param>
    /// <param name="centerz">J̈ʒuZW</param>
    public void SetMotion(int frame_index, float eyex, float eyey, float eyez, float centerx, float centery, float centerz)
    {
        motion.Add(frame_index, new Vector3(eyex, eyey, eyez), new Vector3(centerx, centery, centerz));
    }

    /// <summary>
    /// J[Vݒ肵܂B
    /// </summary>
    /// <param name="frame_index">t[ԍ</param>
    /// <param name="eyex">_XW</param>
    /// <param name="eyey">_YW</param>
    /// <param name="eyez">_ZW</param>
    /// <param name="centerx">J̈ʒuXW</param>
    /// <param name="centery">J̈ʒuYW</param>
    /// <param name="centerz">J̈ʒuZW</param>
    /// <param name="interp_length">Ԃt[</param>
    public void SetMotion(int frame_index, float eyex, float eyey, float eyez, float centerx, float centery, float centerz, int interp_length)
    {
        motion.Add(frame_index, new Vector3(eyex, eyey, eyez), new Vector3(centerx, centery, centerz), interp_length);
    }

    /// <summary>
    /// ̃[Vt[ɐi݂܂B
    /// </summary>
    public void NextFrame()
    {
        if (motion.Count != 0)
        {
            motion.NextFrame();
        }
    }
}
}
