using System;
using System.Collections.Generic;
using System.Diagnostics;
//using System.Drawing;
using System.Threading;
//using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace TDCG
{
    /// <summary>
    /// tBMA
    /// </summary>
public class Figure : IDisposable
{
    /// <summary>
    /// tBMAێĂtsoXg
    /// </summary>
    public List<TSOFile> TSOList = new List<TSOFile>();

    Vector3 center = Vector3.Empty;
    /// <summary>
    /// SW
    /// </summary>
    public Vector3 Center
    {
        get { return center; }
    }

    Vector3 translation = Vector3.Empty;
    /// <summary>
    /// ړψ
    /// </summary>
    public Vector3 Translation
    {
        get { return translation; }
    }

    TMOFile tmo = null;
    /// <summary>
    /// tmo
    /// </summary>
    public TMOFile Tmo
    {
        get { return tmo; }
        set
        {
            tmo = value;
            ResetFrameIndex();
            SetCenterToHips();
            tpo_list.Tmo = tmo;
        }
    }

    internal Dictionary<TSONode, TMONode> nodemap;

    private MatrixStack matrixStack = null;
    private int frame_index = 0;
    private int current_frame_index = 0;

    /// <summary>
    /// ̌^XNvg̃Xg
    /// </summary>
    public static ProportionList ProportionList { get; set; }

    TPOFileList tpo_list = new TPOFileList();
    /// <summary>
    /// TPOt@C̃Xg
    /// </summary>
    public TPOFileList TPOList { get { return tpo_list; } }

    /// <summary>
    /// ̌^Vs̃t@C
    /// </summary>
    /// <returns></returns>
    public static string GetTPOConfigPath()
    {
        return Path.Combine(Application.StartupPath, @"TPOConfig.xml");
    }

    /// <summary>
    /// tBMA𐶐܂B
    /// </summary>
    public Figure()
    {
        tmo = new TMOFile();
        nodemap = new Dictionary<TSONode, TMONode>();
        matrixStack = new MatrixStack();

        tpo_list.SetProportionList(ProportionList);

        string config_file = GetTPOConfigPath();
        if (File.Exists(config_file))
        {
            TPOConfig config = TPOConfig.Load(config_file);
            tpo_list.SetRatiosFromConfig(config);
        }
    }

    string[] proportion_names = new string[] {"Age", "Arm", "Leg", "Waist", "Bust", "Eye"};

    /// <summary>
    /// ̌^ό`䗦ݒ肵܂B
    /// </summary>
    public void SetRatios(List<float> ratios)
    {
        for (int i = 0; i < proportion_names.Length; i++)
        {
            tpo_list["TDCG.Proportion." + proportion_names[i]].Ratio = ratios[i] * 2.0f - 1.0f;
        }
    }

    /// <summary>
    /// ̌^ό`s܂B
    /// </summary>
    public void TransformTpo()
    {
        if (tmo.frames == null)
            return;

        tpo_list.Transform();
    }

    /// <summary>
    /// ̌^ό`s܂B
    /// </summary>
    /// <param name="frame_index">t[ԍ</param>
    public void TransformTpo(int frame_index)
    {
        if (tmo.frames == null)
            return;

        tpo_list.Transform(frame_index);
    }
    
    /// <summary>
    /// tBMAړ܂i΍WjB
    /// </summary>
    /// <param name="dx">Xψ</param>
    /// <param name="dy">Yψ</param>
    /// <param name="dz">Zψ</param>
    public void Move(float dx, float dy, float dz)
    {
        Move(new Vector3(dx, dy, dz));
    }

    /// <summary>
    /// tBMAړ܂i΍WjB
    /// </summary>
    /// <param name="delta">ψ</param>
    public void Move(Vector3 delta)
    {
        center += delta;
        translation += delta;
        UpdateBoneMatrices(true);
    }

    /// <summary>
    /// wʒuɂtsöʒuւ܂B`揇ύX܂B
    /// </summary>
    /// <param name="aidx">Xg̈ʒua</param>
    /// <param name="bidx">Xg̈ʒub</param>
    public void SwapAt(int aidx, int bidx)
    {
        Debug.Assert(aidx < bidx);
        TSOFile a = TSOList[aidx];
        TSOFile b = TSOList[bidx];
        TSOList.RemoveAt(bidx);
        TSOList.RemoveAt(aidx);
        TSOList.Insert(aidx, b);
        TSOList.Insert(bidx, a);
    }

    /// <summary>
    /// nodemapbonesXV܂B
    /// tmoǂݍ܂ĂȂꍇ͐擪tso琶܂B
    /// </summary>
    public void UpdateNodeMapAndBoneMatrices()
    {
        if (tmo.frames == null)
            if (TSOList.Count != 0)
            {
                Tmo = GenerateTMOFromTSO(TSOList[0]);
                TransformTpo();
            }

        nodemap.Clear();
        if (tmo.frames != null)
        foreach (TSOFile tso in TSOList)
            AddNodeMap(tso);

        UpdateBoneMatrices(true);
    }

    /// <summary>
    /// tsoɑ΂nodemapǉ܂B
    /// </summary>
    /// <param name="tso">tso</param>
    protected void AddNodeMap(TSOFile tso)
    {
        foreach (TSONode tso_node in tso.nodes)
        {
            TMONode tmo_node;
            if (tmo.nodemap.TryGetValue(tso_node.Name, out tmo_node))
                nodemap.Add(tso_node, tmo_node);
        }
    }

    /// <summary>
    /// t[ԍ0ɐݒ肵܂B
    /// </summary>
    protected void ResetFrameIndex()
    {
        frame_index = 0;
        current_frame_index = 0;
    }

    /// <summary>
    /// S_bonëʒuɐݒ肵܂B
    /// </summary>
    protected void SetCenterToHips()
    {
        if (tmo.frames == null)
            return;

        TMONode tmo_node;
        if (tmo.nodemap.TryGetValue("|W_Hips", out tmo_node))
        {
            Debug.Assert(tmo_node.frame_matrices.Count > 0);
            Matrix m = tmo_node.frame_matrices[0].m;
            center = new Vector3(m.M41, m.M42, m.M43);
        }
    }

    /// <summary>
    /// ̃t[ɐi݂܂B
    /// </summary>
    public void NextTMOFrame()
    {
        if (tmo.frames != null)
        {
            frame_index++;
            if (frame_index >= tmo.frames.Length)
                frame_index = 0;
        }
    }

    /// <summary>
    /// ݂̃t[𓾂܂B
    /// </summary>
    /// <returns>݂tmo frame</returns>
    protected TMOFrame GetTMOFrame()
    {
        if (tmo.frames != null)
        {
            Debug.Assert(current_frame_index >= 0 && current_frame_index < tmo.frames.Length);
            return tmo.frames[current_frame_index];
        }
        return null;
    }

    /// <summary>
    /// ݂̃t[ԍ𓾂܂B
    /// </summary>
    /// <returns></returns>
    public int GetFrameIndex()
    {
        return current_frame_index;
    }

    /// <summary>
    /// tsoTSOListɒǉ܂B
    /// </summary>
    /// <param name="tso">tso</param>
    public void AddTSO(TSOFile tso)
    {
        if (tmo.frames != null)
            AddNodeMap(tso);

        TSOList.Add(tso);
    }

    /// <summary>
    /// tsotmo𐶐܂B
    /// </summary>
    /// <param name="tso">tso</param>
    public static TMOFile GenerateTMOFromTSO(TSOFile tso)
    {
        TMOFile tmo = new TMOFile();
        tmo.header = new byte[8] { 0, 0, 0, 0, 0, 0, 0, 0 };
        tmo.opt0 = 1;
        tmo.opt1 = 0;

        int node_count = tso.nodes.Length;
        tmo.nodes = new TMONode[node_count];

        for (int i = 0; i < node_count; i++)
        {
            string name = tso.nodes[i].Name;
            tmo.nodes[i] = new TMONode(i, name);
        }

        tmo.GenerateNodemapAndTree();

        int frame_count = 1;
        tmo.frames = new TMOFrame[frame_count];

        for (int i = 0; i < frame_count; i++)
        {
            tmo.frames[i] = new TMOFrame();
            tmo.frames[i].id = i;

            int matrix_count = node_count;
            tmo.frames[i].matrices = new TMOMat[matrix_count];

            for (int j = 0; j < matrix_count; j++)
            {
                TMOMat mat = tmo.frames[i].matrices[j] = new TMOMat(tso.nodes[j].TransformationMatrix);
                tmo.nodes[j].frame_matrices.Add(mat);
            }
        }
        tmo.footer = new byte[4] { 0, 0, 0, 0 };

        return tmo;
    }

    /// <summary>
    /// bonesXV܂B
    /// tmo frame𖳎܂B
    /// </summary>
    public void UpdateBoneMatricesWithoutTMOFrame()
    {
        UpdateBoneMatrices(tmo, null);
    }

    /// <summary>
    /// bonesXV܂B
    /// </summary>
    public void UpdateBoneMatrices()
    {
        UpdateBoneMatrices(false);
    }

    /// <summary>
    /// bonesXV܂B
    /// </summary>
    /// <param name="forced">falsȅꍇframe indexɕύXȂ΍XV܂B</param>
    public void UpdateBoneMatrices(bool forced)
    {
        if (!forced && frame_index == current_frame_index)
            return;
        current_frame_index = frame_index;

        TMOFrame tmo_frame = GetTMOFrame();

        UpdateBoneMatrices(tmo, tmo_frame);
    }
    
    /// <summary>
    /// bonesXV܂B
    /// </summary>
    protected void UpdateBoneMatrices(TMOFile tmo, TMOFrame tmo_frame)
    {
        matrixStack.LoadMatrix(Matrix.Translation(translation));
        UpdateBoneMatrices(tmo.nodes[0], tmo_frame);
    }

    /// <summary>
    /// bonesXV܂B
    /// </summary>
    protected void UpdateBoneMatrices(TMONode tmo_node, TMOFrame tmo_frame)
    {
        matrixStack.Push();

        if (tmo_frame != null)
        {
            // TMO animation
            tmo_node.TransformationMatrix = tmo_frame.matrices[tmo_node.ID].m;
        }
        matrixStack.MultiplyMatrixLocal(tmo_node.TransformationMatrix);
        tmo_node.combined_matrix = matrixStack.Top;

        foreach (TMONode child_node in tmo_node.children)
            UpdateBoneMatrices(child_node, tmo_frame);

        matrixStack.Pop();
    }

    /// <summary>
    /// TSOFilewdeviceŊJ܂B
    /// </summary>
    /// <param name="device">device</param>
    /// <param name="effect">effect</param>
    public void OpenTSOFile(Device device, Effect effect)
    {
        foreach (TSOFile tso in TSOList)
            tso.Open(device, effect);
    }

    /// <summary>
    /// w胂[Vt[ɐi݂܂B
    /// </summary>
    public void SetFrameIndex(int frame_index)
    {
        Debug.Assert(frame_index >= 0);
        if (tmo.frames != null)
        {
            if (frame_index >= tmo.frames.Length)
                this.frame_index = 0;
            else
                this.frame_index = frame_index;
        }
    }

    /// <summary>
    /// objectj܂B
    /// </summary>
    public void Dispose()
    {
        foreach (TSOFile tso in TSOList)
            tso.Dispose();
    }
}
}
