using System;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

public class TSOCamera
{
    internal Vector3 center = Vector3.Empty;    //]Sʒu
    internal Vector3 translation = Vector3.Empty;
    internal Vector3 camPosL = new Vector3(0.0f, 0.0f, -10.0f); //Jʒu
    internal Vector3 camDirDef = Vector3.Empty; //JړxNg
    internal float offsetZ = 0.0f;      //JsItZbgl
    internal bool needUpdate = true;    //XV
    internal Matrix viewMat = Matrix.Identity;  //r[s
    internal Matrix camPoseMat = Matrix.Identity;       //Jps
    internal float camZRotDef = 0.0f;   //J Z]
    internal float camAngleUnit = 0.02f;        //ړ]PʁiWAj

    /// <summary>JʒuXV</summary>
    /// <param name="camDirX">ړioxj</param>
    /// <param name="camDirY">ړiܓxj</param>
    /// <param name="offsetZ">sItZbgl</param>
    public void Move(float camDirX, float camDirY, float offsetZ)
    {
        if (camDirX == 0.0f && camDirY == 0.0f && offsetZ == 0.0f)
            return;

        camDirDef.X += camDirX;
        camDirDef.Y += camDirY;
        this.offsetZ += offsetZ;
        needUpdate = true;
    }

    /// <summary>Z]</summary>
    public void RotZ(float radian)
    {
        if (radian == 0.0f)
            return;

        camZRotDef = radian;
        needUpdate = true;
    }

    public Vector3 GetCamZAxis()
    {
        return new Vector3(camPoseMat.M31, camPoseMat.M32, camPoseMat.M33);
    }

    public Vector3 GetCamYAxis()
    {
        return new Vector3(camPoseMat.M21, camPoseMat.M22, camPoseMat.M23);
    }

    /// <summary>JXV</summary>
    public void Update()
    {
        if (! needUpdate)
            return;

        //J Z]ŎpXV
        camPoseMat = Matrix.RotationZ(camZRotDef) * camPoseMat;

        //ܓxox̍ړ
        Vector3 dL = Vector3.TransformCoordinate(camDirDef, camPoseMat);
        if (dL.X != 0.0f || dL.Y != 0.0f || dL.Z != 0.0f)
        {
            //JʒuXV
            Vector3 camZAxis = GetCamZAxis();
            Vector3 rotAxis = Vector3.Cross(dL, camZAxis);
            Quaternion q = Quaternion.RotationAxis(rotAxis, camAngleUnit * camDirDef.Length());
            Matrix rotMat = Matrix.RotationQuaternion(q);
            camPosL = Vector3.TransformCoordinate(camPosL, rotMat);

            //JpXV
            Vector3 z = Vector3.Normalize(-camPosL);
            Vector3 y = GetCamYAxis();
            Vector3 x = Vector3.Normalize(Vector3.Cross(y, z));
            y = Vector3.Normalize(Vector3.Cross(z, x));
            {
                Matrix m = Matrix.Identity;
                m.M11 = x.X;
                m.M12 = x.Y;
                m.M13 = x.Z;
                m.M21 = y.X;
                m.M22 = y.Y;
                m.M23 = y.Z;
                m.M31 = z.X;
                m.M32 = z.Y;
                m.M33 = z.Z;
                camPoseMat = m;
            }
        }

        //sItZbgXV
        if (offsetZ != 0.0f && camPosL.Length() - offsetZ > 0)
        {
            Vector3 z = Vector3.Normalize(-camPosL);
            camPosL += offsetZ * z;
        }

        //r[sXV
        Vector3 posW = camPosL + center;
        {
            Matrix m = camPoseMat;
            m.M41 = posW.X;
            m.M42 = posW.Y;
            m.M43 = posW.Z;
            m.M44 = 1.0f;
            viewMat = Matrix.Invert(m) * Matrix.Translation(-translation);
        }

        //Zbg
        ResetDefValue();
        needUpdate = false;
    }

    /// <summary>r[s擾</summary>
    public Matrix GetViewMatrix()
    {
        return viewMat;
    }

    /// <summary>]Sʒuݒ</summary>
    public void SetCenter(Vector3 center)
    {
        this.center = center;
        needUpdate = true;
    }

    /// <summary>ړʒuݒ</summary>
    public void SetTranslation(Vector3 translation)
    {
        this.translation = translation;
        needUpdate = true;
    }

    // Zbg
    protected void ResetDefValue()
    {
        camDirDef = Vector3.Empty;
        offsetZ = 0.0f;
        camZRotDef = 0.0f;
    }
}
