using System;
using System.Collections.Generic;
using System.IO;
using System.Text.RegularExpressions;
using System.ComponentModel;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace TDCG
{
    /// <summary>
    /// VF[_ݒp[^
    /// </summary>
    [TypeConverter(typeof(ExpandableObjectConverter))]
    public class ShaderParameter
    {
        /// <summary>
        /// VF[_ݒ̌^
        /// </summary>
        public enum Type
        {
            /// <summary>
            /// 킩Ȃ
            /// </summary>
            Unknown,
            /// <summary>
            /// string
            /// </summary>
            String,
            /// <summary>
            /// float
            /// </summary>
            Float,
            /// <summary>
            /// float3
            /// </summary>
            Float3,
            /// <summary>
            /// float4
            /// </summary>
            Float4,
            /// <summary>
            /// eNX`
            /// </summary>
            Texture
        };

        internal Type type;
        internal string name;

        private string str;
        private float f1;
        private float f2;
        private float f3;
        private float f4;
        private int dim = 0;

        internal bool system_p = false;

        /// <summary>
        /// p[^̖
        /// </summary>
        public string Name { get { return name; } set { name = value; } }
        /// <summary>
        /// floatl1
        /// </summary>
        public float F1 { get { return f1; } set { f1 = value; } }
        /// <summary>
        /// floatl2
        /// </summary>
        public float F2 { get { return f2; } set { f2 = value; } }
        /// <summary>
        /// floatl3
        /// </summary>
        public float F3 { get { return f3; } set { f3 = value; } }
        /// <summary>
        /// floatl4
        /// </summary>
        public float F4 { get { return f4; } set { f4 = value; } }
        /// <summary>
        /// float
        /// </summary>
        public int Dimension { get { return dim; } }

        /// <summary>
        /// VF[_ݒt@C̍s͂ăVF[_ݒp[^𐶐܂B
        /// </summary>
        /// <param name="line">VF[_ݒt@C̍s</param>
        /// <returns>VF[_ݒp[^</returns>
        public static ShaderParameter Parse(string line)
        {
            int m = line.IndexOf('='); if (m < 0) throw new ArgumentException();
            string type_name = line.Substring(0,m);
            string value = line.Substring(m+1).Trim();
            m = type_name.IndexOf(' '); if (m < 0) throw new ArgumentException();
            string type = type_name.Substring(0,m);
            string name = type_name.Substring(m+1).Trim();

            return new ShaderParameter(type, name, value);
        }

        /// <summary>
        /// VF[_ݒp[^𐶐܂B
        /// </summary>
        public ShaderParameter()
        {
        }

        /// <summary>
        /// VF[_ݒp[^𐶐܂B
        /// </summary>
        /// <param name="type_string">^</param>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public ShaderParameter(string type_string, string name, string value)
        {
            this.name = name;

            switch (type_string)
            {
            case "string":
                type = Type.String;
                SetString(value);
                break;
            case "float":
                type = Type.Float;
                SetFloat(value);
                break;
            case "float3":
                type = Type.Float3;
                SetFloat3(value);
                break;
            case "float4":
                type = Type.Float4;
                SetFloat4(value);
                break;
            case "texture":
                type = Type.Texture;
                SetTexture(value);
                break;
            default:
                type = Type.Unknown;
                break;
            }
        }

        /// Ƃĕ\܂B
        public override string ToString()
        {
            return GetTypeName() + " " + name + " = " + GetValueString();
        }

        /// ^𕶎Ƃē܂B
        public string GetTypeName()
        {
            switch (type)
            {
                case Type.String:
                    return "string";
                case Type.Float:
                    return "float";
                case Type.Float3:
                    return "float3";
                case Type.Float4:
                    return "float4";
                case Type.Texture:
                    return "texture";
            }
            return null;
        }

        /// <summary>
        /// l𕶎Ƃē܂B
        /// </summary>
        public string GetValueString()
        {
            switch (type)
            {
                case Type.String:
                    return "\"" + str + "\"";
                case Type.Float:
                    return string.Format("[{0}]", f1);
                case Type.Float3:
                    return string.Format("[{0}, {1}, {2}]", f1, f2, f3);
                case Type.Float4:
                    return string.Format("[{0}, {1}, {2}, {3}]", f1, f2, f3, f4);
                case Type.Texture:
                    return str;
            }
            return str;
        }

        /// <summary>
        /// 擾܂B
        /// </summary>
        /// <returns></returns>
        public string GetString()
        {
            return str;
        }

        /// <summary>
        /// ݒ肵܂B
        /// </summary>
        /// <param name="value">\</param>
        public void SetString(string value)
        {
            str = value.Trim('"', ' ', '\t');
        }

        static Regex re_float_array = new Regex(@"\s*,\s*|\s+");

        /// <summary>
        /// floatl̔zݒ肵܂B
        /// </summary>
        /// <param name="value">floatzl̕\</param>
        /// <param name="dim"></param>
        public void SetFloatDim(string value, int dim)
        {
            string[] token = re_float_array.Split(value.Trim('[', ']', ' ', '\t'));
            this.dim = dim;
            if (token.Length > 0)
                f1 = float.Parse(token[0].Trim());
            if (token.Length > 1)
                f2 = float.Parse(token[1].Trim());
            if (token.Length > 2)
                f3 = float.Parse(token[2].Trim());
            if (token.Length > 3)
                f4 = float.Parse(token[3].Trim());
        }

        /// <summary>
        /// floatl擾܂B
        /// </summary>
        /// <returns>floatl</returns>
        public float GetFloat()
        {
            return f1;
        }
        /// <summary>
        /// floatlݒ肵܂B
        /// </summary>
        /// <param name="value">floatl̕\</param>
        public void SetFloat(string value)
        {
            try
            {
                SetFloatDim(value, 1);
            }
            catch (FormatException)
            {
                Console.WriteLine("shader format error (type float): " + value);
            }
        }

        /// <summary>
        /// float3l擾܂B
        /// </summary>
        /// <returns>float3l</returns>
        public Vector3 GetFloat3()
        {
            return new Vector3(f1, f2, f3);
        }
        /// <summary>
        /// float3lݒ肵܂B
        /// </summary>
        /// <param name="value">float3l̕\</param>
        public void SetFloat3(string value)
        {
            try
            {
                SetFloatDim(value, 3);
            }
            catch (FormatException)
            {
                Console.WriteLine("shader format error (type float3): " + value);
            }
        }

        /// <summary>
        /// float4l擾܂B
        /// </summary>
        /// <returns>float4l</returns>
        public Vector4 GetFloat4()
        {
            return new Vector4(f1, f2, f3, f4);
        }
        /// <summary>
        /// float4lݒ肵܂B
        /// </summary>
        /// <param name="value">float4l̕\</param>
        public void SetFloat4(string value)
        {
            try
            {
                SetFloatDim(value, 4);
            }
            catch (FormatException)
            {
                Console.WriteLine("shader format error (type float4): " + value);
            }
        }

        /// <summary>
        /// eNX`擾܂B
        /// </summary>
        /// <returns>eNX`</returns>
        public string GetTexture()
        {
            return str;
        }
        /// <summary>
        /// eNX`ݒ肵܂B
        /// </summary>
        /// <param name="value">eNX`</param>
        public void SetTexture(string value)
        {
            str = value;
        }
    }

    /// <summary>
    /// VF[_ݒ
    /// </summary>
    public class Shader
    {
        /// <summary>
        /// VF[_ݒp[^̔z
        /// </summary>
        public ShaderParameter[] shader_parameters;

        //internal string     description;     // = "TA ToonShader v0.50"
        //internal string     shader;          // = "TAToonshade_050.cgfx"
        internal string     technique;       // = "ShadowOn"
        internal float      lightDirX;       // = [-0.00155681]
        internal float      lightDirY;       // = [-0.0582338]
        internal float      lightDirZ;       // = [-0.998302]
        internal float      lightDirW;       // = [0]
        //internal Vector4    shadowColor;     // = [0, 0, 0, 1]
        internal ShaderParameter shadeTex;        // = Ninjya_Ribbon_Toon_Tex
        //internal float      highLight;       // = [0]
        //internal float      colorBlend;      // = [10]
        //internal float      highLightBlend;  // = [10]
        //internal Vector4    penColor;        // = [0.166, 0.166, 0.166, 1]
        //internal float      ambient;         // = [38]
        internal ShaderParameter colorTex;        // = file24
        //internal float      thickness;       // = [0.018]
        //internal float      shadeBlend;      // = [10]
        //internal float      highLightPower;  // = [100]

        /// <summary>
        /// xNg
        /// </summary>
        public Vector4 LightDir
        {
            get { return new Vector4(lightDirX, lightDirY, lightDirZ, lightDirW); }
        }

        /// <summary>
        /// AeNX`̃t@C
        /// </summary>
        public string ShadeTexName
        {
            get
            {
                return shadeTex.GetTexture();
            }
            set
            {
                shadeTex.SetTexture(value);
            }
        }
        /// <summary>
        /// FeNX`̃t@C
        /// </summary>
        public string ColorTexName
        {
            get
            {
                return colorTex.GetTexture();
            }
            set
            {
                colorTex.SetTexture(value);
            }
        }

        /// <summary>
        /// VF[_ݒǂݍ݂܂B
        /// </summary>
        /// <param name="lines">eLXgsz</param>
        public void Load(string[] lines)
        {
            shader_parameters = new ShaderParameter[lines.Length];
            int i = 0;
            foreach (string line in lines)
            {
                ShaderParameter p = ShaderParameter.Parse(line);
                switch(p.name)
                {
                    case "description":
                        p.system_p = true;
                        break;
                    case "shader":
                        p.system_p = true;
                        break;
                    case "technique":
                        p.system_p = true;
                        technique = p.GetString();
                        break;
                    case "LightDirX":
                        p.system_p = true;
                        lightDirX = p.GetFloat();
                        break;
                    case "LightDirY":
                        p.system_p = true;
                        lightDirY = p.GetFloat();
                        break;
                    case "LightDirZ":
                        p.system_p = true;
                        lightDirZ = p.GetFloat();
                        break;
                    case "LightDirW":
                        p.system_p = true;
                        lightDirW = p.GetFloat();
                        break;
                    case "LightDir":
                        p.system_p = true;
                    {
                        Vector3 v = p.GetFloat3();
                        lightDirX = v.X;
                        lightDirY = v.Y;
                        lightDirZ = v.Z;
                    }
                        break;
                    case "ShadeTex":
                        p.system_p = true;
                        shadeTex = p;
                        break;
                    case "ColorTex":
                        p.system_p = true;
                        colorTex = p;
                        break;
                }
                shader_parameters[i++] = p;
            }
            Array.Resize(ref shader_parameters, i);
        }

        /// <summary>
        /// VF[_ݒ𕶎̔zƂē܂B
        /// </summary>
        public string[] GetLines()
        {
            string[] lines = new string[shader_parameters.Length];
            int i = 0;
            foreach (ShaderParameter p in shader_parameters)
            {
                lines[i++] = p.ToString();
            }
            Array.Resize(ref lines, i);
            return lines;
        }
    }
}
