using System;
using System.Collections.Generic;
using System.IO;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;
using TAHdecrypt;

namespace TDCG.TMOTool.Command
{
    public class Kemo : ITMOCommand
    {
        Dictionary<string, TMONode> nodes;
        public Dictionary<string, TMONode> Nodes { set { nodes = value; }}

        static float DegreeToRadian(float angle)
        {
           return (float)(Math.PI * angle / 180.0);
        }

        public void Execute()
        {
                TMONode node;

                node = nodes["W_Hips"];
                node.Scale1(0.964F, 0.94F, 0.94F);
                node.RotateX(DegreeToRadian(3.438F));
                node = nodes["W_LeftHips_Dummy"];
                node.Scale1(1F, 1F, 1F);
                node.RotateX(DegreeToRadian(-2.292F));
                node = nodes["W_LeftUpLeg"];
                node.Scale1(0.960F, 1F, 0.957F);
                node.RotateZ(DegreeToRadian(-1.146F));
                node = nodes["W_LeftUpLegRoll"];
                node.Scale1(0.930F, 1F, 0.873F);
                node = nodes["W_LeftLeg"];
                node.Scale1(1.050F, 1F, 0.920F);
                node = nodes["W_LeftLegRoll"];
                node.Scale1(1F, 1F, 0.850F);
                node = nodes["W_LeftFoot"];
                node.Scale1(1F, 1F, 1F);
                node.RotateX(DegreeToRadian(5.730F));
                node = nodes["W_RightHips_Dummy"];
                node.Scale1(1F, 1F, 1F);
                node.RotateX(DegreeToRadian(-2.292F));
                node = nodes["W_RightUpLeg"];
                node.Scale1(0.960F, 1F, 0.957F);
                node.RotateZ(DegreeToRadian(1.146F));
                node = nodes["W_RightUpLegRoll"];
                node.Scale1(0.930F, 1F, 0.873F);
                node = nodes["W_RightLeg"];
                node.Scale1(1.050F, 1F, 0.920F);
                node = nodes["W_RightLegRoll"];
                node.Scale1(1F, 1F, 0.850F);
                node = nodes["W_RightFoot"];
                node.Scale1(1F, 1F, 1F);
                node.RotateX(DegreeToRadian(5.730F));
                node = nodes["W_Spine_Dummy"];
                node.Scale1(1F, 0.9F, 0.9F);
                node.RotateX(DegreeToRadian(-1.719F));
                node = nodes["W_Spine1"];
                node.Scale1(0.943F, 0.95F, 0.95F);
                node.RotateX(DegreeToRadian(0.573F));
                node = nodes["W_Spine2"];
                node.Scale1(0.909F, 0.887F, 0.887F);
                node.RotateX(DegreeToRadian(-6.303F));
                node = nodes["W_Spine3"];
                node.Move(0F, 0.5F, 0F);
                node.Scale1(1F, 0.809F, 0.809F);
                node = nodes["W_RightShoulder_Dummy"];
                node.Scale1(0.780F, 1F, 0.980F);
                node = nodes["W_RightShoulder"];
                node.Scale1(1F, 0.900F, 0.937F);
                node = nodes["W_RightArm_Dummy"];
                node.Scale1(1F, 0.980F, 0.912F);
                node = nodes["W_RightArm"];
                node.Scale1(1F, 0.921F, 1F);
                node = nodes["W_RightArmRoll"];
                node.Scale1(1F, 1.069F, 1.010F);
                node = nodes["W_RightForeArm"];
                node.Scale1(1F, 0.862F, 0.980F);
                node = nodes["W_RightForeArmRoll"];
                node.Move(0F, 0F, 0F);
                node.Scale1(1F, 0.890F, 1.030F);
                node = nodes["W_RightHand"];
                node.Scale1(1F, 0.915F, 0.920F);
                node = nodes["W_RightHandPinky1"];
                node.Scale1(1F, 1F, 1F);
                node.RotateZ(DegreeToRadian(3.438F));
                node = nodes["W_RightHandPinky2"];
                node.Scale1(1F, 0.910F, 1F);
                node.RotateZ(DegreeToRadian(-3.438F));
                node = nodes["W_RightHandPinky3"];
                node.Scale1(1F, 0.900F, 1F);
                node = nodes["W_RightHandRing1"];
                node.Scale1(1F, 0.880F, 1F);
                node = nodes["W_RightHandRing2"];
                node.Scale1(1F, 0.940F, 1F);
                node = nodes["W_RightHandRing3"];
                node.Scale1(1F, 0.970F, 1F);
                node.RotateX(DegreeToRadian(9.921F));
                node.RotateY(DegreeToRadian(5.880F));
                node.RotateZ(DegreeToRadian(-3.607F));
                node = nodes["W_RightHandMiddle1"];
                node.Scale1(1F, 0.860F, 1F);
                node = nodes["W_RightHandMiddle2"];
                node.Scale1(1F, 0.772F, 1F);
                node = nodes["W_RightHandMiddle3"];
                node.Scale1(1F, 0.695F, 1F);
                node.RotateX(DegreeToRadian(-5.157F));
                node = nodes["W_RightHandIndex1"];
                node.Move(0F, -0.1F, 0F);
                node.Scale1(1F, 0.930F, 1.090F);
                node.RotateZ(DegreeToRadian(-4.584F));
                node = nodes["W_RightHandIndex2"];
                node.Move(0F, 0.1F, 0F);
                node.Scale1(1F, 0.960F, 1F);
                node.RotateZ(DegreeToRadian(9.740F));
                node = nodes["W_RightHandIndex3"];
                node.Scale1(1F, 0.820F, 1F);
                node.RotateX(DegreeToRadian(9.167F));
                node = nodes["W_RightHandThumb2"];
                node.Scale1(1F, 0.940F, 0.912F);
                node.RotateX(DegreeToRadian(0F));
                node.RotateY(DegreeToRadian(0F));
                node.RotateZ(DegreeToRadian(0F));
                node = nodes["W_RightHandThumb3"];
                node.Scale1(1F, 1F, 0.900F);
                node = nodes["W_LeftShoulder_Dummy"];
                node.Scale1(0.780F, 1F, 0.980F);
                node = nodes["W_LeftShoulder"];
                node.Scale1(1F, 0.900F, 0.937F);
                node = nodes["W_LeftArm_Dummy"];
                node.Scale1(1F, 0.980F, 0.912F);
                node = nodes["W_LeftArm"];
                node.Scale1(1F, 0.921F, 1F);
                node = nodes["W_LeftArmRoll"];
                node.Scale1(1F, 1.069F, 1.010F);
                node = nodes["W_LeftForeArm"];
                node.Scale1(1F, 0.862F, 0.980F);
                node = nodes["W_LeftForeArmRoll"];
                node.Scale1(1F, 0.890F, 1.030F);
                node = nodes["W_LeftHand"];
                node.Scale1(1F, 0.915F, 0.920F);
                node = nodes["W_LeftHandPinky1"];
                node.Scale1(1F, 1F, 1F);
                node.RotateZ(DegreeToRadian(-3.438F));
                node = nodes["W_LeftHandPinky2"];
                node.Scale1(1F, 0.910F, 1F);
                node.RotateZ(DegreeToRadian(3.438F));
                node = nodes["W_LeftHandPinky3"];
                node.Scale1(1F, 0.900F, 1F);
                node = nodes["W_LeftHandRing1"];
                node.Scale1(1F, 0.880F, 1F);
                node = nodes["W_LeftHandRing2"];
                node.Scale1(1F, 0.940F, 1F);
                node = nodes["W_LeftHandRing3"];
                node.Scale1(1F, 0.970F, 1F);
                node.RotateX(DegreeToRadian(9.921F));
                node.RotateY(DegreeToRadian(-5.880F));
                node.RotateZ(DegreeToRadian(3.607F));
                node = nodes["W_LeftHandMiddle1"];
                node.Scale1(1F, 0.860F, 1F);
                node = nodes["W_LeftHandMiddle2"];
                node.Scale1(1F, 0.772F, 1F);
                node = nodes["W_LeftHandMiddle3"];
                node.Scale1(1F, 0.695F, 1F);
                node.RotateX(DegreeToRadian(-5.157F));
                node = nodes["W_LeftHandIndex1"];
                node.Move(0F, -0.1F, 0F);
                node.Scale1(1F, 0.930F, 1.090F);
                node.RotateZ(DegreeToRadian(4.584F));
                node = nodes["W_LeftHandIndex2"];
                node.Move(0F, 0.1F, 0F);
                node.Scale1(1F, 0.960F, 1F);
                node.RotateZ(DegreeToRadian(-9.740F));
                node = nodes["W_LeftHandIndex3"];
                node.Scale1(1F, 0.820F, 1F);
                node.RotateX(DegreeToRadian(9.167F));
                node = nodes["W_LeftHandThumb2"];
                node.Scale1(1F, 0.940F, 0.912F);
                node = nodes["W_LeftHandThumb3"];
                node.Scale1(1F, 1F, 0.900F);
                node = nodes["W_Neck"];
                node.Move(0F, 0.1F, 0F);
                node.RotateX(DegreeToRadian(-3.438F));
                node = nodes["Head"];
                node.Move(0F, 0.1F, 0F);
                node.RotateX(DegreeToRadian(-7.448F));
                node = nodes["face_oya"];
                node.RotateX(DegreeToRadian(-15.470F));
                node = nodes["Chichi_Right1"];
                node.Move(0.1F, 0.1F, -0.4F);
                node.Scale1(1.271F, 1.100F, 1F);
                node.RotateX(DegreeToRadian(3F));
                node.RotateY(DegreeToRadian(8.092F));
                node.RotateZ(DegreeToRadian(0F));
                node = nodes["Chichi_Right2"];
                node.Move(0.25F, -0.04F, -0.2F);
                node.Scale1(1.124F, 1.08F, 1.236F);
                node.RotateX(DegreeToRadian(-3.051F));
                node.RotateY(DegreeToRadian(-10F));
                node.RotateZ(DegreeToRadian(-0.780F));
                node = nodes["Chichi_Right3"];
                node.Move(-0.1F, 0F, -0.1F);
                node.Scale1(1.155F, 1.000F, 1.275F);
                node.RotateX(DegreeToRadian(-10.866F));
                node.RotateY(DegreeToRadian(-5.458F));
                node.RotateZ(DegreeToRadian(-0.531F));
                node = nodes["Chichi_Right4"];
                node.Scale1(1.000F, 1.000F, 1.657F);
                node.RotateX(DegreeToRadian(-2.292F));
                node.RotateY(DegreeToRadian(0F));
                node.RotateZ(DegreeToRadian(0F));
                node = nodes["Chichi_Left1"];
                node.Move(-0.1F, 0.1F, -0.4F);
                node.Scale1(1.271F, 1.100F, 1F);
                node.RotateX(DegreeToRadian(3F));
                node.RotateY(DegreeToRadian(-8.092F));
                node.RotateZ(DegreeToRadian(0F));
                node = nodes["Chichi_Left2"];
                node.Move(-0.25F, -0.04F, -0.2F);
                node.Scale1(1.124F, 1.08F, 1.236F);
                node.RotateX(DegreeToRadian(-3.051F));
                node.RotateY(DegreeToRadian(10F));
                node.RotateZ(DegreeToRadian(0.780F));
                node = nodes["Chichi_Left3"];
                node.Move(0.1F, 0F, -0.1F);
                node.Scale1(1.155F, 1.000F, 1.275F);
                node.RotateX(DegreeToRadian(-10.866F));
                node.RotateY(DegreeToRadian(5.458F));
                node.RotateZ(DegreeToRadian(0.531F));
                node = nodes["Chichi_Left4"];
                node.Scale1(1.000F, 1.000F, 1.657F);
                node.RotateX(DegreeToRadian(-2.292F));
                node.RotateY(0F);
                node.RotateZ(0F);
        }
    }
}
