using System;
using System.Collections.Generic;
using System.IO;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

using TDCG;
using TDCGUtils;
using Tso2Pmd;

using jp.nyatla.nymmd.cs.types;
using jp.nyatla.nymmd.cs.core;
using jp.nyatla.nymmd.cs.struct_type;
using jp.nyatla.nymmd.cs.struct_type.pmd;

namespace TDCG.PhysObTemplate
{
    public class Skirt_Default : IPhysObTemplate
    {
        string name = "ftHg"; // gɕ\閼O
        int group = 2;              // \g̎ށi0: 1: 2:XJ[g 3:̑j

        public string Name() { return name; }
        public int Group() { return group; }

        public void Execute(ref T2PPhysObjectList phys_list)
        {
            phys_list.MakeChain("XP");
            phys_list.MakeChain("EXP");
            phys_list.MakeChain("EXP");
            phys_list.MakeChain("EXOP");
            phys_list.MakeChain("XOP");
            phys_list.MakeChain("XP");

            SetParameter(phys_list.GetBodyListByName(".X.."));
            SetParameterSide(phys_list.GetBodyListByName(".X."));
            SetParameterEnd(phys_list.GetBodyListByName(".X."));
            SetParameterSideEnd(phys_list.GetBodyListByName(".X"));
            SetParameter(phys_list.GetJointListByName(".X.."));

            phys_list.GetJointByName("g-XP").constrain_rot_1.x = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").constrain_rot_2.x = (float)((60.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").constrain_rot_1.y = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").constrain_rot_2.y = (float)((0.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").constrain_rot_1.z = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").constrain_rot_2.z = (float)((5.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").spring_rot.x = 50.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").spring_rot.y = 0.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").spring_rot.z = 0.0f; // ΂ˁF](rad(x), rad(y), rad(z))

            phys_list.GetJointByName("g-EXP").constrain_rot_1.x = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").constrain_rot_2.x = (float)((60.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").constrain_rot_1.y = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").constrain_rot_2.y = (float)((0.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").constrain_rot_1.z = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").constrain_rot_2.z = (float)((5.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").spring_rot.x = 50.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").spring_rot.y = 0.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").spring_rot.z = 0.0f; // ΂ˁF](rad(x), rad(y), rad(z))

            phys_list.GetJointByName("g-EXP").constrain_rot_1.x = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").constrain_rot_2.x = (float)((5.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").constrain_rot_1.y = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").constrain_rot_2.y = (float)((0.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").constrain_rot_1.z = (float)((-15.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").constrain_rot_2.z = (float)((60.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").spring_rot.x = 0.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").spring_rot.y = 0.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").spring_rot.z = 50.0f; // ΂ˁF](rad(x), rad(y), rad(z))

            phys_list.GetJointByName("g-EXOP").constrain_rot_1.x = (float)((-120.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").constrain_rot_2.x = (float)((20.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").constrain_rot_1.y = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").constrain_rot_2.y = (float)((0.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").constrain_rot_1.z = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").constrain_rot_2.z = (float)((5.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").spring_rot.x = 50.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").spring_rot.y = 0.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").spring_rot.z = 0.0f; // ΂ˁF](rad(x), rad(y), rad(z))

            phys_list.GetJointByName("g-XOP").constrain_rot_1.x = (float)((-120.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").constrain_rot_2.x = (float)((20.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").constrain_rot_1.y = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").constrain_rot_2.y = (float)((0.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").constrain_rot_1.z = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").constrain_rot_2.z = (float)((5.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").spring_rot.x = 50.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").spring_rot.y = 0.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").spring_rot.z = 0.0f; // ΂ˁF](rad(x), rad(y), rad(z))

            phys_list.GetJointByName("g-XP").constrain_rot_1.x = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").constrain_rot_2.x = (float)((5.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").constrain_rot_1.y = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").constrain_rot_2.y = (float)((0.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").constrain_rot_1.z = (float)((-60.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").constrain_rot_2.z = (float)((15.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").spring_rot.x = 0.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").spring_rot.y = 0.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").spring_rot.z = 50.0f; // ΂ˁF](rad(x), rad(y), rad(z))

            phys_list.MakeJointFromTwoBones("XOQ", "EXOQ");
            phys_list.MakeJointFromTwoBones("EXOQ", "EXQ");
            phys_list.MakeJointFromTwoBones("EXQ", "EXQ");
            phys_list.MakeJointFromTwoBones("EXQ", "XQ");
            phys_list.MakeJointFromTwoBones("XQ", "XQ");
            phys_list.MakeJointFromTwoBones("XQ", "XOQ");
            phys_list.MakeJointFromTwoBones("XOR", "EXOR");
            phys_list.MakeJointFromTwoBones("EXOR", "EXR");
            phys_list.MakeJointFromTwoBones("EXR", "EXR");
            phys_list.MakeJointFromTwoBones("EXR", "XR");
            phys_list.MakeJointFromTwoBones("XR", "XR");
            phys_list.MakeJointFromTwoBones("XR", "XOR");
        }

        // XJ[gO
        private void SetParameter(List<PMD_RigidBody> body_list)
        {
            foreach (PMD_RigidBody body in body_list)
            {
                body.rigidbody_group_index = 4; // f[^FO[v // 00
                body.rigidbody_group_target = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_type = 1; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.shape_w = 0.8f; // `Fa() // CD CC CC 3F // 1.6
                body.shape_h *= 0.6f; // `F // CD CC CC 3D // 0.1
                body.shape_d = 0.2f; // `Fs // CD CC CC 3D // 0.1

                body.rigidbody_weight = 0.5f; // f[^F // 00 00 80 3F // 1.0
                body.rigidbody_pos_dim = 0.5f; // f[^Fړ // 00 00 00 00
                body.rigidbody_rot_dim = 0.9f; // f[^F] // 00 00 00 00
                body.rigidbody_recoil = 0.0f; // f[^F // 00 00 00 00
                body.rigidbody_friction = 0.0f; // f[^FC // 00 00 00 00
                body.rigidbody_type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        // XJ[g
        private void SetParameterSide(List<PMD_RigidBody> body_list)
        {
            foreach (PMD_RigidBody body in body_list)
            {
                body.rigidbody_group_index = 4; // f[^FO[v // 00
                body.rigidbody_group_target = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_type = 1; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.shape_w = 0.2f; // `Fa() // CD CC CC 3F // 1.6
                body.shape_h *= 0.6f; // `F // CD CC CC 3D // 0.1
                body.shape_d = 0.8f; // `Fs // CD CC CC 3D // 0.1

                body.rigidbody_weight = 0.5f; // f[^F // 00 00 80 3F // 1.0
                body.rigidbody_pos_dim = 0.5f; // f[^Fړ // 00 00 00 00
                body.rigidbody_rot_dim = 0.9f; // f[^F] // 00 00 00 00
                body.rigidbody_recoil = 0.0f; // f[^F // 00 00 00 00
                body.rigidbody_friction = 0.0f; // f[^FC // 00 00 00 00
                body.rigidbody_type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        // XJ[gO
        private void SetParameterEnd(List<PMD_RigidBody> body_list)
        {
            foreach (PMD_RigidBody body in body_list)
            {
                body.rigidbody_group_index = 4; // f[^FO[v // 00
                body.rigidbody_group_target = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_type = 0; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.shape_w = 0.2f; // `Fa() // CD CC CC 3F // 1.6

                body.rigidbody_weight = 0.5f; // f[^F // 00 00 80 3F // 1.0
                body.rigidbody_pos_dim = 0.5f; // f[^Fړ // 00 00 00 00
                body.rigidbody_rot_dim = 0.9f; // f[^F] // 00 00 00 00
                body.rigidbody_recoil = 0.0f; // f[^F // 00 00 00 00
                body.rigidbody_friction = 0.0f; // f[^FC // 00 00 00 00
                body.rigidbody_type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        // XJ[g
        private void SetParameterSideEnd(List<PMD_RigidBody> body_list)
        {
            foreach (PMD_RigidBody body in body_list)
            {
                body.rigidbody_group_index = 4; // f[^FO[v // 00
                body.rigidbody_group_target = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_type = 0; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.shape_w = 0.2f; // `Fa() // CD CC CC 3F // 1.6

                body.rigidbody_weight = 0.5f; // f[^F // 00 00 80 3F // 1.0
                body.rigidbody_pos_dim = 0.5f; // f[^Fړ // 00 00 00 00
                body.rigidbody_rot_dim = 0.9f; // f[^F] // 00 00 00 00
                body.rigidbody_recoil = 0.0f; // f[^F // 00 00 00 00
                body.rigidbody_friction = 0.0f; // f[^FC // 00 00 00 00
                body.rigidbody_type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        private void SetParameter(List<PMD_Joint> joint_list)
        {
            foreach (PMD_Joint joint in joint_list)
            {
                joint.constrain_rot_1.x = (float)((-15.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
                joint.constrain_rot_2.x = (float)((15.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
                joint.constrain_rot_1.z = (float)((-15.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
                joint.constrain_rot_2.z = (float)((15.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
                joint.spring_rot.x = 20.0f; // ΂ˁF](rad(x), rad(y), rad(z))
                joint.spring_rot.y = 20.0f; // ΂ˁF](rad(x), rad(y), rad(z))
                joint.spring_rot.z = 20.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            }
        }
    }
}
