//css_reference Microsoft.DirectX.Direct3DX;

using System;
using System.Collections.Generic;
using System.IO;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

using TDCG;
using TDCGUtils;
using Tso2Pmd;

namespace TDCG.PhysObTemplate
{
    public class Skirt_Default : IPhysObTemplate
    {
        string name = "ftHg"; // gɕ\閼O
        int group = 2;              // \g̎ށi0: 1: 2:XJ[g 3:̑j

        public string Name() { return name; }
        public int Group() { return group; }

        public void Execute(ref T2PPhysObjectList phys_list)
        {
            phys_list.MakeChain("XP");
            phys_list.MakeChain("EXP");
            phys_list.MakeChain("EXP");
            phys_list.MakeChain("EXOP");
            phys_list.MakeChain("XOP");
            phys_list.MakeChain("XP");

            SetParameter(phys_list.GetBodyListByName(".X.."));
            SetParameterSide(phys_list.GetBodyListByName(".X."));
            SetParameterEnd(phys_list.GetBodyListByName(".X."));
            SetParameterSideEnd(phys_list.GetBodyListByName(".X"));
            SetParameter(phys_list.GetJointListByName(".X.."));

            phys_list.GetJointByName("g-XP").rotation_min.X = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").rotation_max.X = (float)((60.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").rotation_min.Y = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").rotation_max.Y = (float)((0.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").rotation_min.Z = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").rotation_max.Z = (float)((5.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").spring_rotation = new Vector3(50.0f, 0.0f, 0.0f);

            phys_list.GetJointByName("g-EXP").rotation_min.X = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").rotation_max.X = (float)((60.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").rotation_min.Y = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").rotation_max.Y = (float)((0.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").rotation_min.Z = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").rotation_max.Z = (float)((5.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").spring_rotation = new Vector3(50.0f, 0.0f, 0.0f);

            phys_list.GetJointByName("g-EXP").rotation_min.X = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").rotation_max.X = (float)((5.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").rotation_min.Y = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").rotation_max.Y = (float)((0.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").rotation_min.Z = (float)((-15.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").rotation_max.Z = (float)((60.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXP").spring_rotation = new Vector3(0.0f, 0.0f, 50.0f);

            phys_list.GetJointByName("g-EXOP").rotation_min.X = (float)((-120.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").rotation_max.X = (float)((20.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").rotation_min.Y = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").rotation_max.Y = (float)((0.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").rotation_min.Z = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").rotation_max.Z = (float)((5.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-EXOP").spring_rotation = new Vector3(50.0f, 0.0f, 0.0f);
            
            phys_list.GetJointByName("g-XOP").rotation_min.X = (float)((-120.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").rotation_max.X = (float)((20.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").rotation_min.Y = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").rotation_max.Y = (float)((0.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").rotation_min.Z = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").rotation_max.Z = (float)((5.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XOP").spring_rotation = new Vector3(50.0f, 0.0f, 0.0f);

            phys_list.GetJointByName("g-XP").rotation_min.X = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").rotation_max.X = (float)((5.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").rotation_min.Y = (float)((-0.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").rotation_max.Y = (float)((0.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").rotation_min.Z = (float)((-60.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").rotation_max.Z = (float)((15.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("g-XP").spring_rotation = new Vector3(0.0f, 0.0f, 50.0f);

            phys_list.MakeJointFromTwoBones("XOQ", "EXOQ");
            phys_list.MakeJointFromTwoBones("EXOQ", "EXQ");
            phys_list.MakeJointFromTwoBones("EXQ", "EXQ");
            phys_list.MakeJointFromTwoBones("EXQ", "XQ");
            phys_list.MakeJointFromTwoBones("XQ", "XQ");
            phys_list.MakeJointFromTwoBones("XQ", "XOQ");
            phys_list.MakeJointFromTwoBones("XOR", "EXOR");
            phys_list.MakeJointFromTwoBones("EXOR", "EXR");
            phys_list.MakeJointFromTwoBones("EXR", "EXR");
            phys_list.MakeJointFromTwoBones("EXR", "XR");
            phys_list.MakeJointFromTwoBones("XR", "XR");
            phys_list.MakeJointFromTwoBones("XR", "XOR");
        }

        // XJ[gO
        private void SetParameter(List<PMD_RBody> body_list)
        {
            foreach (PMD_RBody body in body_list)
            {
                body.group_id = 4; // f[^FO[v // 00
                body.group_non_collision = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_id = 1; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.size.X = 0.8f; // `Fa() // CD CC CC 3F // 1.6
                body.size.Y *= 0.6f; // `F // CD CC CC 3D // 0.1
                body.size.Z = 0.2f; // `Fs // CD CC CC 3D // 0.1

                body.weight = 0.5f; // f[^F // 00 00 80 3F // 1.0
                body.position_dim = 0.5f; // f[^Fړ // 00 00 00 00
                body.rotation_dim = 0.9f; // f[^F] // 00 00 00 00
                body.recoil = 0.0f; // f[^F // 00 00 00 00
                body.friction = 0.0f; // f[^FC // 00 00 00 00
                body.type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        // XJ[g
        private void SetParameterSide(List<PMD_RBody> body_list)
        {
            foreach (PMD_RBody body in body_list)
            {
                body.group_id = 4; // f[^FO[v // 00
                body.group_non_collision = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_id = 1; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.size.X = 0.2f; // `Fa() // CD CC CC 3F // 1.6
                body.size.Y *= 0.6f; // `F // CD CC CC 3D // 0.1
                body.size.Z = 0.8f; // `Fs // CD CC CC 3D // 0.1

                body.weight = 0.5f; // f[^F // 00 00 80 3F // 1.0
                body.position_dim = 0.5f; // f[^Fړ // 00 00 00 00
                body.rotation_dim = 0.9f; // f[^F] // 00 00 00 00
                body.recoil = 0.0f; // f[^F // 00 00 00 00
                body.friction = 0.0f; // f[^FC // 00 00 00 00
                body.type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        // XJ[gO
        private void SetParameterEnd(List<PMD_RBody> body_list)
        {
            foreach (PMD_RBody body in body_list)
            {
                body.group_id = 4; // f[^FO[v // 00
                body.group_non_collision = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_id = 0; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.size.X = 0.2f; // `Fa() // CD CC CC 3F // 1.6

                body.weight = 0.5f; // f[^F // 00 00 80 3F // 1.0
                body.position_dim = 0.5f; // f[^Fړ // 00 00 00 00
                body.rotation_dim = 0.9f; // f[^F] // 00 00 00 00
                body.recoil = 0.0f; // f[^F // 00 00 00 00
                body.friction = 0.0f; // f[^FC // 00 00 00 00
                body.type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        // XJ[g
        private void SetParameterSideEnd(List<PMD_RBody> body_list)
        {
            foreach (PMD_RBody body in body_list)
            {
                body.group_id = 4; // f[^FO[v // 00
                body.group_non_collision = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_id = 0; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.size.X = 0.2f; // `Fa() // CD CC CC 3F // 1.6

                body.weight = 0.5f; // f[^F // 00 00 80 3F // 1.0
                body.position_dim = 0.5f; // f[^Fړ // 00 00 00 00
                body.rotation_dim = 0.9f; // f[^F] // 00 00 00 00
                body.recoil = 0.0f; // f[^F // 00 00 00 00
                body.friction = 0.0f; // f[^FC // 00 00 00 00
                body.type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        private void SetParameter(List<PMD_Joint> joint_list)
        {
            foreach (PMD_Joint joint in joint_list)
            {
                joint.rotation_min.X = Geometry.DegreeToRadian(-15.0f);
                joint.rotation_max.X = Geometry.DegreeToRadian(+15.0f);
                joint.rotation_min.Z = Geometry.DegreeToRadian(-15.0f);
                joint.rotation_max.Z = Geometry.DegreeToRadian(+15.0f);
                joint.spring_rotation = new Vector3(20.0f, 20.0f, 20.0f);
            }
        }
    }
}
