using System;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace TDCG
{
    /// <summary>
    /// J
    /// </summary>
public class Camera
{
    private Vector3 center = Vector3.Empty;
    private Vector3 translation = Vector3.Empty;
    private Vector3 localP = new Vector3(0.0f, 0.0f, -10.0f);
    private Vector3 dirD = Vector3.Empty; //JړxNg
    private float zD = 0.0f;      //JsItZbgl
    private bool needUpdate = true;    //XVKv邩
    private Matrix view = Matrix.Identity;  //r[s
    private Matrix pose = Matrix.Identity;
    private float rotZD = 0.0f;   //J Z]
    private float angleU = 0.02f;        //ړ]PʁiWAj

    /// <summary>
    /// ]S
    /// </summary>
    public Vector3 Center { get { return center; } set { center = value; } }

    /// <summary>
    /// viewW̃J̈ʒu
    /// </summary>
    public Vector3 Translation { get { return translation; } set { translation = value; } }

    /// <summary>
    /// __ƂW̃J̈ʒu
    /// </summary>
    public Vector3 LocalPosition { get { return localP; } set { localP = value; } }
    
    /// <summary>
    /// J̎ps
    /// </summary>
    public Matrix Pose { get { return pose; } set { pose = value; } }

    /// <summary>
    /// J𐶐܂B
    /// </summary>
    public Camera()
    {
    }

    /// <summary>
    /// J̈ʒuƎpWo͂֏o܂B
    /// </summary>
    public void Dump()
    {
        XmlSerializer serializer = new XmlSerializer(typeof(Camera));
        XmlWriterSettings settings = new XmlWriterSettings();
        settings.Encoding = Encoding.GetEncoding("Shift_JIS");
        settings.Indent = true;
        XmlWriter writer = XmlWriter.Create(Console.Out, settings);
        serializer.Serialize(writer, this);
        writer.Close();
    }

    /// <summary>
    /// J̈ʒuƎpwpX֏o܂B
    /// </summary>
    /// <param name="dest_file">pX</param>
    public void Save(string dest_file)
    {
        XmlSerializer serializer = new XmlSerializer(typeof(Camera));
        XmlWriterSettings settings = new XmlWriterSettings();
        settings.Encoding = Encoding.GetEncoding("Shift_JIS");
        settings.Indent = true;
        XmlWriter writer = XmlWriter.Create(dest_file, settings);
        serializer.Serialize(writer, this);
        writer.Close();
    }

    /// <summary>
    /// J̈ʒuƎpwpXǂݍ݂܂B
    /// </summary>
    /// <param name="source_file">pX</param>
    /// <returns>J</returns>
    public static Camera Load(string source_file)
    {
        XmlReader reader = XmlReader.Create(source_file);
        XmlSerializer serializer = new XmlSerializer(typeof(Camera));
        Camera camera = serializer.Deserialize(reader) as Camera;
        reader.Close();
        return camera;
    }

    /// <summary>
    /// J̈ʒuƎp⊮܂B
    /// </summary>
    /// <param name="cam1">ԊJn̈ʒupێJ</param>
    /// <param name="cam2">ԏÏʒupێJ</param>
    /// <param name="ratio">Ԕ䗦</param>
    /// <returns>J</returns>
    public static Camera Interpolation(Camera cam1, Camera cam2, float ratio)
    {
        Camera camera = new Camera();
        camera.Center = Vector3.Lerp(cam1.Center, cam2.Center, ratio);
        camera.Translation = Vector3.Lerp(cam1.Translation, cam2.Translation, ratio);
        camera.LocalPosition = Vector3.Lerp(cam1.LocalPosition, cam2.LocalPosition, ratio);
        Quaternion q1 = Quaternion.RotationMatrix(cam1.Pose);
        Quaternion q2 = Quaternion.RotationMatrix(cam2.Pose);
        camera.Pose = Matrix.RotationQuaternion(Quaternion.Slerp(q1, q2, ratio));
        return camera;
    }

    /// <summary>
    /// J̈ʒuƎp⊮܂B
    /// </summary>
    /// <param name="cam1">ԊJn̈ʒupێJ</param>
    /// <param name="cam2">ԏÏʒupێJ</param>
    /// <param name="ratio">Ԕ䗦</param>
    public void Interp(Camera cam1, Camera cam2, float ratio)
    {
        center = Vector3.Lerp(cam1.Center, cam2.Center, ratio);
        translation = Vector3.Lerp(cam1.Translation, cam2.Translation, ratio);
        localP = Vector3.Lerp(cam1.LocalPosition, cam2.LocalPosition, ratio);
        Quaternion q1 = Quaternion.RotationMatrix(cam1.Pose);
        Quaternion q2 = Quaternion.RotationMatrix(cam2.Pose);
        pose = Matrix.RotationQuaternion(Quaternion.Slerp(q1, q2, ratio));

        //viewsXV
        Vector3 posW = localP + center;
        {
            Matrix m = pose;
            m.M41 = posW.X;
            m.M42 = posW.Y;
            m.M43 = posW.Z;
            m.M44 = 1.0f;
            view = Matrix.Invert(m) * Matrix.Translation(-translation);
        }

        //Zbg
        ResetDefValue();
        needUpdate = false;
    }

    /// <summary>
    /// J̈ʒuƎpZbg܂B
    /// </summary>
    public void Reset()
    {
        center = Vector3.Empty;
        translation = Vector3.Empty;
        localP = new Vector3(0.0f, 0.0f, -10.0f);
        pose = Matrix.Identity;
        needUpdate = true;
    }

    /// <summary>
    /// J̈ʒuXV܂B
    /// </summary>
    /// <param name="dirX">ړioxj</param>
    /// <param name="dirY">ړiܓxj</param>
    /// <param name="dirZ">ړisj</param>
    public void Move(float dirX, float dirY, float dirZ)
    {
        if (dirX == 0.0f && dirY == 0.0f && dirZ == 0.0f)
            return;

        dirD.X += dirX;
        dirD.Y += dirY;
        this.zD += dirZ;
        needUpdate = true;
    }

    /// <summary>
    /// JZ]܂B
    /// </summary>
    /// <param name="angle">]pxiWAj</param>
    public void RotZ(float angle)
    {
        if (angle == 0.0f)
            return;

        rotZD = angle;
        needUpdate = true;
    }

    /// <summary>
    /// J̈ʒuƎpXV܂B
    /// }EX̉]S͌_ɃZbg܂B
    /// ӁF̑ Move() RotZ() Update() Ƃ͈قȂnłB
    /// </summary>
    /// <param name="eye">_</param>
    /// <param name="center">viewW̃J̈ʒu</param>
    /// <param name="up">xNg</param>
    public void LookAt(Vector3 eye, Vector3 center, Vector3 up)
    {
        this.localP = center - eye;
        {
            // JpXV
            Vector3 z = Vector3.Normalize(-localP);
            Vector3 y = up;
            Vector3 x = Vector3.Normalize(Vector3.Cross(y, z));
            y = Vector3.Normalize(Vector3.Cross(z, x));
            {
                Matrix m = Matrix.Identity;
                m.M11 = x.X;
                m.M12 = x.Y;
                m.M13 = x.Z;
                m.M21 = y.X;
                m.M22 = y.Y;
                m.M23 = y.Z;
                m.M31 = z.X;
                m.M32 = z.Y;
                m.M33 = z.Z;
                this.pose = m;
            }
        }
        this.center = Vector3.Empty;
        this.translation = eye;

        //viewsXV
        Vector3 posW = localP + this.center;
        {
            Matrix m = pose;
            m.M41 = posW.X;
            m.M42 = posW.Y;
            m.M43 = posW.Z;
            m.M44 = 1.0f;
            view = Matrix.Invert(m) * Matrix.Translation(-translation);
        }

        //Zbg
        ResetDefValue();
        needUpdate = false;
    }

    /// <summary>
    /// J̈ʒuƎpXV܂B
    /// }EX̉]S͌_ɃZbg܂B
    /// ӁF̑ Move() RotZ() Update() Ƃ͈قȂnłB
    /// </summary>
    /// <param name="eye">_</param>
    /// <param name="center">viewW̃J̈ʒu</param>
    public void LookAt(Vector3 eye, Vector3 center)
    {
        LookAt(eye, center, new Vector3(0.0f, 1.0f, 0.0f));
    }

    /// <summary>
    /// JZ𓾂܂B
    /// </summary>
    /// <returns>Z</returns>
    public Vector3 GetZAxis()
    {
        return new Vector3(pose.M31, pose.M32, pose.M33);
    }

    /// <summary>
    /// JY𓾂܂B
    /// </summary>
    /// <returns>Y</returns>
    public Vector3 GetYAxis()
    {
        return new Vector3(pose.M21, pose.M22, pose.M23);
    }

    /// <summary>
    /// J̈ʒuƎpXV܂B
    /// </summary>
    public void Update()
    {
        if (! needUpdate)
            return;

        //J Z]ŎpXV
        pose = Matrix.RotationZ(rotZD) * pose;

        //ܓxox̍ړ
        Vector3 localD = Vector3.TransformCoordinate(dirD, pose);
        if (localD.X != 0.0f || localD.Y != 0.0f || localD.Z != 0.0f)
        {
            //JʒuXV
            Vector3 zAxis = GetZAxis();
            Vector3 rotAxis = Vector3.Cross(localD, zAxis);
            Quaternion q = Quaternion.RotationAxis(rotAxis, angleU * dirD.Length());
            Matrix rotation = Matrix.RotationQuaternion(q);
            localP = Vector3.TransformCoordinate(localP, rotation);

            //JpXV
            Vector3 z = Vector3.Normalize(-localP);
            Vector3 y = GetYAxis();
            Vector3 x = Vector3.Normalize(Vector3.Cross(y, z));
            y = Vector3.Normalize(Vector3.Cross(z, x));
            {
                Matrix m = Matrix.Identity;
                m.M11 = x.X;
                m.M12 = x.Y;
                m.M13 = x.Z;
                m.M21 = y.X;
                m.M22 = y.Y;
                m.M23 = y.Z;
                m.M31 = z.X;
                m.M32 = z.Y;
                m.M33 = z.Z;
                pose = m;
            }
        }

        //sItZbgXV
        if (zD != 0.0f && localP.Length() - zD > 0)
        {
            Vector3 z = Vector3.Normalize(-localP);
            localP += zD * z;
        }

        //viewsXV
        Vector3 worldP = localP + center;
        {
            Matrix m = pose;
            m.M41 = worldP.X;
            m.M42 = worldP.Y;
            m.M43 = worldP.Z;
            m.M44 = 1.0f;
            view = Matrix.Invert(m) * Matrix.Translation(-translation);
        }

        //Zbg
        ResetDefValue();
        needUpdate = false;
    }

    /// <summary>
    /// views擾܂B
    /// </summary>
    public Matrix GetViewMatrix()
    {
        return view;
    }

    /// <summary>
    /// ]Sݒ肵܂B
    /// </summary>
    /// <param name="center">]S</param>
    public void SetCenter(Vector3 center)
    {
        this.center = center;
        needUpdate = true;
    }
    public void SetCenter(float x, float y, float z)
    {
        SetCenter(new Vector3(x, y, z));
    }

    /// <summary>
    /// viewẄʒuݒ肵܂B
    /// </summary>
    /// <param name="translation">viewẄʒu</param>
    public void SetTranslation(Vector3 translation)
    {
        this.translation = translation;
        needUpdate = true;
    }
    public void SetTranslation(float x, float y, float z)
    {
        SetTranslation(new Vector3(x, y, z));
    }

    /// <summary>
    /// viewWňړ܂B
    /// </summary>
    /// <param name="dx">Xړ</param>
    /// <param name="dy">Yړ</param>
    public void MoveView(float dx, float dy)
    {
        this.translation.X += dx;
        this.translation.Y += dy;
        needUpdate = true;
    }

    /// <summary>
    /// Zbg܂B
    /// </summary>
    protected void ResetDefValue()
    {
        dirD = Vector3.Empty;
        zD = 0.0f;
        rotZD = 0.0f;
    }

}
}
