using System;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace TDCG
{
    /// <summary>
    /// J
    /// </summary>
    public class SimpleCamera
    {
        private Vector3 center = Vector3.Empty;
        private Vector3 translation = new Vector3(0.0f, 0.0f, +10.0f);
        private Vector3 dirD = Vector3.Empty; //JړxNg
        private float zD = 0.0f;      //JsItZbgl
        private bool needUpdate = true;
        private Matrix view = Matrix.Identity;
        private Vector3 angle = Vector3.Empty;
        private float rotZD = 0.0f;   //J Z]
        private float angleU = 0.01f;        //ړ]PʁiWAj

        /// <summary>
        /// ]S
        /// </summary>
        public Vector3 Center { get { return center; } set { center = value; } }

        /// <summary>
        /// viewW̃J̈ʒu
        /// </summary>
        public Vector3 Translation { get { return translation; } set { translation = value; } }
    
        /// <summary>
        ///XVKv邩
        /// </summary>
        public bool NeedUpdate { get { return needUpdate; }}

        /// <summary>
        /// r[s
        /// </summary>
        public Matrix ViewMatrix { get { return view; } }

        /// <summary>
        /// J̈ʒuƎpZbg܂B
        /// </summary>
        public void Reset()
        {
            center = Vector3.Empty;
            translation = new Vector3(0.0f, 0.0f, +10.0f);
            angle = Vector3.Empty;
            needUpdate = true;
        }

        /// <summary>
        /// viewW̃J̈ʒuZbg܂B
        /// </summary>
        public void ResetTranslation()
        {
            translation = new Vector3(0.0f, 0.0f, +10.0f);
            needUpdate = true;
        }

        /// <summary>
        /// J̈ʒuXV܂B
        /// </summary>
        /// <param name="dirX">ړioxj</param>
        /// <param name="dirY">ړiܓxj</param>
        /// <param name="dirZ">ړisj</param>
        public void Move(float dirX, float dirY, float dirZ)
        {
            if (dirX == 0.0f && dirY == 0.0f && dirZ == 0.0f)
                return;

            dirD.X += dirX;
            dirD.Y += dirY;
            this.zD += dirZ;
            needUpdate = true;
        }

        /// <summary>
        /// JZ]܂B
        /// </summary>
        /// <param name="angle">]pxiWAj</param>
        public void RotZ(float angle)
        {
            if (angle == 0.0f)
                return;

            rotZD = angle;
            needUpdate = true;
        }

        /// <summary>
        /// J̈ʒuƎpXV܂B
        /// </summary>
        public void Update()
        {
            if (!needUpdate)
                return;

            angle.Y += angleU * -dirD.X;
            angle.X += angleU * +dirD.Y;
            angle.Z += +rotZD;
            this.translation.Z += zD;

            Matrix m = Matrix.RotationYawPitchRoll(angle.Y, angle.X, angle.Z);
            m.M41 = center.X;
            m.M42 = center.Y;
            m.M43 = center.Z;
            m.M44 = 1;

            view = Matrix.Invert(m) * Matrix.Translation(-translation);

            //Zbg
            ResetDefValue();
            needUpdate = false;
        }

        /// <summary>
        /// views擾܂B
        /// </summary>
        public Matrix GetViewMatrix()
        {
            return view;
        }

        /// <summary>
        /// ]Sݒ肵܂B
        /// </summary>
        /// <param name="center">]S</param>
        public void SetCenter(Vector3 center)
        {
            this.center = center;
            needUpdate = true;
        }
        /// <summary>
        /// ]Sݒ肵܂B
        /// </summary>
        /// <param name="x">]SxW</param>
        /// <param name="y">]SyW</param>
        /// <param name="z">]SzW</param>
        public void SetCenter(float x, float y, float z)
        {
            SetCenter(new Vector3(x, y, z));
        }

        /// <summary>
        /// viewẄʒuݒ肵܂B
        /// </summary>
        /// <param name="translation">viewẄʒu</param>
        public void SetTranslation(Vector3 translation)
        {
            this.translation = translation;
            needUpdate = true;
        }
        /// <summary>
        /// viewẄʒuݒ肵܂B
        /// </summary>
        /// <param name="x">viewẄʒuxW</param>
        /// <param name="y">viewẄʒuyW</param>
        /// <param name="z">viewẄʒuzW</param>
        public void SetTranslation(float x, float y, float z)
        {
            SetTranslation(new Vector3(x, y, z));
        }

        /// <summary>
        /// viewWňړ܂B
        /// </summary>
        /// <param name="dx">Xړ</param>
        /// <param name="dy">Yړ</param>
        public void MoveView(float dx, float dy)
        {
            this.translation.X += dx;
            this.translation.Y += dy;
            needUpdate = true;
        }

        /// <summary>
        /// Zbg܂B
        /// </summary>
        protected void ResetDefValue()
        {
            dirD = Vector3.Empty;
            zD = 0.0f;
            rotZD = 0.0f;
        }
    }
}
