using System;
using System.Collections.Generic;
using System.Diagnostics;
//using System.Drawing;
using System.Threading;
//using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace TDCG
{
    /// <summary>
    /// tBMA
    /// </summary>
public class Figure : IDisposable
{
    /// <summary>
    /// tBMAێĂtsoXg
    /// </summary>
    public List<TSOFile> TSOList = new List<TSOFile>();
    internal TMOFile tmo = null;

    internal Vector3 center = Vector3.Empty;
    /// <summary>
    /// SW
    /// </summary>
    public Vector3 Center
    {
        get { return center; }
    }

    internal Vector3 translation = Vector3.Empty;
    /// <summary>
    /// ړψ
    /// </summary>
    public Vector3 Translation
    {
        get { return translation; }
    }

    /// <summary>
    /// tmo
    /// </summary>
    public TMOFile Tmo
    {
        get { return tmo; }
        set
        {
            tmo = value;
            ResetFrameIndex();
            SetCenterToHips();
        }
    }

    internal Dictionary<TSONode, TMONode> nodemap;

    /// <summary>
    /// tBMAړ܂i΍WjB
    /// </summary>
    /// <param name="dx">Xψ</param>
    /// <param name="dy">Yψ</param>
    /// <param name="dz">Zψ</param>
    public void Move(float dx, float dy, float dz)
    {
        Move(new Vector3(dx, dy, dz));
    }

    /// <summary>
    /// tBMAړ܂i΍WjB
    /// </summary>
    /// <param name="delta">ψ</param>
    public void Move(Vector3 delta)
    {
        center += delta;
        translation += delta;
        UpdateBoneMatrices(true);
    }

    /// <summary>
    /// wʒuɂtsöʒuւ܂B`揇ύX܂B
    /// </summary>
    /// <param name="aidx">Xg̈ʒua</param>
    /// <param name="bidx">Xg̈ʒub</param>
    public void SwapAt(int aidx, int bidx)
    {
        Debug.Assert(aidx < bidx);
        TSOFile a = TSOList[aidx];
        TSOFile b = TSOList[bidx];
        TSOList.RemoveAt(bidx);
        TSOList.RemoveAt(aidx);
        TSOList.Insert(aidx, b);
        TSOList.Insert(bidx, a);
    }

    /// <summary>
    /// nodemapbonesXV܂B
    /// </summary>
    public void UpdateNodeMapAndBoneMatrices()
    {
        nodemap.Clear();
        if (tmo.frames != null)
        foreach (TSOFile tso in TSOList)
            AddNodeMap(tso);

        UpdateBoneMatrices(true);
    }

    /// <summary>
    /// tsoɑ΂nodemapǉ܂B
    /// </summary>
    /// <param name="tso">tso</param>
    protected void AddNodeMap(TSOFile tso)
    {
        foreach (TSONode tso_node in tso.nodes)
        {
            TMONode tmo_node;
            if (tmo.nodemap.TryGetValue(tso_node.Name, out tmo_node))
                nodemap.Add(tso_node, tmo_node);
        }
    }

    private MatrixStack matrixStack = null;
    private int frame_index = 0;
    private int current_frame_index = 0;

    /// <summary>
    /// tBMA𐶐܂B
    /// </summary>
    public Figure()
    {
        tmo = new TMOFile();
        nodemap = new Dictionary<TSONode, TMONode>();
        matrixStack = new MatrixStack();
    }
    
    /// <summary>
    /// t[ԍ0ɐݒ肵܂B
    /// </summary>
    protected void ResetFrameIndex()
    {
        frame_index = 0;
        current_frame_index = 0;
    }

    /// <summary>
    /// S_bonëʒuɐݒ肵܂B
    /// </summary>
    protected void SetCenterToHips()
    {
        Debug.Assert(tmo != null);
        TMONode tmo_node;
        if (tmo.nodemap.TryGetValue("|W_Hips", out tmo_node))
        {
            Debug.Assert(tmo_node.frame_matrices.Count > 0);
            Matrix m = tmo_node.frame_matrices[0].m;
            center = new Vector3(m.M41, m.M42, -m.M43);
        }
    }

    /// <summary>
    /// ̃t[ɐi݂܂B
    /// </summary>
    public void NextTMOFrame()
    {
        if (tmo.frames != null)
        {
            frame_index++;
            if (frame_index >= tmo.frames.Length)
                frame_index = 0;
        }
    }

    /// <summary>
    /// ݂̃t[𓾂܂B
    /// </summary>
    /// <returns>݂tmo frame</returns>
    protected TMOFrame GetTMOFrame()
    {
        if (tmo.frames != null)
        {
            Debug.Assert(current_frame_index >= 0 && current_frame_index < tmo.frames.Length);
            return tmo.frames[current_frame_index];
        }
        return null;
    }

    /// <summary>
    /// ݂̃t[ԍ𓾂܂B
    /// </summary>
    /// <returns></returns>
    public int GetFrameIndex()
    {
        return current_frame_index;
    }

    /// <summary>
    /// tsoTSOListɒǉ܂B
    /// </summary>
    /// <param name="tso">tso</param>
    public void AddTSO(TSOFile tso)
    {
        if (tmo.frames != null)
            AddNodeMap(tso);

        current_frame_index = frame_index;

        TMOFrame tmo_frame = GetTMOFrame();
        UpdateBoneMatrices(tso, tmo_frame);
        //CopyBoneMatricesToTSO(tso);

        TSOList.Add(tso);
    }

    /// <summary>
    /// bonesXV܂Btmo frame𖳎܂B
    /// </summary>
    public void UpdateBoneMatricesWithoutTMOFrame()
    {
        foreach (TSOFile tso in TSOList)
            UpdateBoneMatrices(tso, null);
            //CopyBoneMatricesToTSO(tso);
    }

    /// <summary>
    /// bonesXV܂B
    /// </summary>
    public void UpdateBoneMatrices()
    {
        UpdateBoneMatrices(false);
    }

    /// <summary>
    /// bonesXV܂B
    /// </summary>
    /// <param name="forced">falsȅꍇframe indexɕύXȂ΍XV܂B</param>
    public void UpdateBoneMatrices(bool forced)
    {
        if (!forced && frame_index == current_frame_index)
            return;
        current_frame_index = frame_index;

        TMOFrame tmo_frame = GetTMOFrame();

        foreach (TSOFile tso in TSOList)
            UpdateBoneMatrices(tso, tmo_frame);
            //CopyBoneMatricesToTSO(tso);
    }
    
    /// <summary>
    /// bonesXV܂B
    /// </summary>
    protected void UpdateBoneMatrices(TSOFile tso, TMOFrame tmo_frame)
    {
        matrixStack.LoadMatrix(Matrix.Translation(translation));
        UpdateBoneMatrices(tso.nodes[0], tmo_frame);
    }

    /// <summary>
    /// bonesXV܂B
    /// </summary>
    protected void UpdateBoneMatrices(TSONode tso_node, TMOFrame tmo_frame)
    {
        matrixStack.Push();

        if (tmo_frame != null)
        {
            // TMO animation
            TMONode tmo_node;
            if (nodemap.TryGetValue(tso_node, out tmo_node))
            tso_node.TransformationMatrix = tmo_frame.matrices[tmo_node.ID].m;
        }
        matrixStack.MultiplyMatrixLocal(tso_node.TransformationMatrix);
        tso_node.combined_matrix = matrixStack.Top;

        foreach (TSONode child_node in tso_node.child_nodes)
            UpdateBoneMatrices(child_node, tmo_frame);

        matrixStack.Pop();
    }

    /// <summary>
    /// TSOFilewdeviceŊJ܂B
    /// </summary>
    /// <param name="device">device</param>
    /// <param name="effect">effect</param>
    public void OpenTSOFile(Device device, Effect effect)
    {
        foreach (TSOFile tso in TSOList)
            tso.Open(device, effect);
    }

    private FigureMotion motion = new FigureMotion();
    
    /// <summary>
    /// tBMA[V
    /// </summary>
    public FigureMotion Motion
    {
        get { return motion; }
    }

    /// <summary>
    /// tBMA[Vݒ肵܂B
    /// </summary>
    /// <param name="frame_index">t[ԍ</param>
    /// <param name="tmo">tmo</param>
    public void SetMotion(int frame_index, TMOFile tmo)
    {
        motion.Add(frame_index, tmo);
    }

    /// <summary>
    /// ̃[Vt[ɐi݂܂B
    /// </summary>
    public void NextFrame()
    {
        if (motion.Count != 0)
        {
            TMOFile tmo = motion.GetTMO();
            if (tmo != Tmo)
            {
                Tmo = tmo;
                UpdateNodeMapAndBoneMatrices();
            }
            motion.NextFrame();
        }
    }

    /// <summary>
    /// w胂[Vt[ɐi݂܂B
    /// </summary>
    public void SetFrameIndex(int frame_index)
    {
        Debug.Assert(frame_index >= 0);
        if (tmo.frames != null)
        {
            if (frame_index >= tmo.frames.Length)
                this.frame_index = 0;
            else
                this.frame_index = frame_index;
        }
    }

    /// <summary>
    /// objectj܂B
    /// </summary>
    public void Dispose()
    {
        foreach (TSOFile tso in TSOList)
            tso.Dispose();
    }
}
}
