using System;
using System.Collections.Generic;
using System.IO;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

using TDCG;
using TDCGUtils;
using Tso2Pmd;

using jp.nyatla.nymmd.cs.types;
using jp.nyatla.nymmd.cs.core;
using jp.nyatla.nymmd.cs.struct_type;
using jp.nyatla.nymmd.cs.struct_type.pmd;

namespace TDCG.PhysObTemplate
{
    public class Kami_Twin : IPhysObTemplate
    {
        string name = "cCe["; // gɕ\閼O
        int group = 0;              // \g̎ށi0: 1: 2:XJ[g 3:̑j

        public string Name() { return name; }
        public int Group() { return group; }

        public void Execute(ref T2PPhysObjectList phys_list)
        {
            phys_list.MakeChain("P");
            phys_list.MakeChain("EP");
            phys_list.MakeChain("P");
            phys_list.MakeChain("EP");
            phys_list.MakeChain("OP");
            phys_list.MakeChain("EOP");

            SetParameter(phys_list.GetBodyListByName("..*"));
            SetParameterEnd(phys_list.GetBodyListByName("..*"));
            SetParameter(phys_list.GetJointListByName("..*"));

            phys_list.GetBodyByName("P").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("Q").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("R").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]

            phys_list.GetBodyByName("EP").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("EQ").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("ER").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]

            phys_list.GetBodyByName("P").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("Q").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetJointByName("Q-R").constrain_rot_1.x = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("Q-R").constrain_rot_2.x = (float)((30.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("R-S").constrain_rot_1.x = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("R-S").constrain_rot_2.x = (float)((30.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))

            phys_list.GetBodyByName("EP").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("EQ").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetJointByName("EQ-ER").constrain_rot_1.x = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("EQ-ER").constrain_rot_2.x = (float)((30.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("ER-ES").constrain_rot_1.x = (float)((-5.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
            phys_list.GetJointByName("ER-ES").constrain_rot_2.x = (float)((30.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))

            phys_list.GetBodyByName("OP").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("OQ").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("OR").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("O").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]

            phys_list.GetBodyByName("EOP").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("EOQ").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("EOR").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("EO").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
        }

        private void SetParameter(List<PMD_RigidBody> body_list)
        {
            foreach (PMD_RigidBody body in body_list)
            {
                body.rigidbody_group_index = 2; // f[^FO[v // 00
                body.rigidbody_group_target = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_type = 2; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.shape_w = 0.4f; // `Fa() // CD CC CC 3F // 1.6
                body.shape_h *= 0.6f; // `F // CD CC CC 3D // 0.1

                body.rigidbody_weight = 0.5f; // f[^F // 00 00 80 3F // 1.0
                body.rigidbody_pos_dim = 0.8f; // f[^Fړ // 00 00 00 00
                body.rigidbody_rot_dim = 0.8f; // f[^F] // 00 00 00 00
                body.rigidbody_recoil = 0.0f; // f[^F // 00 00 00 00
                body.rigidbody_friction = 0.8f; // f[^FC // 00 00 00 00
                body.rigidbody_type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        private void SetParameterEnd(List<PMD_RigidBody> body_list)
        {
            foreach (PMD_RigidBody body in body_list)
            {
                body.rigidbody_group_index = 2; // f[^FO[v // 00
                body.rigidbody_group_target = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_type = 0; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.shape_w = 0.3f; // `Fa() // CD CC CC 3F // 1.6

                body.rigidbody_weight = 1.0f; // f[^F // 00 00 80 3F // 1.0
                body.rigidbody_pos_dim = 0.8f; // f[^Fړ // 00 00 00 00
                body.rigidbody_rot_dim = 0.8f; // f[^F] // 00 00 00 00
                body.rigidbody_recoil = 0.0f; // f[^F // 00 00 00 00
                body.rigidbody_friction = 0.8f; // f[^FC // 00 00 00 00
                body.rigidbody_type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        private void SetParameter(List<PMD_Joint> joint_list)
        {
            foreach (PMD_Joint joint in joint_list)
            {
                joint.constrain_rot_1.x = (float)((-20.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
                joint.constrain_rot_2.x = (float)((20.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
                joint.constrain_rot_1.z = (float)((-20.0 / 180.0) * Math.PI); // F]1(rad(x), rad(y), rad(z))
                joint.constrain_rot_2.z = (float)((20.0 / 180.0) * Math.PI); // F]2(rad(x), rad(y), rad(z))
                joint.spring_rot.x = 10.0f; // ΂ˁF](rad(x), rad(y), rad(z))
                joint.spring_rot.y = 10.0f; // ΂ˁF](rad(x), rad(y), rad(z))
                joint.spring_rot.z = 10.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            }
        }
    }
}
