using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;

namespace TDCG
{
/// <summary>
/// TPOt@C̃XgłB
/// </summary>
public class TPOFileList
{
    /// TPOt@CXg
    public List<TPOFile> files = new List<TPOFile>();

    //[Vslێt[z
    private TMOFrame[] frames;

    private TMOFile tmo = null;

    /// <summary>
    /// CfNT
    /// </summary>
    /// <param name="i">index</param>
    /// <returns>tpo</returns>
    public TPOFile this[int i]
    {
        get
        {
            return files[i];
        }
    }

    /// <summary>
    /// CfNT
    /// </summary>
    /// <param name="name">proportion name</param>
    /// <returns>tpo</returns>
    public TPOFile this[string name]
    {
        get
        {
            return files.Find(delegate(TPOFile tpo) { return tpo.ProportionName == name; });
        }
    }

    /// <summary>
    /// vf
    /// </summary>
    public int Count
    {
        get
        {
            return files.Count;
        }
    }
    
    /// <summary>
    /// tpoǉ܂B
    /// </summary>
    /// <param name="tpo"></param>
    public void Add(TPOFile tpo)
    {
        tpo.Tmo = tmo;
        files.Add(tpo);
    }

    /// <summary>
    /// TPOt@CXg܂B
    /// </summary>
    public void Clear()
    {
        files.Clear();
    }

    /// <summary>
    /// ̌^Xgݒ肵܂B
    /// </summary>
    /// <param name="pro_list">̌^Xg</param>
    public void SetProportionList(ProportionList pro_list)
    {
        Clear();
        foreach (IProportion pro in pro_list.items)
        {
            TPOFile tpo = new TPOFile();
            tpo.Proportion = pro;
            Add(tpo);
        }
    }

    /// <summary>
    /// ̌^Vsό`䗦ݒ肵܂B
    /// </summary>
    /// <param name="config">̌^Vs</param>
    public void SetRatiosFromConfig(TPOConfig config)
    {
        Dictionary<string, Proportion> proportion_map = new Dictionary<string, Proportion>();

        foreach (Proportion proportion in config.Proportions)
            proportion_map[proportion.ClassName] = proportion;

        foreach (TPOFile tpo in files)
        {
            Debug.Assert(tpo.Proportion != null, "tpo.Proportion should not be null");
            Proportion proportion;
            if (proportion_map.TryGetValue(tpo.ProportionName, out proportion))
                tpo.Ratio = proportion.Ratio;
        }
    }

    /// <summary>
    /// ό`䗦܂B
    /// </summary>
    public void ClearRatios()
    {
        foreach (TPOFile tpo in files)
        {
            tpo.Ratio = 0.0f;
        }
    }

    /// <summary>
    /// SẴt[Ɋ܂܂郂[Vslό`܂B
    /// </summary>
    public void Transform()
    {
        LoadMatrix();
        foreach (TPOFile tpo in files)
            tpo.Transform();
    }

    /// <summary>
    /// wԍ̃t[Ɋ܂܂郂[Vslό`܂B
    /// </summary>
    /// <param name="frame_index">t[ԍ</param>
    public void Transform(int frame_index)
    {
        LoadMatrix();
        foreach (TPOFile tpo in files)
            tpo.Transform(frame_index);
    }

    /// <summary>
    /// tmo
    /// </summary>
    public TMOFile Tmo
    {
        get
        {
            return tmo;
        }
        set
        {
            tmo = value;

            foreach (TPOFile tpo in files)
                tpo.Tmo = tmo;

            CreateFrames();
            SaveMatrix();
        }
    }

    //[Vslێ̈mۂ܂B
    private void CreateFrames()
    {
        if (tmo.frames == null)
            return;

        int frame_count = tmo.frames.Length;
        frames = new TMOFrame[frame_count];
        for (int i = 0; i < frame_count; i++)
        {
            int matrix_count = tmo.frames[i].matrices.Length;
            frames[i] = new TMOFrame(i);
            frames[i].matrices = new TMOMat[matrix_count];
            for (int j = 0; j < matrix_count; j++)
            {
                frames[i].matrices[j] = new TMOMat();
            }
        }
    }

    /// <summary>
    /// ޔ[Vsltmoɖ߂܂B
    /// </summary>
    public void LoadMatrix()
    {
        if (frames == null)
            return;

        if (tmo.frames == null)
            return;

        int frame_count = frames.Length;
        for (int i = 0; i < frame_count; i++)
        {
            int matrix_count = frames[i].matrices.Length;
            for (int j = 0; j < matrix_count; j++)
                tmo.frames[i].matrices[j].m = frames[i].matrices[j].m;
        }
    }

    /// <summary>
    /// [Vsltmoޔ܂B
    /// </summary>
    public void SaveMatrix()
    {
        if (frames == null)
            return;

        if (tmo.frames == null)
            return;

        int frame_count = frames.Length;
        for (int i = 0; i < frame_count; i++)
        {
            int matrix_count = frames[i].matrices.Length;
            for (int j = 0; j < matrix_count; j++)
                frames[i].matrices[j].m = tmo.frames[i].matrices[j].m;
        }
    }
}
}
