﻿//-----------------------------------------------------------------------------
//  TenjiTexter
//  Copyright(c)2009 Masataka Shinke
//  <http://www.shinke.net/>  
//-----------------------------------------------------------------------------

///////////////////////////////////////////////////////////////////////////////
// インクルード宣言
#include "stdafx.h"			//
#include "Braille.h"		// 点字変換クラスライブラリ

///////////////////////////////////////////////////////////////////////////////
// コンストラクタ
CBraille::CBraille(wstring m_FileName)
{
	///////////////////////////////////////////////////////////////////////////
	// ファイル読み込み
	this->m_Data = this->ReadFile(m_FileName);
	
	///////////////////////////////////////////////////////////////////////////
	// 略語列取得
	for(unsigned i=0;i<this->size(e07);i+=2)
	{
		if(e07[i+1].length()==2)
		{
			wstring m_Bf;
			m_Bf += e07[i+1].at(0);
			m_Buff.push_back(m_Bf); 
		}
	}
	//文字昇順ソート	
	sort(m_Buff.begin(),m_Buff.end());
	vector<wstring>::iterator new_end = 
		unique(m_Buff.begin(),m_Buff.end(),this->is_eqals);
	//重複データを削除する（文字昇順ソート済みであること）		
	m_Buff.erase(new_end, m_Buff.end());							
	//文字数降順ソート
	//sort(m_Buff.begin(),m_Buff.end(),this->is_sizes);

	// 文字列の降順ソート
	sort(m_Buff.begin(),m_Buff.end(),greater<wstring>());
	
	//区切り文字のコード一覧を作る。
	m_Separator = L"⠀⠤\r\n";

//	m_Katakana = this->katakana_conv();

	m_Katakana = this->Cxx(this->katakana_conv());	// カタカナ変換
	m_Katakana = this->Cxx2(m_Katakana);			// 改行コードを変換
	m_Katakana = this->Cxx3(m_Katakana);			// 行頭にスペースを埋め込む
	
}
///////////////////////////////////////////////////////////////////////////////
// デストラクタ
CBraille::~CBraille(void)
{
	
}
///////////////////////////////////////////////////////////////////////////////
// 点字ベースコード凸面(braille)
// 戻り値：６点字文字コード（０から６３のユニコード）
wstring CBraille::braille_code(void)
{
	wstring ret;
	for(wchar_t  i=(wchar_t)L'⠀';i<=(wchar_t)L'⠿';i++)
		ret += i;
	return ret;
}

///////////////////////////////////////////////////////////////////////////////
// 点字ベースコード凹面(braille)
// 戻り値：６点字文字コード（０から６３のユニコード）
wstring CBraille::braille_code_r(void)
{
	wstring ret;
	for(wchar_t  i=(wchar_t)L'⠿';i>=(wchar_t)L'⠀';i--)
		ret += i;
	return ret;
}
///////////////////////////////////////////////////////////////////////////////
// 点字ベースコード凸面(win-bes)
// 戻り値：６点字文字コード（０から６３のｗｉｎ－ｂｅｓコード）
wstring CBraille::winbes_code(void)
{
	wstring ret;
	for(wchar_t  i=(wchar_t)L' ';i<=(wchar_t)L'_';i++)
		ret += i;
	return ret;
}
///////////////////////////////////////////////////////////////////////////////
// 点字ベースコード凹面(win-bes)
// 戻り値：６点字文字コード（０から６３のｗｉｎ－ｂｅｓコード）
wstring CBraille::winbes_code_r(void)
{
	wstring ret;
	for(wchar_t  i=(wchar_t)L'_';i>=(wchar_t)L' ';i--)
		ret += i;
	return ret;
}

///////////////////////////////////////////////////////////////////////////////
// カタカナ　ベースコード
// 戻り値：カタカナ文字コード（ア～ン）
wstring CBraille::katakana_code(void)
{
	wstring ret;
	for(wchar_t  i=(wchar_t)L'ｱ';i<=(wchar_t)L'ﾝ';i++)
		ret += i;
	return ret;
}
//////////////////////////////////////////////////////////////////////////////////
// カタカナからひらがなに変換
// 引き数：カタカナ
// 戻り値：ひらがな
wstring CBraille::katakana_to_hiragana(wstring katakana)
{
	wchar_t h1 = L'ぁ';
	wchar_t h2 = L'ん';
	wchar_t k1 = L'ァ';
	wchar_t k2 = L'ン';
	wstring ret = L"";
	for(unsigned i=0;i<katakana.length() ; i++ )
		if( (katakana[i]<k1)||(katakana[i]>k2) )
			ret += katakana[i];
		else 
			ret += (katakana[i]+(h1-k1));
	return ret;
}
//////////////////////////////////////////////////////////////////////////////////
// ひらがなからカタカナに変換
// 引き数：ひらがな
// 戻り値：カタカナ
wstring CBraille::hiragana_to_katakana(wstring hiragana)
{
	wchar_t h1 = L'ぁ';
	wchar_t h2 = L'ん';
	wchar_t k1 = L'ァ';
	wchar_t k2 = L'ン';
	wstring ret = L"";
	for(unsigned i=0;i<hiragana.length() ; i++ )
		if( (hiragana[i]<h1)||(hiragana[i]>h2) )
			ret += hiragana[i];
		else 
			ret += (hiragana[i]+(k1-h1));
	return ret;
}
//////////////////////////////////////////////////////////////////////////////////
// アルファベットの小文字を大文字に変換
// 引き数：小文字
// 戻り値：大文字
wstring CBraille::a_to_A(wstring al)
{
	wchar_t h1 = L'a';
	wchar_t h2 = L'z';
	wchar_t k1 = L'A';
	wchar_t k2 = L'Z';
	wstring ret = L"";
	for(unsigned i=0;i<al.length() ; i++ )
		if( (al[i]<h1)||(al[i]>h2) )
			ret += al[i];
		else 
			ret += (al[i]+(k1-h1));
	return ret;
}
//////////////////////////////////////////////////////////////////////////////////
// アルファベットの大文字を小文字に変換
// 引き数：小文字
// 戻り値：大文字
wstring CBraille::A_to_a(wstring Al)
{
	wchar_t h1 = L'A';
	wchar_t h2 = L'Z';
	wchar_t k1 = L'a';
	wchar_t k2 = L'z';
	wstring ret = L"";
	for(unsigned i=0;i<Al.length() ; i++ )
		if( (Al[i]<h1)||(Al[i]>h2) )
			ret += Al[i];
		else 
			ret += (Al[i]+(k1-h1));
	return ret;
}

//////////////////////////////////////////////////////////
//ワイド文字列からマルチバイト文字列
//ロケール依存
// 	実行時時に指定が必要：setlocale(LC_CTYPE, "");
string CBraille::narrow(const wstring &src) {
	string dest = "";	
	char *mbs = new char[src.length() * MB_CUR_MAX + 1];
size_t convertedChars = 0;
wcstombs_s(&convertedChars,mbs, src.length() * MB_CUR_MAX + 1, src.c_str(),_TRUNCATE);
//@@	wcstombs(mbs, src.c_str(), src.length() * MB_CUR_MAX + 1);
	dest = mbs;
	delete [] mbs;
	return dest;	
}
//////////////////////////////////////////////////////////
//マルチバイト文字列からワイド文字列
//ロケール依存
// 	実行時時に指定が必要：setlocale(LC_CTYPE, "");
wstring CBraille::widen(const string &src)
{
	std::wstring dest=L"";	
	wchar_t *wcs = new wchar_t[src.length() + 1];
size_t convertedChars = 0;
mbstowcs_s(&convertedChars,wcs,src.length() + 1,src.c_str(),_TRUNCATE);
//@@	mbstowcs(wcs, src.c_str(), src.length() + 1);
	dest = wcs;
	delete [] wcs;
	return dest;	
}
///////////////////////////////////////////////////////////
// 重複チェック演算子(wstring)
// 
bool CBraille::is_eqals(const wstring& left,const wstring& right)
{
	return ((left.compare(right)==0) );
}
///////////////////////////////////////////////////////////////////////////////
// 文字サイズ降順チェック演算子(wstring)
//  
bool CBraille::is_sizes(const wstring& left,const wstring& right) 
{
    return left.size() > right.size();
}
///////////////////////////////////////////////////////////////////////////////
// ＢＥＳ、ＢＥＴファイル読み込み関数
// 引き数：ファイル名
// 戻り値：ＵＮＩＣＯＤＥ点字データ
wstring CBraille::ReadFile(wstring p_LoadFileName)
{

	///////////////////////////////////////////////////////////////////////////
	// テキストファイルの場合の処理
	if	(this->a_to_A(p_LoadFileName).rfind(L".TXT")==wstring::npos)
	{
		;
		;
		;
	}
	///////////////////////////////////////////////////////////////////////////
	// 拡張子チエック
	if( 
		(this->a_to_A(p_LoadFileName).rfind(L".BES")==wstring::npos) && 
		(this->a_to_A(p_LoadFileName).rfind(L".BET")==wstring::npos)
	)
	return L"File Extension Error";	
	
	///////////////////////////////////////////////////////////////////////////
	// 点字ファイルオープン
	ifstream p_FileStream;
	p_FileStream.open( 
		narrow(p_LoadFileName).c_str(),
		ios::binary  | ios::in
	);
	bool  p_ISOPEN = p_FileStream.is_open();
	///////////////////////////////////////////////////////////////////////////
	// 点字ファイルオープン
	if(!p_ISOPEN)
		return L"File Open Error";
	///////////////////////////////////////////////////////////////////////////
	// バッファー宣言
	unsigned char ch		= 0x00;
	string buff		= "";
	///////////////////////////////////////////////////////////////////////////
	// ヘッダー読み込み
	while((ch!=0xfd)&&(!p_FileStream.eof()))
	{
		unsigned int pHederCount=0x00;
		p_FileStream >> ch;
		if( p_FileStream.fail() )
			return L"File Read Error";
		if(pHederCount++ > 1024)
			break;
	}
	//////////////////////////////////////////////////////////////////////////////
	// 本文読み込み
	while(!p_FileStream.eof())
	{
		p_FileStream >> ch;
		buff+=(char)ch;
		if( p_FileStream.fail() )
			break;					
	}
	//////////////////////////////////////////////////////////////////////////////
	// ページサイズコードを点字のスペースコードに置換する。
	for(unsigned i=2;i<buff.length();i++)	//@@ i=0から2に変更2009/9/24
	{
		if((unsigned char)buff[i]==0xfd)
		{
			buff[i-2]=(unsigned)0xA0;	// 
			buff[i-1]=(unsigned)0xA0;	// 
		}
	}
	buff[buff.length()-1]=(unsigned)0xA0;	//@@ 追加 2009/9/24
	buff[buff.length()-2]=(unsigned)0xA0;	//@@ 追加 2009/9/24
	//////////////////////////////////////////////////////////////////////////////
	// ＵＮＩＣＯＤＥに変換しバッファーに格納する。
	std::wostringstream wbuff;
	for (unsigned i=0;i<buff.length();i++)
	{
		switch ((unsigned char)buff.at(i))
		{
		// 改行コードを変換してバッファーに格納
		case 0xfe:			
		//	wbuff << endl;
			wbuff << L"\r\n";	// windows用の改行コード
			break;
		// ページコードを変換してバッファーに格納	
		case 0xfd:
		//	wbuff << endl;			
			wbuff << L"\r\n";	// windows用の改行コード
			break;
		// 点字コードに変換してバッファーに格納
		default:
			wbuff  <<  (wchar_t)(buff.at(i)+0x2800+0x80-(unsigned char)L' ');
			break;
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////
	// ＵＮＩＣＯＤＥ点字データを返す。
	return wbuff.str();
}
///////////////////////////////////////////////////////////////////////////////
// ＵＮＩＣＯＤＥテキスト点字形式でファイルに保存する。
// 引き数：ファイル名
// 戻り値：なし
void CBraille::SaveFile(wstring p_SaveFileName)
{
	////////////////////////////////////////////////////////////////////////////
	// ファイル出力（ユニコード点字）
	// WINDOWS系
	if(p_SaveFileName!=L"")
	{
		FILE *p_File;
		_wfopen_s(&p_File,p_SaveFileName.c_str(),L"wb");
		fwrite(this->m_Data.c_str() , sizeof(wchar_t), this->m_Data.size(), p_File);
		fclose(p_File);
	}
	
	////////////////////////////////////////////////////////////////////////////
	// ファイル出力
	// UNIX系
	/*
	std::wfstream file_stream(this->narrow(p_SaveFileName).c_str(),std::ios::out);
	
	file_stream.imbue( std::locale( "ja_JP.UTF-8" ) );
	file_stream << this->m_Data ;
	file_stream.close();
	*/
}

/////////////////////////////////////////////////////////////////////////////////
// ユニコード点字からカタカナに変換する。
//
wstring CBraille::katakana_conv(void)
{
	wostringstream	wbuff;
	unsigned			pos = 0;
	
	while(pos<this->m_Data.length())
	{
		switch ((wchar_t)m_Data.at(pos))
		{
		// 数符がきた場合の処理
		case L'⠼':		
			wbuff << this->numeric_conv(pos);			// 数符処理へ
		//	wbuff << this->numeric2_conv(pos);			// 数符処理へ
			break;
		// 外字符及び読点がきた場合の処理
		case L'⠰':		
			if(m_Data.at(pos+1)==L'⠄')
			{
				wbuff << L"＜";
				pos++;
			}
			else if(this->m_Separator.find_first_of(m_Data.at(pos+1),0)!=wstring::npos)
				if(m_Data.at(pos+1)==L'⠤')
				{
					wbuff << L"『";
					pos++;
				}
				else
					wbuff << this->finedS(j01,m_Data.substr(pos,1));
			else 
			{
				wbuff << this->roma_conv(pos);		// 外字符処理へ
			}
			break;
		// 外国語引用符がきた場合の処理
		case L'⠦':
				wbuff << this->eng_conv(pos,m_Data.substr(pos-1,1));	// 外国語引用符処理へ
	//			wbuff << this->eng_conv2(pos,m_Data.substr(pos-1,1));	// 外国語引用符処理へ
			break;
		// 閉じ括弧がきた場合の処理
		case L'⠤':		
			if(m_Data.at(pos+1)==L'⠆')
			{
				wbuff << L"』";
				pos++;
			}
			else if(m_Data.at(pos+1)==L'⠂')
			{
				wbuff << L"】";
		//		wbuff << L"＿";
				pos++;
			}
			else
				wbuff << this->finedS(j01,m_Data.substr(pos,1));
			break;
		// 長音の次の不整合の処理
		case L'⠒':		
			if(m_Data.at(pos+1)==L'⠂')	// ッ
			{
				wbuff << L"ー・";
				pos++;
			}
			else
				wbuff << this->finedS(j01,m_Data.substr(pos,1));
			break;
		// 合濁拗音（句読点を前置）
		case L'⠲':		
			if(this->finedS(j09,m_Data.substr(pos,2)).compare(L"─")!=0)
			{
				wbuff << this->finedS(j09,m_Data.substr(pos,2));
				pos++;
			}
			else
				wbuff << L"。";
			break;
		// 合拗音（疑問符を前置）
		case L'⠢':	
			if(this->finedS(j08,m_Data.substr(pos,2)).compare(L"─")!=0)
			{
				wbuff << this->finedS(j08,m_Data.substr(pos,2));
				pos++;
			}
			else
				wbuff << L"？";
			break;
		// その他１
		case L'⠸':		
			if(this->finedS(j07,m_Data.substr(pos,2)).compare(L"─")!=0)
			{
				wbuff << this->finedS(j07,m_Data.substr(pos,2));
				pos++;
			}
			else
				;	//wbuff << L"◆その他◆";
			break;
		// 半濁拗音モード
		case L'⠨':		
			if(this->finedS(j06,m_Data.substr(pos,2)).compare(L"─")!=0)
			{
				wbuff << this->finedS(j06,m_Data.substr(pos,2));
				pos++;
			}
			else
				;	//wbuff << L"◆半濁拗音◆";
			break;
		// 濁拗音モード
		case L'⠘':	
			if(this->finedS(j05,m_Data.substr(pos,2)).compare(L"─")!=0)
			{
				wbuff << this->finedS(j05,m_Data.substr(pos,2));
				pos++;
			}
			else
				;	//wbuff << L"◆濁拗音◆";
			break;
		// 拗音モード
		case L'⠈':
			if(this->finedS(j04,m_Data.substr(pos,2)).compare(L"─")!=0)
			{
				wbuff << this->finedS(j04,m_Data.substr(pos,2));
				pos++;
			}
			else
				;	//wbuff << L"◆拗音◆";
			break;
		// 半濁点モード
		case L'⠠':
			if(m_Data.at(pos+1)==L'⠦')
			{
				// 情報変換モード;
				wbuff << this->info_conv(pos);
			}
			else if(m_Data.at(pos+1)==L'⠆')
			{
				wbuff << L"＞";
				pos++;
			}
			else if(this->finedS(j03,m_Data.substr(pos,2)).compare(L"─")!=0)
			{
				wbuff << this->finedS(j03,m_Data.substr(pos,2));
				pos++;
			}
			else
				;	//wbuff << L"◆半濁点◆";
			break;
		// 濁点モード（ッを前置）
		case L'⠐':
			if(this->finedS(j02,m_Data.substr(pos,2)).compare(L"─")!=0)
			{
				wbuff << this->finedS(j02,m_Data.substr(pos,2));
				pos++;
			}
			else
				wbuff << L"ッ";
			break;
		default:
			wbuff << this->finedS(j01,m_Data.substr(pos,1));
			break;
		}
		pos++;
	}
	return wbuff.str();
}
///////////////////////////////////////////////////////////////////////////////
// ユニコード点字から数値に変換する。
//
wstring CBraille::numeric_conv(unsigned &pos)
{
	wostringstream	wbuff;

	pos++;
	while(pos<this->m_Data.length())
	{
		switch ((wchar_t)m_Data.at(pos))
		{
		case L'⠼':				
			wbuff	<< L"、";	// スペースを出力
			break;
		default:
			if(m_Data.substr(pos,1).compare(L"\r")==0)
			{
				pos++;
				wbuff << L"\r\n";
				return wbuff.str();
			}
			else if(this->finedS(j10,m_Data.substr(pos,1)).compare(L"─")==0)			
			{
				pos--;
				return wbuff.str();
			}
			wbuff << this->finedS(j10,m_Data.substr(pos,1));
			break;
		}
		pos++;
	}
	return wbuff.str();
}
///////////////////////////////////////////////////////////////////////////////
// ユニコード点字から数値に変換する。
//
wstring CBraille::numeric2_conv(unsigned &pos)
{
	wostringstream	wbuff;
	bool f_hankaku = false;

//	if(m_Data.substr(pos-1,1).compare(L"⠀")!=0)
		f_hankaku = true;
	pos++;
		
	
	while(pos<this->m_Data.length())
	{
		switch ((wchar_t)m_Data.at(pos))
		{
		// 数符がきた場合の処理	
		case L'⠼':
			if(f_hankaku)
				wbuff	<< L",";	// スペースを出力
			else
				wbuff	<< L"、";	// スペースを出力
			break;
		default:
			if(m_Data.substr(pos,1).compare(L"\r")==0)
			{
				pos++;
				wbuff << L"\r\n";
				return wbuff.str();
			}
			else if(this->finedS(i03,m_Data.substr(pos,1)).compare(L"─")==0)			
			{
				pos--;
				return wbuff.str();
			}
			if(f_hankaku)
				wbuff << this->finedS(i03,m_Data.substr(pos,1));
			else 
				wbuff << this->finedS(j10,m_Data.substr(pos,1));
			
			break;
		}
		pos++;
	}
	return wbuff.str();
}



///////////////////////////////////////////////////////////////////////////////
// ユニコード点字から外字に変換する。
//
wstring CBraille::roma_conv(unsigned &pos)
{
	wostringstream	wbuff;
	unsigned			f_oomoji=0;

	pos++;
	while(pos<this->m_Data.length())
	{
		switch ((wchar_t)m_Data.at(pos))
		{
		case L'⠠':
			if(m_Data.at(pos+1)==L'⠠')
				f_oomoji=1;	// 大文字連続
			else if (f_oomoji!=1)
				f_oomoji=2;	// 大文字単独フラグ
			break;
		default:
			if(this->finedS(j11,m_Data.substr(pos,1)).compare(L"─")==0)			
			{
				pos--;
				return wbuff.str();
			}
			switch (f_oomoji)
			{
			case 0:
				wbuff << this->finedS(j12,m_Data.substr(pos,1));
				break;
			case 1:
				wbuff << this->finedS(j11,m_Data.substr(pos,1));
				break;
			case 2:
				wbuff << this->finedS(j11,m_Data.substr(pos,1));
				f_oomoji=0;
				break;
			}
		}
		pos++;
	}
	return wbuff.str();
}

///////////////////////////////////////////////////////////////////////////////
// ユニコード点字から情報点字に変換する。
//
wstring CBraille::info_conv(unsigned &pos)
{
	wostringstream	wbuff;
	unsigned			f_oomoji=0;
	
	pos++;	// ヘッダーコード分進める。
	
	while(pos<this->m_Data.length())
	{
		switch ((wchar_t)m_Data.at(pos))
		{
		case L'⠠':
			if(m_Data.at(pos+1)==L'⠴')
			{
				pos+=1;
				wbuff<< L")";
				return wbuff.str();
			}
			else if(m_Data.at(pos+1)==L'⠠')
			{
				f_oomoji=1;	// 大文字連続
			}
			else if (f_oomoji!=1)
			{
				f_oomoji=2;	// 大文字単独フラグ
			}
			else if (m_Data.at(pos+1)==L'⠨')
			{
				f_oomoji=3;	// カナフラグ
			} 
			break;
		case L'⠼':
			wbuff << this->numeric2_conv(pos);
			break;
		default:
			switch (f_oomoji)
			{
			// 英数小文字処理
			case 0:
				for(unsigned x=pos;x<this->m_Data.length();x++)
				{
					if(m_Data.substr(x,2).compare(L"⠠⠴")==0)
					{
						pos = x-1;
						break;
					}
					else if( m_Data.substr(x,1).compare(L"⠼")==0)
					{
						wbuff << this->numeric2_conv(x);
					}	
					else if(this->finedS(i02,m_Data.substr(x,2)).compare(L"─")!=0)  
					{
						wbuff << this->finedS(i02,m_Data.substr(x,2));
						x++;
					}
					else if(this->finedS(i02,m_Data.substr(x,1)).compare(L"─")!=0)  
						wbuff << this->finedS(i02,m_Data.substr(x,1));
					else
					{
						pos=x;
						break;
					}
				}
				break;
			// 英数大文字処理（連続）
			case 1:
				for(unsigned x=pos;x<this->m_Data.length();x++)
				{
					if(m_Data.substr(x,2).compare(L"⠠⠴")==0)
					{
						pos = x-1;
						break;
					}
					else if( m_Data.substr(x,1).compare(L"⠼")==0)
					{
						wbuff << this->numeric2_conv(x);
					}
					else if(this->finedS(i01,m_Data.substr(x,2)).compare(L"─")!=0)  
					{
						wbuff << this->finedS(i01,m_Data.substr(x,2));
						x++;
					}
					else if(this->finedS(i01,m_Data.substr(x,1)).compare(L"─")!=0)  
						wbuff << this->finedS(i01,m_Data.substr(x,1));
					else
					{
						pos=x;
						break;
					}
				}
				break;
			// 英数大文字処理（単独）
			case 2:
				for(unsigned x=pos;x<this->m_Data.length();x++)
				{
					if(m_Data.substr(x,2).compare(L"⠠⠴")==0)
					{
						pos = x-1;
						break;
					}
					else if( m_Data.substr(x,1).compare(L"⠼")==0)
					{
						wbuff << this->numeric2_conv(x);
					}
					else if(this->finedS(i01,m_Data.substr(x,2)).compare(L"─")!=0)  
					{
						wbuff << this->finedS(i01,m_Data.substr(x,2));
						x++;
					}
					else if(this->finedS(i01,m_Data.substr(x,1)).compare(L"─")!=0)  
						wbuff << this->finedS(i01,m_Data.substr(x,1));
					else
					{
						pos=x;
						break;
					}
					break; // 一回のみ。
				}
				f_oomoji=0;
				break;
			// カタカナ処理
			case 3:
				;
				;
				f_oomoji=0;
				break;
			}
			break;
		}
		pos++;
	}
	return wbuff.str();
}
///////////////////////////////////////////////////////////////////////////////
// ユニコード点字から英文点字に変換する。
//
wstring CBraille::eng_conv(unsigned &pos,wstring s_c)
{
	wostringstream	wbuff;
	unsigned			f_oomoji=0;

	wstring xxx;
	xxx=L"⠴";
	if(this->finedS(j01,s_c).compare(L"＿")==0)
		xxx+=s_c;
	else if(this->finedS(j01,s_c).compare(L"｜")==0)
		xxx+=s_c;
	else if(this->finedS(j01,s_c).compare(L"　")==0)
		xxx+=s_c;

	pos++;	// ヘッダーコード分進める。
	
	wbuff << L"￣";
	
	if(m_Data.substr(pos,2).compare(L"⠠⠠")==0)
	{
		f_oomoji=1;	// 大文字連続
		pos+=2;
	}
	else if(m_Data.substr(pos,1).compare(L"⠠")==0)
	{
		f_oomoji=2;	// 大文字単独フラグ
		pos++;
	}
	else 
	{
		f_oomoji=0;
		
	}
	
	while(pos<this->m_Data.length())
	{
		
		switch ((wchar_t)m_Data.at(pos))
		{
		case L'⠴':
		//	if(	m_Data.at(pos+1)==s_c.at(0))
			if (m_Data.substr(pos,xxx.length()).compare(xxx)==0)				
			{
				wbuff	<< L"￣";
				return wbuff.str();
			}
			else if (m_Data.substr(pos,xxx.length()).compare(L"⠴⠀")==0)				
			{
				wbuff	<< L"￣";
				return wbuff.str();
			}
			else if (m_Data.substr(pos,xxx.length()).compare(L"⠴\n")==0)				
			{
				wbuff	<< L"￣";
				return wbuff.str();
			}
			else if (m_Data.substr(pos,xxx.length()).compare(L"⠴\r")==0)				
			{
				wbuff	<< L"￣";
				return wbuff.str();
			}
			else if (m_Data.substr(pos,xxx.length()).compare(L"⠴⠤")==0)				
			{
				wbuff	<< L"￣";
				return wbuff.str();
			}

			break;
		default:
			switch (f_oomoji)
			{
			// 英数小文字処理
			case 0:
				for(unsigned x=pos;x<this->m_Data.length();x++)
				{
					if (m_Data.substr(x,xxx.length()).compare(xxx)==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}
					else if (m_Data.substr(pos,xxx.length()).compare(L"⠴⠀")==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}
					else if (m_Data.substr(pos,xxx.length()).compare(L"⠴\n")==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}
					else if (m_Data.substr(pos,xxx.length()).compare(L"⠴\r")==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}
					else if (m_Data.substr(pos,xxx.length()).compare(L"⠴⠤")==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}
					//@@

					else if(m_Data.substr(x,2).compare(L"⠠⠠")==0)
					{
						f_oomoji=1;	// 大文字連続
						x++;
						break;
					}
					else if(m_Data.substr(x,1).compare(L"⠠")==0)
					{
						f_oomoji=2;	// 大文字単独フラグ
						break;
					}
					else if( m_Data.substr(x,1).compare(L"⠼")==0)
					{
						wbuff << this->numeric2_conv(x);
					}
					else if(this->finedS(e03,m_Data.substr(x,1)).compare(L"─")!=0)  
					{
						wbuff << this->finedS(e03,m_Data.substr(x,1));
					}
					else if(this->finedS(e02,m_Data.substr(x,1)).compare(L"─")!=0)  
					{
						wbuff << this->finedS(e02,m_Data.substr(x,1));
					}
					pos=x;
				//	break; // 一回のみ。					
				}
				break;
			case 1:
				for(unsigned x=pos;x<this->m_Data.length();x++)
				{
					if (m_Data.substr(x,xxx.length()).compare(xxx)==0)				
					{
						pos=x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}

					else if (m_Data.substr(pos,xxx.length()).compare(L"⠴⠀")==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}
					else if (m_Data.substr(pos,xxx.length()).compare(L"⠴\n")==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}
					else if (m_Data.substr(pos,xxx.length()).compare(L"⠴\r")==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}
					else if (m_Data.substr(pos,xxx.length()).compare(L"⠴⠤")==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}
					//@@

					else if(m_Data.substr(x,2).compare(L"⠠⠠")==0)
					{
						f_oomoji=1;	// 大文字連続
						x++;
						break;
					}
					else if(m_Data.substr(x,1).compare(L"⠠")==0)
					{
						f_oomoji=2;	// 大文字単独フラグ
						break;
					}
					else if( m_Data.substr(x,1).compare(L"⠼")==0)
					{
						wbuff << this->numeric2_conv(x);
					}
					else if(this->finedS(e03,m_Data.substr(x,1)).compare(L"─")!=0)  
					{
						wbuff << this->finedS(e03,m_Data.substr(x,1));
					}
					else if(this->finedS(e01,m_Data.substr(x,1)).compare(L"─")!=0)  
					{
						wbuff << this->finedS(e01,m_Data.substr(x,1));
					}	
					f_oomoji=0;
					pos=x;
				//	break; // 一回のみ。
				}
				break;
			case 2:
				for(unsigned x=pos;x<this->m_Data.length();x++)
				{
					if (m_Data.substr(x,xxx.length()).compare(xxx)==0)				
					{
						pos =x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}

					else if (m_Data.substr(pos,xxx.length()).compare(L"⠴⠀")==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}
					else if (m_Data.substr(pos,xxx.length()).compare(L"⠴\n")==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}
					else if (m_Data.substr(pos,xxx.length()).compare(L"⠴\r")==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}
					else if (m_Data.substr(pos,xxx.length()).compare(L"⠴⠤")==0)				
					{
						pos = x;
						wbuff	<< L"￣";
						return wbuff.str();
						break;
					}

					else if(m_Data.substr(x,2).compare(L"⠠⠠")==0)
					{
						f_oomoji=1;	// 大文字連続
						x++;
						break;
					}
					else if(m_Data.substr(x,1).compare(L"⠠")==0)
					{
						f_oomoji=2;	// 大文字単独フラグ
						break;
					}
					else if( m_Data.substr(x,1).compare(L"⠼")==0)
					{
						wbuff << this->numeric2_conv(x);
					}
					else if(this->finedS(e03,m_Data.substr(x,1)).compare(L"─")!=0)  
					{
						wbuff << this->finedS(e03,m_Data.substr(x,1));
					}
					else if(this->finedS(e01,m_Data.substr(x,1)).compare(L"─")!=0)  
					{
						wbuff << this->finedS(e01,m_Data.substr(x,1));
					}
					f_oomoji=0;
					pos=x;
					break; // 一回のみ。
				}
				break;
			default:
				///////////////////////////////////////////////////////////////////////////////////////
				///////////////////////////////////////////////////////////////////////////////////////
				///////////////////////////////////////////////////////////////////////////////////////
				///////////////////////////////////////////////////////////////////////////////////////
				f_oomoji=0;
				break;
			}
			break;
		}
		pos++;
	}
	return wbuff.str();
}


///////////////////////////////////////////////////////////////////////////////
// ユニコード点字から英文点字に変換する。
//
wstring CBraille::eng_conv2(unsigned &pos,wstring s_c)
{
	wostringstream	wbuff;

	wbuff << L"＜ここは英文点字です。>￣";

	wstring xxx;
	xxx=L"⠴";
	if(this->finedS(j01,s_c).compare(L"＿")==0)
		xxx+=s_c;
	else if(this->finedS(j01,s_c).compare(L"｜")==0)
		xxx+=s_c;
		
	
	while(pos<this->m_Data.length())
	{
		switch ((wchar_t)m_Data.at(pos))
		{
		case L'⠴':
			if (m_Data.substr(pos,xxx.length()).compare(xxx)==0)	
			{
				wbuff << L"￣";
				return wbuff.str();
			}
			break;
		default:
			break;
		}
		pos++;
	}
	
	return wbuff.str();
}

///////////////////////////////////////////////////////////////////////////////
// 空白行にスペースを埋め込む
///////////////////////////////////////////////////////////////////////////////
wstring CBraille::Cxx(wstring cbuff)
{
	size_t  pos=0;
	wstring Dc_1 = L"ッッ"; 
	wstring Dc_2 = L"……"; 

	while((pos = cbuff.find(Dc_1.c_str(),pos))!=std::wstring::npos)
	{
		cbuff.replace(pos, Dc_1.length(),Dc_2);
	}
	Dc_1 = L"…ッ"; 

	pos=0;
	while((pos = cbuff.find(Dc_1.c_str(),pos))!=std::wstring::npos)
	{
		cbuff.replace(pos, Dc_1.length(),Dc_2);
	}

	return cbuff;

}


///////////////////////////////////////////////////////////////////////////////
// 改行変換
///////////////////////////////////////////////////////////////////////////////
wstring CBraille::Cxx2(wstring cbuff)
{
	size_t  pos=0;
	std::wstring Dc_1 = L"\r\n"; 
	std::wstring Dc_2 = L"\n"; 

	while((pos = cbuff.find(Dc_1.c_str(),pos))!=std::wstring::npos)
		cbuff.replace(pos, Dc_1.length(),Dc_2);
	return cbuff;

}
///////////////////////////////////////////////////////////////////////////////
// 空白行にスペースを埋め込む
///////////////////////////////////////////////////////////////////////////////
wstring CBraille::Cxx3(wstring cbuff)
{
	size_t  pos=0;
	wstring Dc_1 = L"\n\n"; 
	wstring Dc_2 = L"\n　　　\n"; 

	while((pos = cbuff.find(Dc_1.c_str(),pos))!=std::wstring::npos)
		cbuff.replace(pos, Dc_1.length(),Dc_2);
	return cbuff;
}

