
package net.takemix.testok.activity;

import java.util.ArrayList;
import java.util.List;

import net.takemix.testok.PFConstants;
import net.takemix.testok.Question;
import net.takemix.testok.R;
import net.takemix.testok.view.IconTextArrayAdapter;
import net.takemix.testok.view.IconTextArrayItem;
import net.takemix.testok.Testok;
import android.app.*;
import android.util.Log;
import android.view.*;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.*;
import android.widget.AdapterView.OnItemClickListener;

public class AnswerActivity extends Activity implements OnItemClickListener {
    private static final String TAG = "AnswerActivity";

    private Testok testok;

	private ListView lvAnswer;
	private TextView tvHeader;
    private TextView tvFooter;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Log.i(TAG, "onCreate - IN");

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.answer);

        this.testok = (Testok)getApplication();

        List<IconTextArrayItem> items = new ArrayList<IconTextArrayItem>();

        int count = 0;
        int totalTime = 0;
        int totalRight = 0;
		if(this.testok.questionArray.size() == 0) {
			items.add(new IconTextArrayItem(R.drawable.non, getString(R.string.answer_none)));
		} else {
			for (Question q:this.testok.questionArray) {
                count++;
			    String str = getString(R.string.answer_no);
			    str = str + count + "\n";
			    if (q.selectedIndex == -1) {
                    str = str + getString(R.string.answer_you) + getString(R.string.answer_notselected) + "\n";
			    } else {
			        str = str + getString(R.string.answer_you) + q.answer[q.selectedIndex] + "\n";
			    }
			    str = str + getString(R.string.answer_right) + q.answer[q.rightAnswerIndex];
        		if(q.selectedIndex == q.rightAnswerIndex) {
        			items.add(new IconTextArrayItem(R.drawable.ok, str));
        			totalRight++;
        		} else {
        			items.add(new IconTextArrayItem(R.drawable.ng, str));
        		}
        		Log.d(TAG, "time[" + count + "]:" + q.time);
        		totalTime += q.time / 1000;
        	};
		}

        this.lvAnswer = (ListView)findViewById(R.id.answer_answerListView);
        ListAdapter adapter = new IconTextArrayAdapter(this, R.layout.answerlistview, items);
        this.lvAnswer.setAdapter(adapter);
        this.lvAnswer.setOnItemClickListener(this);

        this.tvHeader = (TextView)findViewById(R.id.answer_headerTextView);
        this.tvFooter = (TextView)findViewById(R.id.answer_footerTextView);

        this.tvHeader.setText(getString(R.string.answer_totalright) + totalRight);

        String str;
        str = getString(R.string.answer_avetime) + (totalTime / count) + getString(R.string.answer_sec) + "\n" + getString(R.string.answer_totaltime) + totalTime + getString(R.string.answer_sec);
        this.tvFooter.setText(str);

        Log.i(TAG, "onCreate - OUT");
    }

    public void onItemClick(AdapterView<?> adapter, View view, int position, long id) {
        SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = pref.edit();
        editor.putInt(PFConstants.getAnswerIndex(), position);
        editor.commit();

        Intent intent = new Intent(this, net.takemix.testok.activity.AnswerDetailActivity.class);
        startActivityForResult(intent, 0);
    }
    public void onNothingSelected(AdapterView<?> parent) {
    }

    @Override
    public void onDestroy() {
    	super.onDestroy();
    }

}
