package net.takemix.testok.activity;

import java.util.ArrayList;
import java.util.HashMap;

import net.takemix.testok.Question;
import net.takemix.testok.R;
import net.takemix.testok.Testok;
import net.takemix.testok.db.TestokDataBaseHelper;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

public class HistoryActivity extends Activity implements View.OnClickListener {
    private static final String TAG = "HistoryActivity";

    private Testok testok;

    private TableLayout tlHistory;
    private ArrayList<HashMap<String, Object>> history;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Log.i(TAG, "onCreate - IN");

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.history);

        this.testok = (Testok)getApplication();

        this.history = this.testok.db.getAllHistory();

        this.tlHistory = (TableLayout)findViewById(R.id.history_historyTableLayout);

        TableRow tableRow;
        TextView tv;

        tableRow = new TableRow(this);

        this.tlHistory.setColumnStretchable(0, true);
        tv = new TextView(this);
        tv.setText(R.string.history_date);
        tableRow.addView(tv);

        this.tlHistory.setColumnStretchable(1, true);
        tv = new TextView(this);
        tv.setText(R.string.history_question);
        tableRow.addView(tv);

        this.tlHistory.setColumnStretchable(2, true);
        tv = new TextView(this);
        tv.setText(R.string.history_right);
        tableRow.addView(tv);

        this.tlHistory.setColumnStretchable(3, true);
        tv = new TextView(this);
        tv.setText(R.string.history_detail);
        tableRow.addView(tv);

        this.tlHistory.addView(tableRow);

        if (this.history != null) {
            for (int i = 0; i < this.history.size(); i++) {
                @SuppressWarnings("unchecked")
                ArrayList<Question> questionArray = (ArrayList<Question>)this.history.get(i).get(TestokDataBaseHelper.HISTORY_MAPKEY_QUESTIONS);
                tableRow = new TableRow(this);

                tv = new TextView(this);
                tv.setText(TestokDataBaseHelper.date2timeString(questionArray.get(0).date));
                tableRow.addView(tv);

                tv = new TextView(this);
                tv.setText(questionArray.size() + getString(R.string.history_num));
                tableRow.addView(tv);

                tv = new TextView(this);
                int rights = 0;
                for (Question q : questionArray) {
                    if (q.selectedIndex == q.rightAnswerIndex) {
                        rights++;
                    }
                }
                tv.setText((float)((rights  * 100)/ questionArray.size()) + "%");
                tableRow.addView(tv);

                Button b = new Button(this);
                b.setText(R.string.history_detail);
                b.setOnClickListener(this);
                b.setTag(questionArray);
                tableRow.addView(b);

                this.tlHistory.addView(tableRow);
            }
        }

        Log.i(TAG, "onCreate - OUT");
    }

    @SuppressWarnings("unchecked")
    public void onClick(View v) {
        Log.i(TAG, "onClick - IN");

        Button bt = (Button)v;

        this.testok.questionArray = (ArrayList<Question>)bt.getTag();

        Intent intent = new Intent(this, net.takemix.testok.activity.AnswerActivity.class);
        startActivity(intent);

        finish();

        Log.i(TAG, "onClick - OUT");
    }
}
