package net.takemix.testok.activity;

import net.takemix.testok.R;
import net.takemix.testok.Testok;
import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class InitialActivity extends Activity implements View.OnClickListener {
    private static final String TAG = "InitialActivity";

    private Testok testok;

    private EditText etName;
    private EditText etScore;
    private EditText etTime;
    private Button bStart;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Log.i(TAG, "onCreate - IN");

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.initial);

        this.testok = (Testok)getApplication();

        this.etName = (EditText)findViewById(R.id.initial_nameEditText);
        this.etScore = (EditText)findViewById(R.id.initial_scoreEditText);
        this.etTime = (EditText)findViewById(R.id.initial_timeEditText);
        this.bStart = (Button)findViewById(R.id.initial_startTestokButton);
        this.bStart.setOnClickListener(this);

        Log.i(TAG, "onCreate - OUT");
    }

    public void onClick(View v) {
        if(v == this.bStart) {
            Log.i(TAG, "onClick - IN [bStart]");

            if (!this.checkFields()) {
                Toast.makeText(this, R.string.init_inputall, Toast.LENGTH_LONG).show();
                return;
            }

            String str;
            str = this.etName.getText().toString();
            this.testok.db.setUserName(str);
            str = this.etScore.getText().toString();
            this.testok.db.setLastScore(Integer.parseInt(str));
            str = this.etTime.getText().toString();
            this.testok.db.setStudyTime(Integer.parseInt(str));

            finish();
        }
        Log.i(TAG, "onClick - OUT");
    }

    private Boolean checkFields() {
        if (this.etName.getText().toString().equals("")) {
            return false;
        }
        if (this.etScore.getText().toString().equals("")) {
            return false;
        }
        if (this.etTime.getText().toString().equals("")) {
            return false;
        }
        return true;
    }
}
