package net.takemix.testok.activity;

import net.takemix.testok.PFConstants;
import net.takemix.testok.R;
import net.takemix.testok.Testok;
import net.takemix.testok.db.TestokDataBaseHelper.QuestionType;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;

public class MockExamActivity extends Activity implements View.OnClickListener {
    private static final String TAG = "MockExamActivity";

    private Testok testok;

    private Integer questions;
    private Integer minutes;

    private Button bStart;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Log.i(TAG, "onCreate - IN");

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.mockexam);

        testok = (Testok)getApplication();

        TextView tv;
        tv = (TextView)findViewById(R.id.mockexam_explanationTextView);
        tv.setText(R.string.mockexam_message);

        this.questions = 0;
        this.minutes = 0;
        for (QuestionType qt : this.testok.mockexamQuestionTypes) {
            this.questions += qt.questions();
            this.minutes += qt.minutes();
        }
        tv = (TextView)findViewById(R.id.mockexam_questionNumTextView);
        tv.setText(this.questions + " " + getString(R.string.mockexam_num));
        tv = (TextView)findViewById(R.id.mockexam_timeTextView);
        tv.setText(this.minutes + " " + getString(R.string.mockexam_min));

        this.bStart = (Button)findViewById(R.id.mockexam_startButton);
        this.bStart.setOnClickListener(this);

        Log.i(TAG, "onCreate - OUT");
    }

    public void onClick(View v) {
        if(v == this.bStart) {
            Log.i(TAG, "onClick - IN [bStart]");

            Object qtArray[] = this.testok.mockexamQuestionTypes.toArray();
            this.testok.setQuestionPref(
                    (QuestionType)qtArray[0],
                    PFConstants.maxLevel,
                    PFConstants.minLevel,
                    this.minutes,
                    this.questions);

            Intent intent = new Intent(getApplicationContext(), net.takemix.testok.activity.QuestionActivity.class);
            startActivity(intent);

            finish();
        }
        Log.i(TAG, "onClick - OUT");
    }
}
