/* R\[֌W */

#include "bootpack.h"
#include <stdio.h>
#include <string.h>

#define CONS_CHAR_X  80
#define CONS_CHAR_Y  24

//ʐMp̃O[oϐBȂƂ
struct FIFO *MainFifo;


void console_task(struct SHEET *sheet, int memtotal)
{
	struct TASK *task = task_now();
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	int i, *fat = (int *) memman_alloc_4k(memman, 4 * 2880);
	struct CONSOLE cons;
	struct FILEHANDLE fhandle[8];
	char cmdline[CONS_CHAR_X];
	unsigned char *nihongo = (char *) *((int *) 0x0fe8);

	cons.sht = sheet;
	cons.cur_x =  8;
	cons.cur_y = 28;
	cons.cur_c = -1;
	task->cons = &cons;
	task->cmdline = cmdline;

	if (cons.sht != 0) {
		cons.timer = timer_alloc();
		timer_init(cons.timer, &task->fifo, 1);
		timer_settime(cons.timer, 50);
	}
	file_readfat(fat, (unsigned char *) (ADR_DISKIMG + 0x000200));
	for (i = 0; i < 8; i++) {
		fhandle[i].buf = 0;	/* gp}[N */
	}
	task->fhandle = fhandle;
	task->fat = fat;
	if (nihongo[4096] != 0xff) {	/* {tHgt@Cǂݍ߂H */
		task->langmode = 1;
	} else {
		task->langmode = 0;
	}
	task->langbyte1 = 0;

	/* vvg\ */
	cons_putchar(&cons, '>', 1);

	for (;;) {
		io_cli();
		if (fifo32_status(&task->fifo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo32_get(&task->fifo);
			io_sti();
			if (i <= 1 && cons.sht != 0) { /* J[\p^C} */
				if (i != 0) {
					timer_init(cons.timer, &task->fifo, 0); /* 0 */
					if (cons.cur_c >= 0) {
						cons.cur_c = COL8_FFFFFF;
					}
				} else {
					timer_init(cons.timer, &task->fifo, 1); /* 1 */
					if (cons.cur_c >= 0) {
						cons.cur_c = COL8_000000;
					}
				}
				timer_settime(cons.timer, 50);
			}
			if (i == 2) {	/* J[\ON */
				cons.cur_c = COL8_FFFFFF;
			}
			if (i == 3) {	/* J[\OFF */
				if (cons.sht != 0) {
					boxfill8(cons.sht->buf, cons.sht->bxsize, COL8_000000,
						cons.cur_x, cons.cur_y, cons.cur_x + 7, cons.cur_y + 15);
				}
				cons.cur_c = -1;
			}
			if (i == 4) {	/* R\[́u~v{^NbN */
				cmd_exit(&cons, fat);
			}
			if (256 <= i && i <= 511) { /* L[{[hf[^i^XNAoRj */
				if (i == 8 + 256) {
					/* obNXy[X */
					if (cons.cur_x > 16) {
						/* J[\Xy[XŏĂAJ[\1߂ */
						cons_putchar(&cons, ' ', 0);
						cons.cur_x -= 8;
					}
				} else if (i == 10 + 256) {
					/* Enter */
					/* J[\Xy[XŏĂs */
					cons_putchar(&cons, ' ', 0);
					cmdline[cons.cur_x / 8 - 2] = 0;
					cons_newline(&cons);
					cons_runcmd(cmdline, &cons, fat, memtotal);	/* R}hs */
					if (cons.sht == 0) {
						cmd_exit(&cons, fat);
					}
					/* vvg\ */
					cons_putchar(&cons, '>', 1);
				} else {
					/* ʕ */
					if (cons.cur_x < CONS_CHAR_X * 8) {
						/* ꕶ\ĂAJ[\1i߂ */
						cmdline[cons.cur_x / 8 - 2] = i - 256;
						cons_putchar(&cons, i - 256, 1);
					}
				}
			}
			/* J[\ĕ\ */
			if (cons.sht != 0) {
				if (cons.cur_c >= 0) {
					boxfill8(cons.sht->buf, cons.sht->bxsize, cons.cur_c, 
						cons.cur_x, cons.cur_y, cons.cur_x + 7, cons.cur_y + 15);
				}
				sheet_refresh(cons.sht, cons.cur_x, cons.cur_y, cons.cur_x + 8, cons.cur_y + 16);
			}
		}
	}
}

void cons_putchar(struct CONSOLE *cons, int chr, char move)
{
	char s[2];
	s[0] = chr;
	s[1] = 0;
	if (s[0] == 0x09) {	/* ^u */
		for (;;) {
			if (cons->sht != 0) {
				putfonts8_asc_sht(cons->sht, cons->cur_x, cons->cur_y, COL8_FFFFFF, COL8_000000, " ", 1);
			}
			cons->cur_x += 8;
			if (cons->cur_x == 8 + CONS_CHAR_X*8) {
				cons_newline(cons);
			}
			if (((cons->cur_x - 8) & 0x1f) == 0) {
				break;	/* 32Ŋ؂ꂽbreak */
			}
		}
	} else if (s[0] == 0x0a) {	/* s */
		cons_newline(cons);
	} else if (s[0] == 0x0d) {	/* A */
		/* Ƃ肠ȂɂȂ */
	} else {	/* ʂ̕ */
		if (cons->sht != 0) {
			putfonts8_asc_sht(cons->sht, cons->cur_x, cons->cur_y, COL8_FFFFFF, COL8_000000, s, 1);
		}
		if (move != 0) {
			/* move0̂Ƃ̓J[\i߂Ȃ */
			cons->cur_x += 8;
			if (cons->cur_x == 8 + CONS_CHAR_X*8) {
				cons_newline(cons);
			}
		}
	}
	return;
}

void cons_newline(struct CONSOLE *cons)
{
	int x, y;
	struct SHEET *sheet = cons->sht;
	struct TASK *task = task_now();
	//--------- ŏIs̓̍vZBs{EBhDp[c̍
	if (cons->cur_y < 28 + (CONS_CHAR_Y -1)*16) {
		cons->cur_y += 16; /* ̍s */
	} else {
		/* XN[ */
		if (sheet != 0) {
			for (y = 28; y < 28 + (CONS_CHAR_Y -1)*16; y++) {
				for (x = 8; x < 8 + CONS_CHAR_X*8; x++) {
					sheet->buf[x + y * sheet->bxsize] = sheet->buf[x + (y + 16) * sheet->bxsize];
				}
			}
			for (y = 28 + (CONS_CHAR_Y -1)*16; y < 28 + CONS_CHAR_Y*16; y++) {
				for (x = 8; x < 8 + CONS_CHAR_X*8; x++) {
					sheet->buf[x + y * sheet->bxsize] = COL8_000000;
				}
			}
			sheet_refresh(sheet, 8, 28, 8 + CONS_CHAR_X*8, 28 + CONS_CHAR_Y*16);
		}
	}
	cons->cur_x = 8;
	if (task->langmode == 1 && task->langbyte1 != 0) {
		cons->cur_x = 16;
	}
	return;
}

void cons_putstr0(struct CONSOLE *cons, char *s)
{
	for (; *s != 0; s++) {
		cons_putchar(cons, *s, 1);
	}
	return;
}

void cons_putstr1(struct CONSOLE *cons, char *s, int l)
{
	int i;
	for (i = 0; i < l; i++) {
		cons_putchar(cons, s[i], 1);
	}
	return;
}

void cons_runcmd(char *cmdline, struct CONSOLE *cons, int *fat, int memtotal)
{
	if (strcmp(cmdline, "mem") == 0 && cons->sht != 0) {
		cmd_mem(cons, memtotal);
	} else if (strcmp(cmdline, "cls") == 0 && cons->sht != 0) {
		cmd_cls(cons);
	} else if (strcmp(cmdline, "dir") == 0 && cons->sht != 0) {
		cmd_dir(cons);
	} else if (strcmp(cmdline, "exit") == 0) {
		cmd_exit(cons, fat);
	} else if (strncmp(cmdline, "start ", 6) == 0) {
		cmd_start(cons, cmdline, memtotal);
	} else if (strncmp(cmdline, "ncst ", 5) == 0) {
		cmd_ncst(cons, cmdline, memtotal);
	} else if (strncmp(cmdline, "langmode ", 9) == 0) {
		cmd_langmode(cons, cmdline);
	} else if (cmdline[0] != 0) {
		if (cmd_app(cons, fat, cmdline) == 0) {
			/* R}hł͂ȂAAvłȂAɋsłȂ */
			cons_putstr0(cons, "Bad command!\n\n");
		}
	}
	return;
}

void cmd_mem(struct CONSOLE *cons, int memtotal)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	char s[60];
	sprintf(s, "total   %dMB\nfree %dKB\n\n", memtotal / (1024 * 1024), memman_total(memman) / 1024);
	cons_putstr0(cons, s);
	return;
}

void cmd_cls(struct CONSOLE *cons)
{
	int x, y;
	struct SHEET *sheet = cons->sht;
	for (y = 28; y < 28 + 128; y++) {
		for (x = 8; x < 8 + 240; x++) {
			sheet->buf[x + y * sheet->bxsize] = COL8_000000;
		}
	}
	sheet_refresh(sheet, 8, 28, 8 + 240, 28 + 128);
	cons->cur_y = 28;
	return;
}

void cmd_dir(struct CONSOLE *cons)
{
	struct FILEINFO *finfo = (struct FILEINFO *) (ADR_DISKIMG + 0x002600);
	int i, j;
	char s[30];
	for (i = 0; i < 224; i++) {
		if (finfo[i].name[0] == 0x00) {
			break;
		}
		if (finfo[i].name[0] != 0xe5) {
			if ((finfo[i].type & 0x18) == 0) {
				sprintf(s, "filename.ext   %7d\n", finfo[i].size);
				for (j = 0; j < 8; j++) {
					s[j] = finfo[i].name[j];
				}
				s[ 9] = finfo[i].ext[0];
				s[10] = finfo[i].ext[1];
				s[11] = finfo[i].ext[2];
				cons_putstr0(cons, s);
			}
		}
	}
	cons_newline(cons);
	return;
}

void cmd_exit(struct CONSOLE *cons, int *fat)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct TASK *task = task_now();
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct FIFO32 *fifo = (struct FIFO32 *) *((int *) 0x0fec);
	if (cons->sht != 0) {
		timer_cancel(cons->timer);
	}
	memman_free_4k(memman, (int) fat, 4 * 2880);
	io_cli();
	if (cons->sht != 0) {
		fifo32_put(fifo, cons->sht - shtctl->sheets0 + 768);	/* 768`1023 */
	} else {
		fifo32_put(fifo, task - taskctl->tasks0 + 1024);	/* 1024`2023 */
	}
	io_sti();
	for (;;) {
		task_sleep(task);
	}
}

void cmd_start(struct CONSOLE *cons, char *cmdline, int memtotal)
{
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct SHEET *sht = open_console(shtctl, memtotal);
	struct FIFO32 *fifo = &sht->task->fifo;
	int i;
	sheet_slide(sht, 32, 4);
	sheet_updown(sht, shtctl->top);
	/* R}hCɓ͂ꂽAꕶVR\[ɓ */
	for (i = 6; cmdline[i] != 0; i++) {
		fifo32_put(fifo, cmdline[i] + 256);
	}
	fifo32_put(fifo, 10 + 256);	/* Enter */
	cons_newline(cons);
	return;
}

void cmd_ncst(struct CONSOLE *cons, char *cmdline, int memtotal)
{
	struct TASK *task = open_constask(0, memtotal);
	struct FIFO32 *fifo = &task->fifo;
	int i;
	/* R}hCɓ͂ꂽAꕶVR\[ɓ */
	for (i = 5; cmdline[i] != 0; i++) {
		fifo32_put(fifo, cmdline[i] + 256);
	}
	fifo32_put(fifo, 10 + 256);	/* Enter */
	cons_newline(cons);
	return;
}

void cmd_langmode(struct CONSOLE *cons, char *cmdline)
{
	struct TASK *task = task_now();
	unsigned char mode = cmdline[9] - '0';
	if (mode <= 2) {
		task->langmode = mode;
	} else {
		cons_putstr0(cons, "mode number error.\n");
	}
	cons_newline(cons);
	return;
}

int cmd_app(struct CONSOLE *cons, int *fat, char *cmdline)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct FILEINFO *finfo;
	char name[18], *p, *q,*buf2;
	struct TASK *task = task_now();
	int i, segsiz, datsiz, esp, dathrb, appsiz,size2;
	struct SHTCTL *shtctl;
	struct SHEET *sht;

	char stylefilename[11];

	int err1;
	char s[40];

	/* R}hCt@C𐶐 */
	for (i = 0; i < 13; i++) {
		if (cmdline[i] <= ' ') {
			break;
		}
		name[i] = cmdline[i];
	}


	//K.hrbtĂȂt
	if ( name[i-4] == '.' || name[i-3] == 'h' || name[i-2] == 'r' || name[i-1] == 'b')
	  {
	    name[i] = 0; 
	    sprintf(s,"name=OK!",name);putfonts8_asc(0xa0000,640,8*14,16*0,COL8_008484,s);
	  }
	else
	  {
	    name[i] = '.'; name[i+1] = 'h'; name[i+2] = 'r'; name[i+3] = 'b';
	    name[i+4] = 0; 
	  }

	//t@C̃`FbN&`
	err1 = fat12_filename_check(name,stylefilename);

	//t@CُI
	if ( err1 != 0 ) {
	  cons_putstr0(cons, "Bad Command name!!\n");
	  return 0;
	}


	//[hI[ߑȂ̂Œڃt@CJB
	//ȂG[ɂȂ̂ŃT[`̕Kv͂Ȃ

	struct FILEHANDLE fh;

	//悢FD^XNɔI
	io_sti();               //荞݂~
	fifo32_put(MainFifo,3500);      //̓t@CI[v߁iRojƂ
	fifo32_put(MainFifo,stylefilename);      //t@CĂԒn
	fifo32_put(MainFifo, &task->fifo); //҂pFIFOĂ
	fifo32_put(MainFifo, &fh);    //t@Cnh
	fifo32_put(MainFifo,3999);      //R}hĨTCI
	io_cli();               //荞ݎtĊJ

	//FD^XN̕Ԏ҂
	for (;;)
	  {
	    io_cli();
	    if (fifo32_status(&task->fifo) == 0)
	      {
		task_sleep(task);/* FIFOȂ̂ŐQđ҂ */
		io_sti();
	      }
	    else
	      {         //ȂFIFOɗII
		i = fifo32_get(&task->fifo);
		io_sti();

		if (i <= 1 )
		  timer_init(cons->timer, &task->fifo, 1); /* 1 */
	      }

	    //FD^XÑG[
	    if ( i == 0xFFFFFFFF )
	      {
		cons_putstr0(cons, "Command nof found.\n");
		timer_settime(cons->timer, 50);
		return 0;
	      }

	    //̂悤I
	    if ( i == 0xFFFFFFF0 )
	      {

		break;
	      }
	  }

	//ǂ琳ɓǂݍ܂ꂽ悤Bs

	appsiz = fh.size;
	p = fh.buf;

	//EEEEƂ̑OɁAteǩB
	if (appsiz >= 17)
	  {
	    size2 = tek_getsize(p);
	    if (size2 > 0) 
	      {	// tekkĂ 
		buf2 = (char *) memman_alloc_4k(memman, size2);
		tek_decomp(p, buf2, size2);
		memman_free_4k(memman, (int) p, appsiz);
		p = buf2;
		appsiz = size2;
		//obt@̑傫ω̂ŁB͊JɊp
		fh.memsize = size2;
	      }
	  }
	
	

	//hrbst@CǂB
	if (appsiz >= 36 && strncmp(p + 4, "Hari", 4) == 0 && *p == 0x00) 
	  {

	    //Ԃhrbst@CIII
	    segsiz = *((int *) (p + 0x0000));
	    esp    = *((int *) (p + 0x000c));
	    datsiz = *((int *) (p + 0x0010));
	    dathrb = *((int *) (p + 0x0014));
	    q = (char *) memman_alloc_4k(memman, segsiz);
	    task->ds_base = (int) q;
	    set_segmdesc(task->ldt + 0, appsiz - 1, (int) p, AR_CODE32_ER + 0x60);
	    set_segmdesc(task->ldt + 1, segsiz - 1, (int) q, AR_DATA32_RW + 0x60);
	    for (i = 0; i < datsiz; i++) 
	      {
		q[esp + i] = p[dathrb + i];
	      }
	    start_app(0x1b, 0 * 8 + 4, esp, 1 * 8 + 4, &(task->tss.esp0));
	    //AvI܂Ōł܂



	    //͏Iꍇ̏B


	    shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	    for (i = 0; i < MAX_SHEETS; i++)
	      {
		sht = &(shtctl->sheets0[i]);
		if ((sht->flags & 0x11) == 0x11 && sht->task == task)
		  {
		    /* AvJςȂɂ𔭌 */
		    sheet_free(sht);	/*  */
		  }
	      }
	    for (i = 0; i < 8; i++) 
	      {
		/* N[YĂȂt@CN[Y */
		if (task->fhandle[i].used != 0) 
		  {
		    memman_free_4k(memman, (int) task->fhandle[i].buf, task->fhandle[i].memsize);
		    task->fhandle[i].buf = 0;
		    task->fhandle[i].used = 0;
		  }
	      }
	    timer_cancelall(&task->fifo);
	    memman_free_4k(memman, (int) q, segsiz);
	    task->langbyte1 = 0;
	    cons_newline(cons);

	    return 1;

	    //J[\p^C}[𕜋A
	    //timer_init(cons->timer, &task->fifo, 1); /* 1 */
	    //timer_settime(cons->timer, 50);

	  }
	else 
	  {
	    //hrbst@CȂ݂IHH
	    cons_putstr0(cons, ".hrb file format error.\n");

	    memman_free_4k(memman, (int) p, appsiz);
	    cons_newline(cons);
	    return 0;

	  }


	return 0;
}

int *hrb_api(int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax)
{
	struct TASK *task = task_now();
	int ds_base = task->ds_base;
	struct CONSOLE *cons = task->cons;
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct SHEET *sht;
	struct FIFO32 *sys_fifo = (struct FIFO32 *) *((int *) 0x0fec);

	int err1;

	int *reg = &eax + 1;	/* eax̎̔Ԓn */
		/* ۑ̂߂PUSHADɏ */
		/* reg[0] : EDI,   reg[1] : ESI,   reg[2] : EBP,   reg[3] : ESP */
		/* reg[4] : EBX,   reg[5] : EDX,   reg[6] : ECX,   reg[7] : EAX */

	int i,i2;
	struct FILEINFO *finfo;
	struct FILEHANDLE *fh;
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;

	if (edx == 1) {
		cons_putchar(cons, eax & 0xff, 1);
	} else if (edx == 2) {
		cons_putstr0(cons, (char *) ebx + ds_base);
	} else if (edx == 3) {
		cons_putstr1(cons, (char *) ebx + ds_base, ecx);
	} else if (edx == 4) {
		return &(task->tss.esp0);
	} else if (edx == 5) {
		sht = sheet_alloc(shtctl);
		sht->task = task;
		sht->flags |= 0x10;
		sheet_setbuf(sht, (char *) ebx + ds_base, esi, edi, eax);
		make_window8((char *) ebx + ds_base, esi, edi, (char *) ecx + ds_base, 0);
		sheet_slide(sht, ((shtctl->xsize - esi) / 2) & ~3, (shtctl->ysize - edi) / 2);
		sheet_updown(sht, shtctl->top); /* ̃}EXƓɂȂ悤ɎwF }EX͂̏ɂȂ */
		reg[7] = (int) sht;
	} else if (edx == 6) {
		sht = (struct SHEET *) (ebx & 0xfffffffe);
		putfonts8_asc(sht->buf, sht->bxsize, esi, edi, eax, (char *) ebp + ds_base);
		if ((ebx & 1) == 0) {
			sheet_refresh(sht, esi, edi, esi + ecx * 8, edi + 16);
		}
	} else if (edx == 7) {
		sht = (struct SHEET *) (ebx & 0xfffffffe);
		boxfill8(sht->buf, sht->bxsize, ebp, eax, ecx, esi, edi);
		if ((ebx & 1) == 0) {
			sheet_refresh(sht, eax, ecx, esi + 1, edi + 1);
		}
	} else if (edx == 8) {
		memman_init((struct MEMMAN *) (ebx + ds_base));
		ecx &= 0xfffffff0;	/* 16oCgPʂ */
		memman_free((struct MEMMAN *) (ebx + ds_base), eax, ecx);
	} else if (edx == 9) {
		ecx = (ecx + 0x0f) & 0xfffffff0; /* 16oCgPʂɐ؂グ */
		reg[7] = memman_alloc((struct MEMMAN *) (ebx + ds_base), ecx);
	} else if (edx == 10) {
		ecx = (ecx + 0x0f) & 0xfffffff0; /* 16oCgPʂɐ؂グ */
		memman_free((struct MEMMAN *) (ebx + ds_base), eax, ecx);
	} else if (edx == 11) {
		sht = (struct SHEET *) (ebx & 0xfffffffe);
		sht->buf[sht->bxsize * edi + esi] = eax;
		if ((ebx & 1) == 0) {
			sheet_refresh(sht, esi, edi, esi + 1, edi + 1);
		}
	} else if (edx == 12) {
		sht = (struct SHEET *) ebx;
		sheet_refresh(sht, eax, ecx, esi, edi);
	} else if (edx == 13) {
		sht = (struct SHEET *) (ebx & 0xfffffffe);
		hrb_api_linewin(sht, eax, ecx, esi, edi, ebp);
		if ((ebx & 1) == 0) {
			if (eax > esi) {
				i = eax;
				eax = esi;
				esi = i;
			}
			if (ecx > edi) {
				i = ecx;
				ecx = edi;
				edi = i;
			}
			sheet_refresh(sht, eax, ecx, esi + 1, edi + 1);
		}
	} else if (edx == 14) {
		sheet_free((struct SHEET *) ebx);
	} else if (edx == 15) {
		for (;;) {
			io_cli();
			if (fifo32_status(&task->fifo) == 0) {
				if (eax != 0) {
					task_sleep(task);	/* FIFOȂ̂ŐQđ҂ */
				} else {
					io_sti();
					reg[7] = -1;
					return 0;
				}
			}
			i = fifo32_get(&task->fifo);
			io_sti();
			if (i <= 1 && cons->sht != 0) { /* J[\p^C} */
				/* Avs̓J[\oȂ̂ŁA͕\p1𒍕Ă */
				timer_init(cons->timer, &task->fifo, 1); /* 1 */
				timer_settime(cons->timer, 50);
			}
			if (i == 2) {	/* J[\ON */
				cons->cur_c = COL8_FFFFFF;
			}
			if (i == 3) {	/* J[\OFF */
				cons->cur_c = -1;
			}
			if (i == 4) {	/* R\[ */
				timer_cancel(cons->timer);
				io_cli();
				fifo32_put(sys_fifo, cons->sht - shtctl->sheets0 + 2024);	/* 2024`2279 */
				cons->sht = 0;
				io_sti();
			}
			if (i >= 256) { /* L[{[hf[^i^XNAoRjȂ */
				reg[7] = i - 256;
				return 0;
			}
		}
	} else if (edx == 16) {
		reg[7] = (int) timer_alloc();
		((struct TIMER *) reg[7])->flags2 = 1;	/* LZL */
	} else if (edx == 17) {
		timer_init((struct TIMER *) ebx, &task->fifo, eax + 256);
	} else if (edx == 18) {
		timer_settime((struct TIMER *) ebx, eax);
	} else if (edx == 19) {
		timer_free((struct TIMER *) ebx);
	} else if (edx == 20) {
		if (eax == 0) {
			i = io_in8(0x61);
			io_out8(0x61, i & 0x0d);
		} else {
			i = 1193180000 / eax;
			io_out8(0x43, 0xb6);
			io_out8(0x42, i & 0xff);
			io_out8(0x42, i >> 8);
			i = io_in8(0x61);
			io_out8(0x61, (i | 0x03) & 0x0f);
		}
	} else if (edx == 21) {
		for (i = 0; i < 8; i++) {
			if (task->fhandle[i].buf == 0) {
				break;
			}
		}
		fh = &task->fhandle[i];
		reg[7] = 0;
		if (i < 8) {
			finfo = file_search((char *) ebx + ds_base,
					(struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
			if (finfo != 0) {
				reg[7] = (int) fh;
				fh->size = finfo->size;
				fh->pos = 0;
				fh->buf = file_loadfile2(finfo->clustno, &fh->size, task->fat);
			}
		}
	} else if (edx == 22) {
		fh = (struct FILEHANDLE *) eax;
		memman_free_4k(memman, (int) fh->buf, fh->memsize);
		fh->buf = 0;
		fh->used = 0;
	} else if (edx == 23) {
		fh = (struct FILEHANDLE *) eax;
		if (ecx == 0) {
			fh->pos = ebx;
		} else if (ecx == 1) {
			fh->pos += ebx;
		} else if (ecx == 2) {
			fh->pos = fh->size + ebx;
		}
		if (fh->pos < 0) {
			fh->pos = 0;
		}
		if (fh->pos > fh->size) {
			fh->pos = fh->size;
		}
	} else if (edx == 24) {
		fh = (struct FILEHANDLE *) eax;
		if (ecx == 0) 
		  {
		    reg[7] = fh->memsize;
		  }
		else if (ecx == 1) 
		  {
		    reg[7] = fh->pos;
		  } 
		else if (ecx == 2) 
		  {
		    reg[7] = fh->pos - fh->memsize;
		  }
		else if (ecx == 3) 
		  {
		    reg[7] = fh->size;
		  }
	} else if (edx == 25) {
		fh = (struct FILEHANDLE *) eax;
		for (i = 0; i < ecx; i++) {
			if (fh->pos == fh->memsize) {
				break;
			}
			*((char *) ebx + ds_base + i) = fh->buf[fh->pos];
			fh->pos++;
		}
		reg[7] = i;
	} else if (edx == 26) {
		i = 0;
		for (;;) {
			*((char *) ebx + ds_base + i) =  task->cmdline[i];
			if (task->cmdline[i] == 0) {
				break;
			}
			if (i >= ecx) {
				break;
			}
			i++;
		}
		reg[7] = i;
	} else if (edx == 27) {
		reg[7] = task->langmode;
	}

	//VXeǂݏoAPI
	else if (edx == 101) {
	  //܂͓nꂽAhX擾
	  char *sendbuf;
	  int i;
	  char *p;
	  char s[40];
	  p = ebx;

	  sendbuf = (char *) ecx + ds_base;

	  for ( i = 0; i <= (eax-1); i++)
	    {
	      sendbuf[i] = p[i];
	    }
	  reg[7] = 0;


	}

	else if (edx == 0x4E) {


	  char *search_f_name;
	  char *fbuf;
	  char *waitflag;

	  int i,i2;

	  search_f_name = (char *) eax + ds_base;
	  fbuf = (char *) ebx + ds_base;
	  waitflag = (char *) esi + ds_base;

	  i = 0;


	  io_sti();               //荞݂~
	  fifo32_put(MainFifo,3200);      //̓T[`߂Ƃ
	  fifo32_put(MainFifo,search_f_name);      //t@CĂԒn
	  fifo32_put(MainFifo,fbuf);      //i[AhX
	  fifo32_put(MainFifo, waitflag); //҂p̃tO
	  fifo32_put(MainFifo,3999);      //R}hĨTCI
	  io_cli();               //荞ݎtĊJ


	  /*	  while ( search_f_name[i] != 0 )
	    {
	      fbuf[i] = search_f_name[i];
	      i++;
	    }

	  for ( i2 = 0; i2 <= 3; i2++)
	    {
	      fbuf[i] = 'A';
	      i++;
	    }

	  for ( i2 = 0; i2 <= 5; i2++)
	    {
	      fbuf[i] = 'B';
	      i++;
	      }*/

	  //	  fbuf[i] = 0x00;

	  //	  fifo32_put(&testtask->fifo,1024);


	  //	  reg[7] = 0;


	  //	  while ( waitflag != 0 ){}



	}


	//FileOpenAPI===================================
	else if (edx == 0x6E) {

	  char *filename_tmp;    //obt@p

	  char filename[8];     //t@C
	  char extname[3];      //gq
	  char *filename_ok;   //`̃t@C
	  char *fbuf;           //ɓǂݍ܂
	  //	  struct FIFO *waitflag;       //IʒmpFIFO

	  int i,i2;


	  //܂EAXAeWX^AhXϊēč
	  filename_tmp = (char *) eax + ds_base;
	  filename_ok = (char *) ebx + ds_base;
	  fbuf = (char *) ecx + ds_base;
	  //	  waitflag = (char *) esi + ds_base;

	  //UXy[XŖ߂
	  for ( i = 0; i <= 7; i++)
	    {
	      filename[i] = 0x20;
	    }
	  for ( i = 0; i <= 2; i++)
	    {
	      extname[i] = 0x20;
	    }

	  //t@C؂o
	  for ( i = 0; i <= 7; i++)
	    {
	      if ( filename_tmp[i] == 0x20 
                || filename_tmp[i] == '.' 
                || filename_tmp[i] == 0)
		{break;}
	      filename[i] = filename_tmp[i];
	    }
	  //gq؂o
	  if ( filename_tmp[i] != 0 )
	    {
	      i++;
	      for ( i2=0; i2 <= 2; i2++)
		{
		  extname[i2] = filename_tmp[i + i2];
		}
	    }

	  //Ōɐ`
	  for ( i = 0; i <= 7; i++ )
	    {
	      filename_ok[i] = filename[i];
	    }

	  for ( i = 8; i <= 10; i++)
	    {
	      filename_ok[i] = extname[i-8];
	    }

	  //悢FD^XNɔI
	  io_sti();               //荞݂~
	  fifo32_put(MainFifo,3100);      //̓t@CI[v߂Ƃ
	  fifo32_put(MainFifo,filename_ok);      //t@CĂԒn
	  fifo32_put(MainFifo,fbuf);      //i[AhX
	  fifo32_put(MainFifo, &task->fifo); //҂pFIFOĂ
	  fifo32_put(MainFifo,3999);      //R}hĨTCI
	  io_cli();               //荞ݎtĊJ




	  for (;;)
	    {
	      if (fifo32_status(&task->fifo) == 0)
		{
		  		  task_sleep(task);/* FIFOȂ̂ŐQđ҂ */
		}
	      else
		{         //ȂFIFOɗII
		  i = fifo32_get(&task->fifo);
		  if ( i == 999 )
		    {
		      reg[7] = -1;
		      return 0;
		    }
		}
	    }
	}

	//@FD̃t@CI[vi[hI[[hBobt@ɑSē]Ⴄj
	else if (edx == 0xa21)
	  {
	    char s[64];

	    //܂̓WX^t@C𓾂
	    char *openfilename;
	    char stylefilename[12];

	    openfilename = (char *) ebx + ds_base;


	    //t@C̃`FbN&`
	    err1 = fat12_filename_check(openfilename,stylefilename);

	    //t@CُI
	    if ( err1 != 0 ) {

	      reg[7] = 0;
	      return 0;
	    }

	    //󂢂Ăt@CnhTāEEE
	    for (i2 = 0; i2 <= 9; i2++)
	      {
		if ( i2 == 9 ){break;}

		//󂢂Ă̂I
		if (task->fhandle[i2].used == 0)
		  {
		    break;
		  }
	      }

	    //󂫂͂ȂI
	    if (i2 == 9)
	      {
		//G[ԂďI
		reg[7] = 0;
		timer_settime(cons->timer, 50);
		return 0;
	      }

	    //i2Ԃ󂢂Ă̂łgp
	    fh = &task->fhandle[i2];


	    //Ƃ肠gp̃}[NĂ
	    fh->used = 1;

	    //悢FD^XNɔI
	    io_sti();               //荞݂~
	    fifo32_put(MainFifo,3500);      //̓t@CI[v߁iRojƂ
	    fifo32_put(MainFifo,stylefilename);      //t@CĂԒn
	    fifo32_put(MainFifo, &task->fifo); //҂pFIFOĂ
	    fifo32_put(MainFifo, fh);    //t@Cnh
	    fifo32_put(MainFifo,3999);      //R}hĨTCI
	    io_cli();               //荞ݎtĊJ



	    //FD^XN̕Ԏ҂
	    for (;;)
	      {
		io_cli();
		if (fifo32_status(&task->fifo) == 0)
		  {
		  		  task_sleep(task);/* FIFOȂ̂ŐQđ҂ */
				  io_sti();
		  }
		else
		  {         //ȂFIFOɗII

		    i = fifo32_get(&task->fifo);
		    io_sti();


		    //FD^XÑG[
		    if ( i == 0xFFFFFFFF )
		      {
			reg[7] = 0;
			timer_settime(cons->timer, 50);
			return 0;
		      }

		    //̂悤I@t@CnhԂ
		    if ( i == 0xFFFFFFF0 )
		      {
			//Ƃ̑OTek̊mFEEE
			int tmpsize,size2;
			char *buf,*buf2;
			tmpsize = fh->size;
			buf = fh->buf;

			if (tmpsize >= 17)
			  {
			    size2 = tek_getsize(buf);
			    if (size2 > 0) 
			      {	// tekkĂ 
				buf2 = (char *) memman_alloc_4k(memman, size2);
				tek_decomp(buf, buf2, size2);
				memman_free_4k(memman, (int) buf, tmpsize);
				fh->buf = buf2;
				tmpsize = size2;
				//obt@̑傫ω̂ŁB͊JɊp
				fh->memsize = size2;
			      }
			  }

			reg[7] = fh;
			timer_settime(cons->timer, 50);
			return 0;
		      }

		  }

	      }




	  }



	return 0;
}

int *inthandler0c(int *esp)
{
	struct TASK *task = task_now();
	struct CONSOLE *cons = task->cons;
	char s[30];
	cons_putstr0(cons, "\nINT 0C :\n Stack Exception.\n");
	sprintf(s, "EIP = %08X\n", esp[11]);
	cons_putstr0(cons, s);
	return &(task->tss.esp0);	/* ُI */
}

int *inthandler0d(int *esp)
{
	struct TASK *task = task_now();
	struct CONSOLE *cons = task->cons;
	char s[30];
	cons_putstr0(cons, "\nINT 0D :\n General Protected Exception.\n");
	sprintf(s, "EIP = %08X\n", esp[11]);
	cons_putstr0(cons, s);
	return &(task->tss.esp0);	/* ُI */
}

void hrb_api_linewin(struct SHEET *sht, int x0, int y0, int x1, int y1, int col)
{
	int i, x, y, len, dx, dy;

	dx = x1 - x0;
	dy = y1 - y0;
	x = x0 << 10;
	y = y0 << 10;
	if (dx < 0) {
		dx = - dx;
	}
	if (dy < 0) {
		dy = - dy;
	}
	if (dx >= dy) {
		len = dx + 1;
		if (x0 > x1) {
			dx = -1024;
		} else {
			dx =  1024;
		}
		if (y0 <= y1) {
			dy = ((y1 - y0 + 1) << 10) / len;
		} else {
			dy = ((y1 - y0 - 1) << 10) / len;
		}
	} else {
		len = dy + 1;
		if (y0 > y1) {
			dy = -1024;
		} else {
			dy =  1024;
		}
		if (x0 <= x1) {
			dx = ((x1 - x0 + 1) << 10) / len;
		} else {
			dx = ((x1 - x0 - 1) << 10) / len;
		}
	}

	for (i = 0; i < len; i++) {
		sht->buf[(y >> 10) * sht->bxsize + (x >> 10)] = col;
		x += dx;
		y += dy;
	}

	return;
}
