/* bootpack̃C */

#include "bootpack.h"
#include <stdio.h>

#define KEYCMD_LED		0xed

//ʐMp̃S[oϐBȂƂEEEE
extern struct FIFO *MainFifo;
struct BOOTINFO2 binfo2;
struct SHTCTL *shtctl;
struct MEMMAN *memman;


void keywin_off(struct SHEET *key_win);
void keywin_on(struct SHEET *key_win);
void close_console(struct SHEET *sht);
void close_constask(struct TASK *task);

void tbartask(struct SHEET *sheet);
void cmos_get(unsigned char *t);



void HariMain(void)
{
  struct BOOTINFO *binfo;
  binfo = (struct BOOTINFO *) ADR_BOOTINFO;

  //binfobinfo2ɃRs[
  binfo2.cyls = binfo->cyls;
  binfo2.leds = binfo->leds;
  binfo2.vmode = binfo->vmode;
  binfo2.reserve = binfo->reserve;
  binfo2.scrnx = binfo->scrnx;
  binfo2.scrny = binfo->scrny;
  binfo2.vram = binfo->vram;
  //ǉ̍ڂZbg
  binfo2.tbar_height = 20;    //^Cgo[̍
  binfo2.frame_width = 4;    //t[̕
  binfo2.footbar_height = 20;  //tbgo[̍

  binfo2.taskbar_height = 20;  //^XNo[̍



	char s[40];
	struct FIFO32 fifo, keycmd;
	int fifobuf[128], keycmd_buf[32];
	int mx, my, i, new_mx = -1, new_my = 0, new_wx = 0x7fffffff, new_wy = 0;
	unsigned int memtotal;
	struct MOUSE_DEC mdec;
	memman = (struct MEMMAN *) MEMMAN_ADDR;
	unsigned char *buf_back, buf_mouse[256],*buf_menu;
	struct SHEET *sht_back, *sht_mouse,*sht_menu;
	struct TASK *task_a, *task;
	static char keytable0[0x80] = {
		0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0x5c, 0,  0,   0,   0,   0,   0,   0,   0,   0,   0x5c, 0,  0
	};
	static char keytable1[0x80] = {
		0,   0,   '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~', '=', '~', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '`', '{', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', '+', '*', 0,   0,   '}', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   '_', 0,   0,   0,   0,   0,   0,   0,   0,   0,   '|', 0,   0
	};
	int key_shift = 0, key_leds = (binfo->leds >> 4) & 7, keycmd_wait = -1;

	//}EX̓iϐ
	int j, x, y, mmx = -1, mmy = -1, mmx2 = 0;
	int mousemode = 0;
	//σ[h̎lp̂߂̕ϐ
	int mbx_x0 = -1,mbx_y0 = -1,mbx_x1 = -1,mbx_y1 = -1,mbx_x1_old = -1,mbx_y1_old = -1;



	struct SHEET *sht = 0, *key_win, *sht2;
	int *fat;
	unsigned char *nihongo;
	struct FILEINFO *finfo;
	extern char hankaku[4096];

	int err1;

	init_gdtidt();
	init_pic();
	io_sti(); /* IDT/PIC̏ÎCPŮ荞݋֎~ */
	fifo32_init(&fifo, 128, fifobuf, 0);
	*((int *) 0x0fec) = (int) &fifo;
	init_pit();
	init_keyboard(&fifo, 256);
	enable_mouse(&fifo, 512, &mdec);
	//	init_fd(&fifo);
	//	io_out8(PIC0_IMR, 0xf8); /* PITPIC1ƃL[{[h(11111000) */
	io_out8(PIC0_IMR, 0xb8); /* PIT,PIC1,L[{[h,fd(10111000) */
	io_out8(PIC1_IMR, 0xef); /* }EX(11101111) */
	fifo32_init(&keycmd, 32, keycmd_buf, 0);

	memtotal = memtest(0x00400000, 0xbfffffff);
	memman_init(memman);
	memman_free(memman, 0x00001000, 0x0009e000); /* 0x00001000 - 0x0009efff */
	memman_free(memman, 0x00400000, memtotal - 0x00400000);

	init_palette();
	shtctl = shtctl_init(memman, binfo->vram, binfo->scrnx, binfo->scrny);
	task_a = task_init(memman);
	fifo.task = task_a;
	task_run(task_a, 1, 2);
	*((int *) 0x0fe4) = (int) shtctl;
	task_a->langmode = 0;

	//ʐMpO[oϐBȂƂ
	MainFifo = &fifo;
	//===========================================


	/*wiƃjZ^XNo[̕`*/
	/* sht_back */
	sht_back  = sheet_alloc(shtctl);
	buf_back  = (unsigned char *) memman_alloc_4k(memman, binfo->scrnx * binfo->scrny);
	//͔wiȂ̂ŃEBhDł͂Ȃ
	sht_back->is_window = 0;
	sheet_setbuf(sht_back, buf_back, binfo->scrnx, binfo->scrny, -1); /* FȂ */
	init_screen8(buf_back, binfo->scrnx, binfo->scrny);


	sht_menu  = sheet_alloc(shtctl);
	buf_menu  = (unsigned char *) memman_alloc_4k(memman, binfo2.scrnx * binfo2.scrny);

	//̓j[Ȃ̂ŃEBhDł͂Ȃ
	sht_back->is_window = 0;
	sht_back->have_tb = 0;
	sht_back->have_fr = 0;
	sht_back->have_fb = 0;
	sheet_setbuf(sht_menu, buf_menu, binfo2.scrnx, binfo2.scrny, 0); // F͂O





	//^XNo[AN
	struct SHEET *tbar_sht = taskbar_make(shtctl,memman);
		
	//FDANZXp̃^XNAN
	struct SHEET *fdtask_sht = fdtask_make(shtctl,memman,binfo);

	/* sht_mouse */
	sht_mouse = sheet_alloc(shtctl);
	sheet_setbuf(sht_mouse, buf_mouse, 16, 16, 99);
	init_mouse_cursor8(buf_mouse, 99);
	mx = (binfo->scrnx - 16) / 2; /* ʒɂȂ悤ɍWvZ */
	my = (binfo->scrny - 28 - 16) / 2;

	/*  eV[gԂɂ*/
	sheet_slide(sht_back,  0,  0);
	sheet_slide(sht_menu, 0, 0);
	sheet_slide(sht_mouse, mx, my);
	//VXeV[gupdownȂ悤ɐݒ
	sht_back->is_updown = -1;
	sht_menu->is_updown = -1;
	sht_mouse->is_updown = -1;

	sheet_updown(sht_back,  0);
	//	sheet_updown(key_win,   1);
	sheet_updown(sht_menu,  2);
	sheet_updown(sht_mouse, 3);



	//==== ^XNo[@========
	sheet_slide(tbar_sht,   0, 0);
	sheet_updown(tbar_sht,   1);

	//==== FD^XN@========
	//	sheet_slide(fdtask_sht,   16, 24);
	sheet_slide(fdtask_sht,   binfo->scrnx+20, binfo->scrny+20);
	//	sheet_updown(fdtask_sht,   1);

	//̎_ŃV[g͍v5邱ƂɂȂB




	/* ŏɃL[{[hԂƂ̐HႢȂ悤ɁAݒ肵ĂƂɂ */
	fifo32_put(&keycmd, KEYCMD_LED);
	fifo32_put(&keycmd, key_leds);

	/* nihongo.fnt̓ǂݍ */
	fat = (int *) memman_alloc_4k(memman, 4 * 2880);
	file_readfat(fat, (unsigned char *) (ADR_DISKIMG + 0x000200));

	finfo = file_search("nihongo.fnt", (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	if (finfo != 0) {
		i = finfo->size;
		nihongo = file_loadfile2(finfo->clustno, &i, fat);
	} else {
		nihongo = (unsigned char *) memman_alloc_4k(memman, 16 * 256 + 32 * 94 * 47);
		for (i = 0; i < 16 * 256; i++) {
			nihongo[i] = hankaku[i]; // tHgȂ̂ŔpRs[ 
		}
		for (i = 16 * 256; i < 16 * 256 + 32 * 94 * 47; i++) {
			nihongo[i] = 0xff; // tHgȂ̂őSp0xffŖߐs 
		}
	}
	*((int *) 0x0fe8) = (int) nihongo;
	memman_free_4k(memman, (int) fat, 4 * 2880);


	//̎_keywin̓R\[Ȃ̂ŕ\
	/* sht_cons */
	key_win = open_console(shtctl, memtotal);
	sheet_slide(key_win,   32, 48);

	keywin_on(key_win);

	sheet_uptop(key_win);



	for (;;) {
	  //----------------------------------------
	  boxfill8(0xa0000,800,COL8_000000,8*22,16*0,8*60,16*1);
	  sprintf(s,"top=%02d,mous=%02d,menu=%02d,tbar=%02d,back=%02d",shtctl->top,sht_mouse->height,sht_menu->height,tbar_sht->height,sht_back->height);
	  putfonts8_asc(0xa0000,800,8*22,16*0,COL8_008484,s);


	  //----------------------------------------



		if (fifo32_status(&keycmd) > 0 && keycmd_wait < 0) {
			/* L[{[hRg[ɑf[^΁A */
			keycmd_wait = fifo32_get(&keycmd);
			wait_KBC_sendready();
			io_out8(PORT_KEYDAT, keycmd_wait);
		}
		io_cli();
		if (fifo32_status(&fifo) == 0) {
			/* FIFOۂɂȂ̂ŁAۗĂ`悪Ύs */

			if (new_mx >= 0) 
			  {
			    //[hɂ炸}EẌړ͕`ʂ
			    io_sti();
			    sheet_slide(sht_mouse, new_mx, new_my);

			    
			    //烂[hƂɁEEE
			    //ړ[hEEE
			    if ( mousemode == 1)
			      {
				if (new_wx != 0x7fffffff) 
				  {
				    sheet_slide(sht, new_wx, new_wy);
				    new_wx = 0x7fffffff;
				  }
			      }
			    //σ[hEEE
			    else if ( mousemode == 2 )
			      {
				//old-1ȂO̒lcĂ؋B
				//܂͏

				if ( mbx_x1_old != -1)
				  {
				    //
				    boxfill8(buf_menu,binfo2.scrnx,0,mbx_x0,mbx_y0,mbx_x1,mbx_y0 + 3 );
				    //
				    boxfill8(buf_menu,binfo2.scrnx,0,mbx_x0,mbx_y1,mbx_x1,mbx_y1 + 3 );
				    //E
				    boxfill8(buf_menu,binfo2.scrnx,0,mbx_x0,mbx_y0,mbx_x0 + 3 ,mbx_y1 );
				    //
				    boxfill8(buf_menu,binfo2.scrnx,0,mbx_x1,mbx_y0,mbx_x1 + 3 ,mbx_y1 );

				    //݂̃}EX̍Wl
				    mbx_x1 = new_mx;mbx_y1 = new_my;

				  }


				

				//
				boxfill8(buf_menu,binfo2.scrnx,COL8_848484,mbx_x0,mbx_y0,mbx_x1,mbx_y0 + 3 );
				//
				boxfill8(buf_menu,binfo2.scrnx,COL8_848484,mbx_x0,mbx_y1,mbx_x1,mbx_y1 + 3 );
				//E
				boxfill8(buf_menu,binfo2.scrnx,COL8_848484,mbx_x0,mbx_y0,mbx_x0 + 3 ,mbx_y1 );
				//
				boxfill8(buf_menu,binfo2.scrnx,COL8_848484,mbx_x1,mbx_y0,mbx_x1 + 3 ,mbx_y1 );


				//̎_ŕ`͏IBȂ̂łl͌ÂƂɂȂ̂
				//I[hɈڂĂ
				mbx_x1_old = mbx_x1;
				mbx_y1_old = mbx_y1;

				sheet_slide(sht_menu, 0, 0);
			      }


			    new_mx = -1;
			  }
			else
			  {
			    task_sleep(task_a);
			    io_sti();
			  }
		} else 
		  {
		    i = fifo32_get(&fifo);
		    
		    io_sti();
		    if (key_win != 0 && key_win->flags == 0)   /* EBhEꂽ */
		      {
			if (shtctl->top == 3)   	/* }EXƔwiȂ */
			  {
			    key_win = 0;
			  }
			else
			  {
			    key_win = shtctl->sheets[shtctl->top - 3];
			    keywin_on(key_win);
			  }
		      }

			if (256 <= i && i <= 511) { /* L[{[hf[^ */
				if (i < 0x80 + 256) { /* L[R[h𕶎R[hɕϊ */
					if (key_shift == 0) {
						s[0] = keytable0[i - 256];
					} else {
						s[0] = keytable1[i - 256];
					}
				} else {
					s[0] = 0;
				}
				if ('A' <= s[0] && s[0] <= 'Z') {	/* ͕At@xbg */
					if (((key_leds & 4) == 0 && key_shift == 0) ||
							((key_leds & 4) != 0 && key_shift != 0)) {
						s[0] += 0x20;	/* 啶ɕϊ */
					}
				}
				if (s[0] != 0 && key_win != 0) { /* ʏ핶AobNXy[XAEnter */

					  fifo32_put(&key_win->task->fifo, s[0] + 256);
				}

				if (i == 256 + 0x0f && key_win != 0) {	/* Tab */
					keywin_off(key_win);
					j = key_win->height - 1;
					if (j == 0) {
						j = shtctl->top - 1;
					}
					key_win = shtctl->sheets[j];
					keywin_on(key_win);
				}
				if (i == 256 + 0x2a) {	/* Vtg ON */
					key_shift |= 1;
				}
				if (i == 256 + 0x36) {	/* EVtg ON */
					key_shift |= 2;
				}
				if (i == 256 + 0xaa) {	/* Vtg OFF */
					key_shift &= ~1;
				}
				if (i == 256 + 0xb6) {	/* EVtg OFF */
					key_shift &= ~2;
				}
				if (i == 256 + 0x3a) {	/* CapsLock */
					key_leds ^= 4;
					fifo32_put(&keycmd, KEYCMD_LED);
					fifo32_put(&keycmd, key_leds);
				}
				if (i == 256 + 0x45) {	/* NumLock */
					key_leds ^= 2;
					fifo32_put(&keycmd, KEYCMD_LED);
					fifo32_put(&keycmd, key_leds);
				}
				if (i == 256 + 0x46) {	/* ScrollLock */
					key_leds ^= 1;
					fifo32_put(&keycmd, KEYCMD_LED);
					fifo32_put(&keycmd, key_leds);
				}
				if (i == 256 + 0x3b && key_shift != 0 && key_win != 0) {	/* Shift+F1 */
					task = key_win->task;
					if (task != 0 && task->tss.ss0 != 0) {
						cons_putstr0(task->cons, "\nBreak(key) :\n");
						io_cli();	/* IɃ^XNςƍ邩 */
						task->tss.eax = (int) &(task->tss.esp0);
						task->tss.eip = (int) asm_end_app;
						io_sti();
						task_run(task, -1, 0);	/* Imɂ点邽߂ɁAQĂN */
					}
				}
				if (i == 256 + 0x3c && key_shift != 0) {	/* Shift+F2 */
					/* VR\[͑IԂɂîقe؂ˁHj */
					if (key_win != 0) {
						keywin_off(key_win);
					}
					key_win = open_console(shtctl, memtotal);
					sheet_slide(key_win, 32, binfo2.taskbar_height + 4);
					//sheet_updown(key_win, shtctl->top - 2);
					sheet_uptop(key_win);
					keywin_on(key_win);
				}
				if (i == 256 + 0x57) {	/* F11 */
					sheet_updown(shtctl->sheets[1], shtctl->top - 1);
				}
				if (i == 256 + 0xfa) {	/* L[{[hf[^𖳎Ɏ󂯎 */
					keycmd_wait = -1;
				}
				if (i == 256 + 0xfe) {	/* L[{[hf[^𖳎Ɏ󂯎Ȃ */
					wait_KBC_sendready();
					io_out8(PORT_KEYDAT, keycmd_wait);
				}
			}


			//}EXMII======================================================
			else if (512 <= i && i <= 767)
			  {

			    
			    if (mouse_decode(&mdec, i - 512) != 0) 
			      {
				/* }EXJ[\̈ړ */
				mx += mdec.x;
				my += mdec.y;
				if (mx < 0)
				  {
				    mx = 0;
				  }
				if (my < 0)
				  {
				    my = 0;
				  }
				if (mx > binfo->scrnx - 1) 
				  {
				    mx = binfo->scrnx - 1;
				  }
				if (my > binfo->scrny - 1)
				  {
				    my = binfo->scrny - 1;
				  }
				new_mx = mx;
				new_my = my;

				// {^Ă =========
				if ((mdec.btn & 0x01) != 0) 
				  {

				    //				    if (mmx == -1 )
				    if ( mousemode == 0 )
				      {
					/* ʏ탂[h̏ꍇ */
					/* ̉珇ԂɃ}EXwĂ鉺T */
					//Ȃ-1B}EX̃V[gO邽
					for (j = shtctl->top - 3 + 1; j > 0; j--)
					  {
					    sht = shtctl->sheets[j];
					    x = mx - sht->vx0;
					    y = my - sht->vy0;

					    //IV[ĝǂĂ邩Jn
					    if (0 <= x && x < sht->bxsize && 0 <= y && y < sht->bysize)
					      {
						/*------------------------------------------------------
						boxfill8(0xa0000,800,COL8_000000,8*22,16*0,8*60,16*1);
						sprintf(s,"Zx=%03d",x);
						putfonts8_asc(0xa0000,800,8*22,16*0,COL8_008484,s);
						sprintf(s,"Zy=%03d",y);
						putfonts8_asc(0xa0000,800,8*30,16*0,COL8_008484,s);

						sprintf(s,"Sx=%03d",sht->bxsize);
						putfonts8_asc(0xa0000,800,8*36,16*0,COL8_008484,s);
						sprintf(s,"Sy=%03d",sht->bysize);
						putfonts8_asc(0xa0000,800,8*42,16*0,COL8_008484,s);
						//---------------------------------------------------*/


						//FȂNbNB邢͂̃V[g
						//updownV[gI
						if (sht->buf[y * sht->bxsize + x] != sht->col_inv || sht->is_updown == 0) 
						  {
						    sheet_uptop(sht);
						    if (sht != key_win && sht->have_tb != 0) 
						      {
							keywin_off(key_win);
							key_win = sht;
							keywin_on(key_win);
						      }



						    //}EXwĂ̂^Cgo[ꍇ
						    if (sht->have_tb == 1 && y <= binfo2.tbar_height && sht->is_window == 1)
						      {
							mousemode = 1;
							mmx = mx;	/* EBhEړ[h */
							mmy = my;
							mmx2 = sht->vx0;
							new_wy = sht->vy0;
						      }

						    //}EX̂σ{^ꍇ
						    if ( y > sht->bysize - binfo2.footbar_height && x > sht->bxsize - 20 && sht->have_fb == 1  )
						      {
							mousemode = 2;

							if ( mbx_x1 != -1)
							  { mbx_x1_old = mbx_x1;mbx_y1_old = mbx_y1;}

							mbx_x0 = sht->vx0;
							mbx_y0 = sht->vy0;

							//͍ŏ̑傫ɂȂ̂ŃV[g̑傫
							mbx_x1 = sht->vx0 + sht->bxsize - 3;
							mbx_y1 = sht->vy0 + sht->bysize - 3;



						      }
						    


						    //}EX̂N[Y{^ꍇ
						    if (sht->bxsize - 20 <= x && x < sht->bxsize - 4 && 7 <= y && y < 18 && sht->have_cb == 1 )
						      {
							/* u~v{^NbN */
							// AvEBhEH
							if ((sht->flags & 0x10) != 0) 
							  {
							    task = sht->task;
							    cons_putstr0(task->cons, "\nBreak(mouse) :\n");
							    io_cli();	/* IɃ^XNςƍ邩 */
							    task->tss.eax = (int) &(task->tss.esp0);
							    task->tss.eip = (int) asm_end_app;
							    io_sti();
							    task_run(task, -1, 0);
							  }
							// ƂR\[ H
							else
							  {
							    task = sht->task;
							    sheet_updown(sht, -1); /* Ƃ肠\ɂĂ */
							    keywin_off(key_win);
							    key_win = shtctl->sheets[shtctl->top - 1];
							    keywin_on(key_win);
							    io_cli();
							    fifo32_put(&task->fifo, 4);
							    io_sti();
							  }
						      }
						    break;
						  }
					      }
					  }
				      }
				    else if (mousemode == 1)
				      {
					/* EBhEړ[h̏ꍇ */
					x = mx - mmx;	/* }EẌړʂvZ */
					y = my - mmy;

					new_wx = (mmx2 + x + 2) & ~3;
					//^XNo[ɂ瓮Ȃ
					if ( new_wy + y >= 20 )
					  {
					    new_wy = new_wy + y;
					    mmy = my;	/* ړ̍WɍXV */
					  }

				      }
				    else if (mousemode == 2)
				      {
					x = mx - mmx;	/* }EẌړʂvZ */
					y = my - mmy;

					//mbx_x1 = new_mx;
					//mbx_y1 = new_my;


				      }
				    



				  } 
				else   	// {^ĂȂ
				  {
				    

				    if (new_wx != 0x7fffffff && mousemode == 1)
				      {
					sheet_slide(sht, new_wx, new_wy);	/* xm肳 */
					new_wx = 0x7fffffff;
				      }


				    if (mousemode == 2 )
				      {
					//lpĂ
					//
					boxfill8(buf_menu,binfo2.scrnx,0,mbx_x0,mbx_y0,mbx_x1,mbx_y0 + 3 );
					//
					boxfill8(buf_menu,binfo2.scrnx,0,mbx_x0,mbx_y1,mbx_x1,mbx_y1 + 3 );
					//E
					boxfill8(buf_menu,binfo2.scrnx,0,mbx_x0,mbx_y0,mbx_x0 + 3 ,mbx_y1 );
					//
					boxfill8(buf_menu,binfo2.scrnx,0,mbx_x1,mbx_y0,mbx_x1 + 3 ,mbx_y1 );
					
					//ep[^߂Ă
					mbx_x0 = -1;
					mbx_y0 = -1;
					mbx_x1 = -1;
					mbx_y1 = -1;
					mbx_x1_old = -1;
					mbx_y1_old = -1;

					sheet_slide(sht_menu,0,0);


				      }



				    mousemode = 0;
				    mmx = -1;	/* ʏ탂[h */


				  }
			      }



			} else if (768 <= i && i <= 1023) {	/* R\[I */
				close_console(shtctl->sheets0 + (i - 768));
			} else if (1024 <= i && i <= 2023) {
				close_constask(taskctl->tasks0 + (i - 1024));
			} else if (2024 <= i && i <= 2279) {	/* R\[ */
				sht2 = shtctl->sheets0 + (i - 2024);
				memman_free_4k(memman, (int) sht2->buf, 256 * 165);
				sheet_free(sht2);
			}

			else if (3000 <= i && i <= 3999)
			  {
			    //w߂FD֌WII
			    //			    putfonts8_asc(binfo->vram,binfo->scrnx,8*76,24,COL8_008484,"abc");
			    //			    fifo32_put(&testtask->fifo,i);
			    struct TASK *task1;
			    int i2,i3;
			    int cmd[10];

			    task1 = fdtask_sht->task;
			    
			    cmd[0] = i;

			    for ( i2 = 1; i2 <= 9; i2++)
			      {
				cmd[i2] = fifo32_get(&fifo);
				if (cmd[i2] == 3999){break;}
			      }
			    
			    io_sti();
			    for ( i3 = 0; i3 <= i2; i3++)
			      {
				fifo32_put(&task1->fifo,cmd[i3]);
			      }
			    io_cli();

			    //			    io_sti;
			    //			    fifo32_put(&task1->fifo,3200);
			    //			    io_cli;

			  }

			

		}
	}
}

void keywin_off(struct SHEET *key_win)
{
	change_wtitle8(key_win, 0);
	if ((key_win->flags & 0x20) != 0) {
		fifo32_put(&key_win->task->fifo, 3); /* R\[̃J[\OFF */
	}
	return;
}

void keywin_on(struct SHEET *key_win)
{
	change_wtitle8(key_win, 1);
	if ((key_win->flags & 0x20) != 0) {
		fifo32_put(&key_win->task->fifo, 2); /* R\[̃J[\ON */
	}
	return;
}

struct TASK *open_constask(struct SHEET *sht, unsigned int memtotal)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct TASK *task = task_alloc();
	int *cons_fifo = (int *) memman_alloc_4k(memman, 128 * 4);
	task->cons_stack = memman_alloc_4k(memman, 64 * 1024);
	task->tss.esp = task->cons_stack + 64 * 1024 - 12;
	task->tss.eip = (int) &console_task;
	task->tss.es = 1 * 8;
	task->tss.cs = 2 * 8;
	task->tss.ss = 1 * 8;
	task->tss.ds = 1 * 8;
	task->tss.fs = 1 * 8;
	task->tss.gs = 1 * 8;
	*((int *) (task->tss.esp + 4)) = (int) sht;
	*((int *) (task->tss.esp + 8)) = memtotal;
	task_run(task, 2, 2); /* level=2, priority=2 */
	fifo32_init(&task->fifo, 128, cons_fifo, task);
	return task;
}

struct SHEET *open_console(struct SHTCTL *shtctl, unsigned int memtotal)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct SHEET *sht = sheet_alloc(shtctl);
	//̓EBhDI
	//	sht->is_window = 1;  //  EEE͂ȂBlOKȁEEE

	int consx,consy;
	consx = get_cons_x();	consy = get_cons_y();

	//	unsigned char *buf = (unsigned char *) memman_alloc_4k(memman, (consx+16) * (consy+37));

	//	sheet_setbuf(sht, buf, consx + 16, consy + 37, -1); /* FȂ */
	//	make_window8(buf, consx + 16, consy + 37, "console", 0);
	make_window(sht, consx,consy, "console");

	//̊֐͍AŃNCAg̈悾Ώۂɂ̂0B
	make_textbox8(sht, 0, 0, consx, consy, COL8_FFFFFF);
	sht->task = open_constask(sht, memtotal);
	sht->flags |= 0x20;	/* J[\ */
	return sht;
}

void close_constask(struct TASK *task)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	task_sleep(task);
	memman_free_4k(memman, task->cons_stack, 64 * 1024);
	memman_free_4k(memman, (int) task->fifo.buf, 128 * 4);
	task->flags = 0; /* task_free(task); ̑ */
	return;
}

void close_console(struct SHEET *sht)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct TASK *task = sht->task;
	memman_free_4k(memman, (int) sht->buf, 256 * 165);
	sheet_free(sht);
	close_constask(task);
	return;
}

//R\[̑傫Ԃ֐
int get_cons_x()
{
  unsigned int i,i2;
  i = binfo2.scrnx;
  i = i - 50;
  i2 = i % 8;
  i = i - i2;

  //łC
  if ( i > 8 * 80)
    {
      i = 8 * 80;
    }

  return i;
}
int get_cons_y()
{
  unsigned int i,i2;
  i = binfo2.scrny;
  i = i - 86;
  i2 = i % 16;
  i = i - i2;

  //łC
  if ( i > 16 * 24)
    {
      i = 16 * 24;
    }

  return i;
}






void cmos_get(unsigned char *t)
{
    char err;
    static unsigned char adr[7] = { 0x00, 0x02, 0x04, 0x07, 0x08, 0x09, 0x32 };
    static unsigned char max[7] = { 0x60, 0x59, 0x23, 0x31, 0x12, 0x99, 0x99 };
    int i;
    for (;;) { /* ǂݍ݂܂ŌJԂ */
        err = 0;
        for (i = 0; i < 7; i++) {
            io_out8(0x70, adr[i]);
            t[i] = io_in8(0x71);
        }
        for (i = 0; i < 7; i++) {
            io_out8(0x70, adr[i]);
            if (t[i] != io_in8(0x71) || (t[i] & 0x0f) > 9 || t[i] > max[i]) {
                err = 1;
            }
        }
        if (err == 0) {
            return;
        }
    }
}


