/* R\[֌W */

#include "bootpack.h"
#include <stdio.h>
#include <math.h>
#include <string.h>

//#define CONS_CHAR_X  80
//#define CONS_CHAR_Y  24

extern struct BOOTINFO2 binfo2;

//ʐMp̃O[oϐBȂƂ
struct FIFO *MainFifo;

//őSʂɂ悭gϐ𓝈Eꊇ錾
int i,i2,i3;          //for[vł悭g
int f;                //fifo̎M͂ɓ
char s[60];           //\pɗǂĝ

void console_task(struct SHEET *sheet, int memtotal)
{
  int consx,consy;
  consx = get_cons_x() / 8;  consy= get_cons_y() / 16;

	struct TASK *task = task_now();
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	int i, *fat = (int *) memman_alloc_4k(memman, 4 * 2880);
	struct CONSOLE cons;
	struct FILEHANDLE fhandle[8];
	//	char cmdline[ consx ];
	char cmdline[ 128 ];
	unsigned char *nihongo = (char *) *((int *) 0x0fe8);

	cons.sht = sheet;
	cons.cur_x =  8;
	cons.cur_y = 28;
	cons.cur_c = -1;
	task->cons = &cons;
	task->cmdline = cmdline;

	if (cons.sht != 0) {
		cons.timer = timer_alloc();
		timer_init(cons.timer, &task->fifo, 1);
		timer_settime(cons.timer, 50);
	}
	file_readfat(fat, (unsigned char *) (ADR_DISKIMG + 0x000200));
	for (i = 0; i < 8; i++) {
		fhandle[i].buf = 0;	/* gp}[N */
	}
	task->fhandle = fhandle;
	task->fat = fat;
	if (nihongo[4096] != 0xff) {	/* {tHgt@Cǂݍ߂H */
		task->langmode = 1;
	} else {
		task->langmode = 0;
	}
	task->langbyte1 = 0;

	/* vvg\ */
	cons_putchar(&cons, '>', 1);

	for (;;) {
		io_cli();
		if (fifo32_status(&task->fifo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo32_get(&task->fifo);
			io_sti();
			if (i <= 1 && cons.sht != 0) { /* J[\p^C} */
				if (i != 0) {
					timer_init(cons.timer, &task->fifo, 0); /* 0 */
					if (cons.cur_c >= 0) {
						cons.cur_c = COL8_FFFFFF;
					}
				} else {
					timer_init(cons.timer, &task->fifo, 1); /* 1 */
					if (cons.cur_c >= 0) {
						cons.cur_c = COL8_000000;
					}
				}
				timer_settime(cons.timer, 50);
			}
			if (i == 2) {	/* J[\ON */
				cons.cur_c = COL8_FFFFFF;
			}
			if (i == 3) {	/* J[\OFF */
				if (cons.sht != 0) {
					boxfill8(cons.sht->buf, cons.sht->bxsize, COL8_000000,
						cons.cur_x, cons.cur_y, cons.cur_x + 7, cons.cur_y + 15);
				}
				cons.cur_c = -1;
			}
			if (i == 4) {	/* R\[́u~v{^NbN */
				cmd_exit(&cons, fat);
			}
			if (256 <= i && i <= 511) { /* L[{[hf[^i^XNAoRj */
				if (i == 8 + 256) {
					/* obNXy[X */
					if (cons.cur_x > 16) {
						/* J[\Xy[XŏĂAJ[\1߂ */
						cons_putchar(&cons, ' ', 0);
						cons.cur_x -= 8;
					}
				} else if (i == 10 + 256) {
					/* Enter */
					/* J[\Xy[XŏĂs */
					cons_putchar(&cons, ' ', 0);
					cmdline[cons.cur_x / 8 - 2] = 0;
					cons_newline(&cons);
					cons_runcmd(cmdline, &cons, fat, memtotal);	/* R}hs */
					if (cons.sht == 0) {
						cmd_exit(&cons, fat);
					}
					/* vvg\ */
					cons_putchar(&cons, '>', 1);
				} else {
					/* ʕ */
					if (cons.cur_x < consx * 8) {
						/* ꕶ\ĂAJ[\1i߂ */
						cmdline[cons.cur_x / 8 - 2] = i - 256;
						cons_putchar(&cons, i - 256, 1);
					}
				}
			}
			/* J[\ĕ\ */
			if (cons.sht != 0) {
				if (cons.cur_c >= 0) {
					boxfill8(cons.sht->buf, cons.sht->bxsize, cons.cur_c, 
						cons.cur_x, cons.cur_y, cons.cur_x + 7, cons.cur_y + 15);
				}
				sheet_refresh(cons.sht, cons.cur_x, cons.cur_y, cons.cur_x + 8, cons.cur_y + 16);
			}
		}
	}
}

void cons_putchar(struct CONSOLE *cons, int chr, char move)
{
  int consx,consy;
  consx = get_cons_x() / 8;  consy= get_cons_y() / 16;


	char s[2];
	s[0] = chr;
	s[1] = 0;
	if (s[0] == 0x09) {	/* ^u */
		for (;;) {
			if (cons->sht != 0) {
				putfonts8_asc_sht(cons->sht, cons->cur_x, cons->cur_y, COL8_000000, COL8_FFFFFF, " ", 1);
			}
			cons->cur_x += 8;
			if (cons->cur_x == 8 + consx*8) {
				cons_newline(cons);
			}
			if (((cons->cur_x - 8) & 0x1f) == 0) {
				break;	/* 32Ŋ؂ꂽbreak */
			}
		}
	} else if (s[0] == 0x0a) {	/* s */
		cons_newline(cons);
	} else if (s[0] == 0x0d) {	/* A */
		/* Ƃ肠ȂɂȂ */
	} else {	/* ʂ̕ */
		if (cons->sht != 0) {
			putfonts8_asc_sht(cons->sht, cons->cur_x, cons->cur_y, COL8_000000, COL8_FFFFFF, s, 1);
		}
		if (move != 0) {
			/* move0̂Ƃ̓J[\i߂Ȃ */
			cons->cur_x += 8;
			if (cons->cur_x == 8 + consx*8) {
				cons_newline(cons);
			}
		}
	}
	return;
}

void cons_newline(struct CONSOLE *cons)
{
  int consx,consy;
  consx = get_cons_x() / 8;  consy= get_cons_y() / 16;

	int x, y;
	struct SHEET *sheet = cons->sht;
	struct TASK *task = task_now();
	//--------- ŏIs̓̍vZBs{EBhDp[c̍
	if (cons->cur_y < 28 + ( consy -1)*16) {
		cons->cur_y += 16; /* ̍s */
	} else {
		/* XN[ */
		if (sheet != 0) {
			for (y = 28; y < 28 + ( consy -1)*16; y++) {
				for (x = 8; x < 8 + consx*8; x++) {
					sheet->buf[x + y * sheet->bxsize] = sheet->buf[x + (y + 16) * sheet->bxsize];
				}
			}
			for (y = 28 + ( consy -1)*16; y < 28 + consy*16; y++) {
				for (x = 8; x < 8 + consx*8; x++) {
					sheet->buf[x + y * sheet->bxsize] = COL8_FFFFFF;
				}
			}
			sheet_refresh(sheet, 8, 28, 8 + consx*8, 28 + consy*16);
		}
	}
	cons->cur_x = 8;
	if (task->langmode == 1 && task->langbyte1 != 0) {
		cons->cur_x = 16;
	}
	return;
}

void cons_putstr0(struct CONSOLE *cons, char *s)
{
	for (; *s != 0; s++) {
		cons_putchar(cons, *s, 1);
	}
	return;
}

void cons_putstr1(struct CONSOLE *cons, char *s, int l)
{
	int i;
	for (i = 0; i < l; i++) {
		cons_putchar(cons, s[i], 1);
	}
	return;
}

void cons_runcmd(char *cmdline, struct CONSOLE *cons, int *fat, int memtotal)
{
  //J[\p^C}[~
  timer_cancel(cons->timer);

	if (strcmp(cmdline, "mem") == 0 && cons->sht != 0) {
		cmd_mem(cons, memtotal);
	} else if (strcmp(cmdline, "cls") == 0 && cons->sht != 0) {
		cmd_cls(cons);
	} else if (strcmp(cmdline, "dir") == 0 && cons->sht != 0) {
		cmd_dir(cons);
	} else if (strcmp(cmdline, "exit") == 0) {
		cmd_exit(cons, fat);
	} else if (strncmp(cmdline, "start ", 6) == 0) {
		cmd_start(cons, cmdline, memtotal);
	} else if (strncmp(cmdline, "ncst ", 5) == 0) {
		cmd_ncst(cons, cmdline, memtotal);
	} else if (strncmp(cmdline, "langmode ", 9) == 0) {
		cmd_langmode(cons, cmdline);
	} else if (cmdline[0] != 0) {
		if (cmd_app(cons, fat, cmdline) == 0) {
			/* R}hł͂ȂAAvłȂAɋsłȂ */
			cons_putstr0(cons, "Bad command!\n\n");
		}
	}

	//J[\p^C}[𕜊
	timer_settime(cons->timer, 50);

	return;
}

void cmd_mem(struct CONSOLE *cons, int memtotal)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	char s[60];
	sprintf(s, "total   %dMB\nfree %dKB\n\n", memtotal / (1024 * 1024), memman_total(memman) / 1024);
	cons_putstr0(cons, s);
	return;
}

void cmd_cls(struct CONSOLE *cons)
{
	int x, y;
	struct SHEET *sheet = cons->sht;
	for (y = 28; y < 28 + 128; y++) {
		for (x = 8; x < 8 + 240; x++) {
			sheet->buf[x + y * sheet->bxsize] = COL8_000000;
		}
	}
	sheet_refresh(sheet, 8, 28, 8 + 240, 28 + 128);
	cons->cur_y = 28;
	return;
}

void cmd_dir(struct CONSOLE *cons)
{
	struct FILEINFO *finfo = (struct FILEINFO *) (ADR_DISKIMG + 0x002600);
	int i, j;
	char s[30];
	for (i = 0; i < 224; i++) {
		if (finfo[i].name[0] == 0x00) {
			break;
		}
		if (finfo[i].name[0] != 0xe5) {
			if ((finfo[i].type & 0x18) == 0) {
				sprintf(s, "filename.ext   %7d\n", finfo[i].size);
				for (j = 0; j < 8; j++) {
					s[j] = finfo[i].name[j];
				}
				s[ 9] = finfo[i].ext[0];
				s[10] = finfo[i].ext[1];
				s[11] = finfo[i].ext[2];
				cons_putstr0(cons, s);
			}
		}
	}
	cons_newline(cons);
	return;
}

void cmd_exit(struct CONSOLE *cons, int *fat)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct TASK *task = task_now();
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct FIFO32 *fifo = (struct FIFO32 *) *((int *) 0x0fec);
	if (cons->sht != 0) {
		timer_cancel(cons->timer);
	}
	memman_free_4k(memman, (int) fat, 4 * 2880);
	io_cli();
	if (cons->sht != 0) {
		fifo32_put(fifo, cons->sht - shtctl->sheets0 + 768);	/* 768`1023 */
	} else {
		fifo32_put(fifo, task - taskctl->tasks0 + 1024);	/* 1024`2023 */
	}
	io_sti();
	for (;;) {
		task_sleep(task);
	}
}

void cmd_start(struct CONSOLE *cons, char *cmdline, int memtotal)
{
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct SHEET *sht = open_console(shtctl, memtotal);
	struct FIFO32 *fifo = &sht->task->fifo;
	int i;
	sheet_slide(sht, 32, 4);
	sheet_updown(sht, shtctl->top);
	/* R}hCɓ͂ꂽAꕶVR\[ɓ */
	for (i = 6; cmdline[i] != 0; i++) {
		fifo32_put(fifo, cmdline[i] + 256);
	}
	fifo32_put(fifo, 10 + 256);	/* Enter */
	cons_newline(cons);
	return;
}

void cmd_ncst(struct CONSOLE *cons, char *cmdline, int memtotal)
{
	struct TASK *task = open_constask(0, memtotal);
	struct FIFO32 *fifo = &task->fifo;
	int i;
	/* R}hCɓ͂ꂽAꕶVR\[ɓ */
	for (i = 5; cmdline[i] != 0; i++) {
		fifo32_put(fifo, cmdline[i] + 256);
	}
	fifo32_put(fifo, 10 + 256);	/* Enter */
	cons_newline(cons);
	return;
}

void cmd_langmode(struct CONSOLE *cons, char *cmdline)
{
	struct TASK *task = task_now();
	unsigned char mode = cmdline[9] - '0';
	if (mode <= 2) {
		task->langmode = mode;
	} else {
		cons_putstr0(cons, "mode number error.\n");
	}
	cons_newline(cons);
	return;
}

int cmd_app(struct CONSOLE *cons, int *fat, char *cmdline)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct FILEINFO *finfo;
	char name[18], *p, *q,*buf2;
	struct TASK *task = task_now();
	int i, segsiz, datsiz, esp, dathrb, appsiz,size2;
	struct SHTCTL *shtctl;
	struct SHEET *sht;

	char stylefilename[11];

	int err1;
	char s[40];

	/* R}hCt@C𐶐 */
	for (i = 0; i < 13; i++) {
		if (cmdline[i] <= ' ') {
			break;
		}
		name[i] = cmdline[i];
	}


	//K.hrbtĂȂt
	if ( name[i-4] == '.' && name[i-3] == 'h' && name[i-2] == 'r' && name[i-1] == 'b')
	  {
	    name[i] = 0; 
	    sprintf(s,"name=OK!",name);putfonts8_asc(0xa0000,640,8*14,16*0,COL8_008484,s);
	  }
	else
	  {
	    name[i] = '.'; name[i+1] = 'h'; name[i+2] = 'r'; name[i+3] = 'b';
	    name[i+4] = 0; 
	  }

	//t@C̃`FbN&`
	err1 = fat12_filename_check(name,stylefilename);

	//t@CُI
	if ( err1 != 0 ) {
	  cons_putstr0(cons, "Bad Command name!!\n");
	  return 0;
	}


	//[hI[ߑȂ̂Œڃt@CJB
	//ȂG[ɂȂ̂ŃT[`̕Kv͂Ȃ

	struct FILEHANDLE fh;

	//悢FD^XNɔI
	io_sti();               //荞݂~
	fifo32_put(MainFifo,3500);      //̓t@CI[v߁iRojƂ
	fifo32_put(MainFifo,stylefilename);      //t@CĂԒn
	fifo32_put(MainFifo, &task->fifo); //҂pFIFOĂ
	fifo32_put(MainFifo, &fh);    //t@Cnh
	fifo32_put(MainFifo,3999);      //R}hĨTCI
	io_cli();               //荞ݎtĊJ

	//FD^XN̕Ԏ҂
	for (;;)
	  {
	    io_cli();
	    if (fifo32_status(&task->fifo) == 0)
	      {
		task_sleep(task);/* FIFOȂ̂ŐQđ҂ */
		io_sti();
	      }
	    else
	      {         //ȂFIFOɗII
		i = fifo32_get(&task->fifo);
		io_sti();

		if (i <= 1 )
		  timer_init(cons->timer, &task->fifo, 1); /* 1 */
	      }

	    //FD^XÑG[
	    if ( i == 0xFFFFFFFF )
	      {
		cons_putstr0(cons, "Command nof found.\n");
		return 0;
	      }

	    //̂悤I
	    if ( i == 0xFFFFFFF0 )
	      {

		break;
	      }
	  }

	//ǂ琳ɓǂݍ܂ꂽ悤Bs

	appsiz = fh.size;
	p = fh.buf;

	//EEEEƂ̑OɁAteǩB
	if (appsiz >= 17)
	  {
	    size2 = tek_getsize(p);
	    if (size2 > 0) 
	      {	// tekkĂ 
		buf2 = (char *) memman_alloc_4k(memman, size2);
		tek_decomp(p, buf2, size2);
		memman_free_4k(memman, (int) p, appsiz);
		p = buf2;
		appsiz = size2;
		//obt@̑傫ω̂ŁB͊JɊp
		fh.memsize = size2;
	      }
	  }
	
	

	//hrbst@CǂB
	if (appsiz >= 36 && strncmp(p + 4, "Hari", 4) == 0 && *p == 0x00) 
	  {

	    //Ԃhrbst@CIII
	    segsiz = *((int *) (p + 0x0000));
	    esp    = *((int *) (p + 0x000c));
	    datsiz = *((int *) (p + 0x0010));
	    dathrb = *((int *) (p + 0x0014));
	    q = (char *) memman_alloc_4k(memman, segsiz);
	    task->ds_base = (int) q;
	    set_segmdesc(task->ldt + 0, appsiz - 1, (int) p, AR_CODE32_ER + 0x60);
	    set_segmdesc(task->ldt + 1, segsiz - 1, (int) q, AR_DATA32_RW + 0x60);
	    for (i = 0; i < datsiz; i++) 
	      {
		q[esp + i] = p[dathrb + i];
	      }
	    start_app(0x1b, 0 * 8 + 4, esp, 1 * 8 + 4, &(task->tss.esp0));
	    //AvI܂Ōł܂



	    //͏Iꍇ̏B


	    shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	    for (i = 0; i < MAX_SHEETS; i++)
	      {
		sht = &(shtctl->sheets0[i]);
		if ((sht->flags & 0x11) == 0x11 && sht->task == task)
		  {
		    /* AvJςȂɂ𔭌 */
		    sheet_free(sht);	/*  */
		  }
	      }
	    for (i = 0; i < 8; i++) 
	      {
		/* N[YĂȂt@CN[Y */
		if (task->fhandle[i].used != 0) 
		  {
		    memman_free_4k(memman, (int) task->fhandle[i].buf, task->fhandle[i].memsize);
		    task->fhandle[i].buf = 0;
		    task->fhandle[i].used = 0;
		  }
	      }
	    timer_cancelall(&task->fifo);
	    memman_free_4k(memman, (int) q, segsiz);
	    task->langbyte1 = 0;
	    cons_newline(cons);

	    return 1;


	  }
	else 
	  {
	    //hrbst@CȂ݂IHH
	    cons_putstr0(cons, ".hrb file format error.\n");

	    memman_free_4k(memman, (int) p, appsiz);
	    cons_newline(cons);
	    return 0;

	  }


	return 0;
}

int *hrb_api(int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax)
{
	struct TASK *task = task_now();
	int ds_base = task->ds_base;
	struct CONSOLE *cons = task->cons;
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct SHEET *sht;
	struct FIFO32 *sys_fifo = (struct FIFO32 *) *((int *) 0x0fec);

	int err1;

	int *reg = &eax + 1;	/* eax̎̔Ԓn */
		/* ۑ̂߂PUSHADɏ */
		/* reg[0] : EDI,   reg[1] : ESI,   reg[2] : EBP,   reg[3] : ESP */
		/* reg[4] : EBX,   reg[5] : EDX,   reg[6] : ECX,   reg[7] : EAX */

	int i,i2;
	struct FILEINFO *finfo;
	struct FILEHANDLE *fh;
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;

	if (edx == 1) {
		cons_putchar(cons, eax & 0xff, 1);
	} else if (edx == 2) {
		cons_putstr0(cons, (char *) ebx + ds_base);
	} else if (edx == 3) {
		cons_putstr1(cons, (char *) ebx + ds_base, ecx);
	} else if (edx == 4) {
		return &(task->tss.esp0);
	}

	//api_openwin============================
	else if (edx == 5)
	  {
	    sht = sheet_alloc(shtctl);
	    sht->task = task;
	    sht->flags |= 0x10;

	    int tmpx,tmpy;

	    //	    sprintf(s,"scrny=%04d",binfo2.scrny);
	    //	    putfonts8_asc(0xa0000,800,8*60,16*0,COL8_008484,s);


	    //w̒l傫ꍇ͏C
	    if (esi >= (int)binfo2.scrnx )
	      {
		tmpx = binfo2.scrnx - (binfo2.frame_width * 2);
	      }
	    else
	      {
		tmpx = esi;
	      }

	    if (edi >= (int)binfo2.scrny )
	      {
		tmpy = binfo2.scrny - (binfo2.tbar_height);
	      }
	    else
	      {
		tmpy = edi;
	      }

	    //	    sprintf(s,"scrnx=%04d,scrny=%04d",tmpx,tmpy);
	    //putfonts8_asc(0xa0000,800,8*60,16*0,COL8_008484,s);



	    //	    char s[40];
	    //	    sprintf(s,"bx=%02d",ebx);
	    //	    putfonts8_asc(0xa0000,800,8*20,16*0,COL8_008484,s);


	    //Ƀobt@ZosheetɑZbg


	    if ( (ebx & 0x01) == 1)   //0rbgBEBhEǂH
	      {
		sht->is_window = 1;
		if ( (ebx & 0x04) == 4)   //2rbgBt[̗L
		  {
		    tmpx = tmpx + binfo2.frame_width*2;
		    tmpy = tmpy + binfo2.frame_width*2;

		    sht->have_fr = 1;
		  }
		else
		  {
		    sht->have_fr = 0;
		  }

		if ( (ebx & 0x02) == 2)   //1rbgB^Cgo[̗L
		  {
		    tmpy = tmpy + binfo2.tbar_height;

		    sht->have_tb = 1;
		  }
		else
		  {
		    sht->have_tb = 0;
		  }

		if ( (ebx & 0x08) == 8)   //3rbgBtbgo[̗L
		  {
		    tmpy = tmpy + binfo2.footbar_height;

		    sht->have_fb = 1;
		  }
		else
		  {
		    sht->have_fb = 0;
		  }

	      }
	    else
	      {
		sht->is_window = 0;
	      }



	    //ZolɃmۂAč

	    char *buf;
	    buf  = (unsigned char *) memman_alloc_4k(memman, tmpx * tmpy);

	    sheet_setbuf(sht, buf, tmpx, tmpy, eax);









	    //V[g̏ԂNCAg̈0_AAZo
	    int c_x0 = 0, c_y0 = 0, c_w = sht->bxsize, c_h = sht->bysize;

	    if ( sht->is_window == 1 )
	      {
		if ( sht->have_fr == 1 )
		  {
		    c_x0 = c_x0 + binfo2.frame_width;
		    c_y0 = c_y0 + binfo2.frame_width;
		    c_w = c_w - (binfo2.frame_width * 2);
		    c_h = c_h - (binfo2.frame_width * 2);
		  }

		if ( sht->have_tb == 1 )
		  {
		    c_y0 = c_y0 + binfo2.tbar_height;
		    c_h = c_h - binfo2.tbar_height;
		  }

		if ( sht->have_fb == 1 )
		  {
		    c_h = c_h - binfo2.footbar_height;
		  }

	      }

	    //ϐ𓖂č
	    sht->c_x0 = c_x0;
	    sht->c_y0 = c_y0;
	    sht->c_w = c_w;
	    sht->c_h = c_h;










	    make_window2(sht, (char *) ecx + ds_base);

	    //	    boxfill8(buf,tmpx,COL8_008484,0,0,3,tmpy);

	    sheet_slide(sht, ((shtctl->xsize - esi) / 2) & ~3, (shtctl->ysize - edi) / 2);
		//sheet_updown(sht, shtctl->top); /* ̃}EXƓɂȂ悤ɎwF }EX͂̏ɂȂ */
	    sheet_uptop(sht); //AvƂĂ̍őOʂ
	    reg[7] = (int) sht;

	  }




	//api_putstrwin =================================================
	else if (edx == 6)
	  {
	    sht = (struct SHEET *) (ebx & 0xfffffffe);


	    //͂ݏooA͂ݏoĂȂɂȂ
	    int tmpx0,tmpy0;
	    tmpx0 = sht->c_x0 + esi;
	    tmpy0 = sht->c_y0 + edi;

	    if ( tmpx0 < (sht->c_x0 + sht->c_w - 8) && tmpx0 >= sht->c_x0
 )  //Jn_܂ĂI
	      {
		if ( tmpy0 < (sht->c_y0 + sht->c_h - 16) )  //yWu!
		  {
		    putfonts8_asc(sht->buf, sht->bxsize, sht->c_x0 + esi, sht->c_y0 + edi, eax, (char *) ebp + ds_base);
		    //putfonts8_asc(sht->buf, sht->bxsize, esi, edi, eax, (char *) ebp + ds_base);
		  }
	      }

	    if ((ebx & 1) == 0) 
	      {
		sheet_refresh(sht, sht->c_x0 + esi , sht->c_y0 + edi , sht->c_x0 + esi + ecx * 8 , sht->c_y0 + edi + 16 );
	      }

	  } 



	//api_boxfilwin ===========================================
	else if (edx == 7) 
	  {
	    sht = (struct SHEET *) (ebx & 0xfffffffe);


	    //͂ݏoN␳G[̏
	    int err1 = 0;

	    int ss_x0,ss_y0,ss_x1,ss_y1;
	    //x̊Jn_ʊOɂ
	    if ( (eax + sht->c_x0) > (sht->c_x0 + sht->c_w) )
	      {
		ss_x0 = sht->c_x0 + sht->c_w;
	      }
	    else
	      {
		err1 = 1;
		ss_x0 = eax + sht->c_x0;
	      }

	    //ẙJn_ʊOɂ
	    if ( (ecx + sht->c_y0) > (sht->c_y0 + sht->c_h) )
	      {
		ss_y0 = sht->c_y0 + sht->c_h;
	      }
	    else
	      {
		err1 = 1;
		ss_y0 = ecx + sht->c_y0;
	      }

	    //x̏I_ʊOɂ
	    if ( (esi + sht->c_x0 - 1) > (sht->c_x0 + sht->c_w - 1 ) )
	      {
		ss_x1 = sht->c_x0 + sht->c_w -1;
	      }
	    else
	      {
		err1 = 1;
		ss_x1 = esi + sht->c_x0 - 1 ;
	      }
	    
	    //y̏I_ʊOɂ
	    if ( (edi + sht->c_y0 - 1 ) > (sht->c_y0 + sht->c_h - 1 ) )
	      {
		ss_y1 = sht->c_y0 + sht->c_h - 1;
	      }
	    else
	      {
		err1 = 1;
		ss_y1 = edi + sht->c_y0 - 1;
	      }

	    boxfill8(sht->buf, sht->bxsize , ebp, ss_x0, ss_y0, ss_x1, ss_y1);
	    if ((ebx & 1) == 0) 
	      {
		sheet_refresh(sht, ss_x0, ss_y0, ss_x1 + 1, ss_y1 + 1);
	      }

	    /*	    char s[40];
	    sprintf(s,"x0=%03d",ss_x0);
	    putfonts8_asc(0xa0000,800,8*15,16*0,COL8_008484,s);
	    sprintf(s,"y0=%03d",ss_y0);
	    putfonts8_asc(0xa0000,800,8*25,16*0,COL8_008484,s);
	    sprintf(s,"x1=%03d",ss_x1);
	    putfonts8_asc(0xa0000,800,8*35,16*0,COL8_008484,s);
	    sprintf(s,"y1=%03d",ss_y1);
	    putfonts8_asc(0xa0000,800,8*45,16*0,COL8_008484,s);*/




	    reg[7] = err1;

	  }





	else if (edx == 8) {
		memman_init((struct MEMMAN *) (ebx + ds_base));
		ecx &= 0xfffffff0;	/* 16oCgPʂ */
		memman_free((struct MEMMAN *) (ebx + ds_base), eax, ecx);
	} else if (edx == 9) {
		ecx = (ecx + 0x0f) & 0xfffffff0; /* 16oCgPʂɐ؂グ */
		reg[7] = memman_alloc((struct MEMMAN *) (ebx + ds_base), ecx);
	} else if (edx == 10) {
		ecx = (ecx + 0x0f) & 0xfffffff0; /* 16oCgPʂɐ؂グ */
		memman_free((struct MEMMAN *) (ebx + ds_base), eax, ecx);
	}



	//api_point ==================================================
	else if (edx == 11)
	  {
	    sht = (struct SHEET *) (ebx & 0xfffffffe);

	    //͂ݏoꍇ͂ȂɂȂG[Ԃ
	    int err1;

	    //x̒lNCAg̈Ɏ܂ĂȂi}CiXIj
	    if ( esi < 0 )
	      {
		err1 = 1;
	      }
	    else
	      //x̒lNCAg̈Ɏ܂ĂȂi傫Ij
	      if ( (esi + sht->c_x0) > (sht->c_x0 + sht->c_w) )
		{
		  err1 = 1;
		}
	      else
		//y̒li}CiXIj
		if ( edi < 0 )
		  {
		    err1 = 1;
		  }
		else
		  //y̒l傫I
		  if ( (edi + sht->c_y0) > (sht->c_y0 + sht->c_h) )
		    {
		      err1 = 1;
		    }
		  else
		    //Ȃ悤EEE
		    {
		      err1 = 0;
		    }

	    if ( err1 == 0 )
	      {
		sht->buf[sht->bxsize * (edi + sht->c_y0) + esi + sht->c_x0] = eax;
		if ((ebx & 1) == 0)
		  {
		    sheet_refresh(sht, esi + sht->c_x0, edi + sht->c_y0, esi + sht->c_x0 + 1, edi + sht->c_y0 + 1);
		  }

		reg[7] = 0;
	      }
	    else
	      {
		reg[7] = 1;

	      }

	  }



	//api_refreshwin ========================================
	else if (edx == 12) 
	  {
	    sht = (struct SHEET *) ebx;

	    //͂ݏo̕␳
	    int tmpx0 = eax + sht->c_x0, tmpy0 = ecx + sht->c_y0, tmpx1 = esi + sht->c_x0, tmpy1 = edi + sht->c_y0;
	    if ( tmpx0 < 0 )
	      {
		tmpx0 = 0;
	      }
	    if ( tmpy0 < 0 )
	      {
		tmpy0 = 0;
	      }
	    if ( tmpx1 > (sht->c_x0 + sht->c_w) )
	      {
		tmpx1 = sht->c_x0 + sht->c_w;
	      }
	    if ( tmpy1 > (sht->c_y0 + sht->c_h) )
	      {
		tmpy1 = sht->c_y0 + sht->c_h;
	      }
	    //	    sheet_refresh(sht, eax, ecx, esi, edi);
	    sheet_refresh(sht, tmpx0, tmpy0, tmpx1, tmpy1);
	  }


	//api_linewin =======================================
	else if (edx == 13) {
	  sht = (struct SHEET *) (ebx & 0xfffffffe);


	  //͂ݏo̕␳͂ĂĂ悤Ȃ̂ŔC
	  hrb_api_linewin(sht, eax + sht->c_x0, ecx + sht->c_y0, esi + sht->c_x0, edi + sht->c_y0, ebp);
	  if ((ebx & 1) == 0) {
	    if (eax > esi) {
	      i = eax;
	      eax = esi;
	      esi = i;
	    }
	    if (ecx > edi) {
	      i = ecx;
	      ecx = edi;
	      edi = i;
	    }
	    sheet_refresh(sht, eax + sht->c_x0, ecx + sht->c_y0, esi + sht->c_x0 + 1, edi + sht->c_y0 + 1);
	  }
	} 

	//api_closewin ===============================
	else if (edx == 14) 
	  {
	    sheet_free((struct SHEET *) ebx);
	  } 
	
	//================================================================
	//====   ȍ~̓IWĩOtBbN֌WAPI    ==========
	//================================================================


	//api_blocksend ===============================
	else if (edx == 120 )
	  {

	    // char s[40];
	    //	    sprintf(s,"esi=%03d,edi=%03d,ecx=%03d,ebp=%03d",esi,edi,ecx,ebp);
	    //	    putfonts8_asc(0xa0000,800,8*50,16*0,COL8_008484,s);
	    
	    sht = (struct SHEET *) (eax & 0xfffffffe);
	    int tmpx,tmpy;
	    tmpx = esi + sht->c_x0;
	    tmpy = edi + sht->c_y0;

	    char *buf;
	    buf = (char *) ebx + ds_base;


	    //	    char s[40];
	    //	    sprintf(s,"0=%03d,1=%03d,2=%03d,3=%03d",buf[0],buf[1],buf[2],buf[3]);
	    //	    putfonts8_asc(0xa0000,800,8*20,16*0,COL8_008484,s);




	    int i,i2,i3;
	    i3 = 0;
	    for ( i = tmpy; i <= ebp + tmpy -1; i++)
	      {
		for ( i2 = tmpx; i2 <= ecx + tmpx -1 ; i2++)
		  {

		    //͂ݏoꍇ͂ȂɂȂ
		    if ( i <= (sht->c_y0 + sht->c_h) && i2 < (sht->c_x0 + sht->c_w) )
		      {


			//char s[40];
			//			sprintf(s,"i2=%03d,cx0=%03d,cw=%03d",i2,sht->c_x0,sht->c_w);
			//			boxfill8(0xa0000,800,COL8_000000,8*20,16*0,8*60,16*1);
			//			putfonts8_asc(0xa0000,800,8*20,16*0,COL8_008484,s);

			sht->buf[ i * sht->bxsize + i2 ] = buf[i3];
		      }
		    //^[Qbg|Cg͐i߂
		    i3++;
		  }
	      }



	    if ((eax & 1) == 0)
	      {
		sheet_refresh(sht, tmpx, tmpy, ecx + tmpx, ebp + tmpy);
	      }




	  }






	//api_blockget ===============================
	else if (edx == 121 )
	  {


	    return;
	  }


	//api_pointget ===============================
	else if (edx == 122 )
	  {

	    int xx0,yy0;
	    sht = (struct SHEET *) (eax & 0xfffffffe);


	    //{̍WvZ
	    xx0 = sht->c_x0 + esi;
	    yy0 = sht->c_y0 + edi;

	    //͂ݏoĂȂvZ
	    if ( xx0 > (sht->c_x0 + sht->c_w) )
	      {
		reg[7] = -1;
		return;
	      }
	    if ( yy0 > (sht->c_y0 + sht->c_h) )
	      {
		reg[7] = -1;
		return;
	      }

	    //lw͐悤BV[gǂݍŒlԂ
	    reg[7] = (int)sht->buf[ (sht->bxsize * yy0) + xx0 ];


	    //	    char s[40];
	    //	    sprintf(s,"x0=%03d,y0=%03d,reg=%08x",esi,edi,reg[7]);
	    //	    boxfill8(0xa0000,800,COL8_000000,8*20,16*0,8*60,16*1);
	    //	    putfonts8_asc(0xa0000,800,8*20,16*0,COL8_008484,s);





	  }


	//api_blockmove ===============================
	else if (edx == 123 )
	  {
	    int x0,y0,xw,yh,xx0,yy0,bc;
	    int xw2,yh2;            //傫Wւ̕ϐ
	    int reg7;
	    int i,i2,i3;
	    char *ccbuf;           //ꎞi[p̕ϐ

	    sht = (struct SHEET *) (eax & 0xfffffffe);


	    //	    char s[40];
	    //	    sprintf(s,"x0y0=%08x,xwyh=%08x,xx0yy0=%08x",ebx,ecx,ebp);
	    //	    boxfill8(0xa0000,800,COL8_000000,8*20,16*0,8*60,16*1);
	    //	    putfonts8_asc(0xa0000,800,8*20,16*0,COL8_008484,s);

	    //܂͍Ă𕪗˂΁EEE
	    x0 = ebx / 0xFFFF;
	    y0 = ebx & 0xFFFF;
	    xw = ecx / 0xFFFF;
	    yh = ecx & 0xFFFF;
	    xx0 = ebp / 0xFFFF;
	    yy0 = ebp & 0xFFFF;
	    bc = esi;

	    //	    char s[40];
	    //	    sprintf(s,"x0=%03d,y0=%03d,xw=%03d,yh=%03d,xx0=%03d,yy0=%03d",x0,y0,xw,yh,xx0,yy0);
	    //    sprintf(s,"ebx=%08x",ebx);
	    //	    boxfill8(0xa0000,800,COL8_000000,8*20,16*0,8*60,16*1);
	    //	    	    putfonts8_asc(0xa0000,800,8*20,16*0,COL8_008484,s);

	    //n_wʒu͂ݏoĂȂH
	    if ( x0 > ( sht->c_w) || y0 > ( sht->c_h) )
	      {
		//n_͂ݏoĂBȂɂȂŃG[Ԃ
		reg[7] = -1;
	      }

	    //

	    //ړ_ʒu͂ݏoĂȂH
	    else if ( xx0 > ( sht->c_w )  || yy0 > ( sht->c_h ) )
	    {
		//n_͂ݏoĂBȂɂȂŃG[Ԃ
		reg[7] = -1;
	    }

	    else
	      {




		//ړ̉


		//⍂傫ꍇ͏C
		if ( x0 + xw > sht->c_w )
		  {
		    xw = sht->c_w - x0;
		  }

		if ( y0 + yh > sht->c_h )
		  {
		    yh = sht->c_h - y0;
		  }

		//elWɕϊ
		x0 = x0 + sht->c_x0;
		y0 = y0 + sht->c_y0;
		xx0 = xx0 + sht->c_x0;
		yy0 = yy0 + sht->c_y0;

		//悢ړJn







		//܂ꎞi[̂߂̕ϐeՂB
		ccbuf = (char *) memman_alloc_4k(memman, xw * yh );
		i3 = 0;
		//̈ꎞϐɌ̃f[^Rs[
		for ( i = y0; i <= y0 + yh; i++)
		  {
		    for ( i2 = x0; i2 <= x0 + xw; i2++)
		      {
			ccbuf[i3] = sht->buf[ i * sht->bxsize + i2];
			i3++;
		      }
		  }




		//		char s[40];
		//		sprintf(s,"x0=%03d,y0=%03d,xw=%03d,yh=%03d,xx0=%03d,yy0=%03d,i3=%08d",x0,y0,xw,yh,xx0,yy0,i3);
		//		boxfill8(0xa0000,800,COL8_000000,8*20,16*0,8*60,16*1);
		//		putfonts8_asc(0xa0000,800,8*20,16*0,COL8_008484,s);






		//blankcolorɂČʒu
		if ( bc != -1 )
		  {
		    for ( i = y0; i <= y0 + yh; i++)
		      {
			for ( i2 = x0; i2 <= x0 + xw; i2++)
			  {
			    sht->buf[ i * sht->bxsize + i2] = (char)bc;
			  }
		      }
		  }

		//f[^VȈʒuɓ\t
		i3 = 0;
		for ( i = yy0; i <= yy0 + yh; i++)
		  {
		    for ( i2 = xx0; i2 <= xx0 + xw; i2++)
		      {
			if ( i2 > sht->c_x0 + sht->c_w )
			  {break;}
			sht->buf[ i * sht->bxsize + i2] = ccbuf[i3];
			i3++;
		      }

		    if ( i > sht->c_y0 + sht->c_h )
		      {break;}

		  }


		//ŌɖYꂸɈꎞobt@JĂI
		memman_free_4k(memman, (int) ccbuf, xw * yh);

		//ƁItbVYꂸɁI
		sheet_refresh(sht, x0, y0, x0 + xw, y0 + yh);
		sheet_refresh(sht, xx0, yy0, xx0 + xw, yy0 + yh);



	      }



	  }

	//api_scrollwin ===============================
	else if (edx == 124 )
	  {
	    sht = (struct SHEET *) (eax & 0xfffffffe);
	    
	    //yhʊۂƂ̏ꍇ͈ړs킸hԂɂ
	    if ( abs(ecx) > sht->c_h)
	      {
		boxfill8(sht->buf, sht->bxsize, ebx,sht->c_x0, sht->c_y0, sht->c_x0 + sht->c_w, sht->c_y0 + sht->c_h);
		//͂ݏoĂ͂Ȃ̂ŁEEE
		reg[7] = -1;

	      }
	    else
	      {




	      }



	  }

	//api_slidewin ===============================
	else if (edx == 125 )
	  {


	    return;
	  }






	//================================================================
	//====   ܂łIWĩOtBbN֌WAPI    ==========
	//================================================================









	else if (edx == 15) {
		for (;;) {
			io_cli();
			if (fifo32_status(&task->fifo) == 0) {
				if (eax != 0) {
					task_sleep(task);	/* FIFOȂ̂ŐQđ҂ */
				} else {
					io_sti();
					reg[7] = -1;
					return 0;
				}
			}
			i = fifo32_get(&task->fifo);
			io_sti();
			if (i <= 1 && cons->sht != 0) { /* J[\p^C} */
				/* Avs̓J[\oȂ̂ŁA͕\p1𒍕Ă */
				timer_init(cons->timer, &task->fifo, 1); /* 1 */
				timer_settime(cons->timer, 50);
			}
			if (i == 2) {	/* J[\ON */
				cons->cur_c = COL8_FFFFFF;
			}
			if (i == 3) {	/* J[\OFF */
				cons->cur_c = -1;
			}
			if (i == 4) {	/* R\[ */
				timer_cancel(cons->timer);
				io_cli();
				fifo32_put(sys_fifo, cons->sht - shtctl->sheets0 + 2024);	/* 2024`2279 */
				cons->sht = 0;
				io_sti();
			}
			if (i >= 256) { /* L[{[hf[^i^XNAoRjȂ */
				reg[7] = i - 256;
				return 0;
			}
		}
	} else if (edx == 16) {
		reg[7] = (int) timer_alloc();
		((struct TIMER *) reg[7])->flags2 = 1;	/* LZL */
	} else if (edx == 17) {
		timer_init((struct TIMER *) ebx, &task->fifo, eax + 256);
	} else if (edx == 18) {
		timer_settime((struct TIMER *) ebx, eax);
	} else if (edx == 19) {
		timer_free((struct TIMER *) ebx);
	} else if (edx == 20) {
		if (eax == 0) {
			i = io_in8(0x61);
			io_out8(0x61, i & 0x0d);
		} else {
			i = 1193180000 / eax;
			io_out8(0x43, 0xb6);
			io_out8(0x42, i & 0xff);
			io_out8(0x42, i >> 8);
			i = io_in8(0x61);
			io_out8(0x61, (i | 0x03) & 0x0f);
		}
	} else if (edx == 21) {
		for (i = 0; i < 8; i++) {
			if (task->fhandle[i].buf == 0) {
				break;
			}
		}
		fh = &task->fhandle[i];
		reg[7] = 0;
		if (i < 8) {
			finfo = file_search((char *) ebx + ds_base,
					(struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
			if (finfo != 0) {
				reg[7] = (int) fh;
				fh->size = finfo->size;
				fh->pos = 0;
				fh->buf = file_loadfile2(finfo->clustno, &fh->size, task->fat);
			}
		}
	} else if (edx == 22) {
		fh = (struct FILEHANDLE *) eax;
		memman_free_4k(memman, (int) fh->buf, fh->memsize);
		fh->buf = 0;
		fh->used = 0;
	} else if (edx == 23) {
		fh = (struct FILEHANDLE *) eax;
		if (ecx == 0) {
			fh->pos = ebx;
		} else if (ecx == 1) {
			fh->pos += ebx;
		} else if (ecx == 2) {
			fh->pos = fh->size + ebx;
		}
		if (fh->pos < 0) {
			fh->pos = 0;
		}
		if (fh->pos > fh->size) {
			fh->pos = fh->size;
		}
	} else if (edx == 24) {
		fh = (struct FILEHANDLE *) eax;
		if (ecx == 0) 
		  {
		    reg[7] = fh->memsize;
		  }
		else if (ecx == 1) 
		  {
		    reg[7] = fh->pos;
		  } 
		else if (ecx == 2) 
		  {
		    reg[7] = fh->pos - fh->memsize;
		  }
		else if (ecx == 3) 
		  {
		    reg[7] = fh->size;
		  }
	} else if (edx == 25) {
		fh = (struct FILEHANDLE *) eax;
		for (i = 0; i < ecx; i++) {
			if (fh->pos == fh->memsize) {
				break;
			}
			*((char *) ebx + ds_base + i) = fh->buf[fh->pos];
			fh->pos++;
		}
		reg[7] = i;
	} else if (edx == 26) {
		i = 0;
		for (;;) {
			*((char *) ebx + ds_base + i) =  task->cmdline[i];
			if (task->cmdline[i] == 0) {
				break;
			}
			if (i >= ecx) {
				break;
			}
			i++;
		}
		reg[7] = i;
	} else if (edx == 27) {
		reg[7] = task->langmode;
	}

	//w̃fBNg̏擾đM 
	else if (edx == 28)
	  {
	    //hCufBNg͏ΉEEE
	    //܂͓nꂽAhX擾
	    char *searchnameorg;     //fBNg݃t@C܂̓p^[
	    char searchname[13];    //󂯎p

	    char *sendbuf;          //荞ރAhX
	    char *getbuf;           //FD^XN炤obt@
	    getbuf = memman_alloc_4k(memman,512 * 13);   //[g̈ɍ킹

	    //WX^̒l󂯎
	    searchnameorg = (char *) eax + ds_base;
	    sendbuf = (char *) ebx + ds_base;

	    //sprintf(s,"%s",searchnameorg);
	    //	    putfonts8_asc(0xa0000,640,8*20,16*0,COL8_008484,s);


	    //_ł̓t@C̑ΉȂ̂ŁEEE
	    //t@C󂯎
	    /*
	    for ( i = 0; i <= 11; i++)
	      {
		searchname[i] = searchnameorg[i];
		if (searchnameorg[i] == 0){break;}
	      }
	    if (i == 11 && searchname[i] != 0)
	      {searchname[i]= 0;}
	    */


	    //悢FD^XNɔI
	    io_cli();               //荞݂~
	    fifo32_put(MainFifo,3200);         //1,dir߂Ƃ
	    fifo32_put(MainFifo,0);            //2,t@CĂԒn
	    fifo32_put(MainFifo,getbuf);      //3,Mobt@̃AhX
	    fifo32_put(MainFifo, &task->fifo); //4,҂pFIFOĂ
	    fifo32_put(MainFifo,3999);         //5,R}hĨTCI
	    io_sti();               //荞ݎtĊJ


	    //FD^XN̕Ԏ҂
	    for (;;)
	      {
		io_cli();    //荞݂~
		if (fifo32_status(&task->fifo) == 0)
		  {
		    task_sleep(task); //FIFOȂ̂ŐQđ҂
		    io_sti();        //荞ݎtĊJ
		  }
		else
		  {         //ȂFIFOɗII
		    f = fifo32_get(&task->fifo);
		    io_sti();

		    //FD^XÑG[
		    if ( f == 0xFFFFFFFF )
		      {
			memman_free_4k(memman,getbuf,512 * 13);
			reg[7] = 0;
			return 0;
		      }
		    
		    //̂悤I
		    //i荞
		    if ( f == 0xFFFFFFF0 )
		      {
			struct FILEINFO *finfo1;
			struct FILEINFO *finfo2;
			finfo1 = getbuf;
			finfo2 = sendbuf;
			i2 = 0;


			for ( i =0; i <= 223; i++)
			  {
			    if ( finfo1[i].name[0] == 0 ){break;}
			    
			    if ( finfo1[i].name[0] != 0xe5 )
			      {
				finfo2[i] = finfo1[i];
				i2++;
			      }
			  }

			memman_free_4k(memman,getbuf,512 * 13);
			//Bt@CԐMĐI
			reg[7] = i2;

			return 0;

		      }

		    //G[̓t@C͂Ȃ
		    memman_free_4k(memman,getbuf,512 * 13);
		    reg[7] = 4440;
		    return 0;
		  }

	      }    // for [v̂K



	  }



	//VXeǂݏoAPI
	else if (edx == 101) {
	  //܂͓nꂽAhX擾
	  char *sendbuf;
	  char *p;
	  p = ebx;

	  sendbuf = (char *) ecx + ds_base;

	  for ( i = 0; i <= (eax-1); i++)
	    {
	      sendbuf[i] = p[i];
	    }
	  reg[7] = 0;


	}


	//@FD̃t@CI[vi[hI[[hBobt@ɑSē]Ⴄj
	else if (edx == 0xa21)
	  {
	    char s[64];

	    //܂̓WX^t@C𓾂
	    char *openfilename;
	    char stylefilename[12];

	    openfilename = (char *) ebx + ds_base;


	    //t@C̃`FbN&`
	    err1 = fat12_filename_check(openfilename,stylefilename);

	    //t@CُI
	    if ( err1 != 0 ) {

	      reg[7] = 0;
	      return 0;
	    }

	    //󂢂Ăt@CnhTāEEE
	    for (i2 = 0; i2 <= 9; i2++)
	      {
		if ( i2 == 9 ){break;}

		//󂢂Ă̂I
		if (task->fhandle[i2].used == 0)
		  {
		    break;
		  }
	      }

	    //󂫂͂ȂI
	    if (i2 == 9)
	      {
		//G[ԂďI
		reg[7] = 0;
		timer_settime(cons->timer, 50);
		return 0;
	      }

	    //i2Ԃ󂢂Ă̂łgp
	    fh = &task->fhandle[i2];


	    //Ƃ肠gp̃}[NĂ
	    fh->used = 1;

	    //悢FD^XNɔI
	    io_sti();               //荞݂~
	    fifo32_put(MainFifo,3500);      //̓t@CI[v߁iRojƂ
	    fifo32_put(MainFifo,stylefilename);      //t@CĂԒn
	    fifo32_put(MainFifo, &task->fifo); //҂pFIFOĂ
	    fifo32_put(MainFifo, fh);    //t@Cnh
	    fifo32_put(MainFifo,3999);      //R}hĨTCI
	    io_cli();               //荞ݎtĊJ



	    //FD^XN̕Ԏ҂
	    for (;;)
	      {
		io_cli();
		if (fifo32_status(&task->fifo) == 0)
		  {
		  		  task_sleep(task);/* FIFOȂ̂ŐQđ҂ */
				  io_sti();
		  }
		else
		  {         //ȂFIFOɗII

		    i = fifo32_get(&task->fifo);
		    io_sti();


		    //FD^XÑG[
		    if ( i == 0xFFFFFFFF )
		      {
			reg[7] = 0;
			return 0;
		      }

		    //̂悤I@t@CnhԂ
		    if ( i == 0xFFFFFFF0 )
		      {
			//Ƃ̑OTek̊mFEEE
			int tmpsize,size2;
			char *buf,*buf2;
			tmpsize = fh->size;
			buf = fh->buf;

			if (tmpsize >= 17)
			  {
			    size2 = tek_getsize(buf);
			    if (size2 > 0) 
			      {	// tekkĂ 
				buf2 = (char *) memman_alloc_4k(memman, size2);
				tek_decomp(buf, buf2, size2);
				memman_free_4k(memman, (int) buf, tmpsize);
				fh->buf = buf2;
				tmpsize = size2;
				//obt@̑傫ω̂ŁB͊JɊp
				fh->memsize = size2;
			      }
			  }

			reg[7] = fh;
			return 0;
		      }

		  }

	      }




	  }



	return 0;
}

int *inthandler0c(int *esp)
{
	struct TASK *task = task_now();
	struct CONSOLE *cons = task->cons;
	char s[30];
	cons_putstr0(cons, "\nINT 0C :\n Stack Exception.\n");
	sprintf(s, "EIP = %08X\n", esp[11]);
	cons_putstr0(cons, s);
	return &(task->tss.esp0);	/* ُI */
}

int *inthandler0d(int *esp)
{
	struct TASK *task = task_now();
	struct CONSOLE *cons = task->cons;
	char s[30];
	cons_putstr0(cons, "\nINT 0D :\n General Protected Exception.\n");
	sprintf(s, "EIP = %08X\n", esp[11]);
	cons_putstr0(cons, s);
	return &(task->tss.esp0);	/* ُI */
}

void hrb_api_linewin(struct SHEET *sht, int x0, int y0, int x1, int y1, int col)
{
	int i, x, y, len, dx, dy;

	dx = x1 - x0;     //x̒߂
	dy = y1 - y0;     //y̒߂
	x = x0 << 10;     //Ȃ̂1000{
	y = y0 << 10;     //Ȃ̂1000{
	if (dx < 0) {
		dx = - dx;
	}
	if (dy < 0) {
		dy = - dy;
	}
	if (dx >= dy) {
		len = dx + 1;
		if (x0 > x1) {
			dx = -1024;
		} else {
			dx =  1024;
		}
		if (y0 <= y1) {
			dy = ((y1 - y0 + 1) << 10) / len;
		} else {
			dy = ((y1 - y0 - 1) << 10) / len;
		}
	} else {
		len = dy + 1;
		if (y0 > y1) {
			dy = -1024;
		} else {
			dy =  1024;
		}
		if (x0 <= x1) {
			dx = ((x1 - x0 + 1) << 10) / len;
		} else {
			dx = ((x1 - x0 - 1) << 10) / len;
		}
	}

	for (i = 0; i < len; i++) 
	  {
	    //͂ݏonA͂ݏoĂȂɂȂ
	    if ( (y >> 10) < (sht->c_y0 + sht->c_h) && (x >> 10) < (sht->c_x0 + sht->c_w) )
	    {
		sht->buf[(y >> 10) * sht->bxsize + (x >> 10)] = col;
		x += dx;
		y += dy;
	    }

	}

	return;
}
